/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.gui.TiledImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class GraphicsUtil {
    public static final int ICON_PLAY = 0;
    public static final int ICON_STOP = 1;
    public static final int ICON_LOOP = 2;
    public static final int ICON_REWIND = 3;
    public static final int ICON_FASTFORWARD = 4;
    public static final int ICON_CHOOSEPATH = 5;
    public static final int ICON_POINTER = 6;
    public static final int ICON_LINE = 7;
    public static final int ICON_CURVE = 8;
    public static final int ICON_PENCIL = 9;
    public static final int ICON_ARC = 10;
    public static final int ICON_FORK = 11;
    public static final int ICON_ZOOM = 12;
    public static final int ICON_CATCH = 13;
    public static final int ICON_REALTIME = 15;
    public static final int ICON_SOLO = 16;
    public static final int ICON_MUTE = 18;
    public static final int ICON_BLENDING = 19;
    public static final int ICON_PREEXTRA = 20;
    public static final int ICON_POSTEXTRA = 21;
    public static final int ICON_INSERTMODE = 22;
    public static final int ICON_OVERWRITEMODE = 23;
    public static final int ICON_MIXMODE = 24;
    public static final Color colrSelection = new Color(0, 0, 255, 47);
    public static final Color colrAdjusting = new Color(255, 255, 0, 47);
    public static final Font smallGUIFont = new Font("Helvetica", 0, 10);
    public static final Paint pntBarGradient;
    protected static final TiledImage imgToolIcons;
    private static final int[] pntBarGradientPixels;

    private GraphicsUtil() {
    }

    public static Icon[] createToolIcons(int n) {
        Icon[] iconArray = new Icon[4];
        for (int i = 0; i < 4; ++i) {
            iconArray[i] = imgToolIcons.createIcon(n, i);
        }
        return iconArray;
    }

    public static void setToolIcons(AbstractButton abstractButton, Icon[] iconArray) {
        abstractButton.setIcon(iconArray[0]);
        abstractButton.setSelectedIcon(iconArray[1]);
        abstractButton.setPressedIcon(iconArray[3]);
        abstractButton.setDisabledIcon(iconArray[2]);
    }

    public static double getLineLength(Line2D line2D) {
        return Point2D.distance(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public static Point2D projectPointOntoLine(Point2D point2D, Line2D line2D) {
        double d;
        double d2 = line2D.getX2() - line2D.getX1();
        double d3 = d2 * d2 + (d = line2D.getY2() - line2D.getY1()) * d;
        if (d3 == 0.0) {
            return new Point2D.Double(line2D.getX1(), line2D.getY1());
        }
        double d4 = ((point2D.getX() - line2D.getX1()) * d2 + (point2D.getY() - line2D.getY1()) * d) / d3;
        return new Point2D.Double(line2D.getX1() + d4 * d2, line2D.getY1() + d4 * d);
    }

    static {
        imgToolIcons = null;
        pntBarGradientPixels = new int[]{-4671304, -4144960, -3618616, -2894893, -2368549, -1776412, -1315861, -921103, -592138, -328966, -263173, -197380, -394759, -723724, -1052689};
        BufferedImage bufferedImage = new BufferedImage(1, 15, 2);
        bufferedImage.setRGB(0, 0, 1, 15, pntBarGradientPixels, 0, 1);
        pntBarGradient = new TexturePaint(bufferedImage, new Rectangle(0, 0, 1, 15));
    }
}

