/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class IIRFilterDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FILTERTYPE = 3;
    private static final int PR_GAIN = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FILTERTYPE = "FilterType";
    private static final int FILTER_DIFF = 0;
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FilterType"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Gain"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FILTERTYPE = 259;
    private static final int GG_GAIN = 512;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public IIRFilterDlg() {
        super("IIR Filter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            IIRFilterDlg.static_pr.text = prText;
            IIRFilterDlg.static_pr.textName = prTextName;
            IIRFilterDlg.static_pr.intg = prIntg;
            IIRFilterDlg.static_pr.intgName = prIntgName;
            IIRFilterDlg.static_pr.para = prPara;
            IIRFilterDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(IIRFilterDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(IIRFilterDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0IIR$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Filter Settings", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Differentiator");
        jComboBox.addItem("Integrator");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Filter Type", 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addChoice(jComboBox, 259, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile = null;
        AudioFile audioFile2 = null;
        AudioFileDescr audioFileDescr = null;
        AudioFileDescr audioFileDescr2 = null;
        float[][] fArray = null;
        float f = 1.0f;
        Param param = new Param(1.0, 1);
        try {
            audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
            audioFileDescr = audioFile.getDescr();
            int n = audioFileDescr.channels;
            long l = (int)audioFileDescr.length;
            if ((long)n * l < 1L) {
                throw new EOFException("File is empty");
            }
            fArray = new float[n][8192];
            long l2 = l * 3L;
            long l3 = 0L;
            PathField pathField = (PathField)this.gui.getItemObj(1025);
            if (pathField == null) {
                throw new IOException("Bug! Missing property!");
            }
            audioFileDescr2 = new AudioFileDescr(audioFileDescr);
            pathField.fillStream(audioFileDescr2);
            audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
            if (this.threadRunning) {
                float f2 = -1.0f;
                if (this.pr.intg[2] == 1) {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                long l4 = 0L;
                while (l4 < l && this.threadRunning) {
                    int n2 = (int)Math.min(8192L, l - l4);
                    audioFile.readFrames(fArray, 0, n2);
                    l4 += (long)n2;
                    l3 += (long)n2;
                    for (int i = 0; i < n; ++i) {
                        Util.mult(fArray[i], 0, n2, f);
                    }
                    audioFile2.writeFrames(fArray, 0, n2);
                    this.setProgression((float)(l3 += (long)n2) / (float)l2);
                }
                if (this.threadRunning) {
                    audioFile.close();
                    audioFile = null;
                    audioFileDescr = null;
                    audioFile2.close();
                    audioFile2 = null;
                    this.handleClipping(f2 *= f);
                }
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            audioFileDescr = null;
            audioFileDescr2 = null;
            fArray = null;
            System.gc();
            this.setError(new Exception("FScape ran out of memory"));
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
    }
}

