/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;

public class IconBitmap
extends Component {
    private final Image img;
    private final Dimension d;
    private final int rows;
    private final int cols;

    public IconBitmap(Image image, int n, int n2) {
        this.img = image;
        this.d = new Dimension(n, n2);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.cols = image.getWidth(this) / this.d.width;
        this.rows = image.getHeight(this) / this.d.height;
    }

    public IconBitmap(String string, int n, int n2) {
        this(Toolkit.getDefaultToolkit().getImage(string), n, n2);
    }

    public Dimension getDimension() {
        return new Dimension(this.d);
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        Point point = this.getOffset(n);
        if (point != null) {
            graphics.drawImage(this.img, n2, n3, n2 + this.d.width, n3 + this.d.height, point.x, point.y, point.x + this.d.width, point.y + this.d.height, this);
        } else {
            Color color = graphics.getColor();
            graphics.setColor(Color.red);
            graphics.fill3DRect(n2, n3, this.d.width, this.d.height, true);
            graphics.setColor(color);
        }
    }

    private Point getOffset(int n) {
        if (n < 0 || n >= this.cols * this.rows) {
            return null;
        }
        return new Point(n % this.cols * this.d.width, n / this.cols * this.d.height);
    }
}

