/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.Dragable;
import de.sciss.fscape.gui.IconBitmap;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;

public class IconicComponent
extends JComponent
implements Dragable {
    public static DataFlavor flavor = null;
    protected IconBitmap ib;
    protected Dimension d;
    protected int ID;
    private static DataFlavor[] flavors = null;

    protected IconicComponent(IconBitmap iconBitmap, int n) {
        this.ib = iconBitmap;
        this.d = iconBitmap.getDimension();
        this.setSize(this.getPreferredSize());
        this.setID(n);
        if (flavor == null) {
            flavor = new DataFlavor(this.getClass(), "Icon");
            flavors = new DataFlavor[1];
            IconicComponent.flavors[0] = flavor;
        }
    }

    protected IconicComponent(IconBitmap iconBitmap) {
        this(iconBitmap, -1);
    }

    public void setID(int n) {
        this.ID = n;
    }

    public int getID() {
        return this.ID;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.d);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        this.ib.paint(graphics, this.ID, dimension.width - this.d.width >> 1, dimension.height - this.d.height >> 1);
    }

    @Override
    public void paintScheme(Graphics graphics, int n, int n2, boolean bl) {
        graphics.drawRect(n - (this.d.width >> 1), n2 - (this.d.height >> 1), this.d.width - 1, this.d.height - 1);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

