/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.EnvIcon;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamEvent;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class LaguerreDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FRAMESIZE = 3;
    private static final int PR_OVERLAP = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_WARP = 1;
    private static final int PR_WARPMODDEPTH = 2;
    private static final int PR_INFREQ = 3;
    private static final int PR_OUTFREQ = 4;
    private static final int PR_WARPMOD = 0;
    private static final int PR_WARPENV = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_WARP = "Warp";
    private static final String PRN_WARPMODDEPTH = "WarpModDepth";
    private static final String PRN_INFREQ = "InFreq";
    private static final String PRN_OUTFREQ = "OutFreq";
    private static final String PRN_WARPMOD = "WarpMod";
    private static final String PRN_WARPENV = "WarpEnv";
    private static final String PRN_FRAMESIZE = "FrameSize";
    private static final String PRN_OVERLAP = "Overlap";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 4, 2};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FrameSize", "Overlap"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"WarpMod"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "Warp", "WarpModDepth", "InFreq", "OutFreq"};
    private static final Envelope[] prEnvl = new Envelope[]{null};
    private static final String[] prEnvlName = new String[]{"WarpEnv"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FRAMESIZE = 259;
    private static final int GG_OVERLAP = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_WARP = 513;
    private static final int GG_WARPMODDEPTH = 514;
    private static final int GG_INFREQ = 515;
    private static final int GG_OUTFREQ = 516;
    private static final int GG_WARPMOD = 0;
    private static final int GG_WARPENV = 1792;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private float inRate = 0.0f;

    public LaguerreDlg() {
        super("Laguerre Warping");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            LaguerreDlg.static_pr.text = prText;
            LaguerreDlg.static_pr.textName = prTextName;
            LaguerreDlg.static_pr.intg = prIntg;
            LaguerreDlg.static_pr.intgName = prIntgName;
            LaguerreDlg.static_pr.bool = prBool;
            LaguerreDlg.static_pr.boolName = prBoolName;
            LaguerreDlg.static_pr.para = prPara;
            LaguerreDlg.static_pr.para[1] = new Param(-10.0, 16);
            LaguerreDlg.static_pr.para[2] = new Param(20.0, 49);
            LaguerreDlg.static_pr.para[3] = new Param(1000.0, 3);
            LaguerreDlg.static_pr.para[4] = new Param(1000.0, 3);
            LaguerreDlg.static_pr.paraName = prParaName;
            LaguerreDlg.static_pr.envl = prEnvl;
            LaguerreDlg.static_pr.envl[0] = Envelope.createBasicEnvelope(0);
            LaguerreDlg.static_pr.envlName = prEnvlName;
            this.fillDefaultAudioDescr(LaguerreDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(LaguerreDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ParamListener paramListener = new ParamListener(){

            @Override
            public void paramChanged(ParamEvent paramEvent) {
                int n = LaguerreDlg.this.gui.getItemID((EventObject)((Object)paramEvent));
                switch (n) {
                    case 513: 
                    case 515: {
                        ((LaguerreDlg)LaguerreDlg.this).pr.para[n - 512] = ((ParamField)paramEvent.getSource()).getParam();
                        LaguerreDlg.this.recalcOutFreq();
                        break;
                    }
                    case 516: {
                        ((LaguerreDlg)LaguerreDlg.this).pr.para[n - 512] = ((ParamField)paramEvent.getSource()).getParam();
                        LaguerreDlg.this.recalcWarpAmount();
                    }
                }
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = LaguerreDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 0: {
                        ((LaguerreDlg)LaguerreDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        LaguerreDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = LaguerreDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        LaguerreDlg.this.setInput(((PathField)pathEvent.getSource()).getPath().getPath());
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Wrp$E");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, paramListener);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Warp settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[1]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Warp amount", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, paramListener);
        ParamField paramField2 = new ParamField(Constants.spaces[6]);
        paramField2.setReference(paramField);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 514, paramListener);
        EnvIcon envIcon = new EnvIcon(this.getComponent());
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addGadget(envIcon, 1792);
        ParamField paramField3 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Input freq.", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 515, paramListener);
        ParamField paramField4 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("\u2192 Output freq.", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 516, paramListener);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 32; n <= 32768; n <<= 1) {
            jComboBox.addItem(String.valueOf(n));
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Frame size [smp]", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 1; n <= 16; ++n) {
            jComboBox2.addItem(n + "x");
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_OVERLAP, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, itemListener);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        block39: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            try {
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr2 = audioFile2.getDescr();
                int n2 = audioFileDescr2.channels;
                long l = audioFileDescr2.length;
                if (l * (long)n2 < 1L) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block39;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescr2);
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block39;
                float f3 = Math.max(-0.98f, Math.min(0.98f, (float)(this.pr.para[1].value / 100.0)));
                float f4 = (1.0f - f3) / (1.0f + f3);
                int n3 = 32 << this.pr.intg[3];
                int n4 = n3 >> 1;
                int n5 = (int)(f4 * (float)n3 + 0.5f);
                int n6 = this.pr.intg[4] + 1;
                while ((float)n5 / (float)n6 > (float)n4) {
                    ++n6;
                }
                int n7 = (int)((float)n5 / (float)n6 + 0.5f);
                int n8 = Math.max(n3, n5);
                float[] fArray4 = Filter.createFullWindow(n3, 7);
                int n9 = n7;
                float f5 = (float)Math.sqrt(1.0f - f3 * f3);
                long l2 = 0L;
                long l3 = l * (long)(2 + n2);
                float[] fArray5 = new float[n8];
                int n10 = n3 + n7;
                fArray3 = new float[n2][n10];
                int n11 = n5 + n9;
                float[][] fArray6 = new float[n2][n11];
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n2];
                    floatFileArray = new FloatFile[n2];
                    for (n = 0; n < n2; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n2; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l3 += l;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block39;
                long l4 = 0L;
                long l5 = 0L;
                int n12 = 0;
                while (this.threadRunning && l5 < l) {
                    int n13 = (int)Math.min((long)n10, l - l4 + (long)n12);
                    int n14 = Math.max(0, n13 - n12);
                    audioFile2.readFrames(fArray3, n12, n14);
                    l4 += (long)n14;
                    this.setProgression((float)(l2 += (long)n14) / (float)l3);
                    if (this.threadRunning) {
                        if (n13 < n10) {
                            for (n = 0; n < n2; ++n) {
                                fArray2 = fArray3[n];
                                for (n6 = n13; n6 < fArray2.length; ++n6) {
                                    fArray2[n6] = 0.0f;
                                }
                            }
                        }
                        for (n = 0; this.threadRunning && n < n2; ++n) {
                            fArray2 = fArray3[n];
                            fArray = fArray6[n];
                            n4 = n8;
                            for (n6 = 0; n6 < n3; ++n6) {
                                fArray5[--n4] = fArray2[n6] * fArray4[n6];
                            }
                            while (n4 > 0) {
                                fArray5[--n4] = 0.0f;
                            }
                            float f6 = -f3;
                            float f7 = f5;
                            float f8 = 0.0f;
                            n4 = 0;
                            while (n4 < n5) {
                                float f9 = 0.0f;
                                float f10 = 0.0f;
                                for (n6 = 0; n6 < n8; ++n6) {
                                    float f11;
                                    float f12 = fArray5[n6];
                                    fArray5[n6] = f11 = f7 * f12 + f8 * f9 - f6 * f10;
                                    f10 = f11;
                                    f9 = f12;
                                }
                                f6 = -f3;
                                f7 = -f3;
                                f8 = 1.0f;
                                int n15 = n4++;
                                fArray[n15] = fArray[n15] + f10;
                            }
                            this.setProgression((float)(l2 += (long)(n13 - n12)) / (float)l3);
                        }
                        if (this.threadRunning) {
                            n13 = (int)Math.min((long)n9, l - l5);
                            if (floatFileArray != null) {
                                for (n = 0; n < n2; ++n) {
                                    floatFileArray[n].writeFloats(fArray6[n], 0, n13);
                                }
                                l5 += (long)n13;
                                this.setProgression((float)(l2 += (long)n13) / (float)l3);
                            } else {
                                for (n = 0; n < n2; ++n) {
                                    Util.mult(fArray6[n], 0, n13, f);
                                }
                                audioFile.writeFrames(fArray6, 0, n13);
                                l5 += (long)n13;
                                this.setProgression((float)(l2 += (long)n13) / (float)l3);
                            }
                            if (this.threadRunning) {
                                for (n = 0; n < n2; ++n) {
                                    fArray2 = fArray6[n];
                                    for (n6 = 0; n6 < n13; ++n6) {
                                        f4 = Math.abs(fArray2[n6]);
                                        if (!(f4 > f2)) continue;
                                        f2 = f4;
                                    }
                                }
                                n12 = n3;
                                for (n = 0; n < n2; ++n) {
                                    System.arraycopy(fArray3[n], n7, fArray3[n], 0, n3);
                                    fArray2 = fArray6[n];
                                    System.arraycopy(fArray2, n9, fArray2, 0, n5);
                                    n6 = n5;
                                    while (n6 < n11) {
                                        fArray2[n6++] = 0.0f;
                                    }
                                }
                                continue;
                            }
                        }
                    }
                    break block39;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0) {
                        Param param2 = new Param(f2, 1);
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / param2.value), (int)param2.unit), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray3, f, 1.0f);
                        f2 *= f;
                        for (n = 0; n < n2; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        audioFileDescr = null;
                        audioFile2.close();
                        audioFile2 = null;
                        audioFileDescr2 = null;
                        fArray3 = null;
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr2 = null;
                audioFileDescr = null;
                fArray3 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                    floatFileArray[n] = null;
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
                fileArray[n] = null;
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(514);
        if (component != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(1792)) != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(516)) != null) {
            component.setEnabled(this.inRate != 0.0f);
        }
    }

    protected void setInput(String string) {
        AudioFile audioFile = null;
        AudioFileDescr audioFileDescr = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFileDescr = audioFile.getDescr();
            audioFile.close();
            this.inRate = (float)audioFileDescr.rate;
            this.recalcOutFreq();
        }
        catch (IOException iOException) {
            this.inRate = 0.0f;
        }
        this.reflectPropertyChanges();
    }

    protected void recalcOutFreq() {
        if (this.inRate == 0.0f) {
            return;
        }
        double d = this.pr.para[3].value / (double)this.inRate * (Math.PI * 2);
        double d2 = Math.max(-0.98, Math.min(0.98, this.pr.para[1].value / 100.0));
        double d3 = d + 2.0 * Math.atan2(d2 * Math.sin(d), 1.0 - d2 * Math.cos(d));
        ParamField paramField = (ParamField)this.gui.getItemObj(516);
        if (paramField != null) {
            paramField.setParam(new Param(d3 / (Math.PI * 2) * (double)this.inRate, 3));
        }
    }

    protected void recalcWarpAmount() {
        if (this.inRate == 0.0f) {
            return;
        }
        double d = this.pr.para[3].value / (double)this.inRate * (Math.PI * 2);
        double d2 = this.pr.para[4].value / (double)this.inRate * (Math.PI * 2);
        double d3 = Math.tan((d2 - d) / 2.0);
        double d4 = Math.max(-0.98, Math.min(0.98, d3 / (Math.sin(d) + Math.cos(d) * d3)));
        ParamField paramField = (ParamField)this.gui.getItemObj(513);
        if (paramField != null) {
            paramField.setParam(new Param(d4 * 100.0, 16));
        }
    }
}

