/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class LueckenbuesserDlg
extends ModulePanel {
    private static final int PR_INPUTFILE1 = 0;
    private static final int PR_INPUTFILE2 = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_PATIENCE = 0;
    private static final int PR_CROSSFADE = 1;
    private static final int PR_EQP = 0;
    private static final String PRN_INPUTFILE1 = "InputFile1";
    private static final String PRN_INPUTFILE2 = "InputFile2";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_EQP = "EqualPower";
    private static final String PRN_PATIENCE = "Patience";
    private static final String PRN_CROSSFADE = "Crossfade";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile1", "InputFile2", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"Patience", "Crossfade"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"EqualPower"};
    private static final int GG_INPUTFILE1 = 1024;
    private static final int GG_INPUTFILE2 = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_EQP = 0;
    private static final int GG_PATIENCE = 512;
    private static final int GG_CROSSFADE = 513;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_CHANNELS = "All inputs must have the same # of channels!";
    private static final String ERR_CHANNELS2 = "Inputs must have at least one channel!";
    private static final String WARN_CHANNELS = "Warning, multi channel input! Only first channel is analyzed!";

    public LueckenbuesserDlg() {
        super("L\u00fcckenb\u00fc\u00dfer");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            LueckenbuesserDlg.static_pr.text = prText;
            LueckenbuesserDlg.static_pr.textName = prTextName;
            LueckenbuesserDlg.static_pr.intg = prIntg;
            LueckenbuesserDlg.static_pr.intgName = prIntgName;
            LueckenbuesserDlg.static_pr.bool = prBool;
            LueckenbuesserDlg.static_pr.boolName = prBoolName;
            LueckenbuesserDlg.static_pr.para = prPara;
            LueckenbuesserDlg.static_pr.para[0] = new Param(100.0, 2);
            LueckenbuesserDlg.static_pr.para[1] = new Param(10.0, 2);
            LueckenbuesserDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(LueckenbuesserDlg.static_pr.intg, 0, 1);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("File I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input A", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input B", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Fuse$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        ParamSpace paramSpace = new ParamSpace(0.01, 10000.0, 0.01, 2);
        ParamField paramField = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_PATIENCE, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 512, null);
        ParamField paramField2 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_CROSSFADE, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 513, null);
        JCheckBox jCheckBox = new JCheckBox("Equal Power");
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        Info[] infoArray;
        AudioFile audioFile;
        block29: {
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            infoArray = new Info[2];
            int n2 = 4096;
            try {
                PathField pathField;
                int n3 = 0;
                long l = 0L;
                long l2 = 0L;
                for (n = 0; n < 2; ++n) {
                    infoArray[n] = new Info();
                    infoArray[n].sf = AudioFile.openAsRead((File)new File(this.pr.text[0 + n]));
                    infoArray[n].stream = infoArray[n].sf.getDescr();
                    infoArray[n].len = (int)((Info)infoArray[n]).stream.length;
                    if (n == 0) {
                        n3 = ((Info)infoArray[n]).stream.channels;
                    } else if (n3 != ((Info)infoArray[n]).stream.channels) {
                        throw new IOException(ERR_CHANNELS);
                    }
                    Info.access$302(infoArray[n], new float[n3][n2]);
                    l2 += (long)infoArray[n].len;
                }
                if (n3 < 1) {
                    throw new IOException(ERR_CHANNELS2);
                }
                if (n3 != 1) {
                    System.out.println(WARN_CHANNELS);
                }
                if ((pathField = (PathField)this.gui.getItemObj(1026)) == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(infoArray[0].stream);
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block29;
                int n4 = 0;
                int n5 = 4096;
                float[][] fArray = new float[n3][n5];
                int n6 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)infoArray[0].stream, (double)this.pr.para[1].value) + 0.5));
                int n7 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)infoArray[0].stream, (double)this.pr.para[0].value) + 0.5));
                float[] fArray2 = Filter.createWindow(n6, 7);
                float[] fArray3 = new float[n6];
                if (this.pr.bool[0]) {
                    for (n = 0; n < n6; ++n) {
                        fArray3[n] = (float)Math.sqrt(1.0 - (double)(fArray2[n] * fArray2[n]));
                    }
                } else {
                    for (n = 0; n < n6; ++n) {
                        fArray3[n] = 1.0f - fArray2[n];
                    }
                }
                int n8 = 0;
                int n9 = 1;
                float f = 0.0f;
                int n10 = n7;
                int n11 = n7;
                int n12 = 0;
                block5: while (this.threadRunning) {
                    for (n = 0; n < 2; ++n) {
                        if (infoArray[n].bufStop == infoArray[n].bufOff) {
                            int n13 = Math.min(infoArray[n].len - infoArray[n].framesRead, n2);
                            infoArray[n].sf.readFrames(infoArray[n].buf, 0, n13);
                            infoArray[n].bufOff = 0;
                            infoArray[n].bufStop = n13;
                            Info info = infoArray[n];
                            info.framesRead = info.framesRead + n13;
                            this.setProgression((float)(l += (long)n13) / (float)l2);
                        }
                        if (infoArray[n].bufStop != infoArray[n].bufOff) continue;
                        n8 = (n + 1) % 2;
                        n9 = n;
                        break block5;
                    }
                    float f2 = infoArray[n9].buf[0][infoArray[n9].bufOff];
                    while (infoArray[n8].bufOff < infoArray[n8].bufStop) {
                        if (n12 == 0) {
                            float f3 = infoArray[n8].buf[0][infoArray[n8].bufOff];
                            if (f2 >= f && f2 <= f3 || f2 <= f && f2 >= f3) {
                                n8 = n9;
                                n9 = 1 - n8;
                                f = f2;
                                f2 = f3;
                                n11 = n7;
                                n10 = n7;
                                n12 = n6 - 1;
                            } else {
                                f = f3;
                                --n10;
                            }
                        }
                        for (int i = 0; i < n3; ++i) {
                            fArray[i][n4] = infoArray[n8].buf[i][infoArray[n8].bufOff] * fArray2[n12] + infoArray[n9].buf[i][infoArray[n9].bufOff] * fArray3[n12];
                        }
                        if (++n4 == n5) {
                            audioFile.writeFrames(fArray, 0, n4);
                            n4 = 0;
                        }
                        if (n10 == 0) {
                            n10 = n11;
                            if (n11 > 1) {
                                n11 >>= 1;
                            }
                            if (++infoArray[n9].bufOff >= infoArray[n9].bufStop) continue block5;
                            f2 = infoArray[n9].buf[0][infoArray[n9].bufOff];
                        }
                        if (n12 > 0) {
                            --n12;
                            if (++infoArray[n9].bufOff == infoArray[n9].bufStop) continue block5;
                        }
                        infoArray[n8].bufOff++;
                    }
                }
                if (this.threadRunning) {
                    audioFile.writeFrames(fArray, 0, n4);
                    n4 = 0;
                    for (n = 0; n < 2; ++n) {
                        infoArray[n].sf.close();
                        infoArray[n].sf = null;
                    }
                    audioFile.close();
                    audioFile = null;
                    this.setProgression(1.0f);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
        }
        for (n = 0; n < 2; ++n) {
            if (infoArray[n] == null || infoArray[n].sf == null) continue;
            infoArray[n].sf.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    protected class Info {
        private AudioFile sf;
        private AudioFileDescr stream;
        private float[][] buf;
        private int bufOff = 0;
        private int bufStop = 0;
        private int framesRead = 0;
        private int len;

        protected Info() {
        }

        static /* synthetic */ float[][] access$302(Info info, float[][] fArray) {
            info.buf = fArray;
            return fArray;
        }
    }
}

