/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SchizoDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_CALLOSUMFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_GAIN = 0;
    private static final int PR_OFFSET = 1;
    private static final int PR_MGAIN = 2;
    private static final int PR_SGAIN = 3;
    private static final int PR_CONVLENGTH = 4;
    private static final int PR_FLATSPECT = 0;
    private static final int PR_ZEROPHASE = 1;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_CALLOSUMFILE = "CallosumFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_OFFSET = "Offset";
    private static final String PRN_MGAIN = "MGain";
    private static final String PRN_SGAIN = "SGain";
    private static final String PRN_CONVLENGTH = "ConvLen";
    private static final String PRN_FLATSPECT = "FlatSpect";
    private static final String PRN_ZEROPHASE = "ZeroPhase";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "CallosumFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType"};
    private static final boolean[] prBool = new boolean[]{true, false};
    private static final String[] prBoolName = new String[]{"FlatSpect", "ZeroPhase"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "Offset", "MGain", "SGain", "ConvLen"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_CALLOSUMFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_OFFSET = 513;
    private static final int GG_MGAIN = 514;
    private static final int GG_SGAIN = 515;
    private static final int GG_CONVLENGTH = 516;
    private static final int GG_FLATSPECT = 0;
    private static final int GG_ZEROPHASE = 1;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_CHANNELS = "Callosum chan# cannot be\ngreater than output chan#!";

    public SchizoDlg() {
        super("Schizophrenia");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SchizoDlg.static_pr.text = prText;
            SchizoDlg.static_pr.textName = prTextName;
            SchizoDlg.static_pr.intg = prIntg;
            SchizoDlg.static_pr.intgName = prIntgName;
            SchizoDlg.static_pr.bool = prBool;
            SchizoDlg.static_pr.boolName = prBoolName;
            SchizoDlg.static_pr.para = prPara;
            SchizoDlg.static_pr.para[1] = new Param(-100.0, 2);
            SchizoDlg.static_pr.para[2] = new Param(-1.4, 785);
            SchizoDlg.static_pr.para[3] = new Param(-17.0, 785);
            SchizoDlg.static_pr.para[4] = new Param(5.0, 2);
            SchizoDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(SchizoDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(SchizoDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select c.callosum file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Corpus callosum", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1026, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0Schz$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1025, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Surgeon Settings", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[12], Constants.spaces[13]};
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Callosum offset", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        JCheckBox jCheckBox = new JCheckBox("Flatten spect");
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        ParamField paramField2 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mid. gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 514, null);
        JCheckBox jCheckBox2 = new JCheckBox("Zero phases");
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox2, 1, null);
        ParamField paramField3 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Side gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 515, null);
        ParamField paramField4 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Conv. length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 516, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block72: {
            float[] fArray;
            float[] fArray2;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            floatFileArray = null;
            fileArray = null;
            float[][] fArray3 = null;
            float[][] fArray4 = null;
            float[][] fArray5 = null;
            float[] fArray6 = null;
            float[] fArray7 = null;
            float[] fArray8 = null;
            float[][] fArray9 = null;
            int[][] nArray = null;
            float[][] fArray10 = null;
            double[][] dArray = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            try {
                int n2;
                int n3;
                double d;
                double d2;
                boolean bl;
                float f3;
                boolean bl2;
                int n4;
                int n5;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile3.getDescr();
                int n6 = audioFileDescr.channels;
                int n7 = (int)audioFileDescr.length;
                if (n7 < 1 || n6 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block72;
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[2]));
                audioFileDescr3 = audioFile.getDescr();
                int n8 = audioFileDescr3.channels;
                int n9 = (int)audioFileDescr3.length;
                if (n9 < 1 || n8 < 1) {
                    throw new EOFException("File is empty");
                }
                int n10 = (this.pr.para[1].value >= 0.0 ? 1 : -1) * (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr3, (double)Math.abs(this.pr.para[1].value)) + 0.5);
                if (n10 >= 0) {
                    n10 = Math.min(n10, n9);
                    audioFile.seekFrame((long)n10);
                    n9 -= n10;
                    n5 = 0;
                } else {
                    n10 = Math.max(n10, -n7);
                    n5 = -n10;
                }
                n9 = Math.min(n7 - n5, n9);
                int n11 = n7 - n5 - n9;
                if (!this.threadRunning) break block72;
                int n12 = Math.max(2, n6);
                int n13 = n7;
                if (n8 > n12) {
                    throw new EOFException(ERR_CHANNELS);
                }
                int n14 = Math.max(this.pr.bool[0] ? 128 : 32, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[4].value) + 0.5));
                int n15 = n14 * (this.pr.bool[0] || this.pr.bool[1] ? 3 : 2) - 1;
                for (n4 = 2; n4 < n15; n4 <<= 1) {
                }
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFileDescr2.channels = n12;
                audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block72;
                long l = 0L;
                long l2 = (long)n7 + (long)n9 + (long)n13;
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n12];
                    floatFileArray = new FloatFile[n12];
                    for (n = 0; n < n12; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n12; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n13;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block72;
                int n16 = 8192 + n14 - 1;
                n16 -= n16 % n14;
                fArray3 = new float[n6][n16];
                fArray5 = new float[n8][n16];
                fArray4 = new float[n12][n16];
                fArray6 = new float[n4 + 2];
                fArray7 = new float[n4 + 2];
                fArray8 = new float[n4 + 2];
                fArray9 = new float[n12][n14];
                Util.clear(fArray9);
                float f4 = (float)(Param.transform((Param)this.pr.para[2], (int)1, (Param)param, null).value * (double)f);
                float f5 = (float)(Param.transform((Param)this.pr.para[3], (int)1, (Param)param, null).value * (double)f);
                boolean bl3 = bl2 = n8 == 1 || n8 == n12;
                if (!bl2) {
                    nArray = new int[n12][2];
                    fArray10 = new float[n12][2];
                    for (n = 0; n < n12; ++n) {
                        f3 = (float)n / (float)(n12 - 1) * (float)(n8 - 1);
                        nArray[n][0] = (int)f3;
                        nArray[n][1] = ((int)f3 + 1) % n8;
                        fArray10[n][0] = 1.0f - (f3 %= 1.0f);
                        fArray10[n][1] = f3;
                    }
                }
                boolean bl4 = bl = n12 == 2;
                if (!bl) {
                    dArray = new double[n12][2];
                    d2 = 0.0;
                    d = Math.PI * 2 / (double)n12;
                    n = 0;
                    while (n < n12) {
                        dArray[n][0] = Math.cos(d2);
                        dArray[n][1] = Math.sin(d2);
                        ++n;
                        d2 += d;
                    }
                }
                int n17 = 0;
                int n18 = 0;
                while (this.threadRunning && n17 < n5) {
                    n3 = Math.min(n5 - n17, n16);
                    audioFile3.readFrames(fArray3, 0, n3);
                    for (n = 0; n < n12; ++n) {
                        fArray2 = fArray4[n];
                        fArray = fArray3[n % n6];
                        System.arraycopy(fArray, 0, fArray2, 0, n3);
                        Util.mult(fArray2, 0, n3, f4);
                    }
                    n17 += n3;
                    this.setProgression((float)(l += (long)n3) / (float)l2);
                    if (floatFileArray != null) {
                        for (n = 0; n < n12; ++n) {
                            fArray2 = fArray4[n];
                            floatFileArray[n].writeFloats(fArray2, 0, n3);
                        }
                    } else {
                        audioFile2.writeFrames(fArray4, 0, n3);
                    }
                    for (n = 0; n < n12; ++n) {
                        fArray2 = fArray4[n];
                        for (n15 = 0; n15 < n3; ++n15) {
                            f3 = Math.abs(fArray2[n15]);
                            if (!(f3 > f2)) continue;
                            f2 = f3;
                        }
                    }
                    n18 += n3;
                    this.setProgression((float)(l += (long)n3) / (float)l2);
                }
                n17 = 0;
                for (n18 = 0; this.threadRunning && n18 < n9; n18 += n3) {
                    n3 = Math.min(n9 - n17, n16);
                    audioFile3.readFrames(fArray3, 0, n3);
                    audioFile.readFrames(fArray5, 0, n3);
                    n17 += n3;
                    this.setProgression((float)(l += (long)(n3 << 1)) / (float)l2);
                    if (!this.threadRunning) break block72;
                    if (n3 < n16) {
                        for (n = 0; n < n6; ++n) {
                            fArray2 = fArray3[n];
                            for (n15 = n3; n15 < n16; ++n15) {
                                fArray2[n15] = 0.0f;
                            }
                        }
                        for (n = 0; n < n8; ++n) {
                            fArray2 = fArray5[n];
                            for (n15 = n3; n15 < n16; ++n15) {
                                fArray2[n15] = 0.0f;
                            }
                        }
                    }
                    for (n2 = 0; this.threadRunning && n2 < n3; n2 += n14) {
                        for (n = 0; n < n12; ++n) {
                            boolean bl5;
                            fArray2 = fArray4[n];
                            fArray = fArray3[n % n6];
                            System.arraycopy(fArray, n2, fArray2, n2, n14);
                            Util.mult(fArray2, n2, n14, f4);
                            Util.add(fArray9[n], 0, fArray2, n2, n14);
                            boolean bl6 = bl5 = !bl;
                            if (n == 0 || n6 > 1) {
                                System.arraycopy(fArray, n2, fArray6, 0, n14);
                                Util.mult(fArray6, 0, n14, f5);
                                for (n15 = n14; n15 < n4; ++n15) {
                                    fArray6[n15] = 0.0f;
                                }
                                Fourier.realTransform(fArray6, n4, 1);
                                bl5 = true;
                            }
                            if (n == 0 || n8 > 1) {
                                float[] fArray11 = fArray = this.pr.bool[0] ? fArray8 : fArray7;
                                if (bl2) {
                                    System.arraycopy(fArray5[n], n2, fArray, 0, n14);
                                } else {
                                    n15 = 0;
                                    int n19 = n2;
                                    while (n15 < n14) {
                                        fArray[n15] = fArray5[nArray[n][0]][n19] * fArray10[n][0] + fArray5[nArray[n][1]][n19] * fArray10[n][1];
                                        ++n15;
                                        ++n19;
                                    }
                                }
                                for (n15 = n14; n15 < n4; ++n15) {
                                    fArray[n15] = 0.0f;
                                }
                                Fourier.realTransform(fArray, n4, 1);
                                if (this.pr.bool[0]) {
                                    this.flattenSpect(fArray, fArray7, n4 + 2);
                                }
                                if (this.pr.bool[1]) {
                                    this.zeroPhase(fArray7, n4 + 2);
                                }
                                bl5 = true;
                            }
                            if (bl5) {
                                Fourier.complexMult(fArray6, 0, fArray7, 0, fArray8, 0, n4 + 2);
                                if (n > 0) {
                                    if (bl) {
                                        for (n15 = 0; n15 < n4 + 2; ++n15) {
                                            fArray8[n15] = -fArray8[n15];
                                        }
                                    } else {
                                        d2 = dArray[n][0];
                                        d = dArray[n][1];
                                        n15 = 0;
                                        while (n15 < n4 + 2) {
                                            double d3 = fArray8[n15];
                                            double d4 = fArray8[n15 + 1];
                                            fArray8[n15++] = (float)(d3 * d2 - d4 * d);
                                            fArray8[n15++] = (float)(d3 * d + d4 * d2);
                                        }
                                    }
                                }
                                Fourier.realTransform(fArray8, n4, -1);
                            } else {
                                for (n15 = 0; n15 < n4 + 2; ++n15) {
                                    fArray8[n15] = -fArray8[n15];
                                }
                            }
                            Util.add(fArray8, 0, fArray2, n2, n14);
                            System.arraycopy(fArray8, n14, fArray9[n], 0, n14);
                        }
                    }
                    if (this.threadRunning) {
                        if (floatFileArray != null) {
                            for (n = 0; n < n12; ++n) {
                                fArray2 = fArray4[n];
                                floatFileArray[n].writeFloats(fArray2, 0, n3);
                            }
                        } else {
                            audioFile2.writeFrames(fArray4, 0, n3);
                        }
                        for (n = 0; n < n12; ++n) {
                            fArray2 = fArray4[n];
                            for (n15 = 0; n15 < n3; ++n15) {
                                f3 = Math.abs(fArray2[n15]);
                                if (!(f3 > f2)) continue;
                                f2 = f3;
                            }
                        }
                        this.setProgression((float)(l += (long)n3) / (float)l2);
                        continue;
                    }
                    break block72;
                }
                n17 = 0;
                n18 = 0;
                n2 = 0;
                while (this.threadRunning && n17 < n11) {
                    n3 = Math.min(n11 - n17, n16);
                    audioFile3.readFrames(fArray3, 0, n3);
                    for (n = 0; n < n12; ++n) {
                        fArray2 = fArray4[n];
                        fArray = fArray3[n % n6];
                        System.arraycopy(fArray, 0, fArray2, 0, n3);
                        Util.mult(fArray2, 0, n3, f4);
                        if (n2 >= n14) continue;
                        Util.add(fArray9[n], n2, fArray2, 0, Math.min(n3, n14 - n2));
                    }
                    n17 += n3;
                    n2 += n3;
                    this.setProgression((float)(l += (long)n3) / (float)l2);
                    if (floatFileArray != null) {
                        for (n = 0; n < n12; ++n) {
                            fArray2 = fArray4[n];
                            floatFileArray[n].writeFloats(fArray2, 0, n3);
                        }
                    } else {
                        audioFile2.writeFrames(fArray4, 0, n3);
                    }
                    for (n = 0; n < n12; ++n) {
                        fArray2 = fArray4[n];
                        for (n15 = 0; n15 < n3; ++n15) {
                            f3 = Math.abs(fArray2[n15]);
                            if (!(f3 > f2)) continue;
                            f2 = f3;
                        }
                    }
                    n18 += n3;
                    this.setProgression((float)(l += (long)n3) / (float)l2);
                }
                if (this.pr.intg[2] == 0) {
                    Param param2 = new Param(f2, 1);
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / param2.value), (int)param2.unit), null).value;
                    this.normalizeAudioFile(floatFileArray, audioFile2, fArray4, f, 1.0f);
                    f2 *= f;
                    for (n = 0; n < n12; ++n) {
                        floatFileArray[n].cleanUp();
                        floatFileArray[n] = null;
                        fileArray[n].delete();
                        fileArray[n] = null;
                    }
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    audioFileDescr2 = null;
                    audioFile.close();
                    audioFile = null;
                    audioFileDescr3 = null;
                    audioFile3.close();
                    audioFile3 = null;
                    audioFileDescr = null;
                    fArray4 = null;
                    fArray3 = null;
                    fArray5 = null;
                    this.handleClipping(f2);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                audioFileDescr3 = null;
                fArray3 = null;
                fArray4 = null;
                fArray5 = null;
                fArray6 = null;
                fArray7 = null;
                fArray8 = null;
                fArray9 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
            audioFile3 = null;
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    protected void flattenSpect(float[] fArray, float[] fArray2, int n) {
        int n2;
        int n3 = n >> 5;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = n3 >> 1;
        for (n2 = 0; n2 < n4; ++n2) {
            d += (double)(fArray[n2] * fArray[n2]);
        }
        n4 = 0;
        while (n2 < n3) {
            fArray2[n4] = Math.max(1.0E-15f, (float)(d / (double)n2));
            d += (double)(fArray[n2] * fArray[n2]);
            ++n2;
            ++n4;
        }
        d2 = d;
        int n5 = 0;
        while (n2 < n) {
            fArray2[n4] = Math.max(1.0E-15f, (float)(d / (double)n3));
            double d3 = fArray[n2] * fArray[n2];
            d = d - (double)(fArray[n5] * fArray[n5]) + d3;
            d2 += d3;
            ++n2;
            ++n4;
            ++n5;
        }
        d2 /= (double)(n >> 1);
        n2 = n3;
        while (n4 < n) {
            fArray2[n4] = Math.max(1.0E-15f, (float)(d / (double)n2));
            d -= (double)(fArray[n5] * fArray[n5]);
            ++n4;
            --n2;
            ++n5;
        }
        for (n2 = 0; n2 < n; ++n2) {
            float f = Math.min(63096.0f, (float)Math.sqrt(d2 / (double)(fArray2[n2] + fArray2[n2 + 1])));
            fArray2[n2] = fArray[n2] * f;
            fArray2[++n2] = fArray[n2] * f;
        }
    }

    protected void zeroPhase(float[] fArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            double d = fArray[n2++];
            double d2 = fArray[n2];
            fArray[n3] = (float)Math.sqrt(d * d + d2 * d2);
            fArray[n2++] = 0.0f;
        }
    }
}

