/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.DoublePoint;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.SmpMap;
import de.sciss.fscape.util.SmpZone;
import de.sciss.gui.GUIUtil;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JPanel;

public class SmpMapPanel
extends JPanel
implements ComponentListener,
MouseListener,
MouseMotionListener {
    public static final String ACTION_BOXSELECTED = "act";
    public static final String ACTION_BOXDESELECTED = "des";
    public static final String ACTION_BOXCHANGED = "mov";
    public static final String ACTION_BOXCREATED = "new";
    public static final String ACTION_BOXDELETED = "rem";
    public static final String ACTION_SPACECHANGED = "spc";
    protected SmpBox currentSmpBox;
    protected SmpBox dummyBox;
    private Cursor lastCursor;
    private SmpBox dragSource = null;
    private boolean dragState = false;
    private int dragType = 0;
    private int dragOriginX;
    private int dragOriginY;
    private Rectangle dragBounds = null;
    private Rectangle dragRubber;
    private SmpZone dragSmp;
    private DoublePoint dragTopLeft;
    private DoublePoint dragBottomRight;
    private static final int DRAG_NONE = 0;
    private static final int DRAG_TOP = 1;
    private static final int DRAG_LEFT = 2;
    private static final int DRAG_BOTTOM = 4;
    private static final int DRAG_RIGHT = 8;
    private static final int DRAG_MOVE = 15;
    private int[] cursorID = new int[]{0, 8, 10, 6, 9, 0, 4, 0, 11, 7, 0, 0, 5, 0, 0, 13};
    protected static final int SB_STATE_NORMAL = 0;
    protected static final int SB_STATE_SELECTED = 3;
    protected static final int SB_STATE_UNKNOWN = -1;
    protected SmpMap smpMap;
    protected Vector<SmpBox> smpBoxes;
    protected Dimension dim;
    protected double vSpaceLog;
    private Button actionComponent = new Button();
    protected static final String ERR_CORRUPTED = "Internal data corrupted. Please report bug!";

    public SmpMapPanel() {
        this.currentSmpBox = this.dummyBox = new SmpBox();
        this.smpMap = new SmpMap(Constants.spaces[0], Constants.spaces[0]);
        this.smpBoxes = new Vector();
        this.dragRubber = new Rectangle();
        this.setLayout(null);
        this.setBackground(Color.white);
        this.dim = this.getPreferredSize();
        this.setSize(this.dim);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setSmpMap(this.smpMap);
        this.setFocusable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmpMap(SmpMap smpMap) {
        this.clear();
        SmpMap smpMap2 = this.smpMap;
        synchronized (smpMap2) {
            this.smpMap = (SmpMap)smpMap.clone();
            this.vSpaceLog = Math.log(smpMap.vSpace.max / smpMap.vSpace.min);
            this.currentSmpBox = this.dummyBox;
            for (int i = 0; i < smpMap.size(); ++i) {
                SmpBox smpBox = new SmpBox();
                smpBox.setName(this.getSmpName(smpMap.getSample(i)));
                smpBox.addMouseListener(this);
                smpBox.addMouseMotionListener(this);
                this.add(smpBox);
                this.smpBoxes.addElement(smpBox);
            }
        }
        this.recalcScreenBoxes();
        this.recalcBoxColors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmpMap getSmpMap() {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            return (SmpMap)this.smpMap.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            this.currentSmpBox = this.dummyBox;
            this.removeAll();
            this.smpBoxes.setSize(0);
            while (this.smpMap.size() > 0) {
                this.smpMap.removeSample(0);
            }
        }
        this.repaint();
        this.notifyListener(ACTION_BOXDESELECTED, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpaces(ParamSpace paramSpace, ParamSpace paramSpace2) {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            if (paramSpace == null) {
                paramSpace = this.smpMap.hSpace;
            }
            if (paramSpace2 == null) {
                paramSpace2 = this.smpMap.vSpace;
            }
            SmpMap smpMap2 = new SmpMap(paramSpace, paramSpace2, this.smpMap.type);
            Vector<SmpBox> vector = new Vector<SmpBox>();
            for (int i = this.smpMap.size() - 1; i >= 0; --i) {
                SmpZone smpZone = this.smpMap.getSample(i);
                SmpBox smpBox = this.smpBoxes.elementAt(i);
                smpZone.velLo.value = Math.abs(smpZone.velLo.value - this.smpMap.hSpace.min) < 1.0E-6 ? paramSpace.min : paramSpace.fitValue(smpZone.velLo.value);
                smpZone.velHi.value = Math.abs(smpZone.velHi.value - this.smpMap.hSpace.max) < 1.0E-6 ? paramSpace.max : paramSpace.fitValue(smpZone.velHi.value);
                smpZone.freqHi.value = Math.abs(smpZone.freqHi.value - this.smpMap.vSpace.max) < 1.0E-6 ? paramSpace2.max : paramSpace2.fitValue(smpZone.freqHi.value);
                smpZone.freqLo.value = Math.abs(smpZone.freqLo.value - this.smpMap.vSpace.min) < 1.0E-6 ? paramSpace2.min : paramSpace2.fitValue(smpZone.freqLo.value);
                if (smpZone.velHi.value - smpZone.velLo.value + 1.0E-6 > paramSpace.inc && smpZone.freqHi.value - smpZone.freqLo.value + 1.0E-6 > paramSpace2.inc) {
                    int n = smpMap2.addSample(smpZone);
                    if (n != -1) {
                        vector.insertElementAt(smpBox, n);
                        continue;
                    }
                    this.remove(smpBox);
                    continue;
                }
                this.remove(smpBox);
            }
            this.smpMap = smpMap2;
            this.smpBoxes = vector;
            this.vSpaceLog = Math.log(paramSpace2.max / paramSpace2.min);
            this.currentSmpBox.setSelected(0);
            this.currentSmpBox = this.dummyBox;
        }
        this.recalcScreenBoxes();
        this.recalcBoxColors();
        this.notifyListener(ACTION_BOXDESELECTED, -1);
        this.notifyListener(ACTION_SPACECHANGED, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamSpace getHSpace() {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            return this.smpMap.hSpace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamSpace getVSpace() {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            return this.smpMap.vSpace;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionComponent.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionComponent.removeActionListener(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmpZone getSample(int n) {
        SmpZone smpZone = null;
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            if (n == -1) {
                int n2 = this.smpBoxes.indexOf(this.currentSmpBox);
                smpZone = this.smpMap.getSample(n2);
                if (smpZone == null) {
                    return null;
                }
            } else {
                for (int i = 0; i < this.smpMap.size() && ((smpZone = this.smpMap.getSample(i)) == null || smpZone.uniqueID != n); ++i) {
                }
                if (smpZone == null || smpZone.uniqueID != n) {
                    return null;
                }
            }
            return (SmpZone)smpZone.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSample(SmpZone smpZone) {
        SmpBox smpBox = this.currentSmpBox;
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = this.smpBoxes.indexOf(smpBox);
            SmpZone smpZone2 = this.smpMap.getSample(n);
            if (smpZone2 == null || smpZone2.uniqueID != smpZone.uniqueID) {
                for (n = 0; n < this.smpMap.size(); ++n) {
                    smpZone2 = this.smpMap.getSample(n);
                    if (smpZone2.uniqueID == smpZone.uniqueID) break;
                }
                if (smpZone2 == null || smpZone2.uniqueID != smpZone.uniqueID) {
                    GUIUtil.displayError((Component)this, (Exception)new NoSuchElementException(ERR_CORRUPTED), (String)"setSample");
                    return false;
                }
                smpBox.setSelected(0);
                smpBox = this.smpBoxes.elementAt(n);
                smpBox.setSelected(3);
                this.currentSmpBox = smpBox;
            }
            this.smpMap.removeSample(n);
            this.smpBoxes.removeElement(smpBox);
            smpZone = (SmpZone)smpZone.clone();
            int n2 = this.smpMap.addSample(smpZone);
            smpBox.setName(this.getSmpName(smpZone));
            if (n2 == -1 && (n2 = this.smpMap.addSample(smpZone2)) == -1) {
                GUIUtil.displayError((Component)this, (Exception)new IllegalStateException(ERR_CORRUPTED), (String)"setSample");
                this.currentSmpBox.setSelected(0);
                this.currentSmpBox = this.dummyBox;
                this.notifyListener(ACTION_BOXDELETED, smpZone.uniqueID);
                return false;
            }
            this.smpBoxes.insertElementAt(smpBox, n2);
            this.recalcScreenBox(smpBox);
            if (n2 != n) {
                this.recalcBoxColors();
            }
            this.notifyListener(ACTION_BOXCHANGED, smpZone.uniqueID);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmpZone addSample(SmpZone smpZone) {
        SmpBox smpBox = new SmpBox();
        smpBox.setName(this.getSmpName(smpZone));
        smpBox.addMouseListener(this);
        smpBox.addMouseMotionListener(this);
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = this.smpMap.addSample(smpZone);
            if (n >= 0) {
                this.add(smpBox);
                this.smpBoxes.insertElementAt(smpBox, n);
                this.recalcScreenBox(smpBox);
                this.recalcBoxColors();
                this.currentSmpBox.setSelected(0);
                this.currentSmpBox = smpBox;
                this.currentSmpBox.setSelected(3);
                this.notifyListener(ACTION_BOXCREATED, smpZone.uniqueID);
                return smpZone;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBox(SmpBox smpBox) {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = this.smpBoxes.indexOf(smpBox);
            if (n >= 0) {
                this.remove(smpBox);
                SmpZone smpZone = this.smpMap.getSample(n);
                this.smpMap.removeSample(n);
                this.smpBoxes.removeElement(smpBox);
                this.recalcBoxColors();
                this.currentSmpBox.setSelected(0);
                this.currentSmpBox = this.dummyBox;
                this.notifyListener(ACTION_BOXDELETED, smpZone.uniqueID);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        int n2 = 1 << (int)Math.max(0.0, Math.floor(Math.log((float)this.dim.width / 20.0f) / 0.6931471805599453));
        int n3 = 1 << (int)Math.max(0.0, Math.floor(Math.log((float)this.dim.height / 16.0f) / 0.6931471805599453));
        graphics.setColor(Color.lightGray);
        for (n = 0; n <= n2; ++n) {
            graphics.drawLine((this.dim.width - 1) * n / n2, 0, (this.dim.width - 1) * n / n2, this.dim.height);
        }
        for (n = 0; n <= n3; ++n) {
            graphics.drawLine(0, (this.dim.height - 1) * n / n3, this.dim.width, (this.dim.height - 1) * n / n3);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.currentSmpBox != this.dummyBox) {
            this.currentSmpBox.setSelected(0);
            this.currentSmpBox = this.dummyBox;
            this.notifyListener(ACTION_BOXDESELECTED, -1);
        }
        this.setBackground(bl ? Color.white : this.getParent().getBackground());
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(64, 64);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.dim = this.getSize();
        this.recalcScreenBoxes();
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (mouseEvent.getSource() == this) {
            if (mouseEvent.getClickCount() == 2 && !mouseEvent.isAltDown()) {
                DoublePoint doublePoint = new DoublePoint();
                DoublePoint doublePoint2 = new DoublePoint();
                if (this.findFreePlaceAround(mouseEvent.getX(), mouseEvent.getY(), doublePoint, doublePoint2)) {
                    SmpZone smpZone;
                    SmpMap smpMap = this.smpMap;
                    synchronized (smpMap) {
                        smpZone = new SmpZone(new Param(doublePoint.y, this.smpMap.vSpace.unit), new Param(doublePoint2.y, this.smpMap.vSpace.unit), new Param(doublePoint2.x, this.smpMap.hSpace.unit), new Param(doublePoint.x, this.smpMap.hSpace.unit));
                    }
                    Point point = this.paramSpaceToScreen(doublePoint.x, doublePoint.y);
                    Point point2 = this.paramSpaceToScreen(doublePoint2.x, doublePoint2.y);
                    Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
                    Rectangle rectangle2 = new Rectangle(point.x, point.y, point2.x - point.x - 1, point2.y - point.y - 1);
                    Graphics graphics = this.getGraphics();
                    graphics.setColor(Color.black);
                    graphics.setXORMode(this.getBackground());
                    GUISupport.rubberGlide(rectangle, rectangle2, graphics);
                    graphics.dispose();
                    this.addSample(smpZone);
                }
            }
        } else if (mouseEvent.isAltDown()) {
            this.removeBox((SmpBox)mouseEvent.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.currentSmpBox.setSelected(0);
        if (mouseEvent.getSource() == this) {
            if (this.currentSmpBox != this.dummyBox) {
                this.currentSmpBox = this.dummyBox;
                this.notifyListener(ACTION_BOXDESELECTED, -1);
            }
            if (mouseEvent.isControlDown()) {
                // empty if block
            }
        } else {
            this.currentSmpBox = (SmpBox)mouseEvent.getSource();
            Rectangle rectangle = this.currentSmpBox.getBounds();
            this.currentSmpBox.setSelected(3);
            if (!mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
                this.dragOriginX = mouseEvent.getX();
                this.dragOriginY = mouseEvent.getY();
                this.dragBounds = rectangle;
                this.dragSource = this.currentSmpBox;
                SmpMap smpMap = this.smpMap;
                synchronized (smpMap) {
                    int n = this.smpBoxes.indexOf(this.dragSource);
                    if (n >= 0) {
                        this.dragSmp = this.smpMap.getSample(n);
                        this.dragType = 0;
                        if (mouseEvent.getY() < 4) {
                            this.dragType |= 1;
                        } else if (rectangle.height - mouseEvent.getY() < 5) {
                            this.dragType |= 4;
                        }
                        if (mouseEvent.getX() < 4) {
                            this.dragType |= 2;
                        } else if (rectangle.width - mouseEvent.getX() < 5) {
                            this.dragType |= 8;
                        }
                        if (this.dragType == 0) {
                            this.dragType = 15;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        SmpZone smpZone;
        if (!this.isEnabled()) {
            return;
        }
        if (this.dragState) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.setXORMode(this.getBackground());
            Graphics graphics2 = this.dragSource.getGraphics();
            graphics2.setColor(Color.black);
            graphics2.setXORMode(Color.black);
            graphics2.setClip(1, 1, this.dragBounds.width - 2, this.dragBounds.height - 2);
            graphics.drawRect(this.dragRubber.x, this.dragRubber.y, this.dragRubber.width - 1, this.dragRubber.height - 1);
            graphics2.drawRect(this.dragRubber.x - this.dragBounds.x, this.dragRubber.y - this.dragBounds.y, this.dragRubber.width - 1, this.dragRubber.height - 1);
            SmpZone smpZone2 = (SmpZone)this.dragSmp.clone();
            smpZone2.freqHi.value = this.dragTopLeft.y;
            smpZone2.freqLo.value = this.dragBottomRight.y;
            smpZone2.velHi.value = this.dragBottomRight.x;
            smpZone2.velLo.value = this.dragTopLeft.x;
            if (!this.setSample(smpZone2)) {
                GUISupport.rubberGlide(this.dragRubber, this.dragBounds, graphics);
                this.notifyListener(ACTION_BOXSELECTED, smpZone2.uniqueID);
            }
            graphics.dispose();
            graphics2.dispose();
            this.dragState = false;
            this.setCursor(this.lastCursor);
        } else if (this.currentSmpBox != this.dummyBox && !mouseEvent.isAltDown() && (smpZone = this.smpMap.getSample(n = this.smpBoxes.indexOf(this.currentSmpBox))) != null) {
            this.notifyListener(ACTION_BOXSELECTED, smpZone.uniqueID);
        }
        this.dragType = 0;
        this.dragSource = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled() || this.dragType == 0) {
            return;
        }
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.black);
        graphics.setXORMode(this.getBackground());
        Graphics graphics2 = this.dragSource.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.setXORMode(Color.black);
        graphics2.setClip(1, 1, this.dragBounds.width - 2, this.dragBounds.height - 2);
        if (!this.dragState) {
            int n = (mouseEvent.getX() - this.dragOriginX) * (mouseEvent.getX() - this.dragOriginX) + (mouseEvent.getY() - this.dragOriginY) * (mouseEvent.getY() - this.dragOriginY);
            if (this.dragType == 15 && n <= 16) {
                graphics.dispose();
                graphics2.dispose();
                return;
            }
            this.lastCursor = this.getCursor();
            this.setCursor(new Cursor(this.cursorID[this.dragType]));
            this.dragState = true;
            this.dragRubber.setBounds(this.dragSource.getBounds());
            this.dragTopLeft = new DoublePoint(this.dragSmp.velLo.value, this.dragSmp.freqHi.value);
            this.dragBottomRight = new DoublePoint(this.dragSmp.velHi.value, this.dragSmp.freqLo.value);
        } else {
            graphics.drawRect(this.dragRubber.x, this.dragRubber.y, this.dragRubber.width - 1, this.dragRubber.height - 1);
            graphics2.drawRect(this.dragRubber.x - this.dragBounds.x, this.dragRubber.y - this.dragBounds.y, this.dragRubber.width - 1, this.dragRubber.height - 1);
        }
        if ((this.dragType & 2) != 0) {
            this.dragRubber.x = this.dragBounds.x + mouseEvent.getX() - this.dragOriginX;
            if ((this.dragType & 8) == 0) {
                this.dragRubber.width = this.dragBounds.width - mouseEvent.getX() + this.dragOriginX;
            }
        } else if ((this.dragType & 8) != 0) {
            this.dragRubber.width = this.dragBounds.width + mouseEvent.getX() - this.dragOriginX;
        }
        if (this.dragRubber.x < 0) {
            if ((this.dragType & 8) == 0) {
                this.dragRubber.width += this.dragRubber.x;
            }
            this.dragRubber.x = 0;
        }
        if (this.dragRubber.x + this.dragRubber.width > this.dim.width) {
            if ((this.dragType & 2) != 0) {
                this.dragRubber.x = this.dim.width - this.dragRubber.width;
            } else {
                this.dragRubber.width = this.dim.width - this.dragRubber.x + 1;
            }
        }
        if ((this.dragType & 1) != 0) {
            this.dragRubber.y = this.dragBounds.y + mouseEvent.getY() - this.dragOriginY;
            if ((this.dragType & 4) == 0) {
                this.dragRubber.height = this.dragBounds.height - mouseEvent.getY() + this.dragOriginY;
            }
        } else if ((this.dragType & 4) != 0) {
            this.dragRubber.height = this.dragBounds.height + mouseEvent.getY() - this.dragOriginY;
        }
        if (this.dragRubber.y < 0) {
            if ((this.dragType & 4) == 0) {
                this.dragRubber.height += this.dragRubber.y;
            }
            this.dragRubber.y = 0;
        }
        if (this.dragRubber.y + this.dragRubber.height > this.dim.height) {
            if ((this.dragType & 1) != 0) {
                this.dragRubber.y = this.dim.height - this.dragRubber.height;
            } else {
                this.dragRubber.height = this.dim.height - this.dragRubber.y + 1;
            }
        }
        DoublePoint doublePoint = this.screenToParamSpace(this.dragRubber.x, this.dragRubber.y);
        DoublePoint doublePoint2 = this.screenToParamSpace(this.dragRubber.x + this.dragRubber.width - 1, this.dragRubber.y + this.dragRubber.height - 1);
        DoublePoint doublePoint3 = (DoublePoint)this.dragTopLeft.clone();
        DoublePoint doublePoint4 = (DoublePoint)this.dragBottomRight.clone();
        if ((this.dragType & 2) != 0) {
            this.dragTopLeft.x = mouseEvent.getX() != this.dragOriginX ? doublePoint.x : this.dragSmp.velLo.value;
        }
        if ((this.dragType & 1) != 0) {
            this.dragTopLeft.y = mouseEvent.getY() != this.dragOriginY ? doublePoint.y : this.dragSmp.freqHi.value;
        }
        if ((this.dragType & 8) != 0) {
            this.dragBottomRight.x = mouseEvent.getX() != this.dragOriginX ? doublePoint2.x : this.dragSmp.velHi.value;
        }
        if ((this.dragType & 4) != 0) {
            this.dragBottomRight.y = mouseEvent.getY() != this.dragOriginY ? doublePoint2.y : this.dragSmp.freqLo.value;
        }
        this.cutTheCheese(this.dragSmp, this.dragTopLeft, this.dragBottomRight, doublePoint3, doublePoint4);
        Point point = this.paramSpaceToScreen(this.dragTopLeft.x, this.dragTopLeft.y);
        Point point2 = this.paramSpaceToScreen(this.dragBottomRight.x, this.dragBottomRight.y);
        this.dragRubber.setBounds(point.x, point.y, point2.x - point.x + 1, point2.y - point.y + 1);
        graphics.drawRect(this.dragRubber.x, this.dragRubber.y, this.dragRubber.width - 1, this.dragRubber.height - 1);
        graphics2.drawRect(this.dragRubber.x - this.dragBounds.x, this.dragRubber.y - this.dragBounds.y, this.dragRubber.width - 1, this.dragRubber.height - 1);
        graphics.dispose();
        graphics2.dispose();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected void notifyListener(String string, int n) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string + n);
        this.actionComponent.dispatchEvent(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recalcScreenBoxes() {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            for (int i = 0; i < this.smpBoxes.size(); ++i) {
                this.recalcScreenBox(this.smpBoxes.elementAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recalcScreenBox(SmpBox smpBox) {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = this.smpBoxes.indexOf(smpBox);
            SmpZone smpZone = this.smpMap.getSample(n);
            if (smpBox != null && smpZone != null) {
                Point point = this.paramSpaceToScreen(smpZone.velLo.value, smpZone.freqHi.value);
                Point point2 = this.paramSpaceToScreen(smpZone.velHi.value, smpZone.freqLo.value);
                Point point3 = this.paramSpaceToScreen(smpZone.velLo.value, smpZone.base.value);
                smpBox.setBase(point3.y - point.y);
                smpBox.setBounds(point.x, point.y, point2.x - point.x + 1, point2.y - point.y + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recalcBoxColors() {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = this.smpBoxes.size();
            for (int i = 0; i < n; ++i) {
                SmpBox smpBox = this.smpBoxes.elementAt(i);
                smpBox.setColor((float)i / (float)n);
            }
        }
    }

    protected String getSmpName(SmpZone smpZone) {
        String string = smpZone.fileName;
        int n = string.lastIndexOf(File.separatorChar) + 1;
        int n2 = string.lastIndexOf(46);
        if (n2 < n) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DoublePoint screenToParamSpace(int n, int n2) {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            double d = this.smpMap.hSpace.min + (this.smpMap.hSpace.max - this.smpMap.hSpace.min) * (double)n / (double)(this.dim.width - 1);
            double d2 = Math.exp((1.0 - (double)n2 / (double)(this.dim.height - 1)) * this.vSpaceLog) * this.smpMap.vSpace.min;
            return new DoublePoint(this.smpMap.hSpace.fitValue(d), this.smpMap.vSpace.fitValue(d2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point paramSpaceToScreen(double d, double d2) {
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = (int)((double)(this.dim.width - 1) * (d - this.smpMap.hSpace.min) / (this.smpMap.hSpace.max - this.smpMap.hSpace.min) + 0.5);
            int n2 = (int)((double)(this.dim.height - 1) * (1.0 - Math.log(d2 / this.smpMap.vSpace.min) / this.vSpaceLog));
            return new Point(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findFreePlaceAround(int n, int n2, DoublePoint doublePoint, DoublePoint doublePoint2) {
        double d;
        double d2;
        double d3;
        double d4;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        DoublePoint doublePoint3 = this.screenToParamSpace(n, n2);
        double d5 = doublePoint3.x;
        double d6 = doublePoint3.y;
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            d4 = this.smpMap.hSpace.min;
            d3 = this.smpMap.hSpace.max;
            d2 = this.smpMap.vSpace.min;
            d = this.smpMap.vSpace.max;
            double d7 = (d - d2) / (d3 - d4);
            int n3 = this.smpMap.size();
            for (int i = 0; i < n3; ++i) {
                boolean bl;
                SmpZone smpZone = this.smpMap.getSample(i);
                if (smpZone == null) continue;
                boolean bl2 = smpZone.velLo.value < d3 && smpZone.velHi.value > d4;
                boolean bl3 = bl = smpZone.freqHi.value > d2 && smpZone.freqLo.value < d;
                if (!bl2 || !bl) continue;
                int n4 = 0;
                if (smpZone.velHi.value <= d5 && smpZone.velHi.value < d3) {
                    dArray[n4] = smpZone.velHi.value;
                    dArray2[n4] = d3;
                    dArray3[n4] = d2;
                    dArray4[n4] = d;
                    ++n4;
                }
                if (smpZone.velLo.value >= d5 && smpZone.velLo.value > d4) {
                    dArray[n4] = d4;
                    dArray2[n4] = smpZone.velLo.value;
                    dArray3[n4] = d2;
                    dArray4[n4] = d;
                    ++n4;
                }
                if (smpZone.freqLo.value >= d6 && smpZone.freqLo.value > d2) {
                    dArray[n4] = d4;
                    dArray2[n4] = d3;
                    dArray3[n4] = d2;
                    dArray4[n4] = smpZone.freqLo.value;
                    ++n4;
                }
                if (smpZone.freqHi.value <= d6 && smpZone.freqHi.value < d) {
                    dArray[n4] = d4;
                    dArray2[n4] = d3;
                    dArray3[n4] = smpZone.freqHi.value;
                    dArray4[n4] = d;
                    ++n4;
                }
                double d8 = 0.0;
                int n5 = -1;
                for (int j = 0; j < n4; ++j) {
                    double d9 = (dArray2[j] - dArray[j]) / (dArray4[j] - dArray3[j]) * d7;
                    if (d9 > 1.0) {
                        d9 = 1.0 / d9;
                    }
                    if (!(d9 > d8)) continue;
                    d8 = d9;
                    n5 = j;
                }
                if (n5 == -1) {
                    return false;
                }
                d4 = dArray[n5];
                d3 = dArray2[n5];
                d2 = dArray3[n5];
                d = dArray4[n5];
            }
        }
        doublePoint.x = d4;
        doublePoint.y = d;
        doublePoint2.x = d3;
        doublePoint2.y = d2;
        Point point = this.paramSpaceToScreen(d4, d);
        Point point2 = this.paramSpaceToScreen(d3, d2);
        return point2.x - point.x >= 6 && point2.y - point.y >= 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cutTheCheese(SmpZone smpZone, DoublePoint doublePoint, DoublePoint doublePoint2, DoublePoint doublePoint3, DoublePoint doublePoint4) {
        boolean bl;
        long l = System.currentTimeMillis() + 500L;
        double d = smpZone.freqHi.value - smpZone.freqLo.value;
        double d2 = smpZone.velHi.value - smpZone.velLo.value;
        SmpMap smpMap = this.smpMap;
        synchronized (smpMap) {
            int n = this.smpMap.size();
            do {
                bl = false;
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    boolean bl3;
                    SmpZone smpZone2 = this.smpMap.getSample(i);
                    if (smpZone2 == null || smpZone2 == smpZone) continue;
                    boolean bl4 = smpZone2.velLo.value < doublePoint2.x && smpZone2.velHi.value > doublePoint.x;
                    boolean bl5 = bl3 = smpZone2.freqHi.value > doublePoint2.y && smpZone2.freqLo.value < doublePoint.y;
                    if (!bl4 || !bl3) continue;
                    bl = true;
                    boolean bl6 = doublePoint4.x <= smpZone2.velLo.value + 1.0E-6;
                    boolean bl7 = doublePoint3.x >= smpZone2.velHi.value - 1.0E-6;
                    boolean bl8 = doublePoint4.y >= smpZone2.freqHi.value - 1.0E-6;
                    boolean bl9 = bl2 = doublePoint3.y <= smpZone2.freqLo.value + 1.0E-6;
                    if (bl6 && (this.dragType & 8) != 0) {
                        doublePoint2.x = smpZone2.velLo.value;
                        if ((this.dragType & 2) != 0) {
                            doublePoint.x = doublePoint2.x - d2;
                        }
                    }
                    if (bl7 && (this.dragType & 2) != 0) {
                        doublePoint.x = smpZone2.velHi.value;
                        if ((this.dragType & 8) != 0) {
                            doublePoint2.x = doublePoint.x + d2;
                        }
                    }
                    if (bl8 && (this.dragType & 4) != 0) {
                        doublePoint2.y = smpZone2.freqHi.value;
                        if ((this.dragType & 1) != 0) {
                            doublePoint.y = doublePoint2.y + d;
                        }
                    }
                    if (!bl2 || (this.dragType & 1) == 0) continue;
                    doublePoint.y = smpZone2.freqLo.value;
                    if ((this.dragType & 4) == 0) continue;
                    doublePoint2.y = doublePoint.y - d;
                }
            } while (bl && System.currentTimeMillis() < l);
            if (bl) {
                doublePoint.x = doublePoint3.x;
                doublePoint.y = doublePoint3.y;
                doublePoint2.x = doublePoint4.x;
                doublePoint2.y = doublePoint4.y;
            }
        }
        return !bl;
    }

    class SmpBox
    extends Canvas {
        private int state = -1;
        private int base = 0;
        private String name = "";
        private int nameWidth = 0;
        private Font fnt;
        private FontMetrics fntMetr;
        private Color normalColor = SystemColor.control;
        private Color activeColor = OpIcon.selectColor;

        public SmpBox() {
            Font font = this.getFont();
            this.fntMetr = this.getFontMetrics(font);
            this.setSelected(0);
            this.setSize(this.getPreferredSize());
            this.setLocation(0, 0);
            this.enableEvents(16L);
            this.setFocusable(false);
        }

        public void setBase(int n) {
            if (this.base != n) {
                this.base = n;
                this.repaint();
            }
        }

        @Override
        public void setName(String string) {
            this.name = string;
            this.nameWidth = this.fntMetr.stringWidth(string);
            this.repaint();
        }

        public int setSelected(int n) {
            int n2 = this.state;
            this.state = n;
            if (n2 != n) {
                if (n == 0) {
                    this.setForeground(this.normalColor);
                    this.setBackground(this.normalColor);
                } else {
                    this.setForeground(this.activeColor);
                    this.setBackground(this.activeColor);
                }
                this.repaint();
            }
            return n2;
        }

        public int isSelected() {
            return this.state;
        }

        public void setColor(float f) {
            int n = this.state;
            this.state = -1;
            this.normalColor = new Color(Color.HSBtoRGB(f, 0.4f, 0.8f));
            this.activeColor = new Color(Color.HSBtoRGB(f, 1.0f, 0.6f));
            this.setSelected(n);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.draw3DRect(1, 1, dimension.width - 3, dimension.height - 3, true);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            if (this.state == 3) {
                graphics.setColor(Color.white);
            }
            if (this.base < 2) {
                graphics.drawLine(dimension.width - 11, 5, dimension.width - 7, 1);
                graphics.drawLine(dimension.width - 6, 2, dimension.width - 3, 5);
            } else if (this.base < dimension.height - 2) {
                if (this.base > this.fntMetr.getHeight()) {
                    graphics.drawLine(2, this.base, dimension.width - 3, this.base);
                } else {
                    graphics.drawLine(3 + this.nameWidth, this.base, dimension.width - 3, this.base);
                }
            } else {
                graphics.drawLine(dimension.width - 11, dimension.height - 6, dimension.width - 7, dimension.height - 2);
                graphics.drawLine(dimension.width - 6, dimension.height - 3, dimension.width - 3, dimension.height - 6);
            }
            graphics.drawString(this.name, 2, this.fntMetr.getAscent() + 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(6, 6);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.requestFocus();
            }
            super.processMouseEvent(mouseEvent);
        }
    }
}

