/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamEvent;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.SmpMapPanel;
import de.sciss.fscape.gui.SmpZoneGlobal;
import de.sciss.fscape.gui.SmpZoneLocal;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectralFile;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.SmpMap;
import de.sciss.fscape.util.SmpZone;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.Region;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SmpSynDlg
extends ModulePanel {
    private static final int QUALITY_LOW = 0;
    private static final int QUALITY_MID = 1;
    private static final int QUALITY_HIGH = 2;
    private static final String ERR_NOZONES = "No sample zones defined";
    private static final double MIDFREQ = 523.2511306;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private GUISupport sgui = null;
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_SMPMAP = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_OUTPUTRATE = 2;
    private static final int PR_QUALITY = 3;
    private static final int PR_NOISEFLOOR = 0;
    private static final int PR_TRIGTHRESH = 1;
    private static final int PR_GAIN = 2;
    private static final int PR_LENGTH = 3;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_SMPMAP = "SampleMap";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_OUTPUTRATE = "OutputRate";
    private static final String PRN_QUALITY = "Quality";
    private static final String PRN_NOISEFLOOR = "NoiseFloor";
    private static final String PRN_TRIGTHRESH = "TrigThresh";
    private static final String PRN_LENGTH = "Length";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "SampleMap"};
    private static final int[] prIntg = new int[]{0, 0, 0, 1};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "OutputRate", "Quality"};
    private static final Param[] prPara = new Param[]{null, null, null, null};
    private static final String[] prParaName = new String[]{"NoiseFloor", "TrigThresh", "Gain", "Length"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_OUTPUTRATE = 258;
    private static final int GGS_SMPMAP = 2048;
    private static final int GGS_NOISEFLOOR = 2049;
    private static final int GGS_TRIGTHRESH = 2050;
    private static final int GGS_SMPHIFREQ = 2051;
    private static final int GGS_SMPLOFREQ = 2052;
    private static final int GGS_SMPHIVEL = 2053;
    private static final int GGS_SMPLOVEL = 2054;
    private static final int GGS_SMPFILE = 2055;
    private static final int GGS_SMPPHASE = 2056;
    private static final int GGS_SMPGAIN = 2057;
    private static final int GGS_SMPBASE = 2058;
    private static final int GGS_SMPLOOP = 2059;
    private static final int GGS_SMPATK = 2060;
    private static final int GGS_SMPRLS = 2061;
    private static final int GGS_GAIN = 2062;
    private static final int GGS_LENGTH = 2063;
    private static final int GGS_QUALITY = 2064;
    private static final int GG_SETTINGS = 2065;
    private Vector samples;
    private SmpZone currentSmp = null;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_SELECTED = 0;
    private static final int CMD_DESELECTED = 1;
    private static final int CMD_CREATED = 2;
    private static final int CMD_DELETED = 3;
    private static final int CMD_CHANGED = 4;
    private static final int CMD_SPACE = 5;
    private float[] flt;
    private float[] fltD;
    private int fltSmpPerCrossing;
    private SmpMapPanel ggSmpMap;
    private ParamListener paramL;
    private ItemListener il;
    private PathListener pathL;

    public SmpSynDlg() {
        super("Sample Synthesis");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SmpSynDlg.static_pr.text = prText;
            SmpSynDlg.static_pr.textName = prTextName;
            SmpSynDlg.static_pr.intg = prIntg;
            SmpSynDlg.static_pr.intgName = prIntgName;
            SmpSynDlg.static_pr.para = prPara;
            SmpSynDlg.static_pr.para[0] = new Param(-60.0, 785);
            SmpSynDlg.static_pr.para[1] = new Param(12.0, 785);
            SmpSynDlg.static_pr.para[2] = new Param(-6.0, 785);
            SmpSynDlg.static_pr.para[3] = new Param(100.0, 18);
            SmpSynDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(SmpSynDlg.static_pr.intg, 0, 1, 2);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.samples = new Vector();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.paramL = new ParamListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void paramChanged(ParamEvent paramEvent) {
                int n = SmpSynDlg.this.gui.getItemID((EventObject)((Object)paramEvent));
                switch (n) {
                    case -1: {
                        if (SmpSynDlg.this.sgui == null) {
                            return;
                        }
                        n = SmpSynDlg.this.sgui.getItemID((EventObject)((Object)paramEvent));
                        switch (n) {
                            case 2049: {
                                Component component = SmpSynDlg.this.sgui.getItemObj(2048);
                                if (component == null) return;
                                ParamSpace paramSpace = new ParamSpace(((SmpMapPanel)component).getHSpace());
                                paramSpace = new ParamSpace(((ParamField)paramEvent.getSource()).getParam().value, paramSpace.max, paramSpace.inc, paramSpace.unit);
                                ((SmpMapPanel)component).setSpaces(paramSpace, null);
                                break;
                            }
                            case 2050: {
                                break;
                            }
                            case 2051: 
                            case 2052: 
                            case 2053: 
                            case 2054: 
                            case 2058: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                SmpZone smpZone = (SmpZone)SmpSynDlg.this.currentSmp.clone();
                                switch (n) {
                                    case 2051: {
                                        smpZone.freqHi = ((ParamField)paramEvent.getSource()).getParam();
                                        break;
                                    }
                                    case 2052: {
                                        smpZone.freqLo = ((ParamField)paramEvent.getSource()).getParam();
                                        break;
                                    }
                                    case 2053: {
                                        smpZone.velHi = ((ParamField)paramEvent.getSource()).getParam();
                                        break;
                                    }
                                    case 2054: {
                                        smpZone.velLo = ((ParamField)paramEvent.getSource()).getParam();
                                        break;
                                    }
                                    case 2058: {
                                        ((SmpSynDlg)SmpSynDlg.this).currentSmp.base = smpZone.base = ((ParamField)paramEvent.getSource()).getParam();
                                        break;
                                    }
                                }
                                Component component = SmpSynDlg.this.sgui.getItemObj(2048);
                                if (component == null || ((SmpMapPanel)component).setSample(smpZone)) return;
                                ((SmpMapPanel)component).setSample(SmpSynDlg.this.currentSmp);
                                break;
                            }
                            case 2057: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.gain = ((ParamField)paramEvent.getSource()).getParam();
                                break;
                            }
                            case 2060: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.atk = ((ParamField)paramEvent.getSource()).getParam();
                                break;
                            }
                            case 2061: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.rls = ((ParamField)paramEvent.getSource()).getParam();
                            }
                        }
                        return;
                    }
                }
            }
        };
        this.pathL = new PathListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void pathChanged(PathEvent pathEvent) {
                int n = SmpSynDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case -1: {
                        if (SmpSynDlg.this.sgui == null) {
                            return;
                        }
                        n = SmpSynDlg.this.sgui.getItemID((EventObject)pathEvent);
                        switch (n) {
                            case 2055: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.fileName = ((PathField)pathEvent.getSource()).getPath().getPath();
                                SmpSynDlg.this.setSample(((SmpSynDlg)SmpSynDlg.this).currentSmp.fileName);
                                Component component = SmpSynDlg.this.sgui.getItemObj(2048);
                                if (component == null) return;
                                ((SmpMapPanel)component).setSample(SmpSynDlg.this.currentSmp);
                            }
                        }
                        return;
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SmpSynDlg.this.gui.getItemID(actionEvent);
                String string = actionEvent.getActionCommand();
                int n2 = -1;
                block1 : switch (n) {
                    case -1: {
                        if (SmpSynDlg.this.sgui == null) {
                            return;
                        }
                        n = SmpSynDlg.this.sgui.getItemID(actionEvent);
                        switch (n) {
                            case 2048: {
                                int n3 = -1;
                                if (string.startsWith("act")) {
                                    n3 = 0;
                                } else if (string.startsWith("mov")) {
                                    n3 = 4;
                                } else if (string.startsWith("new")) {
                                    n3 = 2;
                                } else if (string.startsWith("des")) {
                                    n3 = 1;
                                } else if (string.startsWith("rem")) {
                                    n3 = 3;
                                } else if (string.startsWith("spc")) {
                                    n3 = 5;
                                }
                                try {
                                    n2 = Integer.parseInt(string.substring(3));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n3 = -1;
                                }
                                switch (n3) {
                                    case 0: 
                                    case 2: 
                                    case 4: {
                                        ParamField paramField;
                                        boolean bl;
                                        SmpZone smpZone = ((SmpMapPanel)actionEvent.getSource()).getSample(n2);
                                        if (smpZone == null) {
                                            GUIUtil.displayError((Component)SmpSynDlg.this.getComponent(), (Exception)new IllegalStateException("Internal data corrupted. Please report bug!"), (String)String.valueOf(n2));
                                            return;
                                        }
                                        boolean bl2 = bl = n3 != 4;
                                        if (n3 == 2) {
                                            SmpSynDlg.this.currentSmp = smpZone;
                                            ((SmpSynDlg)SmpSynDlg.this).currentSmp.fileName = "";
                                            SmpSynDlg.this.samples.addElement(SmpSynDlg.this.currentSmp);
                                        }
                                        if (SmpSynDlg.this.currentSmp == null || ((SmpSynDlg)SmpSynDlg.this).currentSmp.uniqueID != smpZone.uniqueID) {
                                            for (int i = 0; i < SmpSynDlg.this.samples.size(); ++i) {
                                                SmpSynDlg.this.currentSmp = (SmpZone)SmpSynDlg.this.samples.elementAt(i);
                                                if (((SmpSynDlg)SmpSynDlg.this).currentSmp.uniqueID == n2) break;
                                            }
                                            if (SmpSynDlg.this.currentSmp == null || ((SmpSynDlg)SmpSynDlg.this).currentSmp.uniqueID != n2) {
                                                GUIUtil.displayError((Component)SmpSynDlg.this.getComponent(), (Exception)new NoSuchElementException("Internal data corrupted. Please report bug!"), (String)String.valueOf(n2));
                                                return;
                                            }
                                            bl = true;
                                        }
                                        if (n3 == 4) {
                                            ((SmpSynDlg)SmpSynDlg.this).currentSmp.freqLo = smpZone.freqLo;
                                            ((SmpSynDlg)SmpSynDlg.this).currentSmp.freqHi = smpZone.freqHi;
                                            ((SmpSynDlg)SmpSynDlg.this).currentSmp.velLo = smpZone.velLo;
                                            ((SmpSynDlg)SmpSynDlg.this).currentSmp.velHi = smpZone.velHi;
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2051)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.freqHi);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2052)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.freqLo);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2053)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.velHi);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2054)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.velLo);
                                        }
                                        if (!bl) break block1;
                                        Component component = SmpSynDlg.this.sgui.getItemObj(2055);
                                        if (component != null) {
                                            ((PathField)component).setPath(new File(((SmpSynDlg)SmpSynDlg.this).currentSmp.fileName));
                                        }
                                        if ((component = SmpSynDlg.this.sgui.getItemObj(2059)) != null) {
                                            ((JCheckBox)component).setSelected((((SmpSynDlg)SmpSynDlg.this).currentSmp.flags & 0x10) != 0);
                                        }
                                        if ((component = SmpSynDlg.this.sgui.getItemObj(2056)) != null) {
                                            ((JComboBox)component).setSelectedIndex(((SmpSynDlg)SmpSynDlg.this).currentSmp.flags & 0xF);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2057)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.gain);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2058)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.base);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2060)) != null) {
                                            paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.atk);
                                        }
                                        if ((paramField = (ParamField)SmpSynDlg.this.sgui.getItemObj(2061)) == null) break block1;
                                        paramField.setParam(((SmpSynDlg)SmpSynDlg.this).currentSmp.rls);
                                        break block1;
                                    }
                                    case 3: {
                                        for (int i = 0; i < SmpSynDlg.this.samples.size(); ++i) {
                                            SmpSynDlg.this.currentSmp = (SmpZone)SmpSynDlg.this.samples.elementAt(i);
                                            if (((SmpSynDlg)SmpSynDlg.this).currentSmp.uniqueID == n2) break;
                                        }
                                        if (SmpSynDlg.this.currentSmp == null || ((SmpSynDlg)SmpSynDlg.this).currentSmp.uniqueID != n2) {
                                            GUIUtil.displayError((Component)SmpSynDlg.this.getComponent(), (Exception)new NoSuchElementException("Internal data corrupted. Please report bug!"), (String)String.valueOf(n));
                                            return;
                                        }
                                        SmpSynDlg.this.samples.removeElement(SmpSynDlg.this.currentSmp);
                                    }
                                    case 1: {
                                        if (SmpSynDlg.this.currentSmp == null) break block1;
                                        SmpSynDlg.this.currentSmp = null;
                                        Component component = SmpSynDlg.this.sgui.getItemObj(2055);
                                        if (component == null) break block1;
                                        ((PathField)component).setPath(new File("(no sample zone selected)"));
                                        break block1;
                                    }
                                    case 5: {
                                        SmpMap smpMap = ((SmpMapPanel)actionEvent.getSource()).getSmpMap();
                                        Enumeration enumeration = smpMap.getSamples();
                                        Vector<SmpZone> vector = new Vector<SmpZone>();
                                        SmpSynDlg.this.currentSmp = null;
                                        block17: while (enumeration.hasMoreElements()) {
                                            SmpZone smpZone = (SmpZone)enumeration.nextElement();
                                            for (int i = 0; i < SmpSynDlg.this.samples.size(); ++i) {
                                                SmpZone smpZone2 = (SmpZone)SmpSynDlg.this.samples.elementAt(i);
                                                if (smpZone2.uniqueID != smpZone.uniqueID) continue;
                                                smpZone2.freqLo = (Param)smpZone.freqLo.clone();
                                                smpZone2.freqHi = (Param)smpZone.freqHi.clone();
                                                smpZone2.velLo = (Param)smpZone.velLo.clone();
                                                smpZone2.velHi = (Param)smpZone.velHi.clone();
                                                vector.addElement(smpZone2);
                                                continue block17;
                                            }
                                        }
                                        SmpSynDlg.this.samples = vector;
                                        ParamSpace[] paramSpaceArray = new ParamSpace[]{((SmpMapPanel)actionEvent.getSource()).getVSpace()};
                                        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{((SmpMapPanel)actionEvent.getSource()).getHSpace()};
                                        Component component = SmpSynDlg.this.sgui.getItemObj(2051);
                                        if (component != null) {
                                            ((ParamField)component).setSpaces(paramSpaceArray);
                                        }
                                        if ((component = SmpSynDlg.this.sgui.getItemObj(2052)) != null) {
                                            ((ParamField)component).setSpaces(paramSpaceArray);
                                        }
                                        if ((component = SmpSynDlg.this.sgui.getItemObj(2054)) != null) {
                                            ((ParamField)component).setSpaces(paramSpaceArray2);
                                        }
                                        if ((component = SmpSynDlg.this.sgui.getItemObj(2053)) == null) break block1;
                                        ((ParamField)component).setSpaces(paramSpaceArray2);
                                        break block1;
                                    }
                                    case -1: {
                                        GUIUtil.displayError((Component)SmpSynDlg.this.getComponent(), (Exception)new NoSuchMethodException("Internal data corrupted. Please report bug!"), (String)String.valueOf(n));
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
        this.il = new ItemListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = SmpSynDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case -1: {
                        if (SmpSynDlg.this.sgui == null) {
                            return;
                        }
                        n = SmpSynDlg.this.sgui.getItemID(itemEvent);
                        switch (n) {
                            case 2056: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.flags &= 0xFFFFFFF0;
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.flags |= ((JComboBox)itemEvent.getSource()).getSelectedIndex() & 0xF;
                                break;
                            }
                            case 2059: {
                                if (SmpSynDlg.this.currentSmp == null) return;
                                if (((JCheckBox)itemEvent.getSource()).isSelected()) {
                                    ((SmpSynDlg)SmpSynDlg.this).currentSmp.flags |= 0x10;
                                    break;
                                }
                                ((SmpSynDlg)SmpSynDlg.this).currentSmp.flags &= 0xFFFFFFEF;
                            }
                        }
                        return;
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select spectral file");
        pathField.handleTypes(GenericFile.TYPES_SPECT);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, this.pathL);
        PathField pathField2 = new PathField(113, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Syn$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, this.pathL);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        this.gui.registerGadget(pathField2.getRateGadget(), 258);
        this.gui.addLabel(new JLabel("Synthesis settings", 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.sgui = this.createGUI();
        this.gui.addGadget(this.sgui, 2065);
        this.initGUI(this, 6, this.gui);
        this.ggSmpMap.addActionListener(actionListener);
    }

    protected GUISupport createGUI() {
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], Constants.spaces[10]};
        GUISupport gUISupport = new GUISupport();
        GridBagConstraints gridBagConstraints = gUISupport.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        this.ggSmpMap = new SmpMapPanel();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gUISupport.addGadget(this.ggSmpMap, 2048);
        ParamSpace paramSpace = new ParamSpace(Constants.spaces[7]);
        ParamSpace paramSpace2 = new ParamSpace(paramSpace);
        ParamSpace paramSpace3 = new ParamSpace(paramSpace);
        paramSpace = new ParamSpace(this.pr.para[0].value, 0.0, paramSpace.inc, paramSpace.unit);
        paramSpace2 = new ParamSpace(paramSpace2.min, -12.0, paramSpace2.inc, paramSpace2.unit);
        paramSpace3 = new ParamSpace(1.0, 96.0, paramSpace3.inc, paramSpace3.unit);
        ParamSpace paramSpace4 = new ParamSpace(Constants.spaces[15]);
        double d = paramSpace4.fitValue(22050.0);
        paramSpace4 = new ParamSpace(paramSpace4.fitValue(273791.7456741783 / d), d, paramSpace4.inc, paramSpace4.unit);
        SmpMap smpMap = new SmpMap(paramSpace, paramSpace4);
        this.ggSmpMap.setSmpMap(smpMap);
        ParamField paramField = new ParamField(paramSpace2);
        ParamField paramField2 = new ParamField(paramSpace3);
        ParamField paramField3 = new ParamField(Constants.spaces[15]);
        ParamField paramField4 = new ParamField(Constants.spaces[15]);
        ParamField paramField5 = new ParamField(paramSpace);
        ParamField paramField6 = new ParamField(paramSpace);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new GroupLabel("General Sensitivity", 1, 12));
        gridBagConstraints.gridwidth = -1;
        gUISupport.addLabel(new JLabel("Noisefloor", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField, 2049, this.paramL);
        gridBagConstraints.gridwidth = -1;
        gUISupport.addLabel(new JLabel("Trigger", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField2, 2050, this.paramL);
        gridBagConstraints.fill = 1;
        gUISupport.addLabel(new GroupLabel("Sample Zone", 1, 12));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gUISupport.addLabel(new JLabel("High freq", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField4, 2051, this.paramL);
        gridBagConstraints.gridwidth = -1;
        gUISupport.addLabel(new JLabel("Low freq", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField3, 2052, this.paramL);
        gridBagConstraints.gridwidth = -1;
        gUISupport.addLabel(new JLabel("High vel.", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField6, 2053, this.paramL);
        gridBagConstraints.gridwidth = -1;
        gUISupport.addLabel(new JLabel("Low vel.", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField5, 2054, this.paramL);
        PathField pathField = new PathField(0, "Select sample");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel("Sample", 4));
        gridBagConstraints.weightx = 0.9;
        gUISupport.addPathField(pathField, 2055, this.pathL);
        JCheckBox jCheckBox = new JCheckBox("Loop");
        gridBagConstraints.weightx = 0.1;
        gUISupport.addCheckbox(jCheckBox, 2059, this.il);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Continuous");
        jComboBox.addItem("Zero @trig");
        jComboBox.addItem("Spect phase @trig");
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel("Phase", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addChoice(jComboBox, 2056, this.il);
        ParamField paramField7 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gUISupport.addParamField(paramField7, 2057, this.paramL);
        ParamField paramField8 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel("Attack", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField8, 2060, this.paramL);
        ParamField paramField9 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.gridwidth = 1;
        gUISupport.addLabel(new JLabel("Base freq", 4));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gUISupport.addParamField(paramField9, 2058, this.paramL);
        ParamField paramField10 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel("Release", 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField10, 2061, this.paramL);
        gridBagConstraints.weightx = 1.0;
        gUISupport.addLabel(new GroupLabel("Total", 1, 12));
        ParamField paramField11 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gUISupport.addParamField(paramField11, 2062, this.paramL);
        ParamField paramField12 = new ParamField(paramSpaceArray);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel(PRN_LENGTH, 4));
        gridBagConstraints.gridwidth = 0;
        gUISupport.addParamField(paramField12, 2063, this.paramL);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("Low: linear+mono");
        jComboBox2.addItem("Medium: linear");
        jComboBox2.addItem("High: filtered");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gUISupport.addLabel(new JLabel(PRN_QUALITY, 4));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gUISupport.addChoice(jComboBox2, 2064, this.il);
        return gUISupport;
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        Component component = this.sgui.getItemObj(2064);
        if (component != null) {
            ((JComboBox)component).setSelectedIndex(this.pr.intg[3]);
        }
        if ((component = this.sgui.getItemObj(2049)) != null) {
            ((ParamField)component).setParam(this.pr.para[0]);
        }
        if ((component = this.sgui.getItemObj(2050)) != null) {
            ((ParamField)component).setParam(this.pr.para[1]);
        }
        if ((component = this.sgui.getItemObj(2062)) != null) {
            ((ParamField)component).setParam(this.pr.para[2]);
        }
        if ((component = this.sgui.getItemObj(2063)) != null) {
            ((ParamField)component).setParam(this.pr.para[3]);
        }
        if ((component = this.sgui.getItemObj(2048)) != null) {
            this.samples.setSize(0);
            this.currentSmp = null;
            String string = this.pr.text[2];
            if (string.length() != 0) {
                SmpMap smpMap = SmpMap.valueOf(string);
                Enumeration enumeration = smpMap.getSamples();
                while (enumeration.hasMoreElements()) {
                    this.samples.addElement(enumeration.nextElement());
                }
                ((SmpMapPanel)component).setSmpMap(smpMap);
            } else {
                ((SmpMapPanel)component).clear();
            }
        }
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        Component component = this.sgui.getItemObj(2064);
        if (component != null) {
            this.pr.intg[3] = ((JComboBox)component).getSelectedIndex();
        }
        if ((component = this.sgui.getItemObj(2049)) != null) {
            this.pr.para[0] = ((ParamField)component).getParam();
        }
        if ((component = this.sgui.getItemObj(2050)) != null) {
            this.pr.para[1] = ((ParamField)component).getParam();
        }
        if ((component = this.sgui.getItemObj(2062)) != null) {
            this.pr.para[2] = ((ParamField)component).getParam();
        }
        if ((component = this.sgui.getItemObj(2063)) != null) {
            this.pr.para[3] = ((ParamField)component).getParam();
        }
        if ((component = this.sgui.getItemObj(2048)) != null) {
            SmpMap smpMap = ((SmpMapPanel)component).getSmpMap();
            while (smpMap.size() > 0) {
                smpMap.removeSample(0);
            }
            for (int i = 0; i < this.samples.size(); ++i) {
                smpMap.addSample((SmpZone)this.samples.elementAt(i));
            }
            this.pr.text[2] = smpMap.toString();
        }
    }

    public void setInput(String string) {
        SpectralFile spectralFile = null;
        SpectStream spectStream = null;
        try {
            spectralFile = new SpectralFile(string, 0);
            spectStream = spectralFile.getDescr();
            spectralFile.close();
        }
        catch (IOException iOException) {
            GUIUtil.displayError((Component)this.getComponent(), (Exception)iOException, (String)this.getTitle());
            return;
        }
        Component component = this.sgui.getItemObj(2063);
        if (component != null) {
            ((ParamField)component).setReference(new Param(SpectStream.framesToMillis(spectStream, spectStream.frames), 2));
        }
        if ((component = this.sgui.getItemObj(2048)) != null) {
            ParamSpace paramSpace = new ParamSpace(((SmpMapPanel)component).getVSpace());
            paramSpace = new ParamSpace(paramSpace.fitValue(273791.7456741783 / (double)spectStream.hiFreq), paramSpace.max, paramSpace.inc, paramSpace.unit);
            ((SmpMapPanel)component).setSpaces(null, paramSpace);
        }
    }

    public void setSample(String string) {
        AudioFile audioFile = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFile.close();
        }
        catch (IOException iOException) {
            GUIUtil.displayError((Component)this.getComponent(), (Exception)iOException, (String)this.getTitle());
            return;
        }
    }

    @Override
    protected void process() {
        SmpZoneLocal smpZoneLocal;
        SmpZoneLocal[][] smpZoneLocalArray;
        SmpZoneGlobal[] smpZoneGlobalArray;
        int n;
        Object object;
        AudioFileDescr[] audioFileDescrArray;
        AudioFile[] audioFileArray;
        AudioFile audioFile;
        SpectralFile spectralFile;
        block53: {
            spectralFile = null;
            audioFile = null;
            SpectStream spectStream = null;
            AudioFileDescr audioFileDescr = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            SpectFrame spectFrame3 = null;
            int n2 = this.samples.size();
            int[] nArray = null;
            audioFileArray = null;
            audioFileDescrArray = null;
            object = null;
            Param param = new Param(1.0, 1);
            float f = (float)Math.PI * 2;
            boolean bl = false;
            int n3 = 0;
            float f2 = 0.0f;
            try {
                float f3;
                int n4;
                if (n2 == 0) {
                    throw new IOException(ERR_NOZONES);
                }
                spectralFile = new SpectralFile(this.pr.text[0], 0);
                spectStream = spectralFile.getDescr();
                if (spectStream.frames <= 1L) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block53;
                int n5 = spectStream.chanNum;
                if (this.pr.intg[3] == 0) {
                    n5 = 1;
                }
                if (this.pr.intg[3] == 2) {
                    this.fltSmpPerCrossing = 256;
                    n4 = this.fltSmpPerCrossing * 6;
                    this.flt = new float[n4];
                    this.fltD = new float[n4];
                    f3 = Filter.createAntiAliasFilter(this.flt, this.fltD, n4, 0.85f, 6.0f);
                } else {
                    this.flt = null;
                    this.fltD = null;
                    f3 = 1.0f;
                }
                audioFileArray = new AudioFile[n2];
                audioFileDescrArray = new AudioFileDescr[n2];
                object = new float[n2][];
                nArray = new int[n2];
                for (n = 0; n < n2; ++n) {
                    audioFileArray[n] = null;
                    audioFileDescrArray[n] = null;
                    object[n] = null;
                    nArray[n] = -1;
                }
                int n6 = 1;
                block9: for (n = 0; n < n2 && this.threadRunning; ++n) {
                    SmpZone smpZone = (SmpZone)this.samples.elementAt(n);
                    for (int i = 0; i < n; ++i) {
                        SmpZone smpZone2 = (SmpZone)this.samples.elementAt(i);
                        if (!smpZone.fileName.equals(smpZone2.fileName)) continue;
                        nArray[n] = i;
                        audioFileDescrArray[n] = audioFileDescrArray[i];
                        object[n] = object[i];
                        continue block9;
                    }
                    nArray[n] = n;
                    audioFileArray[n] = AudioFile.openAsRead((File)new File(smpZone.fileName));
                    audioFileDescrArray[n] = audioFileArray[n].getDescr();
                    if (audioFileDescrArray[n].length <= 0L) {
                        throw new EOFException("File is empty");
                    }
                    n3 = (int)((long)n3 + audioFileDescrArray[n].length * (long)audioFileDescrArray[n].channels);
                    n6 = Math.max(n6, audioFileDescrArray[n].channels);
                }
                if (!this.threadRunning) break block53;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr();
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = n5;
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block53;
                f3 *= (float)Param.transform((Param)this.pr.para[2], (int)1, (Param)param, (SpectStream)spectStream).value;
                float f4 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, (SpectStream)spectStream).value;
                float f5 = (float)Param.transform((Param)this.pr.para[1], (int)1, (Param)param, (SpectStream)spectStream).value;
                float f6 = (float)Param.transform((Param)this.pr.para[3], (int)2, (Param)new Param((double)SpectStream.framesToMillis((SpectStream)spectStream, (long)spectStream.frames), (int)2), (SpectStream)spectStream).value / 1000.0f;
                int n7 = (int)((double)(f6 / (float)spectStream.frames) * audioFileDescr.rate + 0.5);
                int n8 = n7 * n5;
                smpZoneGlobalArray = new SmpZoneGlobal[n2];
                smpZoneLocalArray = SmpZoneLocal.init(spectStream, audioFileDescr, this.samples, audioFileDescrArray, object, f3, smpZoneGlobalArray, nArray, this.flt != null ? this.flt.length : 0);
                int n9 = 0;
                for (n = 0; n < n2; ++n) {
                    n9 = Math.max(n9, smpZoneGlobalArray[n].rls);
                }
                float[] fArray = new float[(Math.max(n7, n9) + 2) * n5];
                int n10 = fArray.length - n8;
                float[][] fArray2 = new float[n6][Math.max(8192, n7)];
                for (n = 0; n < n2 && nArray[n] != n; ++n) {
                }
                if (n == n2) {
                    throw new IOException("Missing " + n3 + " samples?!");
                }
                int n11 = 0;
                int n12 = 0;
                float f7 = 0.01f;
                while (n11 < n3 && this.threadRunning) {
                    n4 = (int)Math.min((long)(8192 - 8192 % audioFileDescrArray[n].channels), audioFileDescrArray[n].length * (long)audioFileDescrArray[n].channels - (long)n12);
                    if (n4 > 0) {
                        n4 += SmpSynDlg.readInterleaved(audioFileArray[n], object[n], n12 + smpZoneGlobalArray[n].dataOff, n4, fArray2, (int)(audioFileDescrArray[n].length * (long)audioFileDescrArray[n].channels));
                        n12 += n4;
                        n11 += n4;
                    } else {
                        while (++n < n2 && nArray[n] != n) {
                        }
                        if (n == n2) {
                            throw new IOException("Missing " + (n3 - n11) + " samples?!");
                        }
                        n12 = 0;
                    }
                    this.setProgression((float)n11 / (float)n3 * f7);
                }
                for (n = 0; n < n2; ++n) {
                    if (audioFileArray[n] == null) continue;
                    audioFileArray[n].close();
                    audioFileArray[n] = null;
                }
                if (!this.threadRunning) break block53;
                float f8 = this.getProgression();
                f7 = 1.0f - f8;
                spectFrame2 = spectralFile.allocFrame();
                spectFrame3 = spectralFile.readFrame();
                SpectFrame.clear(spectFrame2);
                int n13 = 1;
                while ((long)n13 < spectStream.frames && this.threadRunning) {
                    spectFrame = spectFrame2;
                    spectFrame2 = spectFrame3;
                    spectFrame3 = spectralFile.readFrame();
                    for (int i = 0; i < spectStream.bands; ++i) {
                        int n14;
                        float f9;
                        float f10;
                        if (smpZoneLocalArray[i].length == 0) continue;
                        if (n5 == 1) {
                            f10 = spectFrame2.data[0][(i << 1) + 0];
                            for (f9 = spectFrame2.data[0][(i << 1) + 1]; f9 < 0.0f; f9 += f) {
                            }
                            bl = f10 / spectFrame.data[0][(i << 1) + 0] >= f5;
                        } else {
                            double d = 0.0;
                            double d2 = 0.0;
                            bl = false;
                            for (n14 = 0; n14 < n5; ++n14) {
                                f10 = spectFrame2.data[n14][(i << 1) + 0];
                                f9 = spectFrame2.data[n14][(i << 1) + 1];
                                d += (double)f10 * Math.sin(f9);
                                d2 += (double)f10 * Math.cos(f9);
                                if (!(f10 / spectFrame.data[n14][(i << 1) + 0] >= f5)) continue;
                                bl = true;
                            }
                            f10 = (float)Math.sqrt(d * d + d2 * d2) / (float)n5;
                            f9 = (float)Math.atan2(d, d2) + f;
                        }
                        if (f10 > f4) {
                            for (n = smpZoneLocalArray[i].length - 1; n >= 0; --n) {
                                float f11;
                                smpZoneLocal = smpZoneLocalArray[i][n];
                                if (smpZoneLocal.triggered) {
                                    if (smpZoneLocal.basic.velLo >= f10 || smpZoneLocal.basic.velHi < f10) {
                                        smpZoneLocal.triggered = false;
                                        smpZoneLocal.lvlTarget = 0.0f;
                                        smpZoneLocal.lvlIncr = -smpZoneLocal.lvlCurrent / (float)smpZoneLocal.basic.rls;
                                        for (n14 = 0; n14 < n5; ++n14) {
                                            f10 = spectFrame2.data[n14][(i << 1) + 0];
                                            if (this.flt != null) {
                                                this.resampleFlt(smpZoneLocal, n14, n5, f10, f10, fArray, 0, smpZoneLocal.basic.rls);
                                                continue;
                                            }
                                            this.resampleLin(smpZoneLocal, n14, n5, f10, f10, fArray, 0, smpZoneLocal.basic.rls);
                                        }
                                        continue;
                                    }
                                    for (n14 = 0; n14 < n5; ++n14) {
                                        f10 = spectFrame2.data[n14][(i << 1) + 0];
                                        f11 = spectFrame3.data[n14][(i << 1) + 0];
                                        if (this.flt != null) {
                                            this.resampleFlt(smpZoneLocal, n14, n5, f10, f11, fArray, 0, n7);
                                            continue;
                                        }
                                        this.resampleLin(smpZoneLocal, n14, n5, f10, f11, fArray, 0, n7);
                                    }
                                    continue;
                                }
                                if (!bl || !(smpZoneLocal.basic.velLo < f10) || !(smpZoneLocal.basic.velHi >= f10)) continue;
                                smpZoneLocal.triggered = true;
                                smpZoneLocal.lvlCurrent = 0.0f;
                                smpZoneLocal.lvlTarget = smpZoneLocal.basic.gain;
                                smpZoneLocal.lvlIncr = smpZoneLocal.lvlTarget / (float)smpZoneLocal.basic.atk;
                                switch (smpZoneLocal.basic.phaseType) {
                                    case 0: {
                                        smpZoneLocal.phase = (float)audioFileDescr.length * smpZoneLocal.smpIncr;
                                        break;
                                    }
                                    case 1: {
                                        smpZoneLocal.phase = 0.0f;
                                        break;
                                    }
                                    case 2: {
                                        smpZoneLocal.phase = f9 / f % 1.0f * (float)smpZoneLocal.basic.stream.length;
                                    }
                                }
                                for (n14 = 0; n14 < n5; ++n14) {
                                    f10 = spectFrame2.data[n14][(i << 1) + 0];
                                    f11 = spectFrame3.data[n14][(i << 1) + 0];
                                    if (this.flt != null) {
                                        this.resampleFlt(smpZoneLocal, n14, n5, f10, f11, fArray, 0, n7);
                                        continue;
                                    }
                                    this.resampleLin(smpZoneLocal, n14, n5, f10, f11, fArray, 0, n7);
                                }
                            }
                            continue;
                        }
                        for (n = smpZoneLocalArray[i].length - 1; n >= 0; --n) {
                            smpZoneLocal = smpZoneLocalArray[i][n];
                            if (!smpZoneLocal.triggered) continue;
                            smpZoneLocal.triggered = false;
                            smpZoneLocal.lvlTarget = 0.0f;
                            smpZoneLocal.lvlIncr = -smpZoneLocal.lvlCurrent / (float)smpZoneLocal.basic.rls;
                            for (n14 = 0; n14 < n5; ++n14) {
                                f10 = spectFrame2.data[n14][(i << 1) + 0];
                                if (this.flt != null) {
                                    this.resampleFlt(smpZoneLocal, n14, n5, f10, f10, fArray, 0, smpZoneLocal.basic.rls);
                                    continue;
                                }
                                this.resampleLin(smpZoneLocal, n14, n5, f10, f10, fArray, 0, smpZoneLocal.basic.rls);
                            }
                        }
                    }
                    SmpSynDlg.writeInterleaved(audioFile, fArray, 0, n8, fArray2, n5);
                    spectralFile.freeFrame(spectFrame);
                    for (n = 0; n < n8; ++n) {
                        if (!(Math.abs(fArray[n]) > f2)) continue;
                        f2 = Math.abs(fArray[n]);
                    }
                    System.arraycopy(fArray, n8, fArray, 0, n10);
                    for (n = n10; n < fArray.length; ++n) {
                        fArray[n] = 0.0f;
                    }
                    this.setProgression((float)(++n13) / (float)spectStream.frames * f7 + f8);
                }
                if (this.threadRunning) {
                    spectralFile.freeFrame(spectFrame2);
                    spectralFile.freeFrame(spectFrame3);
                    audioFile.close();
                    audioFile = null;
                    spectralFile.close();
                    spectralFile = null;
                    this.handleClipping(f2);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescrArray = null;
                object = null;
                smpZoneGlobalArray = null;
                smpZoneLocalArray = null;
                smpZoneLocal = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        audioFileDescrArray = null;
        object = null;
        smpZoneGlobalArray = null;
        smpZoneLocalArray = null;
        smpZoneLocal = null;
        this.flt = null;
        this.fltD = null;
        if (spectralFile != null) {
            spectralFile.cleanUp();
            spectralFile = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (audioFileArray != null) {
            for (n = 0; n < audioFileArray.length; ++n) {
                if (audioFileArray[n] == null) continue;
                audioFileArray[n].cleanUp();
                audioFileArray[n] = null;
            }
        }
    }

    protected void resampleLin(SmpZoneLocal smpZoneLocal, int n, int n2, float f, float f2, float[] fArray, int n3, int n4) {
        float f3;
        int n5;
        float f4;
        float f5;
        int n6;
        int n7 = smpZoneLocal.basic.stream.channels;
        int n8 = n % n7;
        float[] fArray2 = smpZoneLocal.basic.data;
        float f6 = smpZoneLocal.phase;
        float f7 = smpZoneLocal.smpIncr;
        float f8 = smpZoneLocal.lvlCurrent * f;
        int n9 = n3 * n2 + n;
        int n10 = n4;
        if (smpZoneLocal.lvlIncr != 0.0f) {
            n6 = (int)((smpZoneLocal.lvlTarget - smpZoneLocal.lvlCurrent) / smpZoneLocal.lvlIncr);
            if (n6 <= n10) {
                if (n6 < 1) {
                    n6 = 1;
                }
                f5 = smpZoneLocal.lvlTarget * (f + (float)n6 / (float)n10 * (f2 - f));
                f4 = (f5 - f8) / (float)n6;
                if (n == n2 - 1) {
                    smpZoneLocal.lvlCurrent = smpZoneLocal.lvlTarget;
                    smpZoneLocal.lvlIncr = 0.0f;
                }
            } else {
                f5 = f2 * (smpZoneLocal.lvlCurrent + (float)n10 * smpZoneLocal.lvlIncr);
                f4 = (f5 - f8) / (float)n10;
                if (n == n2 - 1) {
                    smpZoneLocal.lvlCurrent += smpZoneLocal.lvlIncr * (float)n10;
                    smpZoneLocal.lvlIncr = (smpZoneLocal.lvlTarget - smpZoneLocal.lvlCurrent) / (float)(n6 - n10);
                }
            }
        } else {
            f5 = f2 * smpZoneLocal.lvlCurrent;
            f4 = (f5 - f8) / (float)n10;
            n6 = 0;
        }
        do {
            Region region;
            if ((region = (Region)smpZoneLocal.basic.stream.getProperty((Object)"loop")) != null) {
                while (f6 >= (float)region.span.getStop()) {
                    f6 -= (float)region.span.getLength();
                }
                n5 = Math.min(n10, (int)Math.ceil(((float)region.span.getStop() - f6) / f7));
                if (n5 <= 0) {
                    f6 = region.span.getStart();
                    n5 = Math.min(n10, (int)Math.ceil(((float)region.span.getStop() - f6) / f7));
                    if (n5 <= 0) {
                        return;
                    }
                }
            } else {
                n10 = n5 = Math.min(n10, (int)Math.ceil(((float)smpZoneLocal.basic.stream.length - f6) / f7));
            }
            f3 = f6;
            f5 = f8;
            int n11 = 0;
            while (n11 < n5) {
                float f9 = f3 % 1.0f;
                int n12 = ((int)f3 + smpZoneLocal.basic.dataOff) * n7 + n8;
                int n13 = n9;
                fArray[n13] = fArray[n13] + f5 * (fArray2[n12] * (1.0f - f9) + fArray2[n12 + n7] * f9);
                n9 += n2;
                if (n6 > 0 && --n6 == 0) {
                    f4 = (f2 * smpZoneLocal.lvlTarget - f5) / (float)(n10 - n11);
                    f8 = f5 - (float)n11 * f4;
                }
                f3 = f6 + (float)(++n11) * f7;
                f5 = f8 + (float)n11 * f4;
            }
            f6 = f3;
            f8 = f3;
        } while ((n10 -= n5) > 0);
        if (n == n2 - 1) {
            smpZoneLocal.phase = f3;
        }
    }

    protected void resampleFlt(SmpZoneLocal smpZoneLocal, int n, int n2, float f, float f2, float[] fArray, int n3, int n4) {
        float f3;
        int n5;
        float f4;
        float f5;
        int n6;
        float f6;
        int n7 = smpZoneLocal.basic.stream.channels;
        int n8 = n % n7;
        float[] fArray2 = smpZoneLocal.basic.data;
        float f7 = smpZoneLocal.phase;
        float f8 = smpZoneLocal.smpIncr;
        if (f8 > 1.0f) {
            f6 = (float)this.fltSmpPerCrossing / f8;
            f /= f8;
            f2 /= f8;
        } else {
            f6 = this.fltSmpPerCrossing;
        }
        float f9 = smpZoneLocal.lvlCurrent * f;
        int n9 = n3 * n2 + n;
        int n10 = n4;
        if (smpZoneLocal.lvlIncr != 0.0f) {
            n6 = (int)((smpZoneLocal.lvlTarget - smpZoneLocal.lvlCurrent) / smpZoneLocal.lvlIncr);
            if (n6 <= n10) {
                if (n6 < 1) {
                    n6 = 1;
                }
                f5 = smpZoneLocal.lvlTarget * (f + (float)n6 / (float)n10 * (f2 - f));
                f4 = (f5 - f9) / (float)n6;
                if (n == n2 - 1) {
                    smpZoneLocal.lvlCurrent = smpZoneLocal.lvlTarget;
                    smpZoneLocal.lvlIncr = 0.0f;
                }
            } else {
                f5 = f2 * (smpZoneLocal.lvlCurrent + (float)n10 * smpZoneLocal.lvlIncr);
                f4 = (f5 - f9) / (float)n10;
                if (n == n2 - 1) {
                    smpZoneLocal.lvlCurrent += smpZoneLocal.lvlIncr * (float)n10;
                    smpZoneLocal.lvlIncr = (smpZoneLocal.lvlTarget - smpZoneLocal.lvlCurrent) / (float)(n6 - n10);
                }
            }
        } else {
            f5 = f2 * smpZoneLocal.lvlCurrent;
            f4 = (f5 - f9) / (float)n10;
            n6 = 0;
        }
        do {
            Region region;
            if ((region = (Region)smpZoneLocal.basic.stream.getProperty((Object)"loop")) != null) {
                while (f7 >= (float)region.span.getStop()) {
                    f7 -= (float)region.span.getLength();
                }
                n5 = Math.min(n10, (int)Math.ceil(((float)region.span.getStop() - f7) / f8));
                if (n5 <= 0) {
                    f7 = region.span.getStart();
                    n5 = Math.min(n10, (int)Math.ceil(((float)region.span.getStop() - f7) / f8));
                    if (n5 <= 0) {
                        return;
                    }
                }
            } else {
                n10 = n5 = Math.min(n10, (int)Math.ceil(((float)smpZoneLocal.basic.stream.length - f7) / f8));
            }
            f3 = f7;
            f5 = f9;
            int n11 = 0;
            while (n11 < n5) {
                float f10 = f3 % 1.0f;
                float f11 = 0.0f;
                int n12 = -n7;
                for (int i = 0; i < 2; ++i) {
                    int n13 = ((int)f3 + smpZoneLocal.basic.dataOff + i) * n7 + n8;
                    float f12 = f10 * f6;
                    int n14 = (int)f12;
                    while (n14 < this.flt.length) {
                        float f13 = f12 % 1.0f;
                        f11 += fArray2[n13] * (this.flt[n14] + this.fltD[n14] * f13);
                        n13 += n12;
                        n14 = (int)(f12 += f6);
                    }
                    f10 = 1.0f - f10;
                    n12 = -n12;
                }
                int n15 = n9;
                fArray[n15] = fArray[n15] + f11 * f5;
                n9 += n2;
                if (n6 > 0 && --n6 == 0) {
                    f4 = (f2 * smpZoneLocal.lvlTarget - f5) / (float)(n10 - n11);
                    f9 = f5 - (float)n11 * f4;
                }
                f3 = f7 + (float)(++n11) * f8;
                f5 = f9 + (float)n11 * f4;
            }
            f7 = f3;
            f9 = f3;
        } while ((n10 -= n5) > 0);
        if (n == n2 - 1) {
            smpZoneLocal.phase = f3;
        }
    }

    private static int readInterleaved(AudioFile audioFile, float[] fArray, int n, int n2, float[][] fArray2, int n3) throws IOException {
        assert (n2 % n3 == 0) : "invalid interleaved length";
        int n4 = n2 / n3;
        audioFile.readFrames(fArray2, 0, n4);
        for (int i = 0; i < n3; ++i) {
            int n5 = n + i;
            for (int j = 0; j < n2; j += n3) {
                fArray[n5] = fArray2[i][j];
                ++n5;
            }
        }
        return n2;
    }

    private static void writeInterleaved(AudioFile audioFile, float[] fArray, int n, int n2, float[][] fArray2, int n3) throws IOException {
        assert (n2 % n3 == 0) : "invalid interleaved length";
        int n4 = n2 / n3;
        for (int i = 0; i < n3; ++i) {
            int n5 = n + i;
            for (int j = 0; j < n2; j += n3) {
                fArray2[i][j] = fArray[n5];
                ++n5;
            }
        }
        audioFile.writeFrames(fArray2, 0, n4);
    }
}

