/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.SpectPanel;
import de.sciss.fscape.gui.ToolIcon;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JLabel;

public class Spectrogram
extends Frame
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
WindowListener {
    public Image img = null;
    public boolean pausing = false;
    private static final int GG_STARTPAUSE = 1;
    private static final int GG_ZOOMIN = 3;
    private static final int GG_ZOOMOUT = 4;
    private static final int GG_PANEL = 5;
    protected GUISupport gui = null;
    protected SpectPanel spectPanel;
    protected JLabel lbFreq;
    private Cursor lastCursor = null;
    private Graphics imgG = null;
    private float[] rgb = new float[]{0.0f, 0.0f, 0.0f};
    private SpectStreamSlot owner;
    private SpectStream stream = null;
    private int width = 192;
    private int height = 128;
    private int x = 0;
    private int[] xTime;
    private int zoom = 0;
    private int maxZoom = 0;
    private int lines = 0;
    private int bottomLine = 0;
    private double freqSpacing;
    private Cursor dragCursor;
    private int dragLastY;

    public Spectrogram(SpectStreamSlot spectStreamSlot) {
        super(((OpIcon)spectStreamSlot.getOwner().getIcon()).getName() + (spectStreamSlot.toString() == "out" ? "" : "(" + spectStreamSlot.toString() + ")") + " - Spectrogram");
        this.owner = spectStreamSlot;
        this.rgb = new float[3];
        this.dragCursor = new Cursor(8);
        this.xTime = new int[this.width];
        for (int i = 0; i < this.xTime.length; ++i) {
            this.xTime[i] = -1;
        }
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        gridBagConstraints.anchor = 17;
        ToolIcon toolIcon = new ToolIcon(4, null);
        this.gui.addCanvas(toolIcon, 1, this);
        gridBagConstraints.insets = new Insets(2, 16, 0, 2);
        gridBagConstraints.anchor = 17;
        ToolIcon toolIcon2 = new ToolIcon(8, null);
        toolIcon2.setEnabled(false);
        this.gui.addCanvas(toolIcon2, 3, this);
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        ToolIcon toolIcon3 = new ToolIcon(7, null);
        toolIcon3.setEnabled(false);
        gridBagConstraints.gridwidth = 0;
        this.gui.addCanvas(toolIcon3, 4, this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.spectPanel = new SpectPanel(this, this.width, this.height);
        this.spectPanel.addMouseListener(this);
        this.spectPanel.addMouseMotionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.gui.addGadget(this.spectPanel, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.lbFreq = new JLabel();
        gridBagConstraints.weighty = 0.0;
        this.gui.addLabel(this.lbFreq);
        this.add(this.gui);
        this.pack();
        this.addWindowListener(this);
        this.setVisible(true);
        this.img = this.createImage(this.width, this.height);
        this.imgG = this.img.getGraphics();
        this.imgG.setColor(Color.black);
        this.imgG.fillRect(0, 0, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newStream(SpectStream spectStream) {
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            this.stream = spectStream;
            this.maxZoom = 0;
            while (spectStream.bands >> this.maxZoom > this.height) {
                ++this.maxZoom;
            }
            this.zoom = Math.max(0, this.maxZoom - 1);
            this.bottomLine = 0;
            this.freqSpacing = (spectStream.hiFreq - spectStream.loFreq) / (float)spectStream.bands;
            this.updateZoomGG();
            this.spectPanel.setCursor(new Cursor(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ownerTerminated() {
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            this.owner = null;
            this.updateZoomGG();
            this.stream = null;
            this.pausing = true;
            Component component = this.gui.getItemObj(1);
            if (component != null) {
                component.setEnabled(false);
            }
            this.spectPanel.setCursor(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(SpectFrame spectFrame) {
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            int n;
            if (this.stream == null || this.pausing) {
                return;
            }
            if (this.lines < this.height) {
                this.imgG.setColor(Color.black);
                this.imgG.drawLine(this.x, this.lines, this.x, this.height - 1);
            }
            if (this.stream.chanNum == 1) {
                int n2 = this.bottomLine;
                n = this.lines - 1;
                while (n2 < this.bottomLine + this.lines) {
                    this.rgb[0] = (float)Math.sqrt(spectFrame.data[0][n2 << this.zoom + 1 + 0] * 1.17f);
                    if (this.rgb[0] < 0.0f) {
                        this.rgb[0] = 0.0f;
                    }
                    if (this.rgb[0] > 1.0f) {
                        this.rgb[0] = 1.0f;
                    }
                    this.imgG.setColor(new Color(this.rgb[0], this.rgb[0], this.rgb[0]));
                    this.imgG.drawLine(this.x, n, this.x, n);
                    ++n2;
                    --n;
                }
            } else {
                int n3 = this.bottomLine;
                n = this.lines - 1;
                while (n3 < this.bottomLine + this.lines) {
                    for (int i = 0; i < Math.min(this.stream.chanNum, 3); ++i) {
                        this.rgb[i] = (float)Math.sqrt(spectFrame.data[i][(n3 << this.zoom + 1) + 0] * 1.17f);
                        if (this.rgb[i] < 0.0f) {
                            this.rgb[i] = 0.0f;
                        }
                        if (!(this.rgb[i] > 1.0f)) continue;
                        this.rgb[i] = 1.0f;
                    }
                    this.imgG.setColor(new Color(this.rgb[0], this.rgb[1], this.rgb[2]));
                    this.imgG.drawLine(this.x, n, this.x, n);
                    ++n3;
                    --n;
                }
            }
            this.xTime[this.x] = (int)SpectStream.framesToMillis(this.stream, this.stream.framesWritten - 1L);
            this.x = (this.x + 1) % this.width;
            n = Math.min(4, this.bottomLine - (this.stream.bands >> this.zoom + 1));
            n = Math.max(n, 5 - this.lines);
            this.imgG.setColor(OpIcon.progColor);
            this.imgG.drawLine(this.x, 0, this.x, this.lines - 2 + n);
            this.imgG.setColor(Color.red);
            this.imgG.drawLine(this.x, this.lines - 1 + n, this.x, this.height);
            this.spectPanel.repaint();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.gui.getItemID(mouseEvent);
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            if (this.stream == null) {
                return;
            }
            switch (n) {
                case 1: {
                    Component component = this.gui.getItemObj(1);
                    if (component == null) break;
                    int n2 = ((ToolIcon)component).getID();
                    this.pausing = n2 == 4;
                    ((ToolIcon)component).setID(this.pausing ? 3 : 4);
                    break;
                }
                case 3: 
                case 4: {
                    Spectrogram spectrogram2 = this;
                    synchronized (spectrogram2) {
                        int n3 = this.bottomLine + (this.lines >> 1) << this.zoom;
                        if (n == 3) {
                            if (this.zoom > 0) {
                                --this.zoom;
                            }
                        } else if (this.zoom < this.maxZoom) {
                            ++this.zoom;
                        }
                        this.bottomLine = (n3 >> this.zoom) - (this.lines >> 1);
                        this.updateZoomGG();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.spectPanel && this.stream != null && this.height == this.lines) {
            this.dragLastY = mouseEvent.getY();
            this.lastCursor = this.spectPanel.getCursor();
            this.spectPanel.setCursor(this.dragCursor);
            this.lbFreq.setText(null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.spectPanel && this.stream != null) {
            this.spectPanel.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            if (this.stream == null || this.height > this.lines || mouseEvent.getY() == this.dragLastY) {
                return;
            }
            int n = this.bottomLine;
            this.bottomLine = Math.max(0, this.bottomLine + mouseEvent.getY() - this.dragLastY);
            this.bottomLine = Math.min(this.bottomLine, (this.stream.bands >> this.zoom) - this.lines);
            if (n != this.bottomLine) {
                this.imgG.copyArea(0, 0, this.width, this.height, 0, this.bottomLine - n);
                this.dragLastY = mouseEvent.getY();
                this.imgG.setColor(Color.black);
                if (n < this.bottomLine) {
                    this.imgG.fillRect(0, 0, this.width, this.bottomLine - n);
                } else {
                    this.imgG.fillRect(0, this.height - n + this.bottomLine, this.width, this.height);
                }
                this.spectPanel.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.bottomLine + (this.lines - 1 - mouseEvent.getY()) << this.zoom;
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            if (mouseEvent.getSource() == this.spectPanel && this.stream != null && n >= 0 && n < this.stream.bands) {
                this.lbFreq.setText("" + (int)((double)n * this.freqSpacing + (double)this.stream.loFreq) + (mouseEvent.getX() < this.xTime.length && this.xTime[mouseEvent.getX()] != -1 ? " Hz; " + this.xTime[mouseEvent.getX()] + " ms" : " Hz"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        Spectrogram spectrogram = this;
        synchronized (spectrogram) {
            this.pausing = true;
            if (this.img != null) {
                this.img.flush();
                this.img = null;
            }
            if (this.imgG != null) {
                this.imgG.dispose();
                this.imgG = null;
            }
            this.owner = null;
            this.stream = null;
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private void updateZoomGG() {
        Component component = this.gui.getItemObj(3);
        Component component2 = this.gui.getItemObj(4);
        if (component != null) {
            component.setEnabled(this.zoom > 0 && this.owner != null);
        }
        if (component2 != null) {
            component2.setEnabled(this.zoom < this.maxZoom && this.owner != null);
        }
        if (this.stream != null) {
            this.lines = Math.min(this.height, this.stream.bands >> this.zoom);
            int n = this.bottomLine;
            this.bottomLine = Math.max(this.bottomLine, 0);
            this.bottomLine = Math.min(this.bottomLine, (this.stream.bands >> this.zoom) - this.lines);
            if (n != this.bottomLine) {
                this.imgG.copyArea(0, 0, this.width, this.height, 0, this.bottomLine - n);
                this.imgG.setColor(Color.black);
                if (n < this.bottomLine) {
                    this.imgG.fillRect(0, 0, this.width, this.bottomLine - n);
                } else {
                    this.imgG.fillRect(0, this.height - n + this.bottomLine, this.width, this.height);
                }
                this.spectPanel.repaint();
            }
        }
    }
}

