/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SundayDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_WINDOW = 3;
    private static final int PR_OVERLAP = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_CALCLEN = 1;
    private static final int PR_STEPSIZE = 2;
    private static final int PR_LPORDER = 3;
    private static final int PR_RESIDUAL = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_CALCLEN = "CalcLen";
    private static final String PRN_STEPSIZE = "StepSize";
    private static final String PRN_LPORDER = "LPOrder";
    private static final String PRN_RESIDUAL = "Residual";
    private static final String PRN_WINDOW = "Window";
    private static final String PRN_OVERLAP = "Overlap";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 7, 2};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Window", "Overlap"};
    private static final Param[] prPara = new Param[]{null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "CalcLen", "StepSize", "LPOrder"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"Residual"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_WINDOW = 259;
    private static final int GG_OVERLAP = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_CALCLEN = 513;
    private static final int GG_STEPSIZE = 514;
    private static final int GG_LPORDER = 515;
    private static final int GG_RESIDUAL = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public SundayDlg() {
        super("Sunday");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SundayDlg.static_pr.text = prText;
            SundayDlg.static_pr.textName = prTextName;
            SundayDlg.static_pr.intg = prIntg;
            SundayDlg.static_pr.intgName = prIntgName;
            SundayDlg.static_pr.bool = prBool;
            SundayDlg.static_pr.boolName = prBoolName;
            SundayDlg.static_pr.para = prPara;
            SundayDlg.static_pr.para[1] = new Param(32.0, 2);
            SundayDlg.static_pr.para[2] = new Param(8.0, 2);
            SundayDlg.static_pr.para[3] = new Param(10.0, 0);
            SundayDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(SundayDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(SundayDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Sun$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("LP Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Analysis Size", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamField paramField2 = new ParamField(new ParamSpace(2.0, 100000.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("LP Order", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 515, null);
        ParamField paramField3 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Synthesis Size", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 514, null);
        String[] stringArray = Filter.getWindowNames();
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < stringArray.length; ++n) {
            jComboBox.addItem(stringArray[n]);
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_WINDOW, 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < 5; ++n) {
            jComboBox2.addItem("1/" + (1 << n));
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Window Step", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox2, 260, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_RESIDUAL, 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox, 0, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        block31: {
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            FloatFile[] floatFileArray = null;
            File[] fileArray = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            try {
                int n;
                int n2;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n3 = audioFileDescr.channels;
                int n4 = (int)audioFileDescr.length;
                if (n4 * n3 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block31;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block31;
                int n5 = 64;
                int n6 = n5 << 1;
                double d = 1.0 / (double)(n5 - 1);
                float[][] fArray = new float[n3][n6];
                float[][] fArray2 = new float[n3][n5];
                Util.clear(fArray);
                long l = 0L;
                long l2 = (long)n4 * 3L;
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n3];
                    floatFileArray = new FloatFile[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        fileArray[n2] = null;
                        floatFileArray[n2] = null;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        fileArray[n2] = IOUtil.createTempFile();
                        floatFileArray[n2] = new FloatFile(fileArray[n2], 1);
                    }
                    l2 += (long)n4;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block31;
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; this.threadRunning && i < n4; i += n) {
                    int n9;
                    float[] fArray3;
                    for (n2 = 0; n2 < n3; ++n2) {
                        System.arraycopy(fArray[n2], n5, fArray[n2], 0, n5);
                    }
                    n = Math.min(n6 - n8, n4 - n7);
                    audioFile2.readFrames(fArray, n8, n);
                    if (n + n8 < n6) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            fArray3 = fArray[n2];
                            n9 = n8 + n;
                            while (n9 < n6) {
                                fArray3[n9++] = 0.0f;
                            }
                        }
                    }
                    n7 += n;
                    this.setProgression((float)(l += (long)n) / (float)l2);
                    if (this.threadRunning) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            fArray3 = fArray[n2];
                            float[] fArray4 = fArray2[n2];
                            for (int j = 0; j < n5; ++j) {
                                double d2 = fArray3[j];
                                n9 = j + 1;
                                for (int k = n5 - 1; k > 0; --k) {
                                    d2 *= (double)fArray3[n9];
                                    ++n9;
                                }
                                fArray4[j] = (float)Math.pow(d2, d);
                            }
                        }
                        this.setProgression((float)(l += (long)n) / (float)l2);
                        if (this.threadRunning) {
                            float f3;
                            n = Math.min(n5, n4 - i);
                            if (floatFileArray != null) {
                                for (n2 = 0; n2 < n3; ++n2) {
                                    fArray3 = fArray2[n2];
                                    for (n9 = 0; n9 < n; ++n9) {
                                        f3 = Math.abs(fArray3[n9]);
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                    floatFileArray[n2].writeFloats(fArray3, 0, n);
                                }
                            } else {
                                for (n2 = 0; n2 < n3; ++n2) {
                                    fArray3 = fArray2[n2];
                                    for (n9 = 0; n9 < n; ++n9) {
                                        f3 = Math.abs(fArray3[n9]);
                                        int n10 = n9;
                                        fArray3[n10] = fArray3[n10] * f;
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                }
                                audioFile.writeFrames(fArray2, 0, n);
                            }
                            this.setProgression((float)(l += (long)n) / (float)l2);
                            n8 = n5;
                            continue;
                        }
                    }
                    break block31;
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray, f, 1.0f);
                        for (n2 = 0; n2 < n3; ++n2) {
                            floatFileArray[n2].cleanUp();
                            floatFileArray[n2] = null;
                            fileArray[n2].delete();
                            fileArray[n2] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        this.handleClipping(f2 *= f);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                float[][] fArray = null;
                float[][] fArray5 = null;
                Object var21_33 = null;
                Object var22_35 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
    }
}

