/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.io;

import de.sciss.fscape.io.ImageFile;
import de.sciss.fscape.spect.SpectralFile;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class GenericFile
extends RandomAccessFile {
    public static final int MODE_INPUT = 0;
    public static final int MODE_OUTPUT = 1;
    public static final int MODE_FILEMASK = 15;
    public static final int MODE_GENERIC = 0;
    public static final int MODE_TIFF = 16;
    public static final int MODE_AIFF = 32;
    public static final int MODE_SND = 48;
    public static final int MODE_SPECT = 64;
    public static final int MODE_FLOAT = 80;
    public static final int MODE_MPEG = 96;
    public static final int MODE_MOV = 112;
    public static final int MODE_IRCAM = 128;
    public static final int MODE_WAVE = 144;
    public static final int MODE_WAVE64 = 160;
    public static final int MODE_TYPEMASK = 65520;
    public static final int[] TYPES_IMAGE = new int[]{16};
    public static final int[] TYPES_MOVIE = new int[]{96, 112};
    public static final int[] TYPES_SOUND = new int[]{32, 48, 128, 144, 160};
    public static final int[] TYPES_SPECT = new int[]{64};
    public static final int MODE_SPECIALMASK = 0xFF0000;
    public int mode;
    public static final String ERR_ILLEGALFILE = "Unsupported file format";
    public static final String ERR_CORRUPTED = "File is corrupted";
    public static final String ERR_MISSINGDATA = "Essential data missing";
    public static final String ERR_UNSUPPORTED = "Unsupported encoding";
    protected File file;
    protected static final int TIFF_MAC_MAGIC = 1296891946;
    protected static final int TIFF_IBM_MAGIC = 1229520938;
    protected static final int FORM_MAGIC = 1179603533;
    protected static final int AIFF_MAGIC = 1095321158;
    protected static final int AIFC_MAGIC = 1095321155;
    protected static final int SND_MAGIC = 779316836;
    protected static final int CSA_MAGIC = 517730;
    protected static final int SHA_MAGIC = 1165124197;
    protected static final int FLOAT_MAGIC = 1179870022;
    protected static final int MPEG_MAGIC1 = 435;
    protected static final int MPEG_MAGIC2 = 442;
    protected static final int MOV_MAGIC = 1836019574;
    protected static final int IRCAM_MAGIC = 107364;
    protected static final int RIFF_MAGIC = 1380533830;
    protected static final int WAVE_MAGIC = 1463899717;
    protected static final int TYPESHIFT = 4;
    protected static final int[] FILETYPE = new int[]{0x3F3F3F3F, 1414088262, 1095321158, 1315264596, 0x44415441, 1179870022, 1297106247, 1299148630, 1230127949, 1463899717, 1463899717};
    protected static final String[] FILETYPESTR = new String[]{"????", "TIFF", "AIFF", "NeXT", "DATA", "FScF", "MPEG", "MooV", "IRCM", "WAVE", "WAVE"};
    protected static final String[] EXTSTR = new String[]{".???", ".tif", ".aif", ".snd", ".spc", ".dat", ".mpg", ".mov", ".irc", ".wav", ".w64"};
    protected static final String[] TYPEDESCR = new String[]{"Unknown type", "Image: TIFF", "Waveform: AIFF", "Waveform: Snd", "Spectral: SndHack/FScape", "Float stream", "Movie: MPEG", "Movie: QuickTime", "Waveform: IRCAM", "Waveform: WAVE", "Waveform: Wave64"};

    public GenericFile(File file, int n) throws IOException {
        super(GenericFile.prepareOpen(file, n), (n & 0xF) == 1 ? "rw" : "r");
        this.mode = n;
        this.file = file;
        if ((n & 0xF) == 0) {
            this.retrieveType();
        }
    }

    public GenericFile(String string, int n) throws IOException {
        this(new File(string), n);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if ((this.mode & 0xF) == 1) {
            // empty if block
        }
    }

    public void cleanUp() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getTypeDescr() {
        return GenericFile.getTypeDescr(this.mode);
    }

    public static String getTypeDescr(int n) {
        return TYPEDESCR[(n & 0xFFF0) >> 4];
    }

    public int getFileType() {
        return GenericFile.getFileType(this.mode);
    }

    public String getFileTypeStr() {
        return GenericFile.getFileTypeStr(this.mode);
    }

    public static int getFileType(int n) {
        return FILETYPE[(n & 0xFFF0) >> 4];
    }

    public static String getFileTypeStr(int n) {
        return FILETYPESTR[(n & 0xFFF0) >> 4];
    }

    public static String getExtStr(int n) {
        return EXTSTR[(n & 0xFFF0) >> 4];
    }

    public static int getType(String string) {
        int n;
        for (n = 0; n < TYPEDESCR.length; ++n) {
            if (!TYPEDESCR[n].equals(string)) continue;
            return n << 4;
        }
        for (n = 0; n < FILETYPE.length; ++n) {
            if (!FILETYPESTR[n].equals(string)) continue;
            return n << 4;
        }
        for (n = 0; n < EXTSTR.length; ++n) {
            if (!string.endsWith(EXTSTR[n])) continue;
            return n << 4;
        }
        return 0;
    }

    public static int getAudioFileType(int n) {
        int n2;
        switch (n) {
            case 32: {
                n2 = 0;
                break;
            }
            case 48: {
                n2 = 1;
                break;
            }
            case 128: {
                n2 = 2;
                break;
            }
            case 144: {
                n2 = 3;
                break;
            }
            case 160: {
                n2 = 5;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    public String getFormat() throws IOException {
        GenericFile genericFile = null;
        switch (this.mode & 0xFFF0) {
            case 16: {
                genericFile = new ImageFile(this.file, 0);
                try {
                    String string = genericFile.getFormat();
                    genericFile.cleanUp();
                    return string;
                }
                catch (IOException iOException) {
                    genericFile.cleanUp();
                    throw iOException;
                }
            }
            case 32: 
            case 48: 
            case 128: 
            case 144: 
            case 160: {
                AudioFile audioFile = AudioFile.openAsRead((File)this.file);
                AudioFileDescr audioFileDescr = audioFile.getDescr();
                String string = audioFileDescr.getFormat();
                audioFile.cleanUp();
                return string;
            }
            case 64: {
                genericFile = new SpectralFile(this.file, 0);
                try {
                    String string = genericFile.getFormat();
                    genericFile.cleanUp();
                    return string;
                }
                catch (IOException iOException) {
                    genericFile.cleanUp();
                    throw iOException;
                }
            }
        }
        throw new IOException(ERR_ILLEGALFILE);
    }

    private static synchronized File prepareOpen(File file, int n) {
        if ((n & 0xF) == 1 && file.length() > 0L) {
            file.delete();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void retrieveType() throws IOException {
        var1_1 = 0;
        var3_2 = false;
        var4_3 = AudioFile.retrieveType((File)this.file);
        if (var4_3 != -1) {
            var3_2 = true;
            switch (var4_3) {
                case 0: {
                    var1_1 = 32;
                    break;
                }
                case 2: {
                    var1_1 = 128;
                    break;
                }
                case 1: {
                    var1_1 = 48;
                    break;
                }
                case 3: {
                    var1_1 = 144;
                    break;
                }
                case 5: {
                    var1_1 = 160;
                    break;
                }
                default: {
                    var3_2 = false;
                }
            }
        }
        if (!var3_2) {
            var5_4 = this.getFilePointer();
            try {
                this.seek(0L);
                var7_5 = this.readInt();
                switch (var7_5) {
                    case 1229520938: 
                    case 1296891946: {
                        var1_1 = 16;
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 517730: 
                    case 1165124197: {
                        var1_1 = 64;
                        ** break;
lbl37:
                        // 1 sources

                        break;
                    }
                    case 1179870022: {
                        var1_1 = 80;
                        ** break;
lbl41:
                        // 1 sources

                        break;
                    }
                    case 435: 
                    case 442: {
                        var1_1 = 96;
                        ** break;
lbl45:
                        // 1 sources

                        break;
                    }
                    default: {
                        if (this.readInt() == 1836019574) {
                            var1_1 = 112;
                        }
                        break;
                    }
                }
            }
            finally {
                this.seek(var5_4);
            }
        }
        this.mode = this.mode & -65521 | var1_1;
    }
}

