/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.net;

import de.sciss.fscape.net.OSCRouter;
import de.sciss.fscape.net.OSCRouterWrapper;
import de.sciss.fscape.net.RoutedOSCMessage;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCServer;
import de.sciss.util.Param;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public class OSCRoot
implements OSCRouter,
OSCListener,
Runnable,
PreferenceChangeListener {
    public static final String DEFAULT_NODE = "oscserver";
    public static final String KEY_ACTIVE = "active";
    public static final String KEY_PROTOCOL = "protocol";
    public static final String KEY_PORT = "port";
    private final Preferences prefs;
    private OSCServer serv = null;
    private boolean running = false;
    private final Pattern oscPathPtrn = Pattern.compile("/");
    private final List<RoutedOSCMessage> collMessages = Collections.synchronizedList(new ArrayList());
    private final OSCRouterWrapper osc;
    private static final String OSC_DUMP = "dumpOSC";
    public static final String OSC_QUERY = "query";
    public static final String OSC_GET = "get";
    public static final String OSC_QUERYREPLY = "/query.reply";
    public static final String OSC_GETREPLY = "/get.reply";
    public static final String OSC_FAILEDREPLY = "/failed";
    public static final String OSC_DONEREPLY = "/done";
    private final Param defaultPortParam;
    private static OSCRoot instance;

    public OSCRoot(Preferences preferences, int n) {
        if (instance != null) {
            throw new IllegalStateException("Only one instance allowed");
        }
        instance = this;
        this.prefs = preferences;
        this.defaultPortParam = new Param((double)n, 0);
        if (preferences.get(KEY_PORT, null) == null) {
            preferences.putBoolean(KEY_ACTIVE, false);
            preferences.put(KEY_PORT, this.defaultPortParam.toString());
        }
        this.osc = new OSCRouterWrapper(null, this);
        this.osc.oscAddRouter(new OSCRouter(){

            @Override
            public String oscGetPathComponent() {
                return OSCRoot.OSC_DUMP;
            }

            @Override
            public void oscRoute(RoutedOSCMessage routedOSCMessage) {
                OSCRoot.this.oscCmdDump(routedOSCMessage);
            }

            @Override
            public void oscAddRouter(OSCRouter oSCRouter) {
                throw new IllegalStateException("Path endpoint");
            }

            @Override
            public void oscRemoveRouter(OSCRouter oSCRouter) {
                throw new IllegalStateException("Path endpoint");
            }
        });
    }

    public static OSCRoot getInstance() {
        return instance;
    }

    public void init() {
        if (this.prefs.getBoolean(KEY_ACTIVE, false)) {
            this.boot();
        }
        this.prefs.addPreferenceChangeListener(this);
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void boot() {
        try {
            this.boot(this.prefs.get(KEY_PROTOCOL, "tcp"), (int)Param.fromPrefs((Preferences)this.prefs, (String)KEY_PORT, (Param)this.defaultPortParam).val, true);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getClass().getName() + " : " + iOException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(String string, int n, boolean bl) throws IOException {
        OSCRoot oSCRoot = this;
        synchronized (oSCRoot) {
            if (this.running) {
                throw new IllegalStateException("Already booted");
            }
            try {
                this.serv = OSCServer.newUsing((String)string, (int)n, (boolean)bl);
                this.serv.addOSCListener((OSCListener)this);
                this.serv.start();
            }
            catch (IOException iOException) {
                if (this.serv != null) {
                    this.serv.dispose();
                    this.serv = null;
                }
                throw iOException;
            }
            this.running = true;
        }
    }

    public static String getResourceString(String string) {
        return string;
    }

    public void send(OSCPacket oSCPacket, SocketAddress socketAddress) throws IOException {
        if (!this.running) {
            throw new IllegalStateException("Not running");
        }
        this.serv.send(oSCPacket, socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        OSCRoot oSCRoot = this;
        synchronized (oSCRoot) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        OSCRoot oSCRoot = this;
        synchronized (oSCRoot) {
            if (this.running) {
                this.serv.dispose();
                this.serv = null;
                this.running = false;
            }
        }
    }

    public static void failedUnknownPath(OSCMessage oSCMessage) {
        OSCRoot.failed(oSCMessage, "Path not found");
    }

    public static void failedUnknownPath(RoutedOSCMessage routedOSCMessage) {
        OSCRoot.failedUnknownPath(routedOSCMessage, routedOSCMessage.getPathIndex());
    }

    public static void failedUnknownCmd(RoutedOSCMessage routedOSCMessage) {
        System.err.println("FAILURE " + routedOSCMessage.msg.getName() + " " + routedOSCMessage.msg.getArg(0).toString() + " Command not found");
    }

    public static void failedUnknownPath(RoutedOSCMessage routedOSCMessage, int n) {
        int n2 = 0;
        String string = routedOSCMessage.msg.getName();
        if (routedOSCMessage.getPathCount() > 0) {
            n2 += routedOSCMessage.getPathComponent(0).length();
        }
        for (int i = 1; i < n; ++i) {
            n2 += routedOSCMessage.getPathComponent(i).length() + 1;
        }
        int n3 = Math.min(string.length(), n2 + (n < routedOSCMessage.getPathCount() ? routedOSCMessage.getPathComponent(n).length() + 1 : 0));
        System.err.println("FAILURE " + string.substring(0, n2) + "!" + string.substring(n2, n3) + "!" + string.substring(n3) + " Path not found");
    }

    public static void failedArgCount(RoutedOSCMessage routedOSCMessage) {
        OSCRoot.failed(routedOSCMessage.msg, "Illegal argument count (" + routedOSCMessage.msg.getArgCount() + ")");
    }

    public static void failedArgType(RoutedOSCMessage routedOSCMessage, int n) {
        OSCRoot.failed(routedOSCMessage.msg, "Illegal argument type (" + routedOSCMessage.msg.getArg(n) + ")");
    }

    public static void failedQuery(RoutedOSCMessage routedOSCMessage, String string) {
        OSCRoot.failed(routedOSCMessage.msg, "Illegal query property (" + string + ")");
    }

    public static void failedGet(RoutedOSCMessage routedOSCMessage, String string) {
        OSCRoot.failed(routedOSCMessage.msg, "Illegal get command (" + string + ")");
    }

    public static void failedArgValue(RoutedOSCMessage routedOSCMessage, int n) {
        OSCRoot.failed(routedOSCMessage.msg, "Illegal argument value (" + routedOSCMessage.msg.getArg(n) + ")");
    }

    public static void failed(RoutedOSCMessage routedOSCMessage, Throwable throwable) {
        OSCRoot.failed(routedOSCMessage.msg, throwable.getClass().getName() + " : " + throwable.getLocalizedMessage());
    }

    public static void failed(OSCMessage oSCMessage, String string) {
        System.err.println("FAILURE " + oSCMessage.getName() + " " + string);
    }

    @Override
    public void run() {
        while (!this.collMessages.isEmpty()) {
            this.osc.oscRoute(this.collMessages.remove(0));
        }
    }

    @Override
    public String oscGetPathComponent() {
        return null;
    }

    @Override
    public void oscRoute(RoutedOSCMessage routedOSCMessage) {
        this.osc.oscRoute(routedOSCMessage);
    }

    @Override
    public void oscAddRouter(OSCRouter oSCRouter) {
        this.osc.oscAddRouter(oSCRouter);
    }

    @Override
    public void oscRemoveRouter(OSCRouter oSCRouter) {
        this.osc.oscRemoveRouter(oSCRouter);
    }

    protected void oscCmdDump(RoutedOSCMessage routedOSCMessage) {
        int n = routedOSCMessage.msg.getArgCount();
        int n2 = 0;
        try {
            this.serv.dumpIncomingOSC(((Number)routedOSCMessage.msg.getArg(n2)).intValue(), System.out);
            ++n2;
            if (n == 2) {
                this.serv.dumpOutgoingOSC(((Number)routedOSCMessage.msg.getArg(n2)).intValue(), System.out);
            }
        }
        catch (ClassCastException classCastException) {
            OSCRoot.failedArgType(routedOSCMessage, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            OSCRoot.failedArgCount(routedOSCMessage);
        }
    }

    public void messageReceived(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
        String[] stringArray = this.oscPathPtrn.split(oSCMessage.getName());
        if (stringArray.length < 2) {
            OSCRoot.failedUnknownPath(oSCMessage);
            return;
        }
        this.collMessages.add(new RoutedOSCMessage(oSCMessage, socketAddress, l, this, stringArray, 0));
        EventQueue.invokeLater(this);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string = preferenceChangeEvent.getKey();
        if (string.equals(KEY_ACTIVE)) {
            if (Boolean.valueOf(preferenceChangeEvent.getNewValue()).booleanValue()) {
                if (!this.isRunning()) {
                    this.boot();
                }
            } else if (this.isRunning()) {
                this.quit();
            }
        }
    }
}

