/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Modulator;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import java.io.EOFException;
import java.io.IOException;

public class AmpEnvOp
extends Operator {
    protected static final String defaultName = "Amp Env";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_ENV = 0;
    private static final String PRN_ENV = "Env";
    private static final Envelope[] prEnvl = new Envelope[]{null};
    private static final String[] prEnvlName = new String[]{"Env"};

    public AmpEnvOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), AmpEnvOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            AmpEnvOp.static_pr.envl = prEnvl;
            AmpEnvOp.static_pr.envl[0] = Envelope.createBasicEnvelope(0);
            AmpEnvOp.static_pr.envlName = prEnvlName;
            AmpEnvOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "AmpEnvOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block17: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block17;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                Modulator modulator = new Modulator(new Param(0.0, 1), new Param(1.0, 1), this.pr.envl[0], spectStream);
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    float f = (float)modulator.calc().value;
                    int n = 0;
                    while (n == 0 && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            n = 1;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    Util.copy(spectFrame.data, 0, spectFrame2.data, 0, spectStream.bands << 1);
                    for (n = 0; n < spectStream.chanNum; ++n) {
                        float[] fArray = spectFrame2.data[n];
                        int n2 = 0;
                        for (int i = 0; i < spectStream.bands; ++i) {
                            int n3 = n2;
                            fArray[n3] = fArray[n3] * f;
                            n2 += 2;
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    n = 0;
                    while (n == 0 && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            n = 1;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nen,prEnv");
        return propertyGUI;
    }
}

