/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;

public class AnalysisOp
extends Operator {
    protected static final String defaultName = "Analyse";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_OUTPUT = 0;
    private static final int PR_FILENAME = 0;
    private static final int PR_FFTLENGTH = 0;
    private static final int PR_OVERSMP = 1;
    private static final int PR_WINDOW = 2;
    private static final int PR_OVERLAP = 3;
    private static final int PR_TYPE = 4;
    private static final int PR_ADJUSTSTART = 0;
    private static final int PR_ADJUSTLENGTH = 1;
    private static final int PR_ROTATE = 2;
    private static final int PR_STARTSHIFT = 0;
    private static final int PR_LENGTH = 1;
    private static final int PR_LOFREQ = 2;
    private static final int PR_HIFREQ = 3;
    private static final int PR_LORADIUS = 4;
    private static final int PR_HIRADIUS = 5;
    protected static final int TYPE_FFT = 0;
    protected static final int TYPE_CZT = 1;
    protected static final int TYPE_NONE = 2;
    private static final String PRN_FILENAME = "Filename";
    private static final String PRN_FFTLENGTH = "FFTLength";
    private static final String PRN_OVERSMP = "OverSmp";
    private static final String PRN_WINDOW = "Window";
    private static final String PRN_OVERLAP = "Overlap";
    private static final String PRN_TYPE = "Type";
    private static final String PRN_ADJUSTSTART = "AdjustStart";
    private static final String PRN_ADJUSTLENGTH = "AdjustLength";
    private static final String PRN_STARTSHIFT = "StartShift";
    private static final String PRN_LENGTH = "Length";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_LORADIUS = "LoRadius";
    private static final String PRN_HIRADIUS = "HiRadius";
    private static final String PRN_ROTATE = "Rotate";
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"Filename"};
    private static final int[] prIntg = new int[]{6, 0, 0, 2, 0};
    private static final String[] prIntgName = new String[]{"FFTLength", "OverSmp", "Window", "Overlap", "Type"};
    private static final boolean[] prBool = new boolean[]{false, false, true};
    private static final String[] prBoolName = new String[]{"AdjustStart", "AdjustLength", "Rotate"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"StartShift", "Length", "LoFreq", "HiFreq", "LoRadius", "HiRadius"};
    protected static final int[] overlaps = new int[]{1, 2, 4, 8, 16};
    protected static final String ERR_NOINPUT = "No input file";

    public AnalysisOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), AnalysisOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            AnalysisOp.static_pr.text = prText;
            AnalysisOp.static_pr.textName = prTextName;
            AnalysisOp.static_pr.intg = prIntg;
            AnalysisOp.static_pr.intgName = prIntgName;
            AnalysisOp.static_pr.bool = prBool;
            AnalysisOp.static_pr.boolName = prBoolName;
            AnalysisOp.static_pr.para = prPara;
            AnalysisOp.static_pr.para[0] = new Param(0.0, 2);
            AnalysisOp.static_pr.para[1] = new Param(5000.0, 2);
            AnalysisOp.static_pr.para[2] = new Param(0.0, 3);
            AnalysisOp.static_pr.para[3] = new Param(22050.0, 3);
            AnalysisOp.static_pr.para[4] = new Param(0.0, 785);
            AnalysisOp.static_pr.para[5] = new Param(0.0, 785);
            AnalysisOp.static_pr.paraName = prParaName;
            AnalysisOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "AnalysisOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 8, defaultName);
    }

    @Override
    public void run() {
        String string;
        this.runInit();
        AudioFile audioFile = null;
        int n = 0;
        int n2 = 131072 >> this.pr.intg[0];
        int n3 = n2 >> 1;
        int n4 = n2 / overlaps[this.pr.intg[3]];
        boolean bl = this.pr.intg[4] == 1;
        boolean bl2 = this.pr.intg[4] == 0;
        double[] dArray = null;
        float[] fArray = null;
        int n5 = this.pr.intg[1];
        if (this.pr.text[0] == null || this.pr.text[0].length() == 0) {
            Component component = this.owner.getModule().getComponent();
            boolean bl3 = !(component instanceof Frame);
            Frame frame = bl3 ? new Frame() : (Frame)component;
            FileDialog fileDialog = new FileDialog(frame, ((OpIcon)this.getIcon()).getName() + ": Select inputfile");
            fileDialog.setVisible(true);
            if (bl3) {
                frame.dispose();
            }
            String string2 = fileDialog.getFile();
            String string3 = fileDialog.getDirectory();
            fileDialog.dispose();
            if (string3 == null) {
                string3 = "";
            }
            if (string2 == null) {
                this.runQuit(new IOException(ERR_NOINPUT));
                return;
            }
            string = string3 + string2;
        } else {
            string = this.pr.text[0];
        }
        try {
            float f;
            float[] fArray2;
            double d;
            double d2;
            int n6;
            int n7;
            int n8;
            int n9;
            double d3;
            double d4;
            int n10;
            int n11;
            audioFile = AudioFile.openAsRead((File)new File(string));
            AudioFileDescr audioFileDescr = audioFile.getDescr();
            int n12 = (int)audioFileDescr.length;
            int n13 = audioFileDescr.channels;
            Param param = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)n12), 2);
            double d5 = Param.transform((Param)this.pr.para[0], (int)2, (Param)param, null).value;
            double d6 = Param.transform((Param)this.pr.para[1], (int)2, (Param)param, null).value;
            SpectStream spectStream = new SpectStream();
            spectStream.smpRate = (float)audioFileDescr.rate;
            double d7 = Param.transform((Param)this.pr.para[2], (int)3, null, (SpectStream)spectStream).value * (Math.PI * 2) / (double)spectStream.smpRate;
            double d8 = Param.transform((Param)this.pr.para[3], (int)3, null, (SpectStream)spectStream).value * (Math.PI * 2) / (double)spectStream.smpRate;
            double d9 = Param.transform((Param)this.pr.para[4], (int)1, (Param)new Param((double)1.0, (int)1), null).value;
            double d10 = Param.transform((Param)this.pr.para[5], (int)1, (Param)new Param((double)1.0, (int)1), null).value;
            int n14 = this.pr.bool[0] ? Math.min(n12, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d5) + 0.5)) : 0;
            audioFile.seekFrame((long)n14);
            int n15 = this.pr.bool[1] ? Math.min(n12 - n14, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d6) + 0.5)) : n12 - n14;
            int n16 = (n15 + n2 - 1) / n4;
            if (bl) {
                n11 = n2 << n5 + 1;
                n10 = n11 << 1;
                fArray = new float[n10 + 2];
                Util.clear(fArray);
                dArray = new double[n10 + 2];
            } else {
                if (!bl2) {
                    ++n5;
                }
                n10 = n11 = n2 << n5;
            }
            int n17 = n2 << n5 >> 1;
            float[] fArray3 = new float[n10 + 2];
            float[][] fArray4 = new float[n13][n2];
            Util.clear(fArray4);
            float[] fArray5 = Filter.createFullWindow(n2, this.pr.intg[2]);
            if (bl) {
                double d11 = n17;
                double d12 = Math.pow(d10 / d9, 1.0 / d11);
                double d13 = (d8 - d7) / d11;
                d4 = 1.0 / Math.sqrt(d12);
                d3 = d13 * -0.5;
                n9 = 0;
                n8 = 0;
                n7 = n10;
                while (n9 <= n11) {
                    n6 = n8 * n8;
                    d2 = Math.pow(d4, n6);
                    d = d3 * (double)n6;
                    dArray[n9] = 1.0 / d2;
                    fArray[n9] = (float)(d2 * Math.cos(d));
                    dArray[n7] = dArray[n9];
                    fArray[n7] = fArray[n9];
                    dArray[++n9] = -d;
                    fArray[n9] = (float)(d2 * Math.sin(d));
                    dArray[++n7] = dArray[n9];
                    fArray[n7] = fArray[n9];
                    ++n9;
                    n7 -= 3;
                    ++n8;
                }
                Fourier.complexTransform(fArray, n11, 1);
                d4 = 1.0 / d9;
                d3 = -d7;
                double d14 = 0.0;
                for (n9 = 0; n9 < n2; ++n9) {
                    d14 += (double)fArray5[n9];
                }
                d14 = 1.0 / d14;
                fArray2 = fArray5;
                fArray5 = new float[fArray5.length << 1];
                n6 = 0;
                n9 = 0;
                for (n8 = 0; n8 < n2; ++n8) {
                    d2 = (double)fArray2[n8] * d14 * Math.pow(d4, n8) * dArray[n6++];
                    d = d3 * (double)n8 + dArray[n6++];
                    fArray5[n9++] = (float)(d2 * Math.cos(d));
                    fArray5[n9++] = (float)(d2 * Math.sin(d));
                }
            } else {
                d2 = 0.0;
                for (n9 = 0; n9 < n2; ++n9) {
                    d2 += (double)fArray5[n9];
                }
                f = (float)(1.0 / d2);
                n9 = 0;
                while (n9 < n2) {
                    int n18 = n9++;
                    fArray5[n18] = fArray5[n18] * f;
                }
            }
            n9 = (n17 << 3) * n13;
            SpectStream spectStream2 = new SpectStream(Math.max(2, 262144 / n9));
            spectStream2.setChannels(n13);
            spectStream2.setBands(0.0f, (float)audioFileDescr.rate / 2.0f, n17 + 1, 1);
            spectStream2.setRate((float)audioFileDescr.rate, n4);
            spectStream2.setEstimatedLength(n16);
            SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
            spectStreamSlot.initWriter(spectStream2);
            this.runSlotsReady();
            int n19 = 0;
            int n20 = 0;
            int n21 = n4;
            while (n < n16 && !this.threadDead) {
                int n22;
                int n23 = Math.min(n21, n15 - n20);
                int n24 = (n19 + n2 - n21) % n2;
                audioFile.readFrames(fArray4, n24, n23);
                if (n23 < n21) {
                    for (n22 = 0; n22 < n13; ++n22) {
                        fArray2 = fArray4[n22];
                        n8 = n24 + n23;
                        n6 = n24 + n21;
                        while (n8 < n6) {
                            fArray2[n8++] = 0.0f;
                        }
                    }
                }
                ++n;
                n20 += n23;
                SpectFrame spectFrame = spectStream2.allocFrame();
                block17: for (n22 = 0; n22 < n13; ++n22) {
                    fArray2 = fArray4[n22];
                    switch (this.pr.intg[4]) {
                        case 1: {
                            if (this.pr.bool[2]) {
                                n9 = n19;
                                n8 = n10 - n2;
                                n6 = 0;
                                while (n6 < n2) {
                                    n7 = Math.min(n2 - n6, Math.min(n2 - n9, n10 - n8 >> 1));
                                    n6 += n7;
                                    while (n7 > 0) {
                                        f = fArray2[n9++];
                                        fArray3[n8++] = f;
                                        fArray3[n8++] = f;
                                        --n7;
                                    }
                                    n9 %= n2;
                                    n8 %= n10;
                                }
                                n9 = 0;
                                n8 = n2;
                                while (n9 < n2) {
                                    int n25 = n9++;
                                    fArray3[n25] = fArray3[n25] * fArray5[n8];
                                    ++n8;
                                }
                                while (n9 < n10 - n2) {
                                    fArray3[n9] = 0.0f;
                                    ++n9;
                                }
                                n8 = 0;
                                while (n9 < n10) {
                                    int n26 = n9++;
                                    fArray3[n26] = fArray3[n26] * fArray5[n8];
                                    ++n8;
                                }
                                Fourier.complexTransform(fArray3, n11, 1);
                                Fourier.complexMult(fArray, 0, fArray3, 0, fArray3, 0, n10);
                                Fourier.complexTransform(fArray3, n11, -1);
                                fArray2 = spectFrame.data[n22];
                                n9 = 0;
                                n8 = n10 - n2;
                                n6 = 0;
                                while (n9 <= n17) {
                                    n7 = Math.min(n10 - n8 >> 1, n17 + 1 - n9);
                                    n9 += n7;
                                    while (n7 > 0) {
                                        d2 = fArray3[n8++];
                                        d = fArray3[n8++];
                                        d4 = dArray[n6];
                                        d3 = dArray[n6 + 1];
                                        fArray2[n6++] = (float)(Math.sqrt(d2 * d2 + d * d) * d4);
                                        fArray2[n6++] = (float)(Math.atan2(d, d2) + d3);
                                        --n7;
                                    }
                                    n8 %= n10;
                                }
                                continue block17;
                            }
                            n9 = n19;
                            n8 = 0;
                            n6 = 0;
                            while (n6 < n2) {
                                n7 = Math.min(n2 - n6, n2 - n9);
                                n6 += n7;
                                while (n7 > 0) {
                                    f = fArray2[n9++];
                                    fArray3[n8] = f * fArray5[n8];
                                    fArray3[++n8] = f * fArray5[n8];
                                    ++n8;
                                    --n7;
                                }
                                n9 %= n2;
                            }
                            while (n8 < n10) {
                                fArray3[n8] = 0.0f;
                                ++n8;
                            }
                            Fourier.complexTransform(fArray3, n11, 1);
                            Fourier.complexMult(fArray, 0, fArray3, 0, fArray3, 0, n10);
                            Fourier.complexTransform(fArray3, n11, -1);
                            fArray2 = spectFrame.data[n22];
                            n9 = 0;
                            n8 = 0;
                            while (n9 <= n17) {
                                n6 = n8 + 1;
                                d2 = fArray3[n8];
                                d = fArray3[n6];
                                d4 = dArray[n8];
                                d3 = dArray[n6];
                                fArray2[n8] = (float)(Math.sqrt(d2 * d2 + d * d) * d4);
                                fArray2[n6] = (float)(Math.atan2(d, d2) + d3);
                                ++n9;
                                n8 += 2;
                            }
                            continue block17;
                        }
                        case 0: 
                        case 2: {
                            if (this.pr.bool[2]) {
                                n9 = n19;
                                n8 = n11 - n3;
                                for (n6 = 0; n6 < n2; n6 += n7) {
                                    n7 = Math.min(n2 - n6, Math.min(n2 - n9, n11 - n8));
                                    System.arraycopy(fArray2, n9, fArray3, n8, n7);
                                    n9 = (n9 + n7) % n2;
                                    n8 = (n8 + n7) % n11;
                                }
                                n9 = 0;
                                n8 = n3;
                                while (n9 < n3) {
                                    int n27 = n9++;
                                    fArray3[n27] = fArray3[n27] * fArray5[n8];
                                    ++n8;
                                }
                                while (n9 < n11 - n3) {
                                    fArray3[n9] = 0.0f;
                                    ++n9;
                                }
                                n8 = 0;
                                while (n9 < n11) {
                                    int n28 = n9++;
                                    fArray3[n28] = fArray3[n28] * fArray5[n8];
                                    ++n8;
                                }
                            } else {
                                n9 = n19;
                                n8 = 0;
                                n6 = 0;
                                while (n6 < n2) {
                                    for (n7 = Math.min(n2 - n6, n2 - n9); n7 > 0; --n7) {
                                        fArray3[n8++] = fArray2[n9++] * fArray5[n6++];
                                    }
                                    n9 %= n2;
                                }
                                while (n8 < n11) {
                                    fArray3[n8] = 0.0f;
                                    ++n8;
                                }
                            }
                            fArray2 = spectFrame.data[n22];
                            if (bl2) {
                                Fourier.realTransform(fArray3, n11, 1);
                            } else if (this.pr.bool[2]) {
                                n9 = n11 - n2;
                                n8 = n11 - n3;
                                while (n9 < n2) {
                                    fArray3[n9++] = fArray3[n8++];
                                    fArray3[n9++] = 0.0f;
                                }
                                n9 = n3;
                                n8 = n2;
                                while (n9 > 0) {
                                    fArray3[--n8] = 0.0f;
                                    fArray3[--n8] = fArray3[--n9];
                                }
                            } else {
                                n9 = n2;
                                n8 = n2 * 2;
                                while (n9 > 0) {
                                    fArray3[--n8] = 0.0f;
                                    fArray3[--n8] = fArray3[--n9];
                                }
                            }
                            Fourier.rect2Polar(fArray3, 0, fArray2, 0, n11 + 2);
                        }
                    }
                }
                boolean bl4 = false;
                while (!bl4 && !this.threadDead) {
                    try {
                        spectStreamSlot.writeFrame(spectFrame);
                        bl4 = true;
                        this.runFrameDone(spectStreamSlot, spectFrame);
                        spectStream2.freeFrame(spectFrame);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                n19 = (n19 + n21) % n2;
            }
            audioFile.close();
            spectStream2.closeWriter();
        }
        catch (IOException iOException) {
            if (audioFile != null) {
                audioFile.cleanUp();
            }
            this.runQuit(iOException);
            return;
        }
        catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
            if (audioFile != null) {
                audioFile.cleanUp();
            }
            this.runQuit(slotAlreadyConnectedException);
            return;
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        StringBuffer stringBuffer;
        String[] stringArray;
        String string;
        block5: {
            AudioFile audioFile = null;
            string = "";
            stringArray = Filter.getWindowNames();
            stringBuffer = new StringBuffer();
            if (n != 0) {
                return null;
            }
            if (this.pr.text[0] != null && this.pr.text[0].length() != 0) {
                try {
                    audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                    AudioFileDescr audioFileDescr = audioFile.getDescr();
                    double d = AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)audioFileDescr.length);
                    audioFile.close();
                    string = ",re" + d + "|" + 2;
                }
                catch (IOException iOException) {
                    if (audioFile == null) break block5;
                    audioFile.cleanUp();
                }
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(",it");
            stringBuffer.append(stringArray[i]);
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbFilename;io0|Select input file,prFilename\nlbTransform;ch,ac0|3|di|4|di|5|di|6|di,ac1|3|en|4|en|5|en|6|en,prType,itDiscrete Fourier,itChirp Z,itNone\nlbChunk(FFT) length;ch,prFFTLength,it131072,it 65536,it 32768,it 16384,it  8192,it  4096,it  2048,it  1024,it   512,it   256,it   128,it    64,it    32\nlbOversampling;ch,prOverSmp,it1x (none),it2x,it4x,it8x\nlbWindow;ch,prWindow" + stringBuffer.toString() + "\nlbWindow step;ch,pr" + PRN_OVERLAP + ",it1/1,it1/2,it1/4,it1/8,it1/16\ncbRotate origin,pr" + PRN_ROTATE + "\nglChirp transform specs\nlbLow freq;pf" + 15 + ",id3,pr" + PRN_LOFREQ + "\nlbHigh freq;pf" + 15 + ",id4,pr" + PRN_HIFREQ + "\nlbLow radius;pf" + 7 + ",id5,pr" + PRN_LORADIUS + "\nlbHigh radius;pf" + 7 + ",id6,pr" + PRN_HIRADIUS + "\nglTruncation\ncbTime offset,actrue|1|en,acfalse|1|di,pr" + PRN_ADJUSTSTART + ";pf" + 8 + "|" + 9 + "|" + 11 + string + ",id1,pr" + PRN_STARTSHIFT + "\ncbLength,actrue|2|en,acfalse|2|di,pr" + PRN_ADJUSTLENGTH + ";pf" + 8 + "|" + 9 + "|" + 11 + string + ",id2,pr" + PRN_LENGTH);
        return propertyGUI;
    }
}

