/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.FIRDesignerDlg;
import de.sciss.fscape.gui.FilterBox;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFileDescr;
import java.awt.Point;
import java.io.EOFException;
import java.io.IOException;

public class CepstralOp
extends Operator {
    protected static final String defaultName = "Cepstral";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_LOFREQ = 0;
    private static final int PR_HIFREQ = 1;
    private static final int PR_QUALITY = 0;
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_QUALITY = "Quality";
    private static final int[] prIntg = new int[]{1};
    private static final String[] prIntgName = new String[]{"Quality"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"LoFreq", "HiFreq"};
    protected static final String ERR_BANDS = "Band# not power of 2";

    public CepstralOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), CepstralOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            CepstralOp.static_pr.intg = prIntg;
            CepstralOp.static_pr.intgName = prIntgName;
            CepstralOp.static_pr.para = prPara;
            CepstralOp.static_pr.para[1] = new Param(22050.0, 3);
            CepstralOp.static_pr.para[0] = new Param(50.0, 3);
            CepstralOp.static_pr.paraName = prParaName;
            CepstralOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "CepstralOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block27: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                int n;
                float f;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block27;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                int n2 = spectStream.bands;
                int n3 = n2 << 1;
                float f2 = Math.min(spectStream.smpRate / 2.0f, (float)this.pr.para[0].value);
                float f3 = Math.max(0.5f, Math.min(spectStream.smpRate / 2.0f, (float)this.pr.para[1].value));
                if (f2 > f3) {
                    f = f2;
                    f2 = f3;
                    f3 = f;
                }
                FilterBox filterBox = new FilterBox();
                if (f2 <= 0.1f) {
                    filterBox.filterType = 1;
                    filterBox.cutOff = new Param(f3, 3);
                } else if (f3 >= spectStream.smpRate / 2.0f) {
                    filterBox.filterType = 2;
                    filterBox.cutOff = new Param(f2, 3);
                } else {
                    filterBox.filterType = 3;
                    filterBox.cutOff = new Param((f2 + f3) / 2.0f, 3);
                    filterBox.bandwidth = new Param(f3 - f2, 35);
                }
                AudioFileDescr audioFileDescr = new AudioFileDescr();
                audioFileDescr.rate = spectStream.smpRate;
                Point point = filterBox.calcLength(audioFileDescr, this.pr.intg[0]);
                int n4 = point.x;
                int n5 = point.x + point.y;
                int n6 = n5 + n2 - 1;
                for (n = 2; n < n6; n <<= 1) {
                }
                int n7 = n << 1;
                float[] fArray = new float[n7];
                float[] fArray2 = new float[n7];
                Util.clear(fArray2);
                filterBox.calcIR(audioFileDescr, this.pr.intg[0], 1, fArray2, point);
                n5 = n;
                n6 = n7;
                while (n5 > 0) {
                    fArray2[--n6] = 0.0f;
                    fArray2[--n6] = fArray2[--n5];
                }
                Util.rotate(fArray2, n7, fArray, -(n4 << 1));
                Fourier.complexTransform(fArray2, n, 1);
                this.runSlotsReady();
                block13: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block13;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        System.arraycopy(spectFrame.data[i], 0, fArray, 0, n3);
                        for (n5 = 0; n5 < n3; n5 += 2) {
                            f = fArray[n5];
                            fArray[n5] = f > 1.2664166E-14f ? (float)Math.log(f) : -32.0f;
                        }
                        Fourier.unwrapPhases(fArray, 0, fArray, 0, n3);
                        float f4 = fArray[1];
                        float f5 = fArray[n3 - 1];
                        float f6 = n3 - 2;
                        n5 = 0;
                        while (n5 < n3) {
                            f = (float)n5++ / f6;
                            int n8 = n5++;
                            fArray[n8] = fArray[n8] + (f4 * (f - 1.0f) - f5 * f);
                        }
                        n5 = n3;
                        while (n5 < n7) {
                            fArray[n5++] = 0.0f;
                        }
                        Fourier.complexTransform(fArray, n, 1);
                        Fourier.complexMult(fArray2, 0, fArray, 0, fArray, 0, n7);
                        Fourier.complexTransform(fArray, n, -1);
                        f6 = n3 - 2;
                        n5 = 0;
                        while (n5 < n3) {
                            fArray[n5] = (float)Math.exp(fArray[n5]);
                            f = (float)n5++ / f6;
                            int n9 = n5++;
                            fArray[n9] = fArray[n9] + (f4 * (1.0f - f) + f5 * f);
                        }
                        System.arraycopy(fArray, 0, spectFrame2.data[i], 0, n3);
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0) {
            return null;
        }
        for (int i = 0; i < FIRDesignerDlg.QUAL_NAMES.length; ++i) {
            stringBuffer.append(",it");
            stringBuffer.append(FIRDesignerDlg.QUAL_NAMES[i]);
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbHigh frequency;pf15,prHiFreq\nlbLow frequency;pf15,prLoFreq\nlbQuality;ch,prQuality" + stringBuffer.toString() + "\n");
        return propertyGUI;
    }
}

