/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Filter;
import java.io.EOFException;
import java.io.IOException;

public class ShrinkOp
extends Operator {
    protected static final String defaultName = "Shrink";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_FACTOR = 0;
    private static final int PR_MODE = 1;
    private static final String PRN_FACTOR = "Factor";
    private static final String PRN_MODE = "Mode";
    protected static final int MODE_SHRINK = 0;
    protected static final int MODE_EXPAND = 1;
    private static final int[] prIntg = new int[]{0, 0};
    private static final String[] prIntgName = new String[]{"Factor", "Mode"};

    public ShrinkOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), ShrinkOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ShrinkOp.static_pr.intg = prIntg;
            ShrinkOp.static_pr.intgName = prIntgName;
            ShrinkOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "ShrinkOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block22: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                float f;
                int n;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block22;
                int n2 = 2 << this.pr.intg[0];
                int n3 = spectStream.bands;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                if (this.pr.intg[1] == 0) {
                    n = (n3 - 1) / n2 + 1;
                    f = (float)n / (float)n3;
                    spectStream2.smpPerFrame /= n2;
                } else {
                    n = (n3 - 1) * n2 + 1;
                    f = (float)n / (float)n3;
                    spectStream2.smpPerFrame *= n2;
                }
                spectStream2.bands = n;
                spectStreamSlot2.initWriter(spectStream2);
                int n4 = 4096;
                int n5 = 5;
                float f2 = 0.7f;
                float f3 = 6.5f;
                n4 = 4096;
                int n6 = (int)((float)(n4 * n5) / f2 + 0.5f);
                float[] fArray = new float[n6];
                float[] fArray2 = null;
                float f4 = Filter.createAntiAliasFilter(fArray, fArray2, n6, n4, f2, f3);
                float[][] fArrayArray = new float[][]{fArray, fArray2, new float[2]};
                fArrayArray[2][0] = n4;
                fArrayArray[2][1] = f4;
                float[] fArray3 = new float[Math.max(n3, n) << 1];
                float[] fArray4 = new float[n3 + 1];
                float[] fArray5 = new float[n + 1];
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        Fourier.polar2Rect(spectFrame.data[i], 0, fArray3, 0, n3 << 1);
                        int n7 = 0;
                        int n8 = 0;
                        while (n7 < n3) {
                            fArray4[n7] = fArray3[n8];
                            ++n7;
                            n8 += 2;
                        }
                        Filter.resample(fArray4, 0.0, fArray5, 0, n, (double)f, fArrayArray);
                        n7 = 0;
                        n8 = 0;
                        while (n7 < n) {
                            fArray3[n8] = fArray5[n7];
                            ++n7;
                            n8 += 2;
                        }
                        n7 = 0;
                        n8 = 1;
                        while (n7 < n3) {
                            fArray4[n7] = fArray3[n8];
                            ++n7;
                            n8 += 2;
                        }
                        Filter.resample(fArray4, 0.0, fArray5, 0, n, (double)f, fArrayArray);
                        n7 = 0;
                        n8 = 1;
                        while (n7 < n) {
                            fArray3[n8] = fArray5[n7];
                            ++n7;
                            n8 += 2;
                        }
                        Fourier.rect2Polar(fArray3, 0, spectFrame2.data[i], 0, n << 1);
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbMode;ch,prMode,itShrink,itExpand\nlbFactor;ch,prFactor,it1:2,it1:4,it1:8,it1:16");
        return propertyGUI;
    }
}

