/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import java.io.EOFException;
import java.io.IOException;

public class ZoomOp
extends Operator {
    protected static final String defaultName = "Zoom";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_FACTOR = 0;
    private static final int PR_BAND = 0;
    private static final String PRN_FACTOR = "Factor";
    private static final String PRN_BAND = "Band";
    private static final int[] prIntg = new int[]{0};
    private static final String[] prIntgName = new String[]{"Factor"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Band"};

    public ZoomOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), ZoomOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ZoomOp.static_pr.intg = prIntg;
            ZoomOp.static_pr.intgName = prIntgName;
            ZoomOp.static_pr.para = prPara;
            ZoomOp.static_pr.para[0] = new Param(16000.0, 3);
            ZoomOp.static_pr.paraName = prParaName;
            ZoomOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "ZoomOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block19: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block19;
                int n = 2 << this.pr.intg[0];
                int n2 = spectStream.bands;
                int n3 = (n2 - 1) / n + 1;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStream2.bands = n3;
                spectStream2.smpPerFrame /= n;
                spectStreamSlot2.initWriter(spectStream2);
                int n4 = (int)(this.pr.para[0].value / (double)((spectStream.hiFreq - spectStream.loFreq) / (float)n2) + 0.5);
                if ((n4 -= n3 >> 1) < 0) {
                    n4 = 0;
                } else if (n4 + n3 > n2) {
                    n4 = n2 - n3;
                }
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        System.arraycopy(spectFrame.data[i], n4 << 1, spectFrame2.data[i], 0, n3 << 1);
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbZoom factor;ch,prFactor,it1:2,it1:4,it1:8,it1:16\nlbZoom to bands around;pf15,id1,prBand");
        return propertyGUI;
    }
}

