/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.session;

import de.sciss.common.ProcessingThread;
import de.sciss.fscape.Application;
import de.sciss.fscape.net.OSCRoot;
import de.sciss.fscape.net.OSCRouter;
import de.sciss.fscape.net.OSCRouterWrapper;
import de.sciss.fscape.net.RoutedOSCMessage;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.util.Flag;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.undo.UndoManager;

public class Session
implements OSCRouter {
    private ModulePanel frame = null;
    private boolean dirty = false;
    private final Session enc_this = this;
    private static int nodeIDAlloc = 0;
    private final int nodeID = ++nodeIDAlloc;
    private final OSCRouterWrapper osc = new OSCRouterWrapper(null, this);
    private File file = null;
    private ProcessingThread currentPT = null;

    public int getNodeID() {
        return this.nodeID;
    }

    public boolean checkProcess() {
        return this.checkProcess(500);
    }

    public boolean checkProcess(int n) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.currentPT == null) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        this.currentPT.sync(n);
        return this.currentPT == null || !this.currentPT.isRunning();
    }

    public void start(ProcessingThread processingThread) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.currentPT != null) {
            throw new IllegalStateException("Process already running");
        }
        this.currentPT = processingThread;
        this.currentPT.addListener(new ProcessingThread.Listener(){

            public void processStarted(ProcessingThread.Event event) {
            }

            public void processStopped(ProcessingThread.Event event) {
                Session.this.currentPT = null;
            }
        });
        this.currentPT.start();
    }

    public ModulePanel getFrame() {
        return this.frame;
    }

    public void setFrame(ModulePanel modulePanel) {
        this.frame = modulePanel;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        if (this.file != null) {
            String string = this.file.getName();
            int n = string.lastIndexOf(46);
            return n < 0 ? string : string.substring(0, n);
        }
        return this.getResourceString("Untitled");
    }

    private void updateTitle() {
    }

    private String getResourceString(String string) {
        return string;
    }

    public ProcessingThread closeDocument(boolean bl, Flag flag) {
        return this.frame.closeDocument(bl, flag);
    }

    @Override
    public String oscGetPathComponent() {
        return null;
    }

    @Override
    public void oscRoute(RoutedOSCMessage routedOSCMessage) {
        this.osc.oscRoute(routedOSCMessage);
    }

    @Override
    public void oscAddRouter(OSCRouter oSCRouter) {
        if (this.osc != null) {
            this.osc.oscAddRouter(oSCRouter);
        }
    }

    @Override
    public void oscRemoveRouter(OSCRouter oSCRouter) {
        if (this.osc != null) {
            this.osc.oscRemoveRouter(oSCRouter);
        }
    }

    public void oscCmd_close(RoutedOSCMessage routedOSCMessage) {
        if (this.frame == null) {
            OSCRoot.failed(routedOSCMessage.msg, this.getResourceString("errWindowNotFound"));
        }
        try {
            boolean bl = routedOSCMessage.msg.getArgCount() > 1 ? ((Number)routedOSCMessage.msg.getArg(1)).intValue() != 0 : false;
            ProcessingThread processingThread = this.closeDocument(bl, new Flag(false));
            if (processingThread != null) {
                processingThread.start();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            OSCRoot.failedArgCount(routedOSCMessage);
        }
        catch (ClassCastException classCastException) {
            OSCRoot.failedArgType(routedOSCMessage, 1);
        }
    }

    public void oscCmd_start(RoutedOSCMessage routedOSCMessage) {
        if (this.frame == null) {
            OSCRoot.failed(routedOSCMessage.msg, this.getResourceString("errWindowNotFound"));
        }
        this.frame.start();
    }

    public void oscCmd_stop(RoutedOSCMessage routedOSCMessage) {
        if (this.frame == null) {
            OSCRoot.failed(routedOSCMessage.msg, this.getResourceString("errWindowNotFound"));
        }
        this.frame.stop();
    }

    public void oscCmd_pause(RoutedOSCMessage routedOSCMessage) {
        if (this.frame == null) {
            OSCRoot.failed(routedOSCMessage.msg, this.getResourceString("errWindowNotFound"));
        }
        this.frame.pause();
    }

    public void oscCmd_resume(RoutedOSCMessage routedOSCMessage) {
        if (this.frame == null) {
            OSCRoot.failed(routedOSCMessage.msg, this.getResourceString("errWindowNotFound"));
        }
        this.frame.resume();
    }

    public void oscCmd_activate(RoutedOSCMessage routedOSCMessage) {
        if (this.frame == null) {
            OSCRoot.failed(routedOSCMessage.msg, this.getResourceString("errWindowNotFound"));
        }
        Application.documentHandler.setActive(this);
    }

    public Object oscQuery_id() {
        return new Integer(this.getNodeID());
    }

    public Object oscQuery_process() {
        if (this.frame == null) {
            return null;
        }
        String string = this.frame.getClass().getName();
        int n = string.lastIndexOf(46);
        boolean bl = string.endsWith("Dlg");
        return string.substring(n + 1, string.length() - (bl ? 3 : 0));
    }

    public Object oscQuery_running() {
        if (this.frame == null) {
            return null;
        }
        return new Integer(this.frame.isThreadRunning() ? 1 : 0);
    }

    public Object oscQuery_progression() {
        if (this.frame == null) {
            return null;
        }
        return new Float(this.frame.getProgression());
    }

    public Object oscQuery_error() {
        if (this.frame == null) {
            return null;
        }
        Exception exception = this.frame.getError();
        return exception == null ? "" : exception.getClass().getName() + " : " + exception.getLocalizedMessage();
    }

    public Object oscQuery_dirty() {
        return new Integer(this.isDirty() ? 1 : 0);
    }

    public Object oscQuery_name() {
        return this.getName();
    }

    public Object oscQuery_file() {
        return this.file == null ? "" : this.file.getAbsolutePath();
    }

    public UndoManager getUndoManager() {
        throw new IllegalStateException("Not implemented");
    }

    public void dispose() {
        if (this.osc != null) {
            this.osc.remove();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        if (!this.dirty == bl) {
            this.dirty = bl;
            this.updateTitle();
        }
    }
}

