/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

import de.sciss.fscape.spect.SpectFrame;
import java.io.EOFException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SpectStream {
    public static final int MODE_LIN = 1;
    public static final int MODE_LOG = 2;
    public int chanNum;
    public int bands;
    public float loFreq;
    public float hiFreq;
    public int freqMode;
    public float smpRate;
    public int smpPerFrame;
    public long frames;
    public long framesWritten = 0L;
    public long framesRead = 0L;
    public static final String ERR_NOREADER = "Reader closed the stream";
    public static final String ERR_NOWRITER = "Writer closed the stream";
    protected Thread readerThread = null;
    protected Thread writerThread = null;
    protected static final int STATE_UNKNOWN = 0;
    protected static final int STATE_ACTIVE = 1;
    protected static final int STATE_DEAD = 2;
    protected int readerState = 0;
    protected int writerState = 0;
    protected static final String ERR_BUFEMPTY = "Streambuffer empty";
    protected static final String ERR_BUFFULL = "Streambuffer full";
    protected static final int DEFAULT_BUF_SIZE = 8;
    protected Vector<SpectFrame> activeBuf;
    protected Vector<SpectFrame> deadBuf;
    protected int bufSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectStream(SpectStream spectStream, int n) {
        if (spectStream != null) {
            SpectStream spectStream2 = spectStream;
            synchronized (spectStream2) {
                this.chanNum = spectStream.chanNum;
                this.bands = spectStream.bands;
                this.loFreq = spectStream.loFreq;
                this.hiFreq = spectStream.hiFreq;
                this.freqMode = spectStream.freqMode;
                this.smpRate = spectStream.smpRate;
                this.smpPerFrame = spectStream.smpPerFrame;
                this.frames = spectStream.frames;
            }
        } else {
            this.chanNum = 0;
            this.bands = 0;
            this.loFreq = 0.0f;
            this.hiFreq = 0.0f;
            this.freqMode = 1;
            this.smpRate = 0.0f;
            this.smpPerFrame = 0;
            this.frames = 0L;
        }
        this.bufSize = n;
        this.activeBuf = new Vector(n);
        this.deadBuf = new Vector(n);
    }

    public SpectStream(SpectStream spectStream) {
        this(spectStream, spectStream.bufSize);
    }

    public SpectStream() {
        this(null, 8);
    }

    public SpectStream(int n) {
        this(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWriter() {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.activeBuf.removeAllElements();
            this.writerThread = Thread.currentThread();
            this.writerState = 1;
            this.framesWritten = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDescr() {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.readerThread = Thread.currentThread();
            this.readerState = 1;
            this.framesRead = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannels(int n) {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.activeBuf.removeAllElements();
            this.deadBuf.removeAllElements();
            this.chanNum = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBands(float f, float f2, int n, int n2) {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.activeBuf.removeAllElements();
            this.deadBuf.removeAllElements();
            this.loFreq = f;
            this.hiFreq = f2;
            this.bands = n;
            this.freqMode = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(float f, int n) {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.smpRate = f;
            this.smpPerFrame = n;
        }
    }

    public void setEstimatedLength(long l) {
        this.frames = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectFrame allocFrame() {
        SpectFrame spectFrame;
        SpectStream spectStream = this;
        synchronized (spectStream) {
            if (!this.deadBuf.isEmpty()) {
                spectFrame = this.deadBuf.firstElement();
                this.deadBuf.removeElement(spectFrame);
                spectFrame.gainAccess();
            } else {
                spectFrame = new SpectFrame(this.chanNum, this.bands);
            }
        }
        return spectFrame;
    }

    public static SpectFrame[] allocFrames(SpectStream spectStream, int n) {
        SpectFrame[] spectFrameArray = new SpectFrame[n];
        for (int i = 0; i < n; ++i) {
            spectFrameArray[i] = spectStream.allocFrame();
        }
        return spectFrameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeFrame(SpectFrame spectFrame) {
        spectFrame.looseAccess();
        SpectFrame spectFrame2 = spectFrame;
        synchronized (spectFrame2) {
            if (spectFrame.accessCount == 0) {
                SpectStream spectStream = this;
                synchronized (spectStream) {
                    if (this.deadBuf.size() < this.bufSize) {
                        this.deadBuf.addElement(spectFrame);
                    }
                }
            }
        }
    }

    public static void freeFrames(SpectStream spectStream, SpectFrame[] spectFrameArray) {
        for (int i = 0; i < spectFrameArray.length; ++i) {
            spectStream.freeFrame(spectFrameArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFrame(SpectFrame spectFrame) throws IOException, IndexOutOfBoundsException {
        switch (this.framesWriteable()) {
            case -1: {
                this.closeWriter();
                throw new EOFException(ERR_NOREADER);
            }
            case 0: {
                throw new IndexOutOfBoundsException(ERR_BUFFULL);
            }
        }
        SpectStream spectStream = this;
        synchronized (spectStream) {
            spectFrame.gainAccess();
            this.activeBuf.addElement(spectFrame);
            ++this.framesWritten;
        }
    }

    public void writeDummy(SpectFrame spectFrame) {
        ++this.framesWritten;
    }

    public static int writeFrames(SpectStream spectStream, SpectFrame[] spectFrameArray) throws IOException {
        int n = 0;
        try {
            for (int i = 0; i < spectFrameArray.length; ++i) {
                spectStream.writeFrame(spectFrameArray[i]);
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (EOFException eOFException) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectFrame readFrame() throws IOException, NoSuchElementException {
        SpectFrame spectFrame;
        switch (this.framesReadable()) {
            case -1: {
                this.closeReader();
                throw new EOFException(ERR_NOWRITER);
            }
            case 0: {
                throw new NoSuchElementException(ERR_BUFEMPTY);
            }
        }
        SpectStream spectStream = this;
        synchronized (spectStream) {
            spectFrame = this.activeBuf.firstElement();
            this.activeBuf.removeElement(spectFrame);
            ++this.framesRead;
        }
        return spectFrame;
    }

    public static int readFrames(SpectStream spectStream, SpectFrame[] spectFrameArray) throws IOException {
        int n;
        block4: {
            n = 0;
            try {
                for (int i = 0; i < spectFrameArray.length; ++i) {
                    spectFrameArray[i] = spectStream.readFrame();
                    ++n;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (EOFException eOFException) {
                if (n != 0) break block4;
                n = -1;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWriter() throws IOException {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.writerThread = null;
            this.writerState = 2;
            this.deadBuf.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReader() throws IOException {
        SpectStream spectStream = this;
        synchronized (spectStream) {
            this.writerThread = null;
            this.writerState = 2;
            this.activeBuf.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int framesReadable() {
        int n;
        SpectStream spectStream = this;
        synchronized (spectStream) {
            n = this.activeBuf.size();
            if (n == 0 && this.writerState == 2) {
                n = -1;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int framesWriteable() {
        int n;
        SpectStream spectStream = this;
        synchronized (spectStream) {
            n = this.bufSize - this.activeBuf.size();
            if (this.readerState == 2) {
                n = -1;
            }
        }
        return n;
    }

    public double getTime() {
        if (Thread.currentThread() == this.readerThread) {
            return (double)this.framesRead * ((double)this.smpPerFrame / (double)this.smpRate) * 1000.0;
        }
        return (double)this.framesWritten * ((double)this.smpPerFrame / (double)this.smpRate) * 1000.0;
    }

    public static String getFormat(SpectStream spectStream) {
        String string = null;
        switch (spectStream.chanNum) {
            case 1: {
                string = "Mono ";
                break;
            }
            case 2: {
                string = "Stereo ";
                break;
            }
            default: {
                string = spectStream.chanNum + "-chn. ";
            }
        }
        int n = (int)(SpectStream.framesToMillis(spectStream, spectStream.frames) + 0.5);
        int n2 = n / 60000;
        int n3 = n / 1000 % 60;
        String string2 = "; " + n2 + ':' + String.valueOf(n3 + 100).substring(1) + '.' + String.valueOf((n %= 1000) + 1000).substring(1);
        return string + spectStream.bands + " bands (" + (int)(spectStream.loFreq + 0.5f) + '-' + (int)(spectStream.hiFreq + 0.5f) + (spectStream.freqMode == 1 ? " Hz linear)" : " Hz exp.)") + string2;
    }

    public static double millisToFrames(SpectStream spectStream, double d) {
        return d / 1000.0 * ((double)spectStream.smpRate / (double)spectStream.smpPerFrame);
    }

    public static double framesToMillis(SpectStream spectStream, long l) {
        return (double)l * ((double)spectStream.smpPerFrame / (double)spectStream.smpRate) * 1000.0;
    }
}

