/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

public class Curve2 {
    public static final int INT_LINEAR = 0;
    public static final int INT_SPLINE = 1;
    public static final int INT_SAMPLEHOLD = 2;
    public static final int INTMASK = 15;
    public static final int TYPE_BIPOLAR = 0;
    public static final int TYPE_UNIPOLAR = 16;
    public int flags;
    public int size;
    public float[] xs;
    public float[] ys;
    public boolean looped = false;
    public float loopStart = 0.0f;
    public float loopEnd = 1.0f;
    public int loopCount = 1;
    private boolean valid = false;
    private float[] yDrv = null;

    public Curve2(int n) {
        this.flags = n;
        this.size = 2;
        this.xs = new float[2];
        this.ys = new float[2];
        this.xs[0] = 0.0f;
        this.ys[0] = 0.0f;
        this.xs[1] = 1.0f;
        this.ys[1] = 1.0f;
    }

    public Curve2() {
        this(0);
    }

    public Curve2(Curve2 curve2) {
        this.flags = curve2.flags;
        this.size = curve2.size;
        this.looped = curve2.looped;
        this.loopStart = curve2.loopStart;
        this.loopEnd = curve2.loopEnd;
        this.loopCount = curve2.loopCount;
        this.xs = new float[this.size + 16];
        this.ys = new float[this.size + 16];
        System.arraycopy(curve2.xs, 0, this.xs, 0, this.size);
        System.arraycopy(curve2.ys, 0, this.ys, 0, this.size);
    }

    public Object clone() {
        return new Curve2(this);
    }

    public void invalidate() {
        this.valid = false;
    }

    public int indexOf(float f) {
        if (this.looped && f > this.loopStart && f < this.loopEnd) {
            f = this.loopStart + (f - this.loopStart) * (float)this.loopCount % (this.loopEnd - this.loopStart);
        }
        if (f < this.xs[0] || f > this.xs[this.size - 1]) {
            return -1;
        }
        int n = 0;
        int n2 = this.size - 1;
        while (n2 - n > 1) {
            int n3 = n2 + n >> 1;
            if (f >= this.xs[n3]) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n;
    }

    public int indexOf(float f, int n) {
        int n2;
        if (this.looped && f > this.loopStart && f < this.loopEnd) {
            f = this.loopStart + (f - this.loopStart) * (float)this.loopCount % (this.loopEnd - this.loopStart);
        }
        if (f < this.xs[0] || f > this.xs[this.size - 1]) {
            return -1;
        }
        if (n >= 0) {
            int n3 = 1;
            if (f >= this.xs[n]) {
                n2 = n + 1;
                if (n2 >= this.size - 1) {
                    return n;
                }
                while (f >= this.xs[n2]) {
                    n = n2;
                    if ((n2 += (n3 <<= 1)) < this.size - 1) continue;
                    n2 = this.size - 1;
                    break;
                }
            } else {
                n2 = n--;
                while (f < this.xs[n]) {
                    n2 = n;
                    if ((n -= (n3 <<= 1)) >= 0) continue;
                    n = 0;
                    break;
                }
            }
        } else {
            n = 0;
            n2 = this.size - 1;
        }
        while (n2 - n > 1) {
            int n4 = n2 + n >> 1;
            if (f >= this.xs[n4]) {
                n = n4;
                continue;
            }
            n2 = n4;
        }
        return n;
    }

    public float calc(float f) {
        return this.calc(f, this.indexOf(f));
    }

    public void calc(float f, float f2, float[] fArray, int n, int n2) {
        float f3 = (f2 - f) / (float)(--n2);
        int n3 = this.indexOf(f);
        fArray[n] = this.calc(f, n3);
        int n4 = n;
        for (int i = 1; i < n2; ++i) {
            float f4 = f + (float)i * f3;
            n3 = this.indexOf(f4, n3);
            fArray[++n4] = this.calc(f4, n3);
        }
        fArray[n + n2] = this.calc(f2, n3);
    }

    private void validate() {
        if ((this.flags & 1) != 0) {
            if (this.yDrv == null || this.yDrv.length < this.size || this.yDrv.length - 64 > this.size) {
                this.yDrv = new float[this.size + 16];
            }
            float[] fArray = new float[this.size - 1];
            this.yDrv[0] = 0.0f;
            fArray[0] = 0.0f;
            this.yDrv[this.size - 1] = 0.0f;
            int n = 1;
            int n2 = 0;
            for (int i = 2; i < this.size; ++i) {
                float f = (this.xs[n] - this.xs[n2]) / (this.xs[i] - this.xs[n2]);
                float f2 = f * this.yDrv[n2] + 2.0f;
                this.yDrv[n] = (f - 1.0f) / f2;
                fArray[n] = (this.ys[i] - this.ys[n]) / (this.xs[i] - this.xs[n]) - (this.ys[n] - this.ys[n2]) / (this.xs[n] - this.xs[n2]);
                fArray[n] = (6.0f * fArray[n] / (this.xs[i] - this.xs[n2]) - f * fArray[n2]) / f2;
                ++n;
                ++n2;
            }
            for (n = this.size - 2; n >= 0; --n) {
                this.yDrv[n] = this.yDrv[n] * this.yDrv[n + 1] + fArray[n];
            }
        }
        this.valid = true;
    }

    private float calc(float f, int n) {
        if (!this.valid) {
            this.validate();
        }
        if (n == -1) {
            return 0.0f;
        }
        switch (this.flags & 0xF) {
            case 2: {
                if (f < this.xs[n + 1]) {
                    return this.ys[n];
                }
                return this.ys[n + 1];
            }
            case 1: {
                return this.spline(f, n);
            }
        }
        return this.linear(f, n);
    }

    private float linear(float f, int n) {
        int n2 = n + 1;
        float f2 = this.xs[n2] - this.xs[n];
        float f3 = (this.xs[n2] - f) / f2;
        float f4 = 1.0f - f3;
        return f3 * this.ys[n] + f4 * this.ys[n2];
    }

    private float spline(float f, int n) {
        int n2 = n + 1;
        float f2 = this.xs[n2] - this.xs[n];
        float f3 = (this.xs[n2] - f) / f2;
        float f4 = 1.0f - f3;
        return f3 * this.ys[n] + f4 * this.ys[n2] + ((f3 * f3 * f3 - f3) * this.yDrv[n] + (f4 * f4 * f4 - f4) * this.yDrv[n2]) * (f2 * f2) / 6.0f;
    }
}

