/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Curve;
import de.sciss.fscape.util.ParamSpace;
import java.util.StringTokenizer;

public class Envelope
implements Cloneable {
    public static final int BASIC_TIME = 0;
    public static final int BASIC_UNSIGNED_TIME = 1;
    public boolean atkState;
    public boolean susState;
    public boolean rlsState;
    public int hUnit;
    public int vUnit;
    public Curve atkCurve;
    public Curve susCurve;
    public Curve rlsCurve;

    public Envelope(Curve curve, Curve curve2, Curve curve3) {
        this.atkCurve = curve;
        this.susCurve = curve2;
        this.rlsCurve = curve3;
        this.atkState = curve != null;
        this.susState = curve2 != null;
        boolean bl = this.rlsState = curve3 != null;
        if (this.susState) {
            this.hUnit = curve2.hSpace.unit & 0xF;
            this.vUnit = curve2.vSpace.unit & 0xF;
        } else if (this.atkState) {
            this.hUnit = curve.hSpace.unit & 0xF;
            this.vUnit = curve.vSpace.unit & 0xF;
        } else if (this.rlsState) {
            this.hUnit = curve3.hSpace.unit & 0xF;
            this.vUnit = curve3.vSpace.unit & 0xF;
        } else {
            this.hUnit = 0;
            this.vUnit = 0;
        }
    }

    public Envelope(Envelope envelope) {
        this.atkCurve = (Curve)envelope.atkCurve.clone();
        this.susCurve = (Curve)envelope.susCurve.clone();
        this.rlsCurve = (Curve)envelope.rlsCurve.clone();
        this.atkState = envelope.atkState;
        this.susState = envelope.susState;
        this.rlsState = envelope.rlsState;
        this.hUnit = envelope.hUnit;
        this.vUnit = envelope.vUnit;
    }

    public Object clone() {
        return new Envelope(this);
    }

    public static Envelope createBasicEnvelope(int n) {
        ParamSpace paramSpace = null;
        paramSpace = n == 0 ? Constants.spaces[1] : Constants.spaces[2];
        ParamSpace paramSpace2 = new ParamSpace(Constants.spaces[11]);
        paramSpace2 = new ParamSpace(paramSpace2.min, paramSpace2.max * 0.1, paramSpace2.inc, paramSpace2.unit);
        ParamSpace paramSpace3 = new ParamSpace(Constants.spaces[11]);
        ParamSpace paramSpace4 = new ParamSpace(Constants.spaces[11]);
        paramSpace4 = new ParamSpace(paramSpace4.min, paramSpace4.max * 0.1, paramSpace4.inc, paramSpace4.unit);
        Curve curve = new Curve(paramSpace2, paramSpace);
        curve.addPoint(paramSpace2.min, 0.0);
        curve.addPoint(paramSpace2.max, paramSpace.max);
        Curve curve2 = new Curve(paramSpace3, paramSpace);
        curve2.addPoint(paramSpace3.min, paramSpace.min);
        curve2.addPoint(paramSpace3.max, paramSpace.max);
        Curve curve3 = new Curve(paramSpace4, paramSpace);
        curve3.addPoint(paramSpace4.min, paramSpace.max);
        curve3.addPoint(paramSpace4.max, 0.0);
        Envelope envelope = new Envelope(curve, curve2, curve3);
        envelope.atkState = false;
        envelope.rlsState = false;
        return envelope;
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this.atkCurve != null) {
            string = this.atkCurve.toString();
        }
        if (this.susCurve != null) {
            string2 = this.susCurve.toString();
        }
        if (this.rlsCurve != null) {
            string3 = this.rlsCurve.toString();
        }
        return "" + string + '|' + string2 + '|' + string3 + '|' + this.atkState + '|' + this.susState + '|' + this.rlsState;
    }

    public static Envelope valueOf(String string) {
        Curve curve = null;
        Curve curve2 = null;
        Curve curve3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (string2.length() > 0) {
            curve = Curve.valueOf(string2);
        }
        if ((string2 = stringTokenizer.nextToken()).length() > 0) {
            curve2 = Curve.valueOf(string2);
        }
        if ((string2 = stringTokenizer.nextToken()).length() > 0) {
            curve3 = Curve.valueOf(string2);
        }
        Envelope envelope = new Envelope(curve, curve2, curve3);
        envelope.atkState = Boolean.valueOf(stringTokenizer.nextToken());
        envelope.susState = Boolean.valueOf(stringTokenizer.nextToken());
        envelope.rlsState = Boolean.valueOf(stringTokenizer.nextToken());
        return envelope;
    }
}

