/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.fscape.spect.SpectStream;

public class Param
implements Cloneable {
    public static final int NONE = 0;
    public static final int AMP = 1;
    public static final int TIME = 2;
    public static final int FREQ = 3;
    public static final int PHASE = 4;
    public static final int DIM_MASK = 15;
    public static final int ABS_UNIT = 0;
    public static final int ABS_PERCENT = 16;
    public static final int REL_UNIT = 32;
    public static final int REL_PERCENT = 48;
    public static final int FORM_MASK = 240;
    public static final int BEATS = 256;
    public static final int SEMITONES = 512;
    public static final int DECIBEL = 768;
    public static final int SPECIAL_MASK = 3840;
    public static final int FACTOR = 16;
    public static final int ABS_AMP = 1;
    public static final int FACTOR_AMP = 17;
    public static final int DECIBEL_AMP = 785;
    public static final int OFFSET_AMP = 49;
    public static final int ABS_MS = 2;
    public static final int ABS_BEATS = 258;
    public static final int FACTOR_TIME = 18;
    public static final int OFFSET_MS = 34;
    public static final int OFFSET_BEATS = 290;
    public static final int OFFSET_TIME = 50;
    public static final int ABS_HZ = 3;
    public static final int FACTOR_FREQ = 19;
    public static final int OFFSET_HZ = 35;
    public static final int OFFSET_SEMITONES = 547;
    public static final int OFFSET_FREQ = 51;
    public double value;
    public int unit;
    private static final int[] chain = new int[]{1, 0, 2, 3};
    private static double freqScale;
    private static double timeScale;

    public Param() {
        this.value = 0.0;
        this.unit = 0;
    }

    public Param(double d, int n) {
        this.value = d;
        this.unit = n;
    }

    public Param(Param param) {
        this.value = param.value;
        this.unit = param.unit;
    }

    public Object clone() {
        return new Param(this);
    }

    public static synchronized void updateScales() {
        freqScale = 12.0;
        timeScale = 120.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Param transform(Param param, int n, Param param2, SpectStream spectStream) {
        if (param.unit == n) {
            return param;
        }
        double d = param.value;
        switch (param.unit & 0xF00) {
            case 256: {
                d *= 60000.0 / timeScale;
                break;
            }
            case 512: {
                if (param2 == null) {
                    return null;
                }
                d = param2.value * (Math.pow(2.0, d / freqScale) - 1.0);
                break;
            }
            case 768: {
                d = Math.exp(d / 20.0 * 2.302585092994046) * 100.0;
                break;
            }
        }
        int n2 = chain[(param.unit & 0xF0) >> 4];
        int n3 = chain[(n & 0xF0) >> 4];
        if (n2 != n3) {
            if (param2 == null) {
                return null;
            }
            if ((param2 = Param.transform(param2, param2.unit & 0xFFFFF00F | 0, null, spectStream)) == null) {
                return null;
            }
            try {
                Param param3 = param2;
                synchronized (param3) {
                    if (n2 < n3) {
                        block25: for (int i = n2; i < n3; ++i) {
                            switch (i) {
                                case 0: {
                                    d *= param2.value / 100.0;
                                    continue block25;
                                }
                                case 1: {
                                    d -= param2.value;
                                    continue block25;
                                }
                                case 2: {
                                    d *= 100.0 / param2.value;
                                    continue block25;
                                }
                            }
                        }
                    } else {
                        block26: for (int i = n2; i > n3; --i) {
                            switch (i) {
                                case 3: {
                                    d *= param2.value / 100.0;
                                    continue block26;
                                }
                                case 2: {
                                    d += param2.value;
                                    continue block26;
                                }
                                case 1: {
                                    d *= 100.0 / param2.value;
                                    continue block26;
                                }
                            }
                        }
                    }
                }
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }
        switch (n & 0xF00) {
            case 256: {
                d *= timeScale / 60000.0;
                break;
            }
            case 512: {
                if (param2 == null) {
                    return null;
                }
                d = Math.log(1.0 + d / param2.value) / 0.6931471805599453 * freqScale;
                break;
            }
            case 768: {
                if (d > 6.30957344480193E-6) {
                    d = Math.log(d / 100.0) * 20.0 / 2.302585092994046;
                    break;
                }
                d = -144.0;
                break;
            }
        }
        return new Param(d, n);
    }

    public static int getPriority(int n, int n2) {
        if (n == n2) {
            return 99;
        }
        if ((n & 0xF) != (n2 & 0xF)) {
            return -99;
        }
        int n3 = chain[(n & 0xF0) >> 4];
        int n4 = chain[(n2 & 0xF0) >> 4];
        if (n3 <= n4) {
            return n4 - n3;
        }
        return n3 - n4;
    }

    public String toString() {
        return "" + this.value + ',' + this.unit;
    }

    public static Param valueOf(String string) {
        int n = string.indexOf(44);
        return new Param(Double.valueOf(string.substring(0, n)), Integer.parseInt(string.substring(n + 1)));
    }

    static {
        Param.updateScales();
    }
}

