/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.TooltipWay;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class TooltipConverter
implements Converter {
    public boolean canConvert(Class type) {
        return Tooltip.class.getCanonicalName().equals(type.getCanonicalName());
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Tooltip value = (Tooltip)source;
        if (TooltipConverter.shouldWriteDelay(value)) {
            writer.addAttribute("delay", value.getDelay().toString());
        }
        if (TooltipConverter.shouldWriteWay(value)) {
            writer.addAttribute("way", value.getWay().toString());
        }
        if (TooltipConverter.shouldWriteType(value)) {
            writer.addAttribute("type", value.getType().toString());
        }
        writer.setValue(value.getText());
    }

    public static boolean shouldWriteDelay(Tooltip value) {
        return value.getDelay() != null;
    }

    public static boolean shouldWriteWay(Tooltip value) {
        return value.getWay() != null;
    }

    public static boolean shouldWriteType(Tooltip value) {
        return value.getType() != null && value.getType() != LanguageManager.getDefaultTooltipType();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String typeV = reader.getAttribute("type");
        TooltipType type = TooltipConverter.parseType(typeV);
        String wayV = reader.getAttribute("way");
        TooltipWay way = TooltipConverter.parseWay(wayV);
        String delayV = reader.getAttribute("delay");
        Integer delay = TooltipConverter.parseDelay(delayV);
        String text = reader.getValue();
        return new Tooltip(type, way, delay, text);
    }

    public static TooltipType parseType(String typeV) {
        return typeV != null ? TooltipType.valueOf(typeV) : LanguageManager.getDefaultTooltipType();
    }

    public static TooltipWay parseWay(String wayV) {
        return wayV != null ? TooltipWay.valueOf(wayV) : null;
    }

    public static Integer parseDelay(String delayV) {
        return delayV != null ? Integer.valueOf(Integer.parseInt(delayV)) : null;
    }
}

