/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.log.Log;
import com.alee.managers.settings.ComponentSettingsManager;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.ReadState;
import com.alee.managers.settings.SettingsGroup;
import com.alee.managers.settings.SettingsGroupState;
import com.alee.managers.settings.SettingsListener;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public final class SettingsManager {
    private static final Map<String, Map<String, List<SettingsListener>>> settingsListeners = new HashMap<String, Map<String, List<SettingsListener>>>();
    private static String settingsFilesExtension = ".xml";
    private static String backupFilesExtension = ".backup";
    private static String defaultSettingsDir = null;
    private static String defaultSettingsDirName = ".weblaf";
    private static String defaultSettingsGroup = "default";
    private static final Map<String, String> groupFileLocation = new HashMap<String, String>();
    private static final Map<String, SettingsGroupState> groupState = new HashMap<String, SettingsGroupState>();
    private static final Map<String, SettingsGroup> groups = new HashMap<String, SettingsGroup>();
    private static final Map<String, Object> files = new HashMap<String, Object>();
    private static boolean saveOnChange = true;
    private static boolean saveDefaultValues = true;
    private static final Object saveOnChangeLock = new Object();
    private static long saveOnChangeDelay = 500L;
    private static WebTimer groupSaveScheduler = null;
    private static final List<String> groupsToSaveOnChange = new ArrayList<String>();
    private static boolean loggingEnabled = true;
    private static boolean saveLoggingEnabled = false;
    private static boolean allowSave = true;
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            XmlUtils.processAnnotations(SettingsGroup.class);
            XmlUtils.processAnnotations(SettingsGroupState.class);
            XmlUtils.processAnnotations(ReadState.class);
            ComponentSettingsManager.initializeManager();
            initialized = true;
        }
    }

    public static List<SettingsGroup> getLoadedGroups() {
        return CollectionUtils.copy(groups.values());
    }

    public static Map<String, SettingsGroup> getLoadedGroupsMap() {
        return groups;
    }

    public static void registerComponent(JComponent component, String key) {
        SettingsManager.registerComponent(component, key, null);
    }

    public static <T extends DefaultValue> void registerComponent(JComponent component, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent(component, key, SettingsManager.getDefaultValue(defaultValueClass));
    }

    public static void registerComponent(JComponent component, String key, Object defaultValue) {
        SettingsManager.registerComponent(component, defaultSettingsGroup, key, defaultValue);
    }

    public static void registerComponent(JComponent component, String group, String key) {
        SettingsManager.registerComponent(component, group, key, null);
    }

    public static <T extends DefaultValue> void registerComponent(JComponent component, String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent(component, group, key, SettingsManager.getDefaultValue(defaultValueClass));
    }

    public static void registerComponent(JComponent component, String group, String key, Object defaultValue) {
        SettingsManager.registerComponent(component, group, key, defaultValue, true, true);
    }

    public static void registerComponent(JComponent component, String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, key, null, loadInitialSettings, applySettingsChanges);
    }

    public static <T extends DefaultValue> void registerComponent(JComponent component, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, key, SettingsManager.getDefaultValue(defaultValueClass), loadInitialSettings, applySettingsChanges);
    }

    public static void registerComponent(JComponent component, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, defaultSettingsGroup, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    public static <T extends DefaultValue> void registerComponent(JComponent component, String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, group, key, SettingsManager.getDefaultValue(defaultValueClass), loadInitialSettings, applySettingsChanges);
    }

    public static void registerComponent(JComponent component, String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        ComponentSettingsManager.registerComponent(new SettingsProcessorData(component, group, key, defaultValue, loadInitialSettings, applySettingsChanges));
    }

    public static void registerComponent(JComponent component, SettingsProcessor settingsProcessor) {
        ComponentSettingsManager.registerComponent(component, settingsProcessor);
    }

    public static void unregisterComponent(JComponent component) {
        ComponentSettingsManager.unregisterComponent(component);
    }

    public static void loadComponentSettings(JComponent component) {
        ComponentSettingsManager.loadSettings(component);
    }

    public static void saveComponentSettings(JComponent component) {
        ComponentSettingsManager.saveSettings(component);
    }

    public static <T extends SettingsProcessor> void registerSettingsProcessor(Class<? extends JComponent> componentType, Class<T> settingsProcessor) {
        ComponentSettingsManager.registerSettingsProcessor(componentType, settingsProcessor);
    }

    public static Boolean getBoolean(String key) {
        return SettingsManager.get(key, (Boolean)null);
    }

    public static Boolean getBoolean(String group, String key) {
        return SettingsManager.get(group, key, (Boolean)null);
    }

    public static String getString(String key) {
        return SettingsManager.get(key, (String)null);
    }

    public static String getString(String group, String key) {
        return SettingsManager.get(group, key, (String)null);
    }

    public static Integer getInteger(String key) {
        return SettingsManager.get(key, (Integer)null);
    }

    public static Integer getInteger(String group, String key) {
        return SettingsManager.get(group, key, (Integer)null);
    }

    public static Long getLong(String key) {
        return SettingsManager.get(key, (Long)null);
    }

    public static Long getLong(String group, String key) {
        return SettingsManager.get(group, key, (Long)null);
    }

    public static Float getFloat(String key) {
        return SettingsManager.get(key, (Float)null);
    }

    public static Float getFloat(String group, String key) {
        return SettingsManager.get(group, key, (Float)null);
    }

    public static Double getDouble(String key) {
        return SettingsManager.get(key, (Double)null);
    }

    public static Double getDouble(String group, String key) {
        return SettingsManager.get(group, key, (Double)null);
    }

    public static Dimension getDimension(String key) {
        return SettingsManager.get(key, (Dimension)null);
    }

    public static Dimension getDimension(String group, String key) {
        return SettingsManager.get(group, key, (Dimension)null);
    }

    public static Point getPoint(String key) {
        return SettingsManager.get(key, (Point)null);
    }

    public static Point getPoint(String group, String key) {
        return SettingsManager.get(group, key, (Point)null);
    }

    public static Color getColor(String key) {
        return SettingsManager.get(key, (Color)null);
    }

    public static Color getColor(String group, String key) {
        return SettingsManager.get(group, key, (Color)null);
    }

    public static Rectangle getRectangle(String key) {
        return SettingsManager.get(key, (Rectangle)null);
    }

    public static Rectangle getRectangle(String group, String key) {
        return SettingsManager.get(group, key, (Rectangle)null);
    }

    public static Insets getInsets(String key) {
        return SettingsManager.get(key, (Insets)null);
    }

    public static Insets getInsets(String group, String key) {
        return SettingsManager.get(group, key, (Insets)null);
    }

    public static <T> T get(String key) {
        return SettingsManager.get(key, null);
    }

    public static <T extends DefaultValue> T get(String key, Class<T> defaultValueClass) {
        return (T)((DefaultValue)SettingsManager.get(defaultSettingsGroup, key, SettingsManager.getDefaultValue(defaultValueClass)));
    }

    public static <T> T get(String key, T defaultValue) {
        return SettingsManager.get(defaultSettingsGroup, key, defaultValue);
    }

    public static <T extends DefaultValue> T get(String group, String key, Class<T> defaultValueClass) {
        return (T)((DefaultValue)SettingsManager.get(group, key, SettingsManager.getDefaultValue(defaultValueClass)));
    }

    public static <T> T get(String group, String key, T defaultValue) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        Object value = settingsGroup.get(key);
        if (value == null && defaultValue != null) {
            value = defaultValue;
            if (saveDefaultValues) {
                SettingsManager.set(group, key, value);
            }
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            Log.error(SettingsManager.class, "Unable to load settings value for group \"" + group + "\" and key \"" + key + "\" because it has inappropriate class type:", e);
            if (saveDefaultValues) {
                SettingsManager.set(group, key, defaultValue);
            }
            return defaultValue;
        }
    }

    public static <T extends DefaultValue> T getDefaultValue(Class<T> defaultValueClass) {
        if (defaultValueClass == null) {
            return null;
        }
        return (T)((DefaultValue)ReflectUtils.callStaticMethodSafely(defaultValueClass, "getDefaultValue", new Object[0]));
    }

    public static <T> T set(String key, T object) {
        return SettingsManager.set(defaultSettingsGroup, key, object);
    }

    public static <T> T set(String group, String key, T object) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        T oldValue = settingsGroup.put(key, object);
        if (saveOnChange) {
            SettingsManager.delayedSaveSettingsGroup(group);
        }
        SettingsManager.fireSettingsChanged(group, key, object);
        return oldValue;
    }

    public static void resetDefaultGroup() {
        SettingsManager.resetGroup(defaultSettingsGroup);
    }

    public static void resetGroup(String group) {
        File dir = new File(SettingsManager.getGroupFilePath(group));
        if (dir.exists() && dir.isDirectory()) {
            File file = SettingsManager.getGroupFile(group, dir);
            File backupFile = SettingsManager.getGroupBackupFile(group, dir);
            FileUtils.deleteFiles(file, backupFile);
        }
        if (groups.containsKey(group)) {
            groups.remove(group);
        }
    }

    public static <T> T resetValue(String key) {
        return SettingsManager.resetValue(defaultSettingsGroup, key);
    }

    public static <T> T resetValue(String group, String key) {
        Object oldValue = null;
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        if (settingsGroup != null) {
            oldValue = settingsGroup.remove(key);
        }
        if (oldValue != null) {
            SettingsManager.saveSettingsGroup(group);
        }
        return (T)oldValue;
    }

    public static SettingsGroup getSettingsGroup(String group) {
        if (groups.containsKey(group)) {
            return groups.get(group);
        }
        return SettingsManager.loadSettingsGroup(group);
    }

    private static SettingsGroup loadSettingsGroup(String group) {
        SettingsGroup settingsGroup = null;
        File dir = new File(SettingsManager.getGroupFilePath(group));
        if (dir.exists() && dir.isDirectory()) {
            File file = SettingsManager.getGroupFile(group, dir);
            File backupFile = SettingsManager.getGroupBackupFile(group, dir);
            if (file.exists() && file.isFile() || backupFile.exists() && backupFile.isFile()) {
                boolean readFromBackup = false;
                if (backupFile.exists() && backupFile.isFile()) {
                    FileUtils.copyFile(backupFile, file);
                    FileUtils.deleteFile(backupFile);
                    readFromBackup = true;
                }
                if (file.exists() && file.isFile()) {
                    try {
                        settingsGroup = (SettingsGroup)XmlUtils.fromXML(file);
                        groupState.put(group, new SettingsGroupState(readFromBackup ? ReadState.restored : ReadState.ok));
                        String state = readFromBackup ? "restored from backup" : "loaded";
                        Log.info(SettingsManager.class, "Settings group \"" + group + "\" " + state + " successfully", new Object[0]);
                    }
                    catch (Throwable e) {
                        Log.error(SettingsManager.class, "Unable to load settings group \"" + group + "\" due to unexpected exception:", e);
                        FileUtils.deleteFile(file);
                        groupState.put(group, new SettingsGroupState(ReadState.failed, e));
                    }
                }
            } else {
                groupState.put(group, new SettingsGroupState(ReadState.created));
                Log.info(SettingsManager.class, "Settings group \"" + group + "\" created successfully", new Object[0]);
            }
        } else {
            groupState.put(group, new SettingsGroupState(ReadState.created));
            Log.info(SettingsManager.class, "Settings group \"" + group + "\" created successfully", new Object[0]);
        }
        if (settingsGroup == null) {
            settingsGroup = new SettingsGroup(group);
        }
        groups.put(group, settingsGroup);
        return settingsGroup;
    }

    public static void saveSettings() {
        for (Map.Entry<String, SettingsGroup> entry : groups.entrySet()) {
            SettingsManager.saveSettingsGroup(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : files.entrySet()) {
            SettingsManager.saveSettings(entry.getKey(), entry.getValue());
        }
        ComponentSettingsManager.saveSettings();
    }

    public static void saveSettingsGroup(String group) {
        SettingsManager.saveSettingsGroup(SettingsManager.getSettingsGroup(group));
    }

    public static void saveSettingsGroup(SettingsGroup settingsGroup) {
        block7: {
            if (allowSave) {
                try {
                    String group = settingsGroup.getName();
                    File dir = new File(SettingsManager.getGroupFilePath(group));
                    if (FileUtils.ensureDirectoryExists(dir)) {
                        File file = SettingsManager.getGroupFile(group, dir);
                        File backupFile = null;
                        if (file.exists()) {
                            backupFile = SettingsManager.getGroupBackupFile(group, dir);
                            FileUtils.copyFile(file, backupFile);
                        }
                        XmlUtils.toXML((Object)settingsGroup, file);
                        if (backupFile != null && backupFile.exists()) {
                            FileUtils.deleteFile(backupFile);
                        }
                        if (saveLoggingEnabled) {
                            Log.info(SettingsManager.class, "Settings group \"" + group + "\" saved successfully", new Object[0]);
                        }
                        break block7;
                    }
                    throw new RuntimeException("Cannot create settings directory: " + dir.getAbsolutePath());
                }
                catch (Throwable e) {
                    Log.error(SettingsManager.class, "Unable to save settings group \"" + settingsGroup.getName() + "\" due to unexpected exception:", e);
                }
            }
        }
    }

    private static File getGroupFile(String group, File dir) {
        return new File(dir, group + settingsFilesExtension);
    }

    private static File getGroupBackupFile(String group, File dir) {
        return new File(dir, group + settingsFilesExtension + backupFilesExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delayedSaveSettingsGroup(String group) {
        if (saveOnChangeDelay > 0L) {
            Object object = saveOnChangeLock;
            synchronized (object) {
                if (!groupsToSaveOnChange.contains(group)) {
                    groupsToSaveOnChange.add(group);
                }
                if (groupSaveScheduler == null || !groupSaveScheduler.isRunning()) {
                    if (groupSaveScheduler == null) {
                        groupSaveScheduler = new WebTimer("SettingsManager.groupSaveScheduler", saveOnChangeDelay, new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Object object = saveOnChangeLock;
                                synchronized (object) {
                                    for (String group : groupsToSaveOnChange) {
                                        SettingsManager.saveSettingsGroup(group);
                                    }
                                    groupsToSaveOnChange.clear();
                                }
                            }
                        });
                        groupSaveScheduler.setRepeats(false);
                    } else {
                        groupSaveScheduler.setDelay(saveOnChangeDelay);
                    }
                    groupSaveScheduler.start();
                }
            }
        } else {
            SettingsManager.saveSettingsGroup(group);
        }
    }

    public SettingsGroupState getSettingsGroupState(String group) {
        if (!groupState.containsKey(group)) {
            groupState.put(group, new SettingsGroupState(ReadState.none));
        }
        return groupState.get(group);
    }

    public static Object getSettings(String fileName) {
        return SettingsManager.getSettings(fileName, null);
    }

    public static <T> T getSettings(String fileName, T defaultValue) {
        Object value;
        if (files.containsKey(fileName)) {
            return (T)files.get(fileName);
        }
        try {
            value = XmlUtils.fromXML(SettingsManager.getSettingsFile(fileName));
        }
        catch (Throwable e) {
            value = defaultValue;
        }
        files.put(fileName, value);
        return value;
    }

    public static void setSettings(String fileName, Object settings) {
        files.put(fileName, settings);
        if (saveOnChange) {
            SettingsManager.saveSettings(fileName, settings);
        }
    }

    private static void saveSettings(String fileName, Object settings) {
        if (allowSave) {
            XmlUtils.toXML(settings, SettingsManager.getSettingsFile(fileName));
        }
    }

    public static boolean settingsExists(String fileName) {
        return SettingsManager.getSettingsFile(fileName).exists();
    }

    private static File getSettingsFile(String fileName) {
        return new File(SettingsManager.getDefaultSettingsDir(), fileName);
    }

    public static String getSettingsFilesExtension() {
        return settingsFilesExtension;
    }

    public static void setSettingsFilesExtension(String settingsFilesExtension) {
        SettingsManager.settingsFilesExtension = settingsFilesExtension;
    }

    public static String getBackupFilesExtension() {
        return backupFilesExtension;
    }

    public static void setBackupFilesExtension(String backupFilesExtension) {
        SettingsManager.backupFilesExtension = backupFilesExtension;
    }

    public static String getDefaultSettingsDir() {
        if (defaultSettingsDir == null) {
            return FileUtils.getUserHomePath() + defaultSettingsDirName;
        }
        return defaultSettingsDir;
    }

    public static void setDefaultSettingsDir(String defaultSettingsDir) {
        SettingsManager.defaultSettingsDir = defaultSettingsDir;
    }

    public static String getDefaultSettingsDirName() {
        return defaultSettingsDirName;
    }

    public static void setDefaultSettingsDirName(String defaultSettingsDir) {
        defaultSettingsDirName = defaultSettingsDir;
    }

    public static String getDefaultSettingsGroup() {
        return defaultSettingsGroup;
    }

    public static void setDefaultSettingsGroup(String defaultSettingsGroup) {
        SettingsManager.defaultSettingsGroup = defaultSettingsGroup;
    }

    public static void setGroupFilePath(String group, String dir) {
        groupFileLocation.put(group, dir);
    }

    public static String getGroupFilePath(String group) {
        if (groupFileLocation.containsKey(group)) {
            return groupFileLocation.get(group);
        }
        return SettingsManager.getDefaultSettingsDir();
    }

    public static boolean isSaveOnChange() {
        return saveOnChange;
    }

    public static void setSaveOnChange(boolean saveOnChange) {
        SettingsManager.saveOnChange = saveOnChange;
    }

    public static boolean isSaveDefaultValues() {
        return saveDefaultValues;
    }

    public static void setSaveDefaultValues(boolean saveDefaultValues) {
        SettingsManager.saveDefaultValues = saveDefaultValues;
    }

    public static long getSaveOnChangeDelay() {
        return saveOnChangeDelay;
    }

    public static void setSaveOnChangeDelay(long saveOnChangeDelay) {
        SettingsManager.saveOnChangeDelay = saveOnChangeDelay;
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        SettingsManager.loggingEnabled = loggingEnabled;
        Log.setLoggingEnabled(SettingsManager.class, loggingEnabled);
    }

    public static boolean isSaveLoggingEnabled() {
        return saveLoggingEnabled;
    }

    public static void setSaveLoggingEnabled(boolean enabled) {
        saveLoggingEnabled = enabled;
    }

    public static boolean isAllowSave() {
        return allowSave;
    }

    public static void setAllowSave(boolean allowSave) {
        SettingsManager.allowSave = allowSave;
    }

    public static void disableSave() {
        SettingsManager.setAllowSave(false);
    }

    public static void enableSave() {
        SettingsManager.setAllowSave(true);
    }

    public static void addSettingsListener(String key, SettingsListener listener) {
        SettingsManager.addSettingsListener(SettingsManager.getDefaultSettingsGroup(), key, listener);
    }

    public static void addSettingsListener(String group, String key, SettingsListener listener) {
        if (!settingsListeners.containsKey(group)) {
            settingsListeners.put(group, new HashMap());
        }
        if (!settingsListeners.get(group).containsKey(key)) {
            settingsListeners.get(group).put(key, new ArrayList());
        }
        settingsListeners.get(group).get(key).add(listener);
    }

    public static void removeSettingsListener(String key, SettingsListener listener) {
        SettingsManager.removeSettingsListener(SettingsManager.getDefaultSettingsGroup(), key, listener);
    }

    public static void removeSettingsListener(String group, String key, SettingsListener listener) {
        if (settingsListeners.containsKey(group) && settingsListeners.get(group).containsKey(key)) {
            settingsListeners.get(group).get(key).remove(listener);
        }
    }

    private static void fireSettingsChanged(String group, String key, Object newValue) {
        if (settingsListeners.containsKey(group) && settingsListeners.get(group).containsKey(key)) {
            for (SettingsListener listener : CollectionUtils.copy((Collection)settingsListeners.get(group).get(key))) {
                listener.settingsChanged(group, key, newValue);
            }
        }
    }
}

