/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.util.List;

public final class CompareUtils {
    public static boolean equals(Object object, Object ... compareWith) {
        if (compareWith != null && compareWith.length > 0) {
            for (Object o : compareWith) {
                if (!CompareUtils.equalsImpl(object, o)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean equalsImpl(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }

    public static boolean contains(String text, List<String> tokens) {
        for (String token : tokens) {
            if (!text.contains(token)) continue;
            return true;
        }
        return false;
    }

    public static int compareNames(String name1, String name2) {
        int n1 = name1.length();
        int n2 = name2.length();
        int min = Math.min(n1, n2);
        for (int i = 0; i < min; ++i) {
            char c1 = name1.charAt(i);
            char c2 = name2.charAt(i);
            boolean d1 = Character.isDigit(c1);
            boolean d2 = Character.isDigit(c2);
            if (d1 && d2) {
                char c4;
                char c3;
                do {
                    c3 = ++i < n1 ? (char)name1.charAt(i) : (char)'x';
                    c4 = i < n2 ? (char)name2.charAt(i) : (char)'x';
                    d1 = Character.isDigit(c3);
                    d2 = Character.isDigit(c4);
                } while (d1 && d2 && c3 == c4);
                if (d1 != d2) {
                    return d1 ? 1 : -1;
                }
                if (c1 != c2) {
                    return c1 - c2;
                }
                if (c3 != c4) {
                    return c3 - c4;
                }
                --i;
                continue;
            }
            if (c1 == c2 || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }
}

