/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.GlobalConstants;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.log.Log;
import com.alee.managers.proxy.ProxyManager;
import com.alee.utils.ImageUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.WebUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.file.FileDescription;
import com.alee.utils.file.FileDownloadListener;
import com.alee.utils.file.SystemFileListener;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.IOFileFilterAdapter;
import com.alee.utils.filefilter.SwingFileFilterAdapter;
import com.alee.utils.swing.WebTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;

public final class FileUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long PB = 0x10000000000L;
    private static final ImageIcon COMPUTER_ICON = new ImageIcon(FileUtils.class.getResource("icons/computer.png"));
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm");
    private static final String defaultEncoding = "UTF-8";
    private static final int MD5_BUFFER_LENGTH = 102400;
    private static final int TEXT_BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '\"', '`', '!', '?', '*', '\\', '<', '>', '|', ':', ';', '.', ',', '%', '$', '@', '#', '^', '{', '}', '[', ']', ']'};
    private static final Map<String, Boolean> isDriveCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isComputerCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isCdDriveCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isFileCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isDirectoryCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isHiddenCache = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, String> displayFileNameCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, FileDescription> fileDescriptionCache = new ConcurrentHashMap<String, FileDescription>();
    private static final Map<String, String> fileTypeDescriptionCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> displayFileCreationDateCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> displayFileModificationDateCache = new ConcurrentHashMap<String, String>();
    private static final Object extensionIconsCacheLock = new Object();
    private static final Map<String, ImageIcon> extensionIconsCache = new ConcurrentHashMap<String, ImageIcon>();
    private static final Map<String, ImageIcon> resourceIconsCache = new ConcurrentHashMap<String, ImageIcon>();
    private static final int FILE_TRACKING_DELAY = 5000;

    public static void clearFilesCaches(File ... files) {
        if (files != null && files.length > 0) {
            for (File file : files) {
                FileUtils.clearFileCaches(file);
            }
        }
    }

    public static void clearFileCaches(File file) {
        if (file != null) {
            FileUtils.clearFileCaches(file.getAbsolutePath());
        }
    }

    public static void clearFileCaches(String path) {
        FileUtils.clearDisplayFileNameCache(path);
        FileUtils.clearIsHiddenCache(path);
        FileUtils.clearIsFileCache(path);
        FileUtils.clearIsDirectoryCache(path);
        FileUtils.clearIsComputerCache(path);
        FileUtils.clearIsDriveCache(path);
        FileUtils.clearIsCdDriveCache(path);
        FileUtils.clearFileDescriptionCache(path);
        FileUtils.clearFileTypeDescriptionCache(path);
        FileUtils.clearDisplayFileCreationDateCache(path);
        FileUtils.clearDisplayFileModificationDateCache(path);
    }

    public static List<File> getFilePath(File file) {
        ArrayList<File> path = new ArrayList<File>();
        while (file != null) {
            path.add(0, file);
            file = file.getParentFile();
        }
        return path;
    }

    public static String getRelativePath(File file, File folder) {
        return folder.toURI().relativize(file.toURI()).getPath();
    }

    public static boolean isNameEditable(File file) {
        return file.getParentFile() != null && file.canWrite() && file.getParentFile().canWrite();
    }

    public static void displayFileName(JTextComponent editor, File file) {
        String name = file.getName();
        editor.setText(name);
        editor.setSelectionStart(0);
        editor.setSelectionEnd(file.isDirectory() ? name.length() : FileUtils.getFileNamePart(name).length());
    }

    public static File getSystemTemp() {
        return new File(FileUtils.getSystemTempPath());
    }

    public static String getSystemTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static boolean grantExecutePermissions(File file) {
        try {
            return file.setExecutable(true, false);
        }
        catch (Throwable e) {
            Log.error(FileUtils.class, e);
            return false;
        }
    }

    public static File normalize(File file) {
        try {
            return file != null ? file.getCanonicalFile() : file;
        }
        catch (IOException e) {
            return file;
        }
    }

    public static File getSystemRoot() {
        File[] roots = FileUtils.getSystemRoots();
        return roots.length > 0 ? roots[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] getSystemRoots() {
        File[] roots;
        FileSystemView fileSystemView = fsv;
        synchronized (fileSystemView) {
            roots = fsv.getRoots();
        }
        if (roots != null && roots.length > 0) {
            return roots;
        }
        return FileUtils.getDiskRoots();
    }

    public static File[] getDiskRoots() {
        File[] roots = File.listRoots();
        int proper = 0;
        for (File root : roots) {
            if (!FileUtils.isDirectory(root)) continue;
            ++proper;
        }
        File[] properRoots = new File[proper];
        int currentIndex = 0;
        for (File root : roots) {
            if (!FileUtils.isDirectory(root)) continue;
            properRoots[currentIndex] = root;
            ++currentIndex;
        }
        return properRoots;
    }

    public static File[] listFiles(File directory, final Filter<File> fileFilter) {
        return FileUtils.listFiles(directory, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return fileFilter.accept(file);
            }
        });
    }

    public static File[] listFiles(File directory, FileFilter fileFilter) {
        File[] files = directory.listFiles(fileFilter);
        return files != null ? files : new File[]{};
    }

    public static String computeMD5(File file) {
        return FileUtils.computeMD5(file, 102400);
    }

    public static String computeMD5(File file, int bufferLength) {
        try {
            return FileUtils.computeMD5(new FileInputStream(file), bufferLength);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static String computeMD5(InputStream is) {
        return FileUtils.computeMD5(is, 102400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeMD5(InputStream is, int bufferLength) {
        String string;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[bufferLength];
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) > 0) {
                digest.update(buffer, 0, bytesRead);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            string = bigInt.toString(16);
        }
        catch (Throwable e) {
            try {
                String string2 = null;
                return string2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            bis.close();
            return string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static File getWorkingDirectory() {
        return new File(FileUtils.getWorkingDirectoryPath());
    }

    public static String getWorkingDirectoryPath() {
        return System.getProperty("user.dir");
    }

    public static File getUserHome() {
        return new File(FileUtils.getUserHomePath());
    }

    public static String getUserHomePath() {
        String home = System.getProperty("user.home");
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        return home;
    }

    public static boolean equals(File file1, File file2) {
        if (file1 == null && file2 == null) {
            return true;
        }
        boolean notNull = file1 != null && file2 != null;
        try {
            return notNull && file1.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (IOException e) {
            return notNull && file1.getAbsolutePath().equals(file2.getAbsolutePath());
        }
    }

    public static boolean equals(List<File> files1, List<File> files2) {
        if (files1.size() != files2.size()) {
            return false;
        }
        if (files1.size() == files2.size() && files2.size() == 0) {
            return true;
        }
        for (int i = 0; i < files1.size(); ++i) {
            if (files1.get(i).getAbsolutePath().equals(files2.get(i).getAbsolutePath())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsFile(List files, File file) {
        for (Object f : files) {
            if (!(f instanceof File ? ((File)f).getAbsolutePath().equals(file.getAbsolutePath()) : f instanceof String && f.equals(file.getAbsolutePath()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileAccepted(File file, List<AbstractFileFilter> filters) {
        if (filters == null || filters.size() == 0) {
            return true;
        }
        for (FileFilter fileFilter : filters) {
            if (!fileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }

    public static String getProperFileName(String name) {
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (FileUtils.isIllegalFileNameChar(name.charAt(i))) continue;
            newName.append(name.charAt(i));
        }
        return newName.toString().replaceAll(" ", "_");
    }

    public static boolean isIllegalFileNameChar(char c) {
        boolean isIllegal = false;
        for (char ILLEGAL_CHARACTER : ILLEGAL_CHARACTERS) {
            if (c != ILLEGAL_CHARACTER) continue;
            isIllegal = true;
        }
        return isIllegal;
    }

    public static String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static File getTopParent(File file) {
        File parent = (file = file.getAbsoluteFile()).getParentFile();
        if (parent == null) {
            return null;
        }
        while (parent.getParentFile() != null) {
            parent = parent.getParentFile();
        }
        return parent;
    }

    public static boolean isParent(File parent, File child) {
        if (child == parent) {
            return false;
        }
        if (child == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        if (child.equals(parent)) {
            return false;
        }
        child = child.getAbsoluteFile();
        for (File cp = child.getParentFile(); cp != null; cp = cp.getParentFile()) {
            if (!cp.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static String getFileNamePart(File file) {
        return file != null ? FileUtils.getFileNamePart(file.getName()) : "";
    }

    public static String getFileNamePart(String name) {
        if (!TextUtils.isEmpty(name)) {
            int i = name.lastIndexOf(".");
            return i == -1 ? name : name.substring(0, i);
        }
        return "";
    }

    public static String getFileExtPart(File file, boolean withDot) {
        return file != null ? FileUtils.getFileExtPart(file.getName(), withDot) : "";
    }

    public static String getFileExtPart(String name, boolean withDot) {
        if (!TextUtils.isEmpty(name)) {
            int i = name.lastIndexOf(".");
            return i == -1 ? "" : (withDot ? name.substring(i) : name.substring(i + 1));
        }
        return "";
    }

    public static String getShortFileName(String name) {
        return FileUtils.getShortFileName(name, 30);
    }

    public static String getShortFileName(String name, int length) {
        if (length < 2) {
            return name;
        }
        String newName = FileUtils.getFileNamePart(name);
        if (newName.length() > length) {
            return newName.substring(0, length - 2) + "..." + FileUtils.getFileExtPart(name, false);
        }
        return name;
    }

    public static List sortFiles(List<File> files) {
        if (files != null) {
            Collections.sort(files, GlobalConstants.FILE_COMPARATOR);
        }
        return files;
    }

    public static File[] sortFiles(File[] files) {
        if (files != null) {
            Arrays.sort(files, GlobalConstants.FILE_COMPARATOR);
        }
        return files;
    }

    public static String getAvailableName(String dir, String name) {
        return FileUtils.getAvailableName(new File(dir), name);
    }

    public static String getAvailableName(File dir, String name) {
        ArrayList<String> exist = new ArrayList<String>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                exist.add(file.getName());
            }
        }
        return FileUtils.getAvailableName(exist, name);
    }

    public static String getAvailableName(List<String> exist, String name) {
        Integer n;
        if (!exist.contains(name)) {
            return name;
        }
        int dot = name.lastIndexOf(".");
        String nameStart = dot != -1 ? name.substring(0, dot).trim() : name;
        String nameExt = dot != -1 ? name.substring(name.lastIndexOf(".")) : null;
        int ob = nameStart.lastIndexOf("(");
        int cb = nameStart.lastIndexOf(")");
        String nameReal = null;
        Integer index = null;
        if (ob < cb && cb == nameStart.length() - 1) {
            try {
                nameReal = nameStart.substring(0, ob);
                Integer n2 = index = Integer.valueOf(Integer.parseInt(nameStart.substring(ob + 1, cb)));
                n = index = Integer.valueOf(index + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int i = 1;
        while (exist.contains(name)) {
            if (nameReal != null && index != null) {
                name = nameReal + "(" + index + ")" + nameExt;
                n = index;
                Integer n3 = index = Integer.valueOf(index + 1);
                continue;
            }
            name = nameStart + " (" + i + ")" + (nameExt != null ? nameExt : "");
            ++i;
        }
        return name;
    }

    public static List<File> toFilesList(Object ... object) {
        ArrayList<File> files = new ArrayList<File>(object != null ? object.length : 0);
        for (Object e : files) {
            if (!(e instanceof File)) continue;
            files.add((File)e);
        }
        return files;
    }

    public static void deleteFiles(Object ... files) {
        for (Object object : files) {
            if (!(object instanceof File)) continue;
            FileUtils.deleteFile((File)object);
        }
    }

    public static void deleteFiles(List files) {
        for (Object object : files) {
            if (!(object instanceof File)) continue;
            FileUtils.deleteFile((File)object);
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            } else if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    FileUtils.deleteFile(child);
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
    }

    public static void clearDirectory(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                FileUtils.deleteFile(child);
            }
        }
    }

    public static AbstractFileFilter transformFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof AbstractFileFilter) {
            return (AbstractFileFilter)fileFilter;
        }
        return new IOFileFilterAdapter(fileFilter, GlobalConstants.ALL_FILES_FILTER.getIcon(), LanguageManager.get("weblaf.file.filter.custom"));
    }

    public static AbstractFileFilter transformFileFilter(javax.swing.filechooser.FileFilter fileFilter) {
        if (fileFilter instanceof AbstractFileFilter) {
            return (AbstractFileFilter)fileFilter;
        }
        return new SwingFileFilterAdapter(fileFilter, GlobalConstants.ALL_FILES_FILTER.getIcon());
    }

    public static javax.swing.filechooser.FileFilter getSwingFileFilter(AbstractFileFilter fileFilter) {
        return fileFilter != null && fileFilter instanceof SwingFileFilterAdapter ? ((SwingFileFilterAdapter)fileFilter).getFileFilter() : fileFilter;
    }

    public static List<File> filterFiles(Collection<File> files, AbstractFileFilter fileFilter) {
        ArrayList<File> filteredFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            if (!fileFilter.accept(file)) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    public static FileDescription createFileDescription(File file, String fileSize) {
        String name = FileUtils.getDisplayFileName(file);
        String size = file.isFile() ? FileUtils.getDisplayFileSize(file) + (fileSize != null ? " (" + fileSize + ")" : "") : null;
        String description = FileUtils.getFileTypeDescription(file);
        return new FileDescription(name, size, description, null);
    }

    public static String getDisplayFileSize(File file) {
        return FileUtils.getFileSizeString(file.length());
    }

    public static String getDisplayFileSize(File file, int digits) {
        return FileUtils.getFileSizeString(file.length(), digits);
    }

    public static String getFileSizeString(long size) {
        return FileUtils.getFileSizeString(size, 2);
    }

    public static String getFileSizeString(long size, int digits) {
        DecimalFormat df = new DecimalFormat(digits > 0 ? "#." + FileUtils.getDigits(digits) : "#");
        if (size < 1024L) {
            return df.format(size) + " " + LanguageManager.get("weblaf.file.size.b");
        }
        if (size >= 1024L && size < 0x100000L) {
            return df.format((float)size / 1024.0f) + " " + LanguageManager.get("weblaf.file.size.kb");
        }
        if (size >= 0x100000L && size < 0x40000000L) {
            return df.format((float)size / 1048576.0f) + " " + LanguageManager.get("weblaf.file.size.mb");
        }
        return df.format((float)size / 1.0737418E9f) + " " + LanguageManager.get("weblaf.file.size.gb");
    }

    private static String getDigits(int digits) {
        StringBuilder stringBuilder = new StringBuilder(digits);
        for (int i = 0; i < digits; ++i) {
            stringBuilder.append("#");
        }
        return stringBuilder.toString();
    }

    public static boolean copyDirectory(String src, String dst) {
        return FileUtils.copyDirectory(src, dst, false);
    }

    public static boolean copyDirectory(String src, String dst, boolean stopOnFail) {
        return FileUtils.copyDirectory(new File(src), new File(dst), stopOnFail);
    }

    public static boolean copyDirectory(File srcDir, File dstDir) {
        return FileUtils.copyDirectory(srcDir, dstDir, false);
    }

    public static boolean copyDirectory(File srcDir, File dstDir, boolean stopOnFail) {
        if (srcDir.exists() && srcDir.isDirectory()) {
            if (FileUtils.ensureDirectoryExists(dstDir)) {
                boolean success = true;
                for (File file : srcDir.listFiles()) {
                    String copied = dstDir.getAbsolutePath() + File.separator + file.getName();
                    if (file.isDirectory()) {
                        boolean bl = success = FileUtils.copyDirectory(file.getAbsolutePath(), copied) && success;
                        if (success || !stopOnFail) continue;
                        return false;
                    }
                    boolean bl = success = FileUtils.copyFile(file.getAbsolutePath(), copied) && success;
                    if (success || !stopOnFail) continue;
                    return false;
                }
                return success;
            }
            return false;
        }
        return false;
    }

    public static boolean copyFile(String src, String dst) {
        try {
            File dstDir = new File(new File(dst).getParent());
            if (FileUtils.ensureDirectoryExists(dstDir)) {
                FileChannel srcFC = new FileInputStream(src).getChannel();
                FileChannel dstFC = new FileOutputStream(dst).getChannel();
                return FileUtils.copyFile(srcFC, dstFC);
            }
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean copyFile(File srcFile, File dstFile) {
        if (srcFile.exists() && srcFile.isFile()) {
            try {
                File dstDir = new File(dstFile.getParent());
                if (FileUtils.ensureDirectoryExists(dstDir)) {
                    FileChannel srcFC = new FileInputStream(srcFile).getChannel();
                    FileChannel dstFC = new FileOutputStream(dstFile).getChannel();
                    return FileUtils.copyFile(srcFC, dstFC);
                }
                return false;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean copyFile(FileChannel srcFC, FileChannel dstFC) {
        try {
            dstFC.transferFrom(srcFC, 0L, srcFC.size());
            srcFC.close();
            dstFC.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String readToString(Class nearClass, String resource) {
        return FileUtils.readToString(nearClass, resource, defaultEncoding);
    }

    public static String readToString(Class nearClass, String resource, String encoding) {
        try {
            return FileUtils.readToString(nearClass.getResourceAsStream(resource), encoding);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String readToString(URL url) {
        return FileUtils.readToString(url, defaultEncoding);
    }

    public static String readToString(URL url, String encoding) {
        try {
            return FileUtils.readToString(url.openStream(), encoding);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String readToString(File file) {
        return FileUtils.readToString(file, defaultEncoding);
    }

    public static String readToString(File file, String encoding) {
        try {
            if (file != null && file.exists() && file.isFile()) {
                return FileUtils.readToString(new FileInputStream(file), encoding);
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String readToString(InputStream inputStream) {
        return FileUtils.readToString(inputStream, defaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readToString(InputStream inputStream, String encoding) {
        block14: {
            if (inputStream == null) break block14;
            String string = FileUtils.readToString(new InputStreamReader(inputStream, encoding));
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        String string = null;
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (Throwable e) {
            try {
                String string2 = null;
                return string2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readToString(Reader reader) {
        int charsRead;
        block15: {
            if (reader != null) break block15;
            String string = "";
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        char[] buffer = new char[65536];
        StringBuilder sb = new StringBuilder();
        while ((charsRead = reader.read(buffer, 0, 65536)) != -1) {
            sb.append(buffer, 0, charsRead);
        }
        String string = sb.toString();
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (Throwable e) {
            try {
                String string2 = "";
                return string2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeStringToFile(String text, File file) {
        FileUtils.writeStringToFile(text, file, defaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String text, File file, String encoding) {
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeException("Specified file points to existing folder!");
        }
        file.getParentFile().mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file, encoding);
            writer.write(text);
        }
        catch (FileNotFoundException e) {
            Log.error(FileUtils.class, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            Log.error(FileUtils.class, (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static List<String> getSubPaths(String dir) {
        return FileUtils.getSubPaths(new File(dir));
    }

    public static List<String> getSubPaths(File dir) {
        return FileUtils.getSubPaths(dir, "");
    }

    public static List<String> getSubPaths(File dir, String path) {
        return FileUtils.getSubPaths(dir, path, new ArrayList<String>());
    }

    public static List<String> getSubPaths(File dir, String path, List<String> paths) {
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                paths.add(path + file.getName());
                continue;
            }
            if (!file.isDirectory()) continue;
            FileUtils.getSubPaths(file, path + file.getName() + File.separator, paths);
        }
        return paths;
    }

    public static File downloadFile(String url, File dstFile) {
        return FileUtils.downloadFile(url, dstFile, false, null, 3000, null);
    }

    public static File downloadFile(String url, File dstFile, FileDownloadListener listener) {
        return FileUtils.downloadFile(url, dstFile, false, null, 3000, listener);
    }

    public static File downloadFile(String url, String dst, boolean encodeUrl, String contentType, int timeout) {
        return FileUtils.downloadFile(url, new File(dst), encodeUrl, contentType, timeout, null);
    }

    public static File downloadFile(String url, String dst, boolean encodeUrl, String contentType, int timeout, FileDownloadListener listener) {
        return FileUtils.downloadFile(url, new File(dst), encodeUrl, contentType, timeout, listener);
    }

    public static File downloadFile(String url, File dstFile, boolean encodeUrl, String contentType, int timeout) {
        return FileUtils.downloadFile(url, dstFile, encodeUrl, contentType, timeout, null);
    }

    public static File downloadFile(String url, File dstFile, boolean encodeUrl, String contentType, int timeout, FileDownloadListener listener) {
        try {
            int bytesRead;
            String ct;
            URL encodedUrl = new URL(encodeUrl ? WebUtils.encodeUrl(url) : url);
            URLConnection uc = ProxyManager.getURLConnection(encodedUrl);
            if (timeout != 0) {
                uc.setConnectTimeout(timeout);
                uc.setReadTimeout(timeout);
            }
            if (listener != null && listener.shouldStopDownload()) {
                FileUtils.deleteFile(dstFile);
                return null;
            }
            if (contentType != null && !(ct = uc.getContentType()).contains(contentType)) {
                FileUtils.deleteFile(dstFile);
                return null;
            }
            if (listener != null) {
                listener.sizeDetermined(uc.getContentLength());
                if (listener.shouldStopDownload()) {
                    FileUtils.deleteFile(dstFile);
                    return null;
                }
            }
            InputStream in = uc.getInputStream();
            FileOutputStream out = new FileOutputStream(dstFile);
            if (listener != null && listener.shouldStopDownload()) {
                out.flush();
                out.close();
                in.close();
                FileUtils.deleteFile(dstFile);
                return null;
            }
            byte[] buf = new byte[51200];
            int totalBytesRead = 0;
            while ((bytesRead = in.read(buf)) != -1) {
                if (listener != null) {
                    listener.partDownloaded(totalBytesRead += bytesRead);
                    if (listener.shouldStopDownload()) {
                        out.flush();
                        out.close();
                        in.close();
                        FileUtils.deleteFile(dstFile);
                        return null;
                    }
                }
                out.write(buf, 0, bytesRead);
            }
            out.flush();
            out.close();
            in.close();
            if (listener != null) {
                listener.fileDownloaded(dstFile);
            }
            return dstFile;
        }
        catch (Throwable e) {
            if (listener != null) {
                listener.fileDownloadFailed(e);
            }
            return null;
        }
    }

    public static int getFileSize(String url) {
        try {
            return FileUtils.getFileSize(new URL(url));
        }
        catch (Throwable e) {
            Log.error(FileUtils.class, e);
            return -1;
        }
    }

    public static int getFileSize(URL url) {
        try {
            URLConnection uc = ProxyManager.getURLConnection(url);
            return uc.getContentLength();
        }
        catch (Throwable e) {
            Log.error(FileUtils.class, e);
            return -1;
        }
    }

    public static List<File> findFilesRecursively(String dir, List<String> extension) {
        return FileUtils.findFilesRecursively(new File(dir), extension);
    }

    public static List<File> findFilesRecursively(File dir, List<String> extension) {
        return FileUtils.findFilesRecursively(dir, extension, true);
    }

    public static List<File> findFilesRecursively(String dir, List<String> extension, boolean withDot) {
        return FileUtils.findFilesRecursively(new File(dir), extension, withDot);
    }

    public static List<File> findFilesRecursively(File dir, List<String> extension, boolean withDot) {
        return FileUtils.findFilesRecursively(dir, extension, withDot, null);
    }

    public static List<File> findFilesRecursively(String dir, List<String> extension, boolean withDot, List<File> found) {
        return FileUtils.findFilesRecursively(new File(dir), extension, withDot, found);
    }

    public static List<File> findFilesRecursively(File dir, final List<String> extension, final boolean withDot, List<File> found) {
        return FileUtils.findFilesRecursively(dir, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && extension.contains(FileUtils.getFileExtPart(file.getName(), withDot));
            }
        }, found);
    }

    public static List<File> findFilesRecursively(String dir, FileFilter filter) {
        return FileUtils.findFilesRecursively(new File(dir), filter);
    }

    public static List<File> findFilesRecursively(File dir, FileFilter filter) {
        return FileUtils.findFilesRecursively(dir, filter, null);
    }

    public static List<File> findFilesRecursively(String dir, FileFilter filter, List<File> found) {
        return FileUtils.findFilesRecursively(new File(dir), filter, found);
    }

    public static List<File> findFilesRecursively(File dir, FileFilter filter, List<File> found) {
        if (found == null) {
            found = new ArrayList<File>();
        }
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (filter.accept(file)) {
                    found.add(file);
                }
                if (!file.isDirectory()) continue;
                FileUtils.findFilesRecursively(file, filter, found);
            }
        }
        return found;
    }

    public static boolean ensureDirectoryExists(String dir) {
        return FileUtils.ensureDirectoryExists(new File(dir));
    }

    public static boolean ensureDirectoryExists(File dir) {
        return dir.exists() || dir.mkdirs();
    }

    public static void clearIsDriveCache() {
        isDriveCache.clear();
    }

    public static void clearIsDriveCache(String absolutePath) {
        isDriveCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDrive(File file) {
        boolean isDrive;
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return false;
        }
        if (isDriveCache.containsKey(absolutePath)) {
            return isDriveCache.get(absolutePath);
        }
        FileSystemView fileSystemView = fsv;
        synchronized (fileSystemView) {
            isDrive = fsv.isDrive(file);
        }
        isDriveCache.put(absolutePath, isDrive);
        return isDrive;
    }

    public static void clearIsComputerCache() {
        isComputerCache.clear();
    }

    public static void clearIsComputerCache(String absolutePath) {
        isComputerCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isComputer(File file) {
        boolean isComputer;
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return false;
        }
        if (isComputerCache.containsKey(absolutePath)) {
            return isComputerCache.get(absolutePath);
        }
        FileSystemView fileSystemView = fsv;
        synchronized (fileSystemView) {
            isComputer = fsv.isComputerNode(file);
        }
        isComputerCache.put(absolutePath, isComputer);
        return isComputer;
    }

    public static void clearIsCdDriveCache() {
        isCdDriveCache.clear();
    }

    public static void clearIsCdDriveCache(String absolutePath) {
        isCdDriveCache.remove(absolutePath);
    }

    public static boolean isCdDrive(File file) {
        boolean isCdDrive;
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return false;
        }
        if (isCdDriveCache.containsKey(absolutePath)) {
            return isCdDriveCache.get(absolutePath);
        }
        if (file.getParent() == null) {
            String sysDes = FileUtils.getFileTypeDescription(file);
            String description = sysDes != null ? sysDes.toLowerCase(Locale.ROOT) : file.getName();
            isCdDrive = description.contains("cd") || description.contains("dvd") || description.contains("blu-ray") || description.contains("bluray");
        } else {
            isCdDrive = false;
        }
        isCdDriveCache.put(absolutePath, isCdDrive);
        return isCdDrive;
    }

    public static void clearIsFileCache() {
        isFileCache.clear();
    }

    public static void clearIsFileCache(String absolutePath) {
        isFileCache.remove(absolutePath);
    }

    public static boolean isFile(File file) {
        if (file == null) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return false;
        }
        if (isFileCache.containsKey(absolutePath)) {
            return isFileCache.get(absolutePath);
        }
        boolean isFile = file.isFile();
        isFileCache.put(absolutePath, isFile);
        return isFile;
    }

    public static void clearIsDirectoryCache() {
        isDirectoryCache.clear();
    }

    public static void clearIsDirectoryCache(String absolutePath) {
        isDirectoryCache.remove(absolutePath);
    }

    public static boolean isDirectory(File file) {
        if (file == null) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return false;
        }
        if (isDirectoryCache.containsKey(absolutePath)) {
            return isDirectoryCache.get(absolutePath);
        }
        boolean isDirectory = file.isDirectory();
        isDirectoryCache.put(absolutePath, isDirectory);
        return isDirectory;
    }

    public static void clearIsHiddenCache() {
        isHiddenCache.clear();
    }

    public static void clearIsHiddenCache(String absolutePath) {
        isHiddenCache.remove(absolutePath);
    }

    public static boolean isHidden(File file) {
        if (file == null) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return false;
        }
        if (isHiddenCache.containsKey(absolutePath)) {
            return isHiddenCache.get(absolutePath);
        }
        boolean isHidden = (file = file.getAbsoluteFile()).getParentFile() != null && file.isHidden();
        isHiddenCache.put(absolutePath, isHidden);
        return isHidden;
    }

    public static void clearFileDescriptionCache() {
        fileDescriptionCache.clear();
    }

    public static void clearFileDescriptionCache(String absolutePath) {
        fileDescriptionCache.remove(absolutePath);
    }

    public static FileDescription getFileDescription(File file, String fileSize) {
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return new FileDescription("Unknown", "0", "", null);
        }
        if (fileDescriptionCache.containsKey(absolutePath)) {
            return fileDescriptionCache.get(absolutePath);
        }
        FileDescription fileDescription = FileUtils.createFileDescription(file, fileSize);
        fileDescriptionCache.put(absolutePath, fileDescription);
        return fileDescription;
    }

    public static void clearDisplayFileNameCache() {
        displayFileNameCache.clear();
    }

    public static void clearDisplayFileNameCache(String absolutePath) {
        displayFileNameCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayFileName(File file) {
        String name;
        String absolutePath;
        String string = absolutePath = file == null ? null : file.getAbsolutePath();
        if (absolutePath == null) {
            return "";
        }
        if (displayFileNameCache.containsKey(absolutePath)) {
            return displayFileNameCache.get(absolutePath);
        }
        FileSystemView fileSystemView = fsv;
        synchronized (fileSystemView) {
            name = fsv.getSystemDisplayName(file);
        }
        if (TextUtils.isEmpty(name)) {
            name = FileUtils.getFileTypeDescription(file);
        }
        if (name == null) {
            name = "";
        }
        displayFileNameCache.put(absolutePath, name);
        return name;
    }

    public static void clearDisplayFileCreationDateCache() {
        displayFileCreationDateCache.clear();
    }

    public static void clearDisplayFileCreationDateCache(String absolutePath) {
        displayFileCreationDateCache.remove(absolutePath);
    }

    public static String getDisplayFileCreationDate(File file) {
        String absolutePath;
        String string = absolutePath = file == null ? null : file.getAbsolutePath();
        if (absolutePath == null) {
            return "";
        }
        if (displayFileCreationDateCache.containsKey(absolutePath)) {
            return displayFileCreationDateCache.get(absolutePath);
        }
        String date = sdf.format(new Date(file.lastModified()));
        displayFileCreationDateCache.put(absolutePath, date);
        return date;
    }

    public static void clearDisplayFileModificationDateCache() {
        displayFileModificationDateCache.clear();
    }

    public static void clearDisplayFileModificationDateCache(String absolutePath) {
        displayFileModificationDateCache.remove(absolutePath);
    }

    public static String getDisplayFileModificationDate(File file) {
        String absolutePath;
        String string = absolutePath = file == null ? null : file.getAbsolutePath();
        if (absolutePath == null) {
            return "";
        }
        if (displayFileModificationDateCache.containsKey(absolutePath)) {
            return displayFileModificationDateCache.get(absolutePath);
        }
        String date = sdf.format(new Date(file.lastModified()));
        displayFileModificationDateCache.put(absolutePath, date);
        return date;
    }

    public static void clearFileTypeDescriptionCache() {
        fileTypeDescriptionCache.clear();
    }

    public static void clearFileTypeDescriptionCache(String absolutePath) {
        fileTypeDescriptionCache.remove(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileTypeDescription(File file) {
        String description;
        if (file == null) {
            return "";
        }
        String absolutePath = file.getAbsolutePath();
        if (absolutePath == null) {
            return "";
        }
        if (fileTypeDescriptionCache.containsKey(absolutePath)) {
            return fileTypeDescriptionCache.get(absolutePath);
        }
        FileSystemView fileSystemView = fsv;
        synchronized (fileSystemView) {
            description = fsv.getSystemTypeDescription(file);
        }
        if (description == null) {
            description = "";
        }
        fileTypeDescriptionCache.put(absolutePath, absolutePath);
        return description;
    }

    public static ImageIcon getMyComputerIcon() {
        return COMPUTER_ICON;
    }

    public static ImageIcon getFileIcon(File file) {
        return FileUtils.getFileIcon(file, false);
    }

    public static ImageIcon getFileIcon(File file, boolean large) {
        return FileUtils.getStandardFileIcon(file, large);
    }

    public static ImageIcon getStandardFileIcon(File file, boolean large) {
        return FileUtils.getStandardFileIcon(file, large, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getStandardFileIcon(File file, boolean large, boolean enabled) {
        boolean contains;
        String extension;
        if (file == null) {
            return null;
        }
        if (!FileUtils.isDirectory(file)) {
            extension = FileUtils.getFileExtPart(file.getName(), false).trim().toLowerCase(Locale.ROOT);
            if (extension.trim().equals("")) {
                extension = file.getAbsolutePath();
            }
        } else {
            extension = FileUtils.isCdDrive(file) ? "cd_drive" : (FileUtils.isDrive(file) ? "drive" : (FileUtils.isComputer(file) ? "computer" : "folder"));
        }
        float opacity = FileUtils.isHidden(file) ? 0.5f : 1.0f;
        String key = FileUtils.getStandardFileIconCacheKey(extension, large, opacity, enabled);
        Object object = extensionIconsCacheLock;
        synchronized (object) {
            contains = extensionIconsCache.containsKey(key);
        }
        if (contains) {
            object = extensionIconsCacheLock;
            synchronized (object) {
                return extensionIconsCache.get(key);
            }
        }
        ImageIcon icon = FileUtils.getStandardFileIcon(large, extension, opacity);
        if (icon == null) {
            icon = FileUtils.getStandardFileIcon(large, "file", opacity);
        }
        if (enabled) {
            if (key != null && icon != null) {
                Object object2 = extensionIconsCacheLock;
                synchronized (object2) {
                    extensionIconsCache.put(key, icon);
                }
            }
        } else {
            Object object3;
            String keyEnebled = FileUtils.getStandardFileIconCacheKey(extension, large, opacity, true);
            if (keyEnebled != null && icon != null) {
                object3 = extensionIconsCacheLock;
                synchronized (object3) {
                    extensionIconsCache.put(keyEnebled, icon);
                }
            }
            icon = ImageUtils.createDisabledCopy(icon);
            if (key != null && icon != null) {
                object3 = extensionIconsCacheLock;
                synchronized (object3) {
                    extensionIconsCache.put(key, icon);
                }
            }
        }
        return icon;
    }

    private static String getStandardFileIconCacheKey(String extension, boolean large, float opacity, boolean enabled) {
        return extension + ";#&;" + large + ";#&;" + opacity + ";#&;" + enabled;
    }

    public static ImageIcon getStandardFileIcon(boolean large, String extension, float opacity) {
        return FileUtils.getIconResource(FileUtils.class, "icons/extensions/" + (large ? "32" : "16") + "/file_extension_" + extension + ".png", opacity);
    }

    public static ImageIcon getIconResource(Class nearClass, String resource) {
        return FileUtils.getIconResource(nearClass, resource, 1.0f);
    }

    public static ImageIcon getIconResource(Class nearClass, String resource, float opacity) {
        ImageIcon icon;
        String key = nearClass.getCanonicalName() + ";#&;" + resource + ";#&;" + opacity;
        if (resourceIconsCache.containsKey(key)) {
            return resourceIconsCache.get(key);
        }
        URL url = nearClass.getResource(resource);
        if (url != null) {
            icon = new ImageIcon(url);
            if (opacity < 1.0f) {
                icon = ImageUtils.createTransparentCopy(icon, opacity);
            }
        } else {
            icon = null;
        }
        if (key != null && icon != null) {
            resourceIconsCache.put(key, icon);
        }
        return icon;
    }

    public static WebTimer trackFile(File file, SystemFileListener listener) {
        return FileUtils.trackFile(file, listener, 5000L);
    }

    public static WebTimer trackFile(final File file, final SystemFileListener listener, long delay) {
        final WebTimer tracker = new WebTimer("File tracker - " + file.getName(), delay, 0L);
        tracker.addActionListener(new ActionListener(){
            private Long lastModified = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (file.exists()) {
                    long lm = file.lastModified();
                    if (this.lastModified != lm) {
                        listener.modified(file);
                        this.lastModified = lm;
                    }
                } else {
                    listener.unbound(file);
                    tracker.stop();
                }
            }
        });
        tracker.setUseDaemonThread(true);
        return tracker;
    }
}

