/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.sort.Edge;
import com.alee.utils.sort.GraphDataProvider;
import com.alee.utils.sort.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SortUtils {
    public static <T> List<T> doTopologicalSort(GraphDataProvider<T> graphDataProvider) {
        ArrayList<Node<T>> nodes = new ArrayList<Node<T>>();
        HashMap nodesCache = new HashMap();
        for (T root : graphDataProvider.getRoots()) {
            SortUtils.buildNodeStructure(root, nodes, nodesCache, graphDataProvider);
        }
        List<Node<T>> sortedNodes = SortUtils.doTopologicalSort(nodes);
        ArrayList<T> sortedData = new ArrayList<T>(sortedNodes.size());
        for (Node<T> node : sortedNodes) {
            sortedData.add(node.getData());
        }
        return sortedData;
    }

    private static <T> Node<T> buildNodeStructure(T data, List<Node<T>> nodes, Map<T, Node<T>> nodesCache, GraphDataProvider<T> graphDataProvider) {
        Node<T> node;
        if (nodesCache.containsKey(data)) {
            node = nodesCache.get(data);
        } else {
            node = new Node<T>(data);
            nodes.add(node);
            nodesCache.put(data, node);
            for (T child : graphDataProvider.getChildren(data)) {
                node.addEdge(SortUtils.buildNodeStructure(child, nodes, nodesCache, graphDataProvider));
            }
        }
        return node;
    }

    public static <T> List<Node<T>> doTopologicalSort(List<Node<T>> nodes) {
        ArrayList<Node<T>> L = new ArrayList<Node<T>>();
        HashSet<Node> S = new HashSet<Node>();
        for (Node<T> n : nodes) {
            if (n.inEdges.size() != 0) continue;
            S.add(n);
        }
        while (!S.isEmpty()) {
            Node n = (Node)S.iterator().next();
            S.remove(n);
            L.add(n);
            Iterator<Edge> it = n.outEdges.iterator();
            while (it.hasNext()) {
                Edge e = it.next();
                Node m = e.to;
                it.remove();
                m.inEdges.remove(e);
                if (!m.inEdges.isEmpty()) continue;
                S.add(m);
            }
        }
        boolean cycle = false;
        for (Node<T> n : nodes) {
            if (n.inEdges.isEmpty()) continue;
            cycle = true;
            break;
        }
        if (!cycle) {
            return L;
        }
        throw new RuntimeException("Cycle present, topological sort not possible");
    }
}

