/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.managers.log.Log;
import com.alee.managers.plugin.data.PluginDependency;
import com.alee.managers.plugin.data.PluginInformation;
import com.alee.managers.plugin.data.PluginLibrary;
import com.alee.managers.plugin.data.PluginVersion;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.collection.ValuesTable;
import com.alee.utils.general.Pair;
import com.alee.utils.xml.AliasProvider;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.DimensionConverter;
import com.alee.utils.xml.InsetsConverter;
import com.alee.utils.xml.PasswordConverter;
import com.alee.utils.xml.Point2DConverter;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceList;
import com.alee.utils.xml.ResourceLocation;
import com.alee.utils.xml.ResourceMap;
import com.alee.utils.xml.StrokeConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public final class XmlUtils {
    public static boolean aliasJdkClasses = true;
    public static final Point2DConverter point2dConverter = new Point2DConverter();
    public static final ColorConverter colorConverter = new ColorConverter();
    public static final DimensionConverter dimensionConverter = new DimensionConverter();
    public static final InsetsConverter insetsConverter = new InsetsConverter();
    public static final StrokeConverter strokeConverter = new StrokeConverter();
    public static final PasswordConverter passwordConverter = new PasswordConverter();
    private static XStream xStream = null;

    public static XStream getXStream() {
        if (xStream == null) {
            XmlUtils.initializeXStream();
        }
        return xStream;
    }

    private static void initializeXStream() {
        try {
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            if (aliasJdkClasses) {
                xStream.alias("Point", Point.class);
                xStream.useAttributeFor(Point.class, "x");
                xStream.useAttributeFor(Point.class, "y");
                xStream.alias("Point2D", Point2D.class);
                xStream.registerConverter((SingleValueConverter)point2dConverter);
                xStream.alias("Dimension", Dimension.class);
                xStream.registerConverter((SingleValueConverter)dimensionConverter);
                xStream.alias("Rectangle", Rectangle.class);
                xStream.useAttributeFor(Rectangle.class, "x");
                xStream.useAttributeFor(Rectangle.class, "y");
                xStream.useAttributeFor(Rectangle.class, "width");
                xStream.useAttributeFor(Rectangle.class, "height");
                xStream.alias("Font", Font.class);
                xStream.alias("Color", Color.class);
                xStream.registerConverter((SingleValueConverter)colorConverter);
                xStream.alias("Insets", Insets.class);
                xStream.registerConverter((SingleValueConverter)insetsConverter);
                xStream.alias("Stroke", Stroke.class);
                xStream.registerConverter((SingleValueConverter)strokeConverter);
            }
            xStream.processAnnotations(ResourceLocation.class);
            xStream.processAnnotations(ResourceFile.class);
            xStream.processAnnotations(ResourceList.class);
            xStream.processAnnotations(ResourceMap.class);
            xStream.processAnnotations(ValuesTable.class);
            xStream.processAnnotations(Pair.class);
            xStream.processAnnotations(PluginInformation.class);
            xStream.processAnnotations(PluginVersion.class);
            xStream.processAnnotations(PluginDependency.class);
            xStream.processAnnotations(PluginLibrary.class);
        }
        catch (Throwable e) {
            Log.get().error("Unable to initialize XStream instance", e);
        }
    }

    public static void processAnnotations(Class type) {
        XmlUtils.getXStream().processAnnotations(type);
    }

    public static void processAnnotations(Class[] types) {
        XmlUtils.getXStream().processAnnotations(types);
    }

    public static void alias(String name, Class type) {
        XmlUtils.getXStream().alias(name, type);
    }

    public static void useAttributeFor(Class type, String field) {
        XmlUtils.getXStream().useAttributeFor(type, field);
    }

    public static void addImplicitArray(Class type, String field) {
        XmlUtils.getXStream().addImplicitArray(type, field);
    }

    public static void addImplicitArray(Class type, String field, String itemName) {
        XmlUtils.getXStream().addImplicitArray(type, field, itemName);
    }

    public static void registerConverter(Converter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static void registerConverter(SingleValueConverter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static <T extends AliasProvider> void alias(Class<T> aliasProvider) {
        ReflectUtils.callStaticMethodSafely(aliasProvider, "provideAliases", XmlUtils.getXStream());
    }

    public static void toXML(Object obj, String file) {
        XmlUtils.toXML(obj, new File(file));
    }

    public static void toXML(Object obj, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            XmlUtils.toXML(obj, osw);
            osw.close();
            fos.close();
        }
        catch (IOException e) {
            Log.get().error(TextUtils.format("Unable to serialize object %s into XML and write it into file: %s", obj, file), (Throwable)e);
        }
    }

    public static String toXML(Object obj) {
        return XmlUtils.getXStream().toXML(obj);
    }

    public static void toXML(Object obj, Writer out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(Object obj, OutputStream out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(Object obj, HierarchicalStreamWriter writer) {
        XmlUtils.getXStream().marshal(obj, writer);
    }

    public static <T> T fromXML(Reader reader) {
        return (T)XmlUtils.getXStream().fromXML(reader);
    }

    public static <T> T fromXML(InputStream input) {
        return (T)XmlUtils.getXStream().fromXML(input);
    }

    public static <T> T fromXML(URL url) {
        return (T)XmlUtils.getXStream().fromXML(url);
    }

    public static <T> T fromXML(File file) {
        return (T)XmlUtils.getXStream().fromXML(file);
    }

    public static <T> T fromXML(String xml) {
        return (T)XmlUtils.getXStream().fromXML(xml);
    }

    public static <T> T fromXML(Object source) {
        if (source instanceof URL) {
            return XmlUtils.fromXML((URL)source);
        }
        if (source instanceof String) {
            return XmlUtils.fromXML(new File((String)source));
        }
        if (source instanceof File) {
            return XmlUtils.fromXML((File)source);
        }
        if (source instanceof Reader) {
            return XmlUtils.fromXML((Reader)source);
        }
        if (source instanceof InputStream) {
            return XmlUtils.fromXML((InputStream)source);
        }
        return null;
    }

    public static <T> T fromXML(ResourceFile resource) {
        return XmlUtils.fromXML(resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromXML(ResourceFile resource, boolean safely) {
        try {
            switch (resource.getLocation()) {
                case url: {
                    return XmlUtils.fromXML(new URL(resource.getSource()));
                }
                case filePath: {
                    return XmlUtils.fromXML(new File(resource.getSource()));
                }
                case nearClass: {
                    InputStream is = null;
                    try {
                        is = Class.forName(resource.getClassName()).getResourceAsStream(resource.getSource());
                        if (is == null) {
                            String src = resource.getSource();
                            String cn = resource.getClassName();
                            throw new RuntimeException("Unable to read XML file \"" + src + "\" near class \"" + cn + "\"");
                        }
                        T t = XmlUtils.fromXML(is);
                        return t;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            return null;
        }
        catch (Throwable e) {
            if (!safely) throw new RuntimeException("Unable to deserialize object from XML", e);
            Log.get().error("Unable to deserialize object from XML", e);
            return null;
        }
    }

    public static String loadString(Object source) {
        return XmlUtils.loadString(XmlUtils.loadResourceFile(source));
    }

    public static String loadString(ResourceFile resource) {
        if (resource.getLocation().equals(ResourceLocation.url)) {
            try {
                return FileUtils.readToString(new URL(resource.getSource()));
            }
            catch (IOException e) {
                Log.get().error("Unable to read string from URL: " + resource.getSource(), (Throwable)e);
                return null;
            }
        }
        if (resource.getLocation().equals(ResourceLocation.filePath)) {
            return FileUtils.readToString(new File(resource.getSource()));
        }
        if (resource.getLocation().equals(ResourceLocation.nearClass)) {
            try {
                return FileUtils.readToString(Class.forName(resource.getClassName()), resource.getSource());
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to read string from file: %s near class: %s";
                Log.get().error(TextUtils.format("Unable to read string from file: %s near class: %s", resource.getSource(), resource.getClassName()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static ImageIcon loadImageIcon(Object source) {
        return XmlUtils.loadImageIcon(XmlUtils.loadResourceFile(source));
    }

    public static ImageIcon loadImageIcon(ResourceFile resource) {
        if (resource.getLocation().equals(ResourceLocation.url)) {
            try {
                return new ImageIcon(new URL(resource.getSource()));
            }
            catch (MalformedURLException e) {
                Log.get().error("Unable to load image from URL: " + resource.getSource(), (Throwable)e);
                return null;
            }
        }
        if (resource.getLocation().equals(ResourceLocation.filePath)) {
            try {
                return new ImageIcon(new File(resource.getSource()).getCanonicalPath());
            }
            catch (IOException e) {
                Log.get().error("Unable to load image from file: " + resource.getSource(), (Throwable)e);
                return null;
            }
        }
        if (resource.getLocation().equals(ResourceLocation.nearClass)) {
            try {
                return new ImageIcon(Class.forName(resource.getClassName()).getResource(resource.getSource()));
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to load image from file: %s near class: %s";
                Log.get().error(TextUtils.format("Unable to load image from file: %s near class: %s", resource.getSource(), resource.getClassName()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static List<ImageIcon> loadImagesList(Object source) {
        return XmlUtils.loadImagesList(XmlUtils.loadResourceList(source));
    }

    public static List<ImageIcon> loadImagesList(ResourceList resourceList) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        for (ResourceFile resource : resourceList.getResources()) {
            ImageIcon imageIcon = XmlUtils.loadImageIcon(resource);
            if (imageIcon == null) continue;
            icons.add(imageIcon);
        }
        return icons;
    }

    public static ResourceMap loadResourceMap(Object source) {
        return (ResourceMap)XmlUtils.fromXML(source);
    }

    public static ResourceList loadResourceList(Object source) {
        return (ResourceList)XmlUtils.fromXML(source);
    }

    public static ResourceFile loadResourceFile(Object source) {
        return (ResourceFile)XmlUtils.fromXML(source);
    }
}

