/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.TextUtils;
import com.alee.utils.xml.StrokeConverterSupport;
import java.awt.BasicStroke;
import java.util.List;

public class BasicStrokeConverterSupport
implements StrokeConverterSupport<BasicStroke> {
    public static final String cap_butt = "butt";
    public static final String cap_round = "round";
    public static final String cap_square = "square";
    public static final String join_miter = "miter";
    public static final String join_round = "round";
    public static final String join_bevel = "bevel";

    @Override
    public String getId() {
        return "basic";
    }

    @Override
    public Class<BasicStroke> getType() {
        return BasicStroke.class;
    }

    @Override
    public BasicStroke fromString(String stroke) {
        List<String> settings = TextUtils.stringToList(stroke, ";");
        Float width = Float.valueOf(settings.size() > 1 ? Float.valueOf(settings.get(1)).floatValue() : 1.0f);
        int cap = settings.size() > 2 ? this.unmarshalCap(settings.get(2)) : 2;
        int join = settings.size() > 3 ? this.unmarshalJoin(settings.get(3)) : 0;
        Float miterlimit = Float.valueOf(settings.size() > 4 ? Float.valueOf(settings.get(4)).floatValue() : 10.0f);
        float[] dash = settings.size() > 5 ? this.unmarshalDash(settings.get(5)) : null;
        Float phase = Float.valueOf(settings.size() > 6 ? Float.valueOf(settings.get(6)).floatValue() : 0.0f);
        return new BasicStroke(width.floatValue(), cap, join, miterlimit.floatValue(), dash, phase.floatValue());
    }

    private int unmarshalCap(String value) {
        if (value.equals(cap_butt)) {
            return 0;
        }
        if (value.equals("round")) {
            return 1;
        }
        if (value.equals(cap_square)) {
            return 2;
        }
        throw new IllegalArgumentException("Unknown stroke cap type specified: " + value);
    }

    protected int unmarshalJoin(String value) {
        if (value.equals(join_miter)) {
            return 0;
        }
        if (value.equals("round")) {
            return 1;
        }
        if (value.equals(join_bevel)) {
            return 2;
        }
        throw new IllegalArgumentException("Unknown stroke join type specified: " + value);
    }

    protected float[] unmarshalDash(String value) {
        List<Float> values = TextUtils.stringToFloatList(value, ",");
        float[] dash = new float[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            dash[i] = values.get(i).floatValue();
        }
        return dash;
    }

    @Override
    public String toString(BasicStroke stroke) {
        String s = ";";
        String id = this.getId();
        String width = Float.toString(stroke.getLineWidth());
        String cap = this.marshalCap(stroke);
        String join = this.marshalJoin(stroke);
        String miterlimit = Float.toString(stroke.getMiterLimit());
        String dash = this.marshalDash(stroke);
        String phase = Float.toString(stroke.getDashPhase());
        return id + ";" + width + ";" + cap + ";" + join + ";" + miterlimit + ";" + dash + ";" + phase;
    }

    protected String marshalCap(BasicStroke stroke) {
        switch (stroke.getEndCap()) {
            case 0: {
                return cap_butt;
            }
            case 1: {
                return "round";
            }
            case 2: {
                return cap_square;
            }
        }
        throw new IllegalArgumentException("Unknown stroke cap type specified: " + stroke.getEndCap());
    }

    protected String marshalJoin(BasicStroke stroke) {
        switch (stroke.getLineJoin()) {
            case 0: {
                return join_miter;
            }
            case 1: {
                return "round";
            }
            case 2: {
                return join_bevel;
            }
        }
        throw new IllegalArgumentException("Unknown stroke line join type specified: " + stroke.getLineJoin());
    }

    protected String marshalDash(BasicStroke stroke) {
        float[] a = stroke.getDashArray();
        int iMax = a.length - 1;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.toString();
            }
            b.append(",");
            ++i;
        }
    }
}

