/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.submin;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.border.AbstractBorder;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import javax.swing.JComponent;

@XStreamAlias(value="SubminFocusBorder")
public class SubminFocusBorder<E extends JComponent, D extends IDecoration<E, D>, I extends SubminFocusBorder<E, D, I>>
extends AbstractBorder<E, D, I> {
    @XStreamAsAttribute
    protected Color focusColor;
    private static final Color defaultFocusColor = new Color(48, 77, 130);

    public Color getFocusColor() {
        return this.focusColor != null ? this.focusColor : defaultFocusColor;
    }

    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        float opacity = this.getOpacity();
        if (opacity > 0.0f && this.getWidth() > 0.0f) {
            Stroke stroke = this.getStroke();
            Color color = this.getColor();
            Color focusColor = this.getFocusColor();
            boolean hasColor = focusColor != null || color != null;
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)stroke, (stroke != null ? 1 : 0) != 0);
            Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)focusColor, (boolean)hasColor);
            BasicStroke s1 = new BasicStroke(2.0f);
            Area a1 = new Area(s1.createStrokedShape(shape));
            Area a2 = new Area(shape);
            a1.intersect(a2);
            g2d.draw(a1);
            g2d.setColor(color);
            g2d.draw(shape);
            GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op, (boolean)hasColor);
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os, (stroke != null ? 1 : 0) != 0);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }
}

