/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.Application;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class AbstractApplication
implements Application {
    private final ResourceBundle resBundle;
    private final Map mapComponents = new HashMap();
    private final Class mainClass;
    private Preferences userPrefs = null;
    private Preferences systemPrefs = null;
    private Clipboard clipboard = null;
    private static Application app = null;
    private String name;

    protected AbstractApplication(Class clazz, String string) {
        if (app != null) {
            throw new RuntimeException("AbstractApplication cannot be instantiated more than once");
        }
        app = this;
        this.setName(string);
        this.resBundle = ResourceBundle.getBundle(string + "Strings", Locale.getDefault());
        this.mainClass = clazz;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = System.getProperty("com.apple.mrj.application.apple.menu.about.name");
        }
        return this.name;
    }

    @Override
    public final Preferences getSystemPrefs() {
        if (this.systemPrefs == null) {
            this.systemPrefs = Preferences.systemNodeForPackage(this.mainClass);
        }
        return this.systemPrefs;
    }

    @Override
    public final Preferences getUserPrefs() {
        if (this.userPrefs == null) {
            this.userPrefs = Preferences.userNodeForPackage(this.mainClass);
        }
        return this.userPrefs;
    }

    @Override
    public final Clipboard getClipboard() {
        if (this.clipboard == null) {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.clipboard = new Clipboard(this.getName());
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getComponent(Object object) {
        Map map = this.mapComponents;
        synchronized (map) {
            return this.mapComponents.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addComponent(Object object, Object object2) {
        Map map = this.mapComponents;
        synchronized (map) {
            this.mapComponents.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeComponent(Object object) {
        Map map = this.mapComponents;
        synchronized (map) {
            this.mapComponents.remove(object);
        }
    }

    @Override
    public final String getResourceString(String string) {
        try {
            return this.resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[Missing Resource: " + string + "]";
        }
    }

    @Override
    public final String getResourceString(String string, String string2) {
        try {
            return this.resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    @Override
    public synchronized void quit() {
        try {
            if (this.systemPrefs != null) {
                this.systemPrefs.flush();
            }
            if (this.userPrefs != null) {
                this.userPrefs.flush();
            }
            System.exit(0);
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println("error while flushing prefs : " + backingStoreException.getLocalizedMessage());
            System.exit(1);
        }
    }

    public static Application getApplication() {
        return app;
    }
}

