/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.BasicEvent;
import de.sciss.app.Document;
import de.sciss.app.DocumentEvent;
import de.sciss.app.DocumentHandler;
import de.sciss.app.DocumentListener;
import de.sciss.app.EventManager;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDocumentHandler
implements DocumentHandler,
EventManager.Processor {
    private final boolean isMDA;
    private final List collDocs = new ArrayList();
    private final EventManager elm = new EventManager(this);
    private Document activeDoc = null;
    protected final Object sync = new Object();

    protected AbstractDocumentHandler(boolean bl) {
        this.isMDA = bl;
    }

    @Override
    public boolean isMultiDocumentApplication() {
        return this.isMDA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDocumentCount() {
        Object object = this.sync;
        synchronized (object) {
            return this.collDocs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocument(int n) {
        Object object = this.sync;
        synchronized (object) {
            if (n < this.collDocs.size()) {
                return (Document)this.collDocs.get(n);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(Object object, Document document) {
        Object object2 = this.sync;
        synchronized (object2) {
            if (!this.isMultiDocumentApplication() && !this.collDocs.isEmpty()) {
                throw new UnsupportedOperationException("Cannot add more than one doc to a SDA");
            }
            if (this.collDocs.contains(document)) {
                throw new IllegalArgumentException("Duplicate document registration");
            }
            this.collDocs.add(document);
            if (object != null) {
                this.elm.dispatchEvent(new DocumentEvent(object, 0, System.currentTimeMillis(), document));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocument(Object object, Document document) {
        Object object2 = this.sync;
        synchronized (object2) {
            if (document == this.activeDoc) {
                this.setActiveDocument(object, null);
            }
            if (!this.collDocs.remove(document)) {
                throw new IllegalArgumentException("Tried to remove unknown document");
            }
            if (object != null) {
                this.elm.dispatchEvent(new DocumentEvent(object, 1, System.currentTimeMillis(), document));
            }
            document.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveDocument(Object object, Document document) {
        Object object2 = this.sync;
        synchronized (object2) {
            if (document != null && !this.collDocs.contains(document)) {
                throw new IllegalArgumentException("Tried to make unknown document active");
            }
            if (document != this.activeDoc) {
                this.activeDoc = document;
                if (object != null) {
                    this.elm.dispatchEvent(new DocumentEvent(object, 2, System.currentTimeMillis(), document));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getActiveDocument() {
        Object object = this.sync;
        synchronized (object) {
            return this.activeDoc;
        }
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.elm.addListener(documentListener);
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.elm.removeListener(documentListener);
    }

    @Override
    public void processEvent(BasicEvent basicEvent) {
        block5: for (int i = 0; i < this.elm.countListeners(); ++i) {
            DocumentListener documentListener = (DocumentListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 2: {
                    documentListener.documentFocussed((DocumentEvent)basicEvent);
                    continue block5;
                }
                case 0: {
                    documentListener.documentAdded((DocumentEvent)basicEvent);
                    continue block5;
                }
                case 1: {
                    documentListener.documentRemoved((DocumentEvent)basicEvent);
                    continue block5;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block5;
                }
            }
        }
    }
}

