/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import de.sciss.app.GraphicsHandler;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class BasicGraphicsHandler
implements GraphicsHandler {
    private final String systemTypeFace;
    private final String userTypeFace;
    private final String labelTypeFace;
    private final int mediumSize;
    private final int smallSize;
    private final int miniSize;
    private final Map mapFonts = new HashMap();

    public BasicGraphicsHandler() {
        boolean bl;
        String string = System.getProperty("os.name");
        boolean bl2 = string.indexOf("Mac OS") >= 0;
        boolean bl3 = bl = string.indexOf("Windows") >= 0;
        if (bl2) {
            this.labelTypeFace = "LucidaGrande";
            this.userTypeFace = "LucidaGrande";
            this.systemTypeFace = "LucidaGrande";
        } else if (bl) {
            this.labelTypeFace = "Tahoma";
            this.userTypeFace = "Tahoma";
            this.systemTypeFace = "Tahoma";
        } else {
            this.labelTypeFace = "SansSerif";
            this.userTypeFace = "SansSerif";
            this.systemTypeFace = "SansSerif";
        }
        this.mediumSize = 13;
        this.smallSize = 11;
        this.miniSize = 9;
    }

    @Override
    public Font getFont(int n) {
        int n2;
        String string;
        int n3;
        Integer n4 = new Integer(n);
        Font font = (Font)this.mapFonts.get(n4);
        if (font != null) {
            return font;
        }
        switch (n & 0xF00) {
            case 0: {
                n3 = this.mediumSize;
                break;
            }
            case 256: {
                n3 = this.smallSize;
                break;
            }
            case 512: {
                n3 = this.miniSize;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + n);
            }
        }
        switch (n & 0xFF) {
            case 0: {
                string = this.systemTypeFace;
                n2 = 0;
                break;
            }
            case 1: {
                string = this.systemTypeFace;
                n2 = 1;
                break;
            }
            case 2: {
                string = this.userTypeFace;
                n2 = 0;
                break;
            }
            case 3: {
                string = this.labelTypeFace;
                n2 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + n);
            }
        }
        font = new Font(string, n2, n3);
        this.mapFonts.put(n4, font);
        return font;
    }
}

