/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;

public abstract class AbstractAboutFrame
extends JFrame {
    private final JLabel lbApp;
    private final JTextArea ggVersion;
    private final JEditorPane ggCredits;
    private final JScrollPane scrollCredits;
    private final JTextArea ggCopyright;
    private final String versionString;
    private String buildVersion;
    private HyperlinkListener hyperlinkListener;

    public AbstractAboutFrame(String string, String string2) {
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridy = 0;
        this.lbApp = new JLabel();
        jPanel.add((Component)this.lbApp, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JTextArea jTextArea = new JTextArea("java");
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFont(new Font("SansSerif", 1, 14));
        jPanel.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.ggVersion = new JTextArea("Version x.x");
        this.ggVersion.setEditable(false);
        this.ggVersion.setOpaque(false);
        Font font = new Font("SansSerif", 0, 10);
        this.ggVersion.setFont(font);
        jPanel.add((Component)this.ggVersion, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.ggCredits = new JEditorPane();
        this.ggCredits.setMargin(new Insets(2, 4, 2, 4));
        this.ggCredits.setEditable(false);
        this.scrollCredits = new JScrollPane(this.ggCredits);
        Border border = this.scrollCredits.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this.scrollCredits) : new Insets(0, 0, 0, 0);
        this.scrollCredits.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -insets.left + 1, 0, -insets.right + 1), border));
        this.scrollCredits.setPreferredSize(new Dimension(100, 150));
        jPanel.add((Component)this.scrollCredits, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets.bottom = 32;
        gridBagConstraints.fill = 0;
        this.ggCopyright = new JTextArea(" ");
        this.ggCopyright.setEditable(false);
        this.ggCopyright.setOpaque(false);
        this.ggCopyright.setFont(font);
        jPanel.add((Component)this.ggCopyright, gridBagConstraints);
        this.lbApp.setVisible(false);
        this.scrollCredits.setVisible(false);
        if (string != null) {
            jTextArea.setText(string);
        }
        this.versionString = string2;
        if (string2 != null) {
            this.ggVersion.setText(string2);
        }
        this.packAndCenter();
    }

    public void setApplicationIcon(Icon icon) {
        this.lbApp.setIcon(icon);
        this.lbApp.setVisible(icon != null);
        this.packAndCenter();
    }

    public void setBuildVersion(String string) {
        this.buildVersion = string;
        this.applyVersion();
    }

    private void applyVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.versionString != null) {
            stringBuilder.append(this.versionString);
        } else {
            stringBuilder.append("Version x.x");
        }
        if (this.buildVersion != null) {
            stringBuilder.append(" (v");
            stringBuilder.append(this.buildVersion);
            stringBuilder.append(")");
        }
        this.ggVersion.setText(stringBuilder.toString());
    }

    public void setCredits(String string, String string2) {
        if (string != null) {
            this.ggCredits.setContentType(string2);
        }
        this.ggCredits.setText(string != null ? string : "");
        this.ggCredits.setCaretPosition(0);
        this.scrollCredits.setVisible(string != null);
        this.packAndCenter();
    }

    public void setCreditsPreferredSize(Dimension dimension) {
        this.scrollCredits.setPreferredSize(dimension);
        this.packAndCenter();
    }

    public void setHyperlinkListener(HyperlinkListener hyperlinkListener) {
        if (this.hyperlinkListener != null) {
            this.ggCredits.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = hyperlinkListener;
        if (hyperlinkListener != null) {
            this.ggCredits.addHyperlinkListener(hyperlinkListener);
        }
    }

    public void setCopyright(String string) {
        this.ggCopyright.setText(string != null ? string : " ");
        this.packAndCenter();
    }

    private void packAndCenter() {
        this.pack();
        this.setSize(285, this.getSize().height);
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 4);
    }
}

