/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AncestorAdapter;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.DoClickAction;
import de.sciss.gui.GradientPanel;
import de.sciss.gui.MenuGroup;
import de.sciss.gui.MenuItem;
import de.sciss.gui.MenuNode;
import java.applet.Applet;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;

public class GUIUtil {
    private static final double VERSION = 0.4;
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("GUIUtilStrings");
    private static final Preferences prefs = Preferences.userNodeForPackage(GUIUtil.class);
    private static Icon icnNoWrite = null;

    private GUIUtil() {
    }

    public static final Preferences getUserPrefs() {
        return prefs;
    }

    public static final double getVersion() {
        return 0.4;
    }

    public static final String getResourceString(String string) {
        try {
            return resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[Missing Resource: " + string + "]";
        }
    }

    public static void displayError(Component component, Exception exception, String string) {
        StringBuffer stringBuffer = new StringBuffer(GUIUtil.getResourceString("errException"));
        Object[] objectArray = new String[]{GUIUtil.getResourceString("buttonOk"), GUIUtil.getResourceString("optionDlgStack")};
        if (exception != null) {
            String string2 = exception.getClass().getName() + " - " + exception.getLocalizedMessage();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = 0;
            stringBuffer.append(":\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (n > 0 && n + string3.length() > 40) {
                    stringBuffer.append("\n");
                    n = 0;
                }
                stringBuffer.append(string3);
                stringBuffer.append(' ');
                n += string3.length() + 1;
            }
        }
        if (JOptionPane.showOptionDialog(component, stringBuffer.toString(), string, 0, 0, null, objectArray, objectArray[0]) == 1) {
            exception.printStackTrace();
        }
    }

    public static void createKeyAction(AbstractButton abstractButton, KeyStroke keyStroke) {
        abstractButton.getInputMap(2).put(keyStroke, "shortcut");
        abstractButton.getActionMap().put("shortcut", new DoClickAction(abstractButton));
    }

    public static void setDeepFont(Container container, Font font) {
        Component[] componentArray = container.getComponents();
        container.setFont(font);
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                GUIUtil.setDeepFont((Container)componentArray[i], font);
                continue;
            }
            componentArray[i].setFont(font);
        }
    }

    public static void setPreferences(Container container, Preferences preferences) {
        Component[] componentArray = container.getComponents();
        if (container instanceof PreferenceEntrySync) {
            ((PreferenceEntrySync)((Object)container)).setPreferenceNode(preferences);
        }
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                GUIUtil.setPreferences((Container)componentArray[i], preferences);
                continue;
            }
            if (!(container instanceof PreferenceEntrySync)) continue;
            ((PreferenceEntrySync)((Object)container)).setPreferenceNode(preferences);
        }
    }

    public static void printSizes(Component component) {
        System.err.println("minimumSize   = " + component.getMinimumSize());
        System.err.println("preferredSize = " + component.getPreferredSize());
        System.err.println("maximumSize   = " + component.getMaximumSize());
    }

    public static void makeSpringGrid(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        SpringLayout.Constraints constraints;
        int n7;
        SpringLayout springLayout;
        SpringLayout.Constraints constraints2 = null;
        SpringLayout.Constraints constraints3 = null;
        int n8 = n * n2;
        if (n8 == 0) {
            return;
        }
        try {
            springLayout = (SpringLayout)container.getLayout();
        }
        catch (ClassCastException classCastException) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        Spring spring = Spring.constant(n5);
        Spring spring2 = Spring.constant(n6);
        Spring spring3 = Spring.constant(n3);
        Spring spring4 = Spring.constant(n4);
        Spring spring5 = springLayout.getConstraints(container.getComponent(0)).getWidth();
        Spring spring6 = springLayout.getConstraints(container.getComponent(0)).getWidth();
        for (n7 = 1; n7 < n8; ++n7) {
            constraints = springLayout.getConstraints(container.getComponent(n7));
            spring5 = Spring.max(spring5, constraints.getWidth());
            spring6 = Spring.max(spring6, constraints.getHeight());
        }
        for (n7 = 0; n7 < n8; ++n7) {
            constraints = springLayout.getConstraints(container.getComponent(n7));
            constraints.setWidth(spring5);
            constraints.setHeight(spring6);
        }
        for (n7 = 0; n7 < n8; ++n7) {
            constraints = springLayout.getConstraints(container.getComponent(n7));
            if (n7 % n2 == 0) {
                constraints3 = constraints2;
                constraints.setX(spring3);
            } else {
                constraints.setX(Spring.sum(constraints2.getConstraint("East"), spring));
            }
            if (n7 / n2 == 0) {
                constraints.setY(spring4);
            } else {
                constraints.setY(Spring.sum(constraints3.getConstraint("South"), spring2));
            }
            constraints2 = constraints;
        }
        constraints = springLayout.getConstraints(container);
        constraints.setConstraint("South", Spring.sum(Spring.constant(n6), constraints2.getConstraint("South")));
        constraints.setConstraint("East", Spring.sum(Spring.constant(n5), constraints2.getConstraint("East")));
    }

    public static void makeCompactSpringGrid(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        SpringLayout.Constraints constraints;
        Component component;
        int n7;
        boolean bl;
        int n8;
        SpringLayout springLayout;
        try {
            springLayout = (SpringLayout)container.getLayout();
        }
        catch (ClassCastException classCastException) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring spring = Spring.constant(n3);
        for (n8 = 0; n8 < n2; ++n8) {
            Spring spring2 = Spring.constant(0);
            bl = false;
            for (n7 = 0; n7 < n; ++n7) {
                component = container.getComponent(n7 * n2 + n8);
                if (!component.isVisible()) continue;
                spring2 = Spring.max(spring2, springLayout.getConstraints(component).getWidth());
                bl = true;
            }
            for (n7 = 0; n7 < n; ++n7) {
                component = container.getComponent(n7 * n2 + n8);
                constraints = springLayout.getConstraints(component);
                constraints.setX(spring);
                if (!component.isVisible()) continue;
                constraints.setWidth(spring2);
            }
            if (!bl) continue;
            spring = Spring.sum(spring, Spring.sum(spring2, Spring.constant(n5)));
        }
        Spring spring3 = Spring.constant(n4);
        for (n8 = 0; n8 < n; ++n8) {
            Spring spring4 = Spring.constant(0);
            bl = false;
            for (n7 = 0; n7 < n2; ++n7) {
                component = container.getComponent(n8 * n2 + n7);
                if (!component.isVisible()) continue;
                spring4 = Spring.max(spring4, springLayout.getConstraints(component).getHeight());
                bl = true;
            }
            for (n7 = 0; n7 < n2; ++n7) {
                component = container.getComponent(n8 * n2 + n7);
                constraints = springLayout.getConstraints(component);
                constraints.setY(spring3);
                if (!component.isVisible()) continue;
                constraints.setHeight(spring4);
            }
            if (!bl) continue;
            spring3 = Spring.sum(spring3, Spring.sum(spring4, Spring.constant(n6)));
        }
        constraints = springLayout.getConstraints(container);
        constraints.setConstraint("South", spring3);
        constraints.setConstraint("East", spring);
    }

    public static Icon getNoWriteIcon() {
        if (icnNoWrite == null) {
            icnNoWrite = new ImageIcon(GUIUtil.class.getResource("nowrite.png"));
        }
        return icnNoWrite;
    }

    public static GradientPanel createGradientPanel() {
        GradientPanel gradientPanel = new GradientPanel();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl = lookAndFeel == null ? false : lookAndFeel.getID().equals("Aqua");
        GradientPaint gradientPaint = bl ? new GradientPaint(0.0f, 0.0f, new Color(243, 243, 243), 0.0f, 69.0f, new Color(196, 196, 196)) : null;
        gradientPanel.setLayout(new BoxLayout(gradientPanel, 0));
        gradientPanel.setGradient(gradientPaint);
        gradientPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return gradientPanel;
    }

    public static void constrainWidth(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getMinimumSize();
        jComponent.setMinimumSize(new Dimension(n, dimension.height));
        dimension = jComponent.getMaximumSize();
        jComponent.setMaximumSize(new Dimension(n, dimension.height));
        dimension = jComponent.getPreferredSize();
        jComponent.setPreferredSize(new Dimension(n, dimension.height));
    }

    public static void constrainHeight(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getMinimumSize();
        jComponent.setMinimumSize(new Dimension(dimension.width, n));
        dimension = jComponent.getMaximumSize();
        jComponent.setMaximumSize(new Dimension(dimension.width, n));
        dimension = jComponent.getPreferredSize();
        jComponent.setPreferredSize(new Dimension(dimension.width, n));
    }

    public static void constrainSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    public static void wrapWindowBounds(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null) {
            rectangle2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        if (rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.x = rectangle2.x;
            if (rectangle.width > rectangle2.width) {
                rectangle.width = rectangle2.width;
            }
        }
        if (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y;
            if (rectangle.height > rectangle2.height) {
                rectangle.height = rectangle2.height;
            }
        }
    }

    public static void setInitialDialogFocus(final JComponent jComponent) {
        jComponent.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                jComponent.requestFocusInWindow();
                jComponent.removeAncestorListener(this);
            }
        });
    }

    public static boolean setAlwaysOnTop(Component component, boolean bl) {
        try {
            Method method = component.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
            method.invoke((Object)component, new Boolean(bl));
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAlwaysOnTop(Component component) {
        try {
            Method method = component.getClass().getMethod("isAlwaysOnTop", null);
            Object object = method.invoke((Object)component, null);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            // empty catch block
        }
        return false;
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null && (component = SwingUtilities.getWindowAncestor(component2)) == null) {
            throw new Error("Source component not connected to component tree hierarchy");
        }
        Point point2 = new Point(point);
        GUIUtil.convertPointToScreen(point2, component);
        if (component2 == null && (component2 = SwingUtilities.getWindowAncestor(component)) == null) {
            throw new Error("Destination component not connected to component tree hierarchy");
        }
        GUIUtil.convertPointFromScreen(point2, component2);
        return point2;
    }

    public static void convertPointToScreen(Point point, Component component) {
        boolean bl;
        do {
            Container container = component.getParent();
            boolean bl2 = bl = component instanceof Applet || component instanceof Window;
            if (container == null || !(container instanceof JViewport)) {
                int n;
                int n2;
                if (component instanceof JComponent) {
                    n2 = ((JComponent)component).getX();
                    n = ((JComponent)component).getY();
                } else if (bl) {
                    try {
                        Point point2 = component.getLocationOnScreen();
                        n2 = point2.x;
                        n = point2.y;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        n2 = component.getX();
                        n = component.getY();
                    }
                } else {
                    n2 = component.getX();
                    n = component.getY();
                }
                point.x += n2;
                point.y += n;
            }
            component = container;
        } while (!bl && component != null);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        boolean bl;
        do {
            Container container = component.getParent();
            boolean bl2 = bl = component instanceof Applet || component instanceof Window;
            if (container == null || !(container instanceof JViewport)) {
                int n;
                int n2;
                if (component instanceof JComponent) {
                    n2 = ((JComponent)component).getX();
                    n = ((JComponent)component).getY();
                } else if (bl) {
                    try {
                        Point point2 = component.getLocationOnScreen();
                        n2 = point2.x;
                        n = point2.y;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        n2 = component.getX();
                        n = component.getY();
                    }
                } else {
                    n2 = component.getX();
                    n = component.getY();
                }
                point.x -= n2;
                point.y -= n;
            }
            component = container;
        } while (!bl && component != null);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = GUIUtil.convertPoint(component, new Point(rectangle.x, rectangle.y), component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static void removeMenuModifierBindings(JComponent jComponent, MenuGroup menuGroup) {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        int n2 = 2 | (n == 2 ? 8 : 0);
        HashSet hashSet = new HashSet();
        GUIUtil.gatherAccelerators(hashSet, menuGroup, n2);
        GUIUtil.removeMenuModifierBindings(jComponent.getInputMap(), n, hashSet);
    }

    private static void gatherAccelerators(Set set, MenuItem menuItem, int n) {
        Object object;
        Action action = menuItem.getAction();
        if (action != null && (object = (KeyStroke)action.getValue("AcceleratorKey")) != null && (((AWTKeyStroke)object).getModifiers() & n) == n) {
            set.add(object);
        }
        if (menuItem instanceof MenuGroup) {
            object = (MenuGroup)menuItem;
            for (int i = 0; i < ((MenuGroup)object).size(); ++i) {
                MenuNode menuNode = ((MenuGroup)object).get(i);
                if (!(menuNode instanceof MenuItem)) continue;
                GUIUtil.gatherAccelerators(set, (MenuItem)menuNode, n);
            }
        }
    }

    private static void removeMenuModifierBindings(InputMap inputMap, int n, Set set) {
        if (inputMap == null) {
            return;
        }
        KeyStroke[] keyStrokeArray = inputMap.keys();
        if (keyStrokeArray != null) {
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                KeyStroke keyStroke = keyStrokeArray[i];
                if (keyStroke.getModifiers() == n || !set.contains(keyStroke)) continue;
                inputMap.remove(keyStroke);
            }
        }
        GUIUtil.removeMenuModifierBindings(inputMap.getParent(), n, set);
    }
}

