/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicPrefChangeManager;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.HelpFrame;
import de.sciss.gui.KeyStrokeTextField;
import de.sciss.gui.NoFocusTraversalPolicy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class HelpGlassPane
extends JComponent
implements PreferenceChangeListener {
    public static final String KEY_KEYSTROKE_HELP = "keystrokehelp";
    private final Color colrBg = new Color(0, 0, 255, 95);
    private final Color colrBg2 = new Color(240, 255, 0, 127);
    private final JFrame f;
    private Component normalGlassPane = null;
    private JComponent focussedHelpComponent = null;
    private FocusTraversalPolicy normalFocus = null;
    private Area focussedArea = new Area();
    private final Action helpAction;
    private KeyStroke helpStroke = null;
    private static final Object HELP_PROPERTY = HelpGlassPane.class;

    public static void attachTo(JFrame jFrame) {
        new HelpGlassPane(jFrame);
    }

    public static void setHelp(JComponent jComponent, String string) {
        jComponent.putClientProperty(HELP_PROPERTY, string);
    }

    private HelpGlassPane(JFrame jFrame) {
        this.f = jFrame;
        JRootPane jRootPane = jFrame.getRootPane();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HelpGlassPane.this.checkMousePressed(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                HelpGlassPane.this.checkMouseMoved(mouseEvent);
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    HelpGlassPane.this.deactivateHelpMode();
                }
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpGlassPane.this.activateHelpMode();
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.addKeyListener(keyAdapter);
        this.setCursor(new Cursor(12));
        jRootPane.getActionMap().put(HELP_PROPERTY, this.helpAction);
        new DynamicAncestorAdapter(new DynamicPrefChangeManager(GUIUtil.getUserPrefs(), new String[]{KEY_KEYSTROKE_HELP}, this)).addTo(jRootPane);
    }

    protected void activateHelpMode() {
        Component component = this.f.getGlassPane();
        if (component == this || component.isVisible()) {
            return;
        }
        this.normalGlassPane = component;
        this.focussedHelpComponent = null;
        this.focussedArea.reset();
        this.f.setGlassPane(this);
        this.setVisible(true);
        this.normalFocus = this.f.getFocusTraversalPolicy();
        this.f.setFocusTraversalPolicy(new NoFocusTraversalPolicy());
        this.requestFocus();
    }

    protected void deactivateHelpMode() {
        if (this.f.getGlassPane() != this) {
            return;
        }
        this.setVisible(false);
        this.f.setGlassPane(this.normalGlassPane);
        this.f.setFocusTraversalPolicy(this.normalFocus);
        this.normalGlassPane = null;
        this.normalFocus = null;
        this.focussedHelpComponent = null;
        this.focussedArea.reset();
        this.f.requestFocus();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Area area = new Area(graphics.getClipBounds());
        area.subtract(this.focussedArea);
        graphics2D.setColor(this.colrBg);
        graphics2D.fill(area);
        graphics2D.setColor(this.colrBg2);
        graphics2D.fill(this.focussedArea);
    }

    protected void checkMousePressed(MouseEvent mouseEvent) {
        this.checkMouseMoved(mouseEvent);
        if (this.focussedHelpComponent != null) {
            HelpFrame.openViewerAndLoadHelpFile((String)this.focussedHelpComponent.getClientProperty(HELP_PROPERTY));
            this.deactivateHelpMode();
        }
    }

    protected void checkMouseMoved(MouseEvent mouseEvent) {
        JComponent jComponent = this.findHelpComponentAt(mouseEvent.getPoint());
        if (jComponent != this.focussedHelpComponent) {
            this.focussedHelpComponent = jComponent;
            if (jComponent == null) {
                this.focussedArea.reset();
            } else {
                Point point = SwingUtilities.convertPoint(jComponent, 0, 0, this);
                Point point2 = SwingUtilities.convertPoint(jComponent, jComponent.getWidth(), jComponent.getHeight(), this);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(point.x - 4, point.y - 4, point2.x - point.x + 8, point2.y - point.y + 8, 8.0, 8.0);
                this.focussedArea = new Area(double_);
            }
            this.repaint();
        }
    }

    private JComponent findHelpComponentAt(Point point) {
        Container container = this.f.getContentPane();
        Point point2 = SwingUtilities.convertPoint(this, point, container);
        for (Component component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y); component != null; component = component.getParent()) {
            JComponent jComponent;
            if (!(component instanceof JComponent) || (jComponent = (JComponent)component).getClientProperty(HELP_PROPERTY) == null) continue;
            return jComponent;
        }
        return null;
    }

    private void updateHelpStroke(KeyStroke keyStroke) {
        InputMap inputMap = this.f.getRootPane().getInputMap(2);
        if (this.helpStroke != null) {
            inputMap.remove(this.helpStroke);
        }
        this.helpStroke = keyStroke;
        if (this.helpStroke != null) {
            inputMap.put(this.helpStroke, HELP_PROPERTY);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        this.updateHelpStroke(KeyStrokeTextField.prefsToStroke(preferenceChangeEvent.getNewValue()));
    }
}

