/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class IndeterminateSpinner
extends JComponent
implements DynamicListening,
ActionListener {
    private static final Color[] colours = new Color[]{new Color(0, 0, 0, 200), new Color(0, 0, 0, 173), new Color(0, 0, 0, 149), new Color(0, 0, 0, 127), new Color(0, 0, 0, 107), new Color(0, 0, 0, 89), new Color(0, 0, 0, 74), new Color(0, 0, 0, 61), new Color(0, 0, 0, 51), new Color(0, 0, 0, 43), new Color(0, 0, 0, 37), new Color(0, 0, 0, 33)};
    private static final double angle = -0.5235987755982988;
    private static final int delay = 50;
    private final int size;
    private final int scale;
    private final RoundRectangle2D r;
    private final Timer timer;
    private int phase = 0;
    private boolean active = false;
    private boolean listening = false;

    public IndeterminateSpinner() {
        this(32);
    }

    public IndeterminateSpinner(int n) {
        this.size = n;
        this.scale = n >> 1;
        this.timer = new Timer(50, this);
        this.r = new RoundRectangle2D.Double(0.39 * (double)this.scale, -0.085 * (double)this.scale, 0.48 * (double)this.scale, 0.17 * (double)this.scale, 0.15 * (double)this.scale, 0.15 * (double)this.scale);
        new DynamicAncestorAdapter(this).addTo(this);
        this.setPreferredSize(new Dimension(n, n));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.active) {
            this.paintIcon(this, graphics, this.getWidth() - this.size >> 1, this.getHeight() - this.size >> 1);
        }
    }

    private void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate((double)(n + this.scale) + 0.5, (double)(n2 + this.scale) + 0.5);
        for (int i = 0; i < 12; ++i) {
            graphics2D.setColor(colours[(i + this.phase) % 12]);
            graphics2D.fill(this.r);
            graphics2D.rotate(-0.5235987755982988);
        }
        graphics2D.setTransform(affineTransform);
        this.phase = (this.phase + 1) % 12;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        if (this.listening) {
            if (this.active) {
                this.timer.restart();
            } else {
                this.timer.stop();
                this.repaint();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void startListening() {
        this.listening = true;
        if (this.active) {
            this.timer.restart();
        }
    }

    @Override
    public void stopListening() {
        this.listening = false;
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }
}

