/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractWindow;
import de.sciss.gui.MenuNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuItem
implements MenuNode {
    private final String id;
    private final Action action;
    private final Map mapWindowActions = new HashMap();
    protected final Map mapRealized = new HashMap();

    public MenuItem(String string, Action action) {
        this.id = string;
        this.action = action;
    }

    public MenuItem(String string, String string2) {
        this(string, new MenuNode.DummyAction(string2));
        this.setEnabled(false);
    }

    public MenuItem(String string, String string2, KeyStroke keyStroke) {
        this(string, new MenuNode.DummyAction(string2, keyStroke));
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.action.setEnabled(bl);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void put(AbstractWindow abstractWindow, Action action) {
        if (this.mapWindowActions.put(abstractWindow, action) != null) {
            throw new IllegalArgumentException("Window specific action has already been added");
        }
    }

    public void remove(AbstractWindow abstractWindow) {
        if (this.mapWindowActions.remove(abstractWindow) == null) {
            throw new IllegalArgumentException("Window specific action not found");
        }
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    public Action getAction(AbstractWindow abstractWindow) {
        Action action = (Action)this.mapWindowActions.get(abstractWindow);
        return action == null ? this.action : action;
    }

    @Override
    public JComponent create(AbstractWindow abstractWindow) {
        JComponent jComponent = this.createComponent(this.getAction(abstractWindow));
        this.mapRealized.put(abstractWindow, new Realized(abstractWindow, jComponent));
        return jComponent;
    }

    protected JComponent createComponent(Action action) {
        return new JMenuItem(action);
    }

    @Override
    public void destroy(AbstractWindow abstractWindow) {
        if (this.mapRealized.remove(abstractWindow) == null) {
            throw new IllegalArgumentException("Element was not found : " + abstractWindow);
        }
        this.mapWindowActions.remove(abstractWindow);
    }

    public Iterator getRealized() {
        return this.mapRealized.values().iterator();
    }

    protected static class Realized {
        public final AbstractWindow w;
        public final JComponent c;

        protected Realized(AbstractWindow abstractWindow, JComponent jComponent) {
            this.w = abstractWindow;
            this.c = jComponent;
        }
    }
}

