/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.NumberEvent;
import de.sciss.gui.NumberField;
import de.sciss.gui.NumberListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PrefNumberField
extends NumberField
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    private NumberListener listener;
    private Number defaultValue = null;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefNumberField() {
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new NumberListener(){

            @Override
            public void numberChanged(NumberEvent numberEvent) {
                if (PrefNumberField.this.writePrefs) {
                    PrefNumberField.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addListener(this.listener);
                } else {
                    this.removeListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    @Override
    public void writePrefs() {
        if (this.prefs != null && this.key != null) {
            Number number = this.getNumber();
            if (this.getSpace().isInteger()) {
                Long l = new Long(this.prefs.getLong(this.key, number.longValue() + 1L));
                if (!number.equals(l)) {
                    this.prefs.putLong(this.key, number.longValue());
                }
            } else {
                Double d = new Double(this.prefs.getDouble(this.key, number.doubleValue() + 1.0));
                if (!number.equals(d)) {
                    this.prefs.putDouble(this.key, number.doubleValue());
                }
            }
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key == null) {
            this.defaultValue = this.getNumber();
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.addListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.removeListener(this.listener);
            }
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        Number number;
        if (string == null) {
            if (this.defaultValue != null) {
                this.setNumber(this.defaultValue);
                if (this.writePrefs) {
                    this.writePrefs();
                }
            }
            return;
        }
        Number number2 = this.getNumber();
        try {
            number = this.getSpace().isInteger() ? (Number)new Long(string) : (Number)new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            number = number2;
        }
        if (!number.equals(number2)) {
            if (this.listening && this.writePrefs) {
                this.removeListener(this.listener);
            }
            this.setNumber(number);
            this.fireNumberChanged();
            if (this.listening && this.writePrefs) {
                this.addListener(this.listener);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }
}

