/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;

public class TreeExpanderButton
extends AbstractButton
implements ActionListener,
MouseListener,
MouseMotionListener {
    public static final int DEFAULT_SIZE = 13;
    private boolean expanded = false;
    private boolean turning = false;
    private static final Color colrNormal = new Color(115, 115, 115, 255);
    private static final Color colrPressed = new Color(57, 57, 57, 255);
    private static final Color colrDisabled = new Color(115, 115, 115, 127);
    private static final GeneralPath shpCollapsed = new GeneralPath();
    private static final GeneralPath shpExpanded;
    private static final GeneralPath shpTurning;
    private final DefaultButtonModel model;
    private final Timer timerTurning;
    private ActionListener al = null;
    private String expandedTT = null;
    private String collapsedTT = null;

    public TreeExpanderButton() {
        Dimension dimension = new Dimension(17, 15);
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.setMargin(new Insets(1, 2, 1, 2));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setFocusable(false);
        this.model = new DefaultButtonModel();
        this.setModel(this.model);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.timerTurning = new Timer(100, this);
        this.timerTurning.setRepeats(false);
    }

    public void setExpandedToolTip(String string) {
        this.expandedTT = string;
        if (this.expanded) {
            this.setToolTipText(string);
        }
    }

    public void setCollapsedToolTip(String string) {
        this.collapsedTT = string;
        if (!this.expanded) {
            this.setToolTipText(string);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (bl != this.expanded) {
            this.turning = false;
            this.expanded = bl;
            this.timerTurning.stop();
            this.model.setArmed(false);
            this.repaint();
            this.setToolTipText(this.expanded ? this.expandedTT : this.collapsedTT);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.isEnabled() ? (this.model.isArmed() ? colrPressed : colrNormal) : colrDisabled;
        GeneralPath generalPath = this.turning ? shpTurning : (this.expanded ? shpExpanded : shpCollapsed);
        graphics2D.translate(1, 2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.translate(-1, -2);
    }

    private void lala() {
        this.model.setPressed(true);
        if (this.model.isArmed()) {
            this.turning = true;
            this.expanded = !this.expanded;
            this.timerTurning.restart();
            this.model.setArmed(false);
            this.repaint();
            this.setToolTipText(this.expanded ? this.expandedTT : this.collapsedTT);
        }
    }

    @Override
    public synchronized void addActionListener(ActionListener actionListener) {
        this.al = AWTEventMulticaster.add(this.al, actionListener);
    }

    @Override
    public synchronized void removeActionListener(ActionListener actionListener) {
        this.al = AWTEventMulticaster.remove(this.al, actionListener);
    }

    private void fireActionPerformed() {
        ActionListener actionListener = this.al;
        if (actionListener != null) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.turning = false;
        this.repaint();
        this.fireActionPerformed();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.model.setArmed(true);
            this.requestFocus();
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.lala();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2;
        if (this.isEnabled() && (bl2 = this.model.isArmed()) != (bl = this.contains(mouseEvent.getPoint()))) {
            this.model.setArmed(bl);
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static {
        shpCollapsed.moveTo(2.0f, 0.6f);
        shpCollapsed.lineTo(11.2f, 5.5f);
        shpCollapsed.lineTo(2.0f, 10.4f);
        shpCollapsed.closePath();
        shpExpanded = new GeneralPath();
        shpExpanded.moveTo(0.6f, 2.0f);
        shpExpanded.lineTo(5.5f, 11.2f);
        shpExpanded.lineTo(10.4f, 2.0f);
        shpExpanded.closePath();
        shpTurning = new GeneralPath();
        shpTurning.moveTo(6.96f, 0.03f);
        shpTurning.lineTo(10.0f, 10.0f);
        shpTurning.lineTo(0.03f, 6.96f);
        shpTurning.closePath();
    }
}

