/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.InterleavedStreamFile;
import de.sciss.io.Marker;
import de.sciss.io.Region;
import de.sciss.io.Span;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AudioFile
implements InterleavedStreamFile {
    private static final int MODE_READONLY = 0;
    private static final int MODE_READWRITE = 1;
    protected final RandomAccessFile raf;
    protected final FileChannel fch;
    private final int mode;
    protected AudioFileDescr afd;
    private AudioFileHeader afh;
    protected ByteBuffer byteBuf;
    private int byteBufCapacity;
    protected int bytesPerFrame;
    protected int frameBufCapacity;
    private BufferHandler bh;
    protected int channels;
    private long framePosition;
    private long updateTime;
    private long updateLen;
    private long updateStep;
    private static final String NAME_LOOP = "loop";
    private static final String NAME_MARK = "mark";
    private static final String NAME_REGION = "region";

    public static AudioFile openAsRead(File file) throws IOException {
        AudioFile audioFile = new AudioFile(file, 0);
        audioFile.afd = new AudioFileDescr();
        audioFile.afd.file = file;
        audioFile.afd.type = audioFile.retrieveType();
        audioFile.afh = audioFile.createHeader();
        audioFile.afh.readHeader(audioFile.afd);
        audioFile.init();
        audioFile.seekFrame(0L);
        return audioFile;
    }

    public static AudioFile openAsWrite(AudioFileDescr audioFileDescr) throws IOException {
        if (audioFileDescr.file.exists()) {
            audioFileDescr.file.delete();
        }
        AudioFile audioFile = new AudioFile(audioFileDescr.file, 1);
        audioFile.afd = audioFileDescr;
        audioFileDescr.length = 0L;
        audioFile.afh = audioFile.createHeader();
        audioFile.afh.writeHeader(audioFile.afd);
        audioFile.init();
        audioFile.seekFrame(0L);
        audioFile.updateLen = audioFile.updateStep = (long)audioFileDescr.rate * 20L;
        audioFile.updateTime = System.currentTimeMillis() + 10000L;
        return audioFile;
    }

    public static int retrieveType(File file) throws IOException {
        AudioFile audioFile = new AudioFile(file, 0);
        int n = audioFile.retrieveType();
        audioFile.cleanUp();
        return n;
    }

    private AudioFile(File file, int n) throws IOException {
        this.raf = new RandomAccessFile(file, n == 1 ? "rw" : "r");
        this.fch = this.raf.getChannel();
        this.mode = n;
    }

    public AudioFileDescr getDescr() {
        return this.afd;
    }

    @Override
    public File getFile() {
        return this.afd.file;
    }

    private void init() throws IOException {
        this.channels = this.afd.channels;
        this.bytesPerFrame = (this.afd.bitsPerSample >> 3) * this.channels;
        this.frameBufCapacity = Math.max(1, 65536 / Math.max(1, this.bytesPerFrame));
        this.byteBufCapacity = this.frameBufCapacity * this.bytesPerFrame;
        this.byteBuf = ByteBuffer.allocateDirect(this.byteBufCapacity);
        this.byteBuf.order(this.afh.getByteOrder());
        this.bh = null;
        block0 : switch (this.afd.sampleFormat) {
            case 0: {
                switch (this.afd.bitsPerSample) {
                    case 8: {
                        if (this.afh.isUnsignedPCM()) {
                            this.bh = new UByteBufferHandler();
                            break;
                        }
                        this.bh = new ByteBufferHandler();
                        break;
                    }
                    case 16: {
                        this.bh = new ShortBufferHandler();
                        break;
                    }
                    case 24: {
                        if (this.afh.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            this.bh = new ThreeByteBufferHandler();
                            break;
                        }
                        this.bh = new ThreeLittleByteBufferHandler();
                        break;
                    }
                    case 32: {
                        this.bh = new IntBufferHandler();
                    }
                }
                break;
            }
            case 1: {
                switch (this.afd.bitsPerSample) {
                    case 32: {
                        this.bh = new FloatBufferHandler();
                        break block0;
                    }
                    case 64: {
                        this.bh = new DoubleBufferHandler();
                    }
                }
            }
        }
        if (this.bh == null) {
            throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
        }
    }

    private AudioFileHeader createHeader() throws IOException {
        switch (this.afd.getType()) {
            case 0: {
                return new AIFFHeader();
            }
            case 1: {
                return new SNDHeader();
            }
            case 2: {
                return new IRCAMHeader();
            }
            case 3: {
                return new WAVEHeader();
            }
            case 4: {
                return new RawHeader();
            }
            case 5: {
                return new Wave64Header();
            }
        }
        throw new IOException(AudioFile.getResourceString("errAudioFileType"));
    }

    private int retrieveType() throws IOException {
        long l = this.raf.length();
        long l2 = this.raf.getFilePointer();
        int n = -1;
        if (l < 4L) {
            return n;
        }
        this.raf.seek(0L);
        int n2 = this.raf.readInt();
        switch (n2) {
            case 1179603533: {
                if (l < 12L) break;
                this.raf.readInt();
                n2 = this.raf.readInt();
                switch (n2) {
                    case 1095321155: 
                    case 1095321158: {
                        n = 0;
                    }
                }
                break;
            }
            case 779316836: {
                n = 1;
                break;
            }
            case 107364: 
            case 172900: 
            case 238436: 
            case 1688404224: 
            case 1688404480: 
            case 1688404736: 
            case 1688404992: {
                n = 2;
                break;
            }
            case 1380533830: {
                if (l < 12L) break;
                this.raf.readInt();
                n2 = this.raf.readInt();
                switch (n2) {
                    case 1463899717: {
                        n = 3;
                    }
                }
                break;
            }
            case 1919510118: {
                if (l < 40L || this.raf.readInt() != 781307665 || this.raf.readLong() != -6496960491292655616L) break;
                this.raf.readLong();
                if (this.raf.readLong() != 8602286943506322193L || this.raf.readLong() != -8299851812298630262L) break;
                n = 5;
                break;
            }
        }
        this.raf.seek(l2);
        return n;
    }

    @Override
    public void seekFrame(long l) throws IOException {
        long l2 = this.afh.getSampleDataOffset() + l * (long)this.bytesPerFrame;
        this.raf.seek(l2);
        this.framePosition = l;
    }

    @Override
    public void flush() throws IOException {
        this.updateTime = System.currentTimeMillis() + 10000L;
        this.afd.length = this.framePosition;
        this.afh.updateHeader(this.afd);
        this.updateLen = this.framePosition + this.updateStep;
        this.fch.force(true);
    }

    @Override
    public long getFramePosition() throws IOException {
        return this.framePosition;
    }

    @Override
    public void readFrames(float[][] fArray, int n, int n2) throws IOException {
        this.bh.readFrames(fArray, n, n2);
        this.framePosition += (long)n2;
    }

    @Override
    public void writeFrames(float[][] fArray, int n, int n2) throws IOException {
        this.bh.writeFrames(fArray, n, n2);
        this.framePosition += (long)n2;
        if (this.framePosition > this.afd.length) {
            if (this.framePosition > this.updateLen || System.currentTimeMillis() > this.updateTime) {
                this.flush();
            } else {
                this.afd.length = this.framePosition;
            }
        }
    }

    @Override
    public long getFrameNum() throws IOException {
        return this.afd.length;
    }

    @Override
    public void setFrameNum(long l) throws IOException {
        long l2 = this.afh.getSampleDataOffset() + l * (long)this.bytesPerFrame;
        this.raf.setLength(l2);
        if (this.framePosition > l) {
            this.framePosition = l;
        }
        this.afd.length = l;
    }

    @Override
    public int getChannelNum() {
        return this.afd.channels;
    }

    @Override
    public void truncate() throws IOException {
        this.fch.truncate(this.fch.position());
        if (this.framePosition != this.afd.length) {
            this.afd.length = this.framePosition;
            this.updateTime = System.currentTimeMillis() + 10000L;
            this.afh.updateHeader(this.afd);
            this.updateLen = this.framePosition + this.updateStep;
        }
    }

    @Override
    public void copyFrames(InterleavedStreamFile interleavedStreamFile, long l) throws IOException {
        int n = (int)Math.min(l, 8192L);
        float[][] fArray = new float[this.channels][n];
        while (l > 0L) {
            int n2 = (int)Math.min(l, (long)n);
            this.readFrames(fArray, 0, n2);
            interleavedStreamFile.writeFrames(fArray, 0, n2);
            l -= (long)n2;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mode == 1) {
            this.fch.force(true);
            this.afh.updateHeader(this.afd);
        }
        this.raf.close();
    }

    public void cleanUp() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readMarkers() throws IOException {
        this.afh.readMarkers();
    }

    public void readAppCode() throws IOException {
        this.afh.readAppCode();
    }

    protected static final String getResourceString(String string) {
        return IOUtil.getResourceString(string);
    }

    private class RawHeader
    extends AudioFileHeader {
        protected RawHeader() {
        }

        @Override
        protected void readHeader(AudioFileDescr audioFileDescr) throws IOException {
        }

        @Override
        protected void writeHeader(AudioFileDescr audioFileDescr) throws IOException {
        }

        @Override
        protected void updateHeader(AudioFileDescr audioFileDescr) throws IOException {
        }

        @Override
        protected long getSampleDataOffset() {
            return 0L;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }
    }

    private class IRCAMHeader
    extends AudioFileHeader {
        private static final int IRCAM_VAXLE_MAGIC = 1688404224;
        private static final int IRCAM_VAXBE_MAGIC = 107364;
        private static final int IRCAM_SUNBE_MAGIC = 1688404480;
        private static final int IRCAM_SUNLE_MAGIC = 172900;
        private static final int IRCAM_MIPSLE_MAGIC = 1688404736;
        private static final int IRCAM_MIPSBE_MAGIC = 238436;
        private static final int IRCAM_NEXTBE_MAGIC = 1688404992;
        private static final short BICSF_END = 0;
        private static final short BICSF_COMMENT = 2;
        private static final short BICSF_LINKCODE = 3;
        private static final short BICSF_VIRTUALCODE = 4;
        private static final short BICSF_CUECODE = 8;
        private ByteOrder byteOrder;
        private long sampleDataOffset;

        protected IRCAMHeader() {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }

        @Override
        protected void readHeader(AudioFileDescr audioFileDescr) throws IOException {
            AudioFileHeader.DataInputReader dataInputReader;
            byte[] byArray = null;
            ArrayList<Region> arrayList = new ArrayList<Region>();
            int n = AudioFile.this.raf.readInt();
            if (n == 1688404224 || n == 172900 || n == 1688404736) {
                this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                dataInputReader = new AudioFileHeader.LittleDataInputReader(AudioFile.this.raf);
            } else {
                dataInputReader = new AudioFileHeader.BigDataInputReader(AudioFile.this.raf);
            }
            audioFileDescr.rate = dataInputReader.readFloat();
            audioFileDescr.channels = dataInputReader.readInt();
            int n2 = dataInputReader.readInt();
            switch (n2) {
                case 1: {
                    audioFileDescr.bitsPerSample = 8;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 2: {
                    audioFileDescr.bitsPerSample = 16;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 3: {
                    audioFileDescr.bitsPerSample = 24;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 262148: {
                    audioFileDescr.bitsPerSample = 32;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 4: {
                    audioFileDescr.bitsPerSample = 32;
                    audioFileDescr.sampleFormat = 1;
                    break;
                }
                case 8: {
                    audioFileDescr.bitsPerSample = 64;
                    audioFileDescr.sampleFormat = 1;
                    break;
                }
                default: {
                    throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                }
            }
            do {
                n2 = dataInputReader.readInt();
                int n3 = n2 & 0xFFFF;
                switch (n2 >>= 16) {
                    case 8: {
                        int n4;
                        if (byArray == null) {
                            byArray = new byte[64];
                        }
                        AudioFile.this.raf.readFully(byArray);
                        for (n4 = 0; n4 < 64 && byArray[n4] != 0; ++n4) {
                        }
                        n2 = dataInputReader.readInt();
                        n3 = dataInputReader.readInt();
                        arrayList.add(new Region(new Span(n2, n3), new String(byArray, 0, n4)));
                        break;
                    }
                    case 3: 
                    case 4: {
                        throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                    }
                    case 2: {
                        byte[] byArray2 = new byte[n3];
                        AudioFile.this.raf.readFully(byArray2);
                        audioFileDescr.setProperty("comment", new String(byArray2));
                        break;
                    }
                    default: {
                        AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + (long)n3);
                    }
                }
            } while (n2 != 0);
            if (!arrayList.isEmpty()) {
                audioFileDescr.setProperty("regions", arrayList);
            }
            long l = AudioFile.this.raf.getFilePointer();
            this.sampleDataOffset = l + 1023L & 0xFFFFFFFFFFFFFC00L;
            l = AudioFile.this.raf.length() - this.sampleDataOffset;
            audioFileDescr.length = l / (long)((audioFileDescr.bitsPerSample + 7 >> 3) * audioFileDescr.channels);
        }

        @Override
        protected void writeHeader(AudioFileDescr audioFileDescr) throws IOException {
            String string;
            byte[] byArray;
            AudioFile.this.raf.writeInt(107364);
            AudioFile.this.raf.writeFloat((float)audioFileDescr.rate);
            AudioFile.this.raf.writeInt(audioFileDescr.channels);
            int n = audioFileDescr.sampleFormat == 0 && audioFileDescr.bitsPerSample == 32 ? 262148 : audioFileDescr.bitsPerSample >> 3;
            AudioFile.this.raf.writeInt(n);
            List list = (List)audioFileDescr.getProperty("regions");
            if (list != null && !list.isEmpty()) {
                n = 524360;
                byArray = new byte[64];
                byArray[0] = 0;
                for (int i = 0; i < list.size(); ++i) {
                    Region region = (Region)list.get(i);
                    AudioFile.this.raf.writeInt(n);
                    if (region.name.length() <= 64) {
                        AudioFile.this.raf.writeBytes(region.name);
                        AudioFile.this.raf.write(byArray, 0, 64 - region.name.length());
                    } else {
                        AudioFile.this.raf.writeBytes(region.name.substring(0, 64));
                    }
                    AudioFile.this.raf.writeInt((int)region.span.getStart());
                    AudioFile.this.raf.writeInt((int)region.span.getStop());
                }
            }
            if ((string = (String)audioFileDescr.getProperty("comment")) != null) {
                n = 0x20000 | string.length();
                AudioFile.this.raf.writeInt(n);
                AudioFile.this.raf.writeBytes(string);
            }
            AudioFile.this.raf.writeInt(0);
            long l = AudioFile.this.raf.getFilePointer();
            this.sampleDataOffset = l + 1023L & 0xFFFFFFFFFFFFFC00L;
            byArray = new byte[(int)(this.sampleDataOffset - l)];
            AudioFile.this.raf.write(byArray);
        }

        @Override
        protected void updateHeader(AudioFileDescr audioFileDescr) throws IOException {
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return this.byteOrder;
        }
    }

    private class SNDHeader
    extends AudioFileHeader {
        private static final int SND_MAGIC = 779316836;
        private long sampleDataOffset;
        private long headDataLenOffset;
        private long lastUpdateLength;

        protected SNDHeader() {
            this.headDataLenOffset = 8L;
            this.lastUpdateLength = 0L;
        }

        @Override
        protected void readHeader(AudioFileDescr audioFileDescr) throws IOException {
            AudioFile.this.raf.readInt();
            this.sampleDataOffset = AudioFile.this.raf.readInt();
            int n = AudioFile.this.raf.readInt();
            int n2 = AudioFile.this.raf.readInt();
            audioFileDescr.rate = AudioFile.this.raf.readInt();
            audioFileDescr.channels = AudioFile.this.raf.readInt();
            String string = this.readNullTermString();
            if (string.length() > 0) {
                audioFileDescr.setProperty("comment", string);
            }
            switch (n2) {
                case 2: {
                    audioFileDescr.bitsPerSample = 8;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 3: {
                    audioFileDescr.bitsPerSample = 16;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 4: {
                    audioFileDescr.bitsPerSample = 24;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 5: {
                    audioFileDescr.bitsPerSample = 32;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 6: {
                    audioFileDescr.bitsPerSample = 32;
                    audioFileDescr.sampleFormat = 1;
                    break;
                }
                case 7: {
                    audioFileDescr.bitsPerSample = 64;
                    audioFileDescr.sampleFormat = 1;
                    break;
                }
                default: {
                    throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                }
            }
            audioFileDescr.length = n / ((audioFileDescr.bitsPerSample + 7 >> 3) * audioFileDescr.channels);
        }

        @Override
        protected void writeHeader(AudioFileDescr audioFileDescr) throws IOException {
            String string = (String)audioFileDescr.getProperty("comment");
            this.sampleDataOffset = string == null ? 28L : (long)(28 + string.length() & 0xFFFFFFFC);
            AudioFile.this.raf.writeInt(779316836);
            AudioFile.this.raf.writeInt((int)this.sampleDataOffset);
            AudioFile.this.raf.writeInt(0);
            if (audioFileDescr.sampleFormat == 0) {
                AudioFile.this.raf.writeInt((audioFileDescr.bitsPerSample >> 3) + 1);
            } else {
                AudioFile.this.raf.writeInt((audioFileDescr.bitsPerSample >> 5) + 5);
            }
            AudioFile.this.raf.writeInt((int)(audioFileDescr.rate + 0.5));
            AudioFile.this.raf.writeInt(audioFileDescr.channels);
            if (string == null) {
                AudioFile.this.raf.writeInt(0);
            } else {
                AudioFile.this.raf.writeBytes(string);
                switch (string.length() & 3) {
                    case 0: {
                        AudioFile.this.raf.writeInt(0);
                        break;
                    }
                    case 1: {
                        AudioFile.this.raf.writeByte(0);
                        AudioFile.this.raf.writeShort(0);
                        break;
                    }
                    case 2: {
                        AudioFile.this.raf.writeShort(0);
                        break;
                    }
                    case 3: {
                        AudioFile.this.raf.writeByte(0);
                    }
                }
            }
        }

        @Override
        protected void updateHeader(AudioFileDescr audioFileDescr) throws IOException {
            long l = AudioFile.this.raf.length();
            if (l == this.lastUpdateLength) {
                return;
            }
            if (l >= this.headDataLenOffset + 4L) {
                long l2 = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.seek(this.headDataLenOffset);
                AudioFile.this.raf.writeInt((int)(l - this.sampleDataOffset));
                AudioFile.this.raf.seek(l2);
                this.lastUpdateLength = l;
            }
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }
    }

    private class Wave64Header
    extends AbstractRIFFHeader {
        private static final int RIFF_MAGIC1a = 1919510118;
        private static final int RIFF_MAGIC1b = 781307665;
        private static final long RIFF_MAGIC1 = 8244233181932408593L;
        private static final long RIFF_MAGIC2 = -6496960491292655616L;
        private static final long WAVE_MAGIC1 = 8602286943506322193L;
        private static final long WAVE_MAGIC2 = -8299851812298630262L;
        private static final long FMT_MAGIC1 = 7380683049206076177L;
        private static final long FMT_MAGIC2 = -8299851812298630262L;
        private static final long FACT_MAGIC1 = 7377287018565128977L;
        private static final long FACT_MAGIC2 = -8299851812298630262L;
        private static final long DATA_MAGIC1 = 7233190440582566673L;
        private static final long DATA_MAGIC2 = -8299851812298630262L;
        private static final long MARKER_MAGIC1 = 6224809949549679121L;
        private static final long MARKER_MAGIC2 = -8735012126293304438L;
        private final Charset charset;
        private long markersOffset;
        private static final long riffLengthOffset = 16L;

        protected Wave64Header() {
            this.charset = Charset.forName("UTF-16LE");
            this.markersOffset = 0L;
        }

        @Override
        protected void readHeader(AudioFileDescr audioFileDescr) throws IOException {
            int n = 0;
            long l = 0L;
            AudioFile.this.raf.readLong();
            AudioFile.this.raf.readLong();
            long l2 = this.readLittleLong();
            AudioFile.this.raf.readLong();
            AudioFile.this.raf.readLong();
            l2 -= 40L;
            long l3 = 0L;
            int n2 = 2;
            block5: while (l2 >= 24L && n2 > 0) {
                if (l3 != 0L) {
                    AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + l3);
                }
                long l4 = AudioFile.this.raf.readLong();
                long l5 = AudioFile.this.raf.readLong();
                l3 = this.readLittleLong() + 7L & 0xFFFFFFFFFFFFFFF8L;
                l2 -= l3;
                l3 -= 24L;
                if (l4 == 7380683049206076177L && l5 == -8299851812298630262L) {
                    --n2;
                    int n3 = this.readLittleUShort();
                    audioFileDescr.channels = this.readLittleUShort();
                    int n4 = this.readLittleInt();
                    audioFileDescr.rate = n4;
                    int n5 = this.readLittleInt();
                    n = this.readLittleUShort();
                    audioFileDescr.bitsPerSample = this.readLittleUShort();
                    if ((audioFileDescr.bitsPerSample & 7) != 0 || (audioFileDescr.bitsPerSample >> 3) * audioFileDescr.channels != n || (audioFileDescr.bitsPerSample >> 3) * audioFileDescr.channels * n4 != n5) {
                        throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                    }
                    this.unsignedPCM = n == 1;
                    l3 -= 16L;
                    switch (n3) {
                        case 1: {
                            audioFileDescr.sampleFormat = 0;
                            continue block5;
                        }
                        case 3: {
                            audioFileDescr.sampleFormat = 1;
                            continue block5;
                        }
                        case 65534: {
                            if (l3 < 24L) {
                                throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
                            }
                            n4 = this.readLittleUShort();
                            if (n4 < 22) {
                                throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
                            }
                            n5 = this.readLittleUShort();
                            AudioFile.this.raf.readInt();
                            int n6 = this.readLittleUShort();
                            if (n5 != audioFileDescr.bitsPerSample || n6 != 1 && n6 != 3) {
                                throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                            }
                            audioFileDescr.sampleFormat = n6 == 1 ? 0 : 1;
                            l3 -= 10L;
                            continue block5;
                        }
                    }
                    throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                }
                if (l4 == 7233190440582566673L && l5 == -8299851812298630262L) {
                    --n2;
                    this.sampleDataOffset = AudioFile.this.raf.getFilePointer();
                    l = l3;
                    continue;
                }
                if (l4 != 6224809949549679121L || l5 != -8735012126293304438L) continue;
                this.markersOffset = AudioFile.this.raf.getFilePointer();
            }
            if (n2 > 0) {
                throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
            }
            audioFileDescr.length = l / (long)n;
        }

        @Override
        protected void writeHeader(AudioFileDescr audioFileDescr) throws IOException {
            this.isFloat = audioFileDescr.sampleFormat == 1;
            AudioFile.this.raf.writeLong(8244233181932408593L);
            AudioFile.this.raf.writeLong(-6496960491292655616L);
            AudioFile.this.raf.writeLong(40L);
            AudioFile.this.raf.writeLong(8602286943506322193L);
            AudioFile.this.raf.writeLong(-8299851812298630262L);
            AudioFile.this.raf.writeLong(7380683049206076177L);
            AudioFile.this.raf.writeLong(-8299851812298630262L);
            this.writeLittleLong(this.isFloat ? 42L : 40L);
            this.writeLittleShort(this.isFloat ? 3 : 1);
            this.writeLittleShort(audioFileDescr.channels);
            int n = (int)(audioFileDescr.rate + 0.5);
            this.writeLittleInt(n);
            int n2 = (audioFileDescr.bitsPerSample >> 3) * audioFileDescr.channels;
            this.writeLittleInt(n * n2);
            this.writeLittleShort(n2);
            this.writeLittleShort(audioFileDescr.bitsPerSample);
            if (this.isFloat) {
                AudioFile.this.raf.writeLong(0L);
            }
            if (this.isFloat) {
                AudioFile.this.raf.writeLong(7377287018565128977L);
                AudioFile.this.raf.writeLong(-8299851812298630262L);
                this.writeLittleLong(32L);
                this.factSmpNumOffset = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.writeLong(0L);
            }
            List list = (List)audioFileDescr.getProperty("markers");
            List list2 = (List)audioFileDescr.getProperty("regions");
            if (list != null && !list.isEmpty() || list2 != null && !list2.isEmpty()) {
                long l;
                int n3;
                CharsetEncoder charsetEncoder = this.charset.newEncoder();
                Buffer buffer = null;
                ByteBuffer byteBuffer = null;
                List[] listArray = new List[]{list == null ? Collections.EMPTY_LIST : list, list2 == null ? Collections.EMPTY_LIST : list2};
                AudioFile.this.raf.writeLong(6224809949549679121L);
                AudioFile.this.raf.writeLong(-8735012126293304438L);
                long l2 = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.writeLong(0L);
                n2 = listArray[0].size() + listArray[1].size();
                this.writeLittleInt(n2);
                int n4 = 1;
                for (n3 = 0; n3 < 2; ++n3) {
                    int n5 = 0;
                    while (n5 < listArray[n3].size()) {
                        String string;
                        long l3;
                        if (n3 == 0) {
                            Marker marker = (Marker)listArray[n3].get(n5);
                            l = marker.pos;
                            l3 = -1L;
                            string = marker.name;
                        } else {
                            Region region = (Region)listArray[n3].get(n5);
                            l = region.span.start;
                            l3 = region.span.getLength();
                            string = region.name;
                        }
                        this.writeLittleInt(n4);
                        AudioFile.this.raf.writeInt(0);
                        this.writeLittleLong(l);
                        this.writeLittleLong(l3);
                        if (buffer == null || buffer.capacity() < string.length()) {
                            buffer = CharBuffer.allocate(string.length() + 8);
                            byteBuffer = ByteBuffer.allocate(buffer.capacity() + 1 << 1);
                        }
                        ((CharBuffer)buffer).clear();
                        ((CharBuffer)buffer).put(string);
                        ((CharBuffer)buffer).flip();
                        byteBuffer.clear();
                        charsetEncoder.reset();
                        charsetEncoder.encode((CharBuffer)buffer, byteBuffer, true);
                        charsetEncoder.flush(byteBuffer);
                        byteBuffer.putShort((short)0);
                        byteBuffer.flip();
                        this.writeLittleInt(byteBuffer.remaining());
                        AudioFile.this.raf.writeInt(0);
                        AudioFile.this.fch.write(byteBuffer);
                        ++n5;
                        ++n4;
                    }
                }
                long l4 = AudioFile.this.raf.getFilePointer();
                l = l4 - l2;
                n3 = (int)((l + 7L & 0xFFFFFFFFFFFFFFF8L) - l);
                for (n4 = 0; n4 < n3; ++n4) {
                    AudioFile.this.raf.write(0);
                }
                AudioFile.this.raf.seek(l2);
                this.writeLittleLong(l + 16L);
                AudioFile.this.raf.seek(l4 + (long)n3);
            }
            AudioFile.this.raf.writeLong(7233190440582566673L);
            AudioFile.this.raf.writeLong(-8299851812298630262L);
            this.dataLengthOffset = AudioFile.this.raf.getFilePointer();
            AudioFile.this.raf.writeLong(24L);
            this.sampleDataOffset = AudioFile.this.raf.getFilePointer();
            this.updateHeader(audioFileDescr);
        }

        @Override
        protected void updateHeader(AudioFileDescr audioFileDescr) throws IOException {
            long l = AudioFile.this.raf.getFilePointer();
            long l2 = AudioFile.this.raf.length();
            if (l2 == this.lastUpdateLength) {
                return;
            }
            long l3 = l2 - 8L;
            if (l3 >= 16L) {
                AudioFile.this.raf.seek(16L);
                this.writeLittleLong(l2);
            }
            if (this.isFloat && l3 >= this.factSmpNumOffset) {
                AudioFile.this.raf.seek(this.factSmpNumOffset);
                this.writeLittleLong(audioFileDescr.length * (long)audioFileDescr.channels);
            }
            if (l3 >= this.dataLengthOffset) {
                AudioFile.this.raf.seek(this.dataLengthOffset);
                this.writeLittleLong(l2 - (this.dataLengthOffset - 16L));
            }
            AudioFile.this.raf.seek(l);
            this.lastUpdateLength = l2;
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        protected boolean isUnsignedPCM() {
            return this.unsignedPCM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readMarkers() throws IOException {
            if (this.markersOffset == 0L) {
                return;
            }
            ArrayList<Marker> arrayList = new ArrayList<Marker>();
            ArrayList<Region> arrayList2 = new ArrayList<Region>();
            CharsetDecoder charsetDecoder = this.charset.newDecoder();
            CharBuffer charBuffer = null;
            Buffer buffer = null;
            long l = AudioFile.this.raf.getFilePointer();
            try {
                AudioFile.this.raf.seek(this.markersOffset);
                int n = this.readLittleInt();
                for (int i = 0; i < n; ++i) {
                    AudioFile.this.raf.readInt();
                    AudioFile.this.raf.readInt();
                    long l2 = this.readLittleLong();
                    long l3 = this.readLittleLong();
                    int n2 = this.readLittleInt();
                    AudioFile.this.raf.readInt();
                    if (buffer == null || buffer.capacity() < n2) {
                        buffer = ByteBuffer.allocate(n2 + 16);
                        charBuffer = CharBuffer.allocate(buffer.capacity() >> 1);
                    }
                    ((ByteBuffer)buffer).rewind().limit(n2);
                    AudioFile.this.fch.read((ByteBuffer)buffer);
                    if (n2 >= 2 && ((ByteBuffer)buffer).get(n2 - 2) == 0 && ((ByteBuffer)buffer).get(n2 - 1) == 0) {
                        ((ByteBuffer)buffer).rewind().limit(n2 - 2);
                    } else {
                        ((ByteBuffer)buffer).flip();
                    }
                    charBuffer.clear();
                    charsetDecoder.reset();
                    CoderResult coderResult = charsetDecoder.decode((ByteBuffer)buffer, charBuffer, true);
                    if (coderResult.isError()) {
                        throw new IOException("Error Reading Cue Name" + (coderResult.isMalformed() ? ": Malformed Input" : (coderResult.isOverflow() ? ": Overflow" : (coderResult.isUnderflow() ? ": Underflow" : (coderResult.isUnmappable() ? ": Unmappable" : "")))));
                    }
                    charsetDecoder.flush(charBuffer);
                    charBuffer.flip();
                    String string = charBuffer.toString();
                    if (l3 < 0L) {
                        arrayList.add(new Marker(l2, string));
                        continue;
                    }
                    arrayList2.add(new Region(new Span(l2, l2 + l3), string));
                }
                AudioFile.this.afd.setProperty("markers", arrayList);
                AudioFile.this.afd.setProperty("regions", arrayList2);
            }
            finally {
                AudioFile.this.raf.seek(l);
            }
        }
    }

    private class WAVEHeader
    extends AbstractRIFFHeader {
        private static final int RIFF_MAGIC = 1380533830;
        private static final int WAVE_MAGIC = 1463899717;
        private static final int FMT_MAGIC = 1718449184;
        private static final int FACT_MAGIC = 1717658484;
        private static final int DATA_MAGIC = 1684108385;
        private static final int CUE_MAGIC = 1668637984;
        private static final int SMPL_MAGIC = 1935764844;
        private static final int INST_MAGIC = 1768846196;
        private static final int LIST_MAGIC = 1818850164;
        private static final int LIST_MAGIC2 = 1279873876;
        private long smplMagicOff;
        private long listMagicOff;
        private long listMagicLen;
        private long cueMagicOff;
        private static final long riffLengthOffset = 4L;

        protected WAVEHeader() {
            this.smplMagicOff = 0L;
            this.listMagicOff = 0L;
            this.listMagicLen = 0L;
            this.cueMagicOff = 0L;
        }

        @Override
        protected void readHeader(AudioFileDescr audioFileDescr) throws IOException {
            int n = 0;
            int n2 = 0;
            AudioFile.this.raf.readInt();
            AudioFile.this.raf.readInt();
            long l = AudioFile.this.raf.length() - 8L;
            AudioFile.this.raf.readInt();
            l -= 4L;
            int n3 = 0;
            int n4 = 2;
            block13: while (l > 0L && n4 > 0) {
                if (n3 != 0) {
                    AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + (long)n3);
                }
                int n5 = AudioFile.this.raf.readInt();
                n3 = this.readLittleInt() + 1 & 0xFFFFFFFE;
                l -= (long)(n3 + 8);
                switch (n5) {
                    case 1718449184: {
                        --n4;
                        int n6 = this.readLittleUShort();
                        audioFileDescr.channels = this.readLittleUShort();
                        int n7 = this.readLittleInt();
                        audioFileDescr.rate = n7;
                        int n8 = this.readLittleInt();
                        n2 = this.readLittleUShort();
                        audioFileDescr.bitsPerSample = this.readLittleUShort();
                        if ((audioFileDescr.bitsPerSample & 7) != 0 || (audioFileDescr.bitsPerSample >> 3) * audioFileDescr.channels != n2 || (audioFileDescr.bitsPerSample >> 3) * audioFileDescr.channels * n7 != n8) {
                            throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                        }
                        this.unsignedPCM = n2 == 1;
                        n3 -= 16;
                        switch (n6) {
                            case 1: {
                                audioFileDescr.sampleFormat = 0;
                                continue block13;
                            }
                            case 3: {
                                audioFileDescr.sampleFormat = 1;
                                continue block13;
                            }
                            case 65534: {
                                if (n3 < 24) {
                                    throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
                                }
                                n7 = this.readLittleUShort();
                                if (n7 < 22) {
                                    throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
                                }
                                n8 = this.readLittleUShort();
                                AudioFile.this.raf.readInt();
                                int n9 = this.readLittleUShort();
                                if (n8 != audioFileDescr.bitsPerSample || n9 != 1 && n9 != 3) {
                                    throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                                }
                                audioFileDescr.sampleFormat = n9 == 1 ? 0 : 1;
                                n3 -= 10;
                                continue block13;
                            }
                        }
                        throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                    }
                    case 1684108385: {
                        --n4;
                        this.sampleDataOffset = AudioFile.this.raf.getFilePointer();
                        n = n3;
                        continue block13;
                    }
                    case 1668637984: {
                        this.cueMagicOff = AudioFile.this.raf.getFilePointer();
                        continue block13;
                    }
                    case 1279873876: 
                    case 1818850164: {
                        int n6 = AudioFile.this.raf.readInt();
                        n3 -= 4;
                        if (n6 != 1633973356) continue block13;
                        this.listMagicOff = AudioFile.this.raf.getFilePointer();
                        this.listMagicLen = n3;
                        continue block13;
                    }
                    case 1935764844: {
                        this.smplMagicOff = AudioFile.this.raf.getFilePointer() + 28L;
                        continue block13;
                    }
                    case 1768846196: {
                        AudioFile.this.raf.readShort();
                        int n6 = AudioFile.this.raf.readByte();
                        if (n6 != 0) {
                            audioFileDescr.setProperty("gain", new Float(Math.exp((double)n6 / 20.0 * Math.log(10.0))));
                        }
                        n3 -= 3;
                        continue block13;
                    }
                }
            }
            if (n4 > 0) {
                throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
            }
            audioFileDescr.length = n / n2;
        }

        @Override
        protected void writeHeader(AudioFileDescr audioFileDescr) throws IOException {
            Object object;
            Region region;
            this.isFloat = audioFileDescr.sampleFormat == 1;
            AudioFile.this.raf.writeInt(1380533830);
            AudioFile.this.raf.writeInt(0);
            AudioFile.this.raf.writeInt(1463899717);
            AudioFile.this.raf.writeInt(1718449184);
            this.writeLittleInt(this.isFloat ? 18 : 16);
            this.writeLittleShort(this.isFloat ? 3 : 1);
            this.writeLittleShort(audioFileDescr.channels);
            int n = (int)(audioFileDescr.rate + 0.5);
            this.writeLittleInt(n);
            int n2 = (audioFileDescr.bitsPerSample >> 3) * audioFileDescr.channels;
            this.writeLittleInt(n * n2);
            this.writeLittleShort(n2);
            this.writeLittleShort(audioFileDescr.bitsPerSample);
            if (this.isFloat) {
                AudioFile.this.raf.writeShort(0);
            }
            if (this.isFloat) {
                AudioFile.this.raf.writeInt(1717658484);
                this.writeLittleInt(4);
                this.factSmpNumOffset = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.writeInt(0);
            }
            List list = (List)audioFileDescr.getProperty("markers");
            List list2 = (List)audioFileDescr.getProperty("regions");
            if (list != null && !list.isEmpty() || list2 != null && !list2.isEmpty()) {
                int n3;
                Marker marker;
                if (list == null) {
                    list = Collections.EMPTY_LIST;
                }
                if (list2 == null) {
                    list2 = Collections.EMPTY_LIST;
                }
                AudioFile.this.raf.writeInt(1668637984);
                n2 = list.size() + list2.size();
                this.writeLittleInt(24 * n2 + 4);
                this.writeLittleInt(n2);
                int n4 = 0;
                n = 1;
                while (n4 < list.size()) {
                    marker = (Marker)list.get(n4);
                    this.writeLittleInt(n);
                    this.writeLittleInt(n);
                    AudioFile.this.raf.writeInt(1684108385);
                    AudioFile.this.raf.writeLong(0L);
                    this.writeLittleInt((int)marker.pos);
                    ++n4;
                    ++n;
                }
                n4 = 0;
                while (n4 < list2.size()) {
                    region = (Region)list2.get(n4);
                    this.writeLittleInt(n);
                    this.writeLittleInt(n);
                    AudioFile.this.raf.writeInt(1684108385);
                    AudioFile.this.raf.writeLong(0L);
                    this.writeLittleInt((int)region.span.getStart());
                    ++n4;
                    ++n;
                }
                AudioFile.this.raf.writeInt(1818850164);
                long l = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.writeInt(0);
                AudioFile.this.raf.writeInt(1633973356);
                n4 = 0;
                n = 1;
                while (n4 < list.size()) {
                    marker = (Marker)list.get(n4);
                    n3 = marker.name.length() + 5;
                    AudioFile.this.raf.writeInt(1818321516);
                    this.writeLittleInt(n3);
                    this.writeLittleInt(n);
                    AudioFile.this.raf.writeBytes(marker.name);
                    if ((n3 & 1) == 0) {
                        AudioFile.this.raf.writeByte(0);
                    } else {
                        AudioFile.this.raf.writeShort(0);
                    }
                    ++n4;
                    ++n;
                }
                n4 = 0;
                while (n4 < list2.size()) {
                    region = (Region)list2.get(n4);
                    n3 = region.name.length() + 5;
                    AudioFile.this.raf.writeInt(1818321516);
                    this.writeLittleInt(n3);
                    this.writeLittleInt(n);
                    AudioFile.this.raf.writeBytes(region.name);
                    if ((n3 & 1) == 0) {
                        AudioFile.this.raf.writeByte(0);
                    } else {
                        AudioFile.this.raf.writeShort(0);
                    }
                    ++n4;
                    ++n;
                }
                n4 = 0;
                n = list.size() + 1;
                while (n4 < list2.size()) {
                    region = (Region)list2.get(n4);
                    AudioFile.this.raf.writeInt(1819572340);
                    this.writeLittleInt(21);
                    this.writeLittleInt(n);
                    this.writeLittleInt((int)region.span.getLength());
                    AudioFile.this.raf.writeInt(1919381024);
                    AudioFile.this.raf.writeLong(0L);
                    AudioFile.this.raf.writeShort(0);
                    ++n4;
                    ++n;
                }
                long l2 = AudioFile.this.raf.getFilePointer();
                n4 = (int)(l2 - l - 4L);
                if ((n4 & 1) == 1) {
                    AudioFile.this.raf.write(0);
                    ++l2;
                }
                AudioFile.this.raf.seek(l);
                this.writeLittleInt(n4);
                AudioFile.this.raf.seek(l2);
            }
            if ((region = (Region)audioFileDescr.getProperty(AudioFile.NAME_LOOP)) != null) {
                AudioFile.this.raf.writeInt(1935764844);
                this.writeLittleInt(60);
                AudioFile.this.raf.writeLong(0L);
                this.writeLittleInt((int)(1.0E9 / audioFileDescr.rate + 0.5));
                this.writeLittleInt(69);
                AudioFile.this.raf.writeInt(0);
                AudioFile.this.raf.writeLong(0L);
                this.writeLittleInt(1);
                AudioFile.this.raf.writeInt(0);
                this.writeLittleInt(0);
                this.writeLittleInt(0);
                this.writeLittleInt((int)region.span.getStart());
                this.writeLittleInt((int)region.span.getStop());
                AudioFile.this.raf.writeLong(0L);
            }
            if ((object = audioFileDescr.getProperty("gain")) != null) {
                n = Math.max(-64, Math.min(63, (int)(20.0 * Math.log(((Float)object).floatValue()) / Math.log(10.0) + 0.5)));
                AudioFile.this.raf.writeInt(1768846196);
                this.writeLittleInt(7);
                AudioFile.this.raf.writeShort(0x45000000);
                AudioFile.this.raf.write(n);
                AudioFile.this.raf.writeInt(0x7F007F);
                AudioFile.this.raf.write(0);
            }
            AudioFile.this.raf.writeInt(1684108385);
            this.dataLengthOffset = AudioFile.this.raf.getFilePointer();
            AudioFile.this.raf.writeInt(0);
            this.sampleDataOffset = AudioFile.this.raf.getFilePointer();
            this.updateHeader(audioFileDescr);
        }

        @Override
        protected void updateHeader(AudioFileDescr audioFileDescr) throws IOException {
            long l = AudioFile.this.raf.getFilePointer();
            long l2 = AudioFile.this.raf.length();
            if (l2 == this.lastUpdateLength) {
                return;
            }
            if (l2 >= 8L) {
                AudioFile.this.raf.seek(4L);
                this.writeLittleInt((int)(l2 - 8L));
            }
            if (this.isFloat && l2 >= this.factSmpNumOffset + 4L) {
                AudioFile.this.raf.seek(this.factSmpNumOffset);
                this.writeLittleInt((int)(audioFileDescr.length * (long)audioFileDescr.channels));
            }
            if (l2 >= this.dataLengthOffset + 4L) {
                AudioFile.this.raf.seek(this.dataLengthOffset);
                this.writeLittleInt((int)(l2 - (this.dataLengthOffset + 4L)));
            }
            AudioFile.this.raf.seek(l);
            this.lastUpdateLength = l2;
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        protected boolean isUnsignedPCM() {
            return this.unsignedPCM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readMarkers() throws IOException {
            if (this.smplMagicOff == 0L && this.listMagicOff == 0L) {
                return;
            }
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
            HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
            long l = AudioFile.this.raf.getFilePointer();
            byte[] byArray = null;
            try {
                int n;
                int n2;
                String string;
                Integer n32;
                int n4;
                int n5;
                if (this.smplMagicOff > 0L) {
                    AudioFile.this.raf.seek(this.smplMagicOff);
                    n5 = this.readLittleInt();
                    AudioFile.this.raf.readInt();
                    if (n5 > 0) {
                        n4 = this.readLittleInt();
                        n32 = new Integer(n4);
                        hashMap.remove(n32);
                        hashMap2.remove(n32);
                        string = (String)hashMap3.remove(n32);
                        if (string == null) {
                            string = AudioFile.NAME_LOOP;
                        }
                        AudioFile.this.afd.setProperty(AudioFile.NAME_LOOP, new Region(new Span(this.readLittleInt(), this.readLittleInt()), string));
                    }
                }
                if (this.listMagicOff > 0L) {
                    AudioFile.this.raf.seek(this.listMagicOff);
                    long l2 = this.listMagicLen;
                    while (l2 >= 8L) {
                        n5 = AudioFile.this.raf.readInt();
                        n4 = this.readLittleInt();
                        n2 = n4 + 1 & 0xFFFFFFFE;
                        l2 -= 8L;
                        switch (n5) {
                            case 1818321516: {
                                n = this.readLittleInt();
                                n2 -= 4;
                                l2 -= 4L;
                                if (byArray == null || byArray.length < (n4 -= 4)) {
                                    byArray = new byte[Math.max(64, n4)];
                                }
                                AudioFile.this.raf.readFully(byArray, 0, n4);
                                hashMap3.put(new Integer(n), new String(byArray, 0, n4 - 1));
                                l2 -= (long)n4;
                                n2 -= n4;
                                break;
                            }
                            case 1819572340: {
                                n = this.readLittleInt();
                                int n6 = this.readLittleInt();
                                int n7 = AudioFile.this.raf.readInt();
                                AudioFile.this.raf.readLong();
                                n2 -= 20;
                                l2 -= 20L;
                                n32 = new Integer(n);
                                if ((n4 -= 20) > 0 && !hashMap3.containsKey(n32)) {
                                    if (byArray == null || byArray.length < n4) {
                                        byArray = new byte[Math.max(64, n4)];
                                    }
                                    AudioFile.this.raf.readFully(byArray, 0, n4);
                                    hashMap3.put(n32, new String(byArray, 0, n4 - 1));
                                    l2 -= (long)n4;
                                    n2 -= n4;
                                }
                                if (n6 <= 0 && n7 != 1919381024) break;
                                hashMap2.put(n32, new Integer(n6));
                                break;
                            }
                        }
                        if (n2 == 0) continue;
                        AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + (long)n2);
                        l2 -= (long)n2;
                    }
                }
                if (this.cueMagicOff > 0L) {
                    AudioFile.this.raf.seek(this.cueMagicOff);
                    n5 = this.readLittleInt();
                    for (int i = 0; i < n5; ++i) {
                        n4 = this.readLittleInt();
                        AudioFile.this.raf.readInt();
                        n2 = AudioFile.this.raf.readInt();
                        AudioFile.this.raf.readLong();
                        n = this.readLittleInt();
                        if (n2 != 1684108385) continue;
                        hashMap.put(new Integer(n4), new Integer(n));
                    }
                }
                if (!hashMap.isEmpty()) {
                    ArrayList<Marker> arrayList = new ArrayList<Marker>();
                    ArrayList<Region> arrayList2 = new ArrayList<Region>();
                    for (Integer n32 : hashMap.keySet()) {
                        n5 = (Integer)hashMap.get(n32);
                        string = (String)hashMap3.get(n32);
                        if ((n32 = hashMap2.get(n32)) == null) {
                            if (string == null) {
                                string = AudioFile.NAME_MARK;
                            }
                            arrayList.add(new Marker(n5, string));
                            continue;
                        }
                        if (string == null) {
                            string = AudioFile.NAME_REGION;
                        }
                        arrayList2.add(new Region(new Span(n5, n32.intValue()), string));
                    }
                    if (!arrayList.isEmpty()) {
                        AudioFile.this.afd.setProperty("markers", arrayList);
                    }
                    if (!arrayList2.isEmpty()) {
                        AudioFile.this.afd.setProperty("regions", arrayList2);
                    }
                }
            }
            finally {
                AudioFile.this.raf.seek(l);
            }
        }
    }

    private abstract class AbstractRIFFHeader
    extends AudioFileHeader {
        protected static final int ADTL_MAGIC = 1633973356;
        protected static final int LABL_MAGIC = 1818321516;
        protected static final int LTXT_MAGIC = 1819572340;
        protected static final int RGN_MAGIC = 1919381024;
        protected static final int FORMAT_PCM = 1;
        protected static final int FORMAT_FLOAT = 3;
        protected static final int FORMAT_EXT = 65534;
        protected long sampleDataOffset;
        protected long dataLengthOffset;
        protected long factSmpNumOffset;
        protected long lastUpdateLength;
        protected boolean isFloat;
        protected boolean unsignedPCM;

        protected AbstractRIFFHeader() {
            this.lastUpdateLength = 0L;
            this.isFloat = false;
        }
    }

    private class AIFFHeader
    extends AudioFileHeader {
        private static final int FORM_MAGIC = 1179603533;
        private static final int AIFF_MAGIC = 1095321158;
        private static final int AIFC_MAGIC = 1095321155;
        private static final int COMM_MAGIC = 1129270605;
        private static final int INST_MAGIC = 1229869908;
        private static final int MARK_MAGIC = 1296126539;
        private static final int SSND_MAGIC = 1397968452;
        private static final int FVER_MAGIC = 1180058962;
        private static final int APPL_MAGIC = 1095782476;
        private static final int COMT_MAGIC = 1129270612;
        private static final int ANNO_MAGIC = 1095650895;
        private static final int NONE_MAGIC = 1313820229;
        private static final int fl32_MAGIC = 1718367026;
        private static final int FL32_MAGIC = 1179398962;
        private static final int fl64_MAGIC = 1718367796;
        private static final int FL64_MAGIC = 1179399732;
        private static final int in16_MAGIC = 1768829238;
        private static final int in24_MAGIC = 1768829492;
        private static final int in32_MAGIC = 1768829746;
        private static final int in16LE_MAGIC = 1936684916;
        private boolean isAIFC;
        private static final int AIFCVersion1 = -1568648896;
        private static final String fl32_HUMAN = "32-bit float";
        private static final String fl64_HUMAN = "64-bit float";
        private long sampleDataOffset;
        private long formLengthOffset;
        private long commSmpNumOffset;
        private long ssndLengthOffset;
        private long lastUpdateLength;
        private ByteOrder byteOrder;
        private int appCodeLen;
        private long appCodeOff;
        private long markersOffset;
        private boolean loop;
        private int loopStart;
        private int loopEnd;

        protected AIFFHeader() {
            this.isAIFC = true;
            this.formLengthOffset = 4L;
            this.lastUpdateLength = 0L;
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            this.appCodeOff = 0L;
            this.markersOffset = 0L;
            this.loop = false;
            this.loopStart = 0;
            this.loopEnd = 0;
        }

        @Override
        protected void readHeader(AudioFileDescr audioFileDescr) throws IOException {
            boolean bl = false;
            AudioFile.this.raf.readInt();
            AudioFile.this.raf.readInt();
            long l = AudioFile.this.raf.length() - 8L;
            this.isAIFC = AudioFile.this.raf.readInt() == 1095321155;
            l -= 4L;
            int n = 0;
            int n2 = 2;
            block18: while (l > 0L && n2 > 0) {
                if (n != 0) {
                    AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + (long)n);
                }
                int n3 = AudioFile.this.raf.readInt();
                n = AudioFile.this.raf.readInt() + 1 & 0xFFFFFFFE;
                l -= (long)(n + 8);
                switch (n3) {
                    case 1129270605: {
                        --n2;
                        audioFileDescr.channels = AudioFile.this.raf.readShort();
                        this.commSmpNumOffset = AudioFile.this.raf.getFilePointer();
                        audioFileDescr.length = AudioFile.this.raf.readInt();
                        audioFileDescr.bitsPerSample = AudioFile.this.raf.readShort();
                        audioFileDescr.sampleFormat = 0;
                        long l2 = AudioFile.this.raf.readLong();
                        long l3 = AudioFile.this.raf.readUnsignedShort();
                        long l4 = l2 & 0xFFFFFFFFFFFFL;
                        int n4 = ((int)(l2 >> 48) & Short.MAX_VALUE) - 16382;
                        audioFileDescr.rate = ((double)l4 * Math.pow(2.0, n4 - 48) + (double)l3 * Math.pow(2.0, n4 - 64)) * (double)(l2 < 0L ? -1 : 1);
                        n -= 18;
                        if (!this.isAIFC) continue block18;
                        switch (AudioFile.this.raf.readInt()) {
                            case 1313820229: {
                                break;
                            }
                            case 1768829238: {
                                audioFileDescr.bitsPerSample = 16;
                                break;
                            }
                            case 1768829492: {
                                audioFileDescr.bitsPerSample = 24;
                                break;
                            }
                            case 1768829746: {
                                audioFileDescr.bitsPerSample = 32;
                                break;
                            }
                            case 1179398962: 
                            case 1718367026: {
                                audioFileDescr.bitsPerSample = 32;
                                audioFileDescr.sampleFormat = 1;
                                break;
                            }
                            case 1179399732: 
                            case 1718367796: {
                                audioFileDescr.bitsPerSample = 64;
                                audioFileDescr.sampleFormat = 1;
                                break;
                            }
                            case 1936684916: {
                                audioFileDescr.bitsPerSample = 16;
                                this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                                break;
                            }
                            default: {
                                throw new IOException(AudioFile.getResourceString("errAudioFileEncoding"));
                            }
                        }
                        n -= 4;
                        continue block18;
                    }
                    case 1229869908: {
                        AudioFile.this.raf.readInt();
                        int n4 = AudioFile.this.raf.readInt();
                        audioFileDescr.setProperty("gain", new Float(Math.exp((double)(n4 & 0xFFFF) / 20.0 * Math.log(10.0))));
                        n4 = AudioFile.this.raf.readShort();
                        this.loop = n4 != 0;
                        n4 = AudioFile.this.raf.readInt();
                        this.loopStart = n4 >> 16 & 0xFFFF;
                        this.loopEnd = n4 & 0xFFFF;
                        n -= 14;
                        continue block18;
                    }
                    case 1296126539: {
                        this.markersOffset = AudioFile.this.raf.getFilePointer();
                        continue block18;
                    }
                    case 1397968452: {
                        --n2;
                        int n4 = AudioFile.this.raf.readInt();
                        AudioFile.this.raf.readInt();
                        this.sampleDataOffset = AudioFile.this.raf.getFilePointer() + (long)n4;
                        n -= 8;
                        continue block18;
                    }
                    case 1095782476: {
                        byte[] byArray = new byte[4];
                        AudioFile.this.raf.readFully(byArray);
                        audioFileDescr.appCode = new String(byArray);
                        this.appCodeOff = AudioFile.this.raf.getFilePointer();
                        this.appCodeLen = n -= 4;
                        continue block18;
                    }
                    case 1129270612: {
                        byte[] byArray;
                        int n4 = AudioFile.this.raf.readShort();
                        n -= 2;
                        for (int i = 0; !bl && i < n4; ++i) {
                            AudioFile.this.raf.readInt();
                            int n5 = AudioFile.this.raf.readInt();
                            n -= 8;
                            if (n5 != 0 && n5 >> 16 == 0) {
                                byArray = new byte[n5];
                                AudioFile.this.raf.readFully(byArray);
                                audioFileDescr.setProperty("comment", new String(byArray));
                                if ((n5 & 1) == 1) {
                                    ++n5;
                                    AudioFile.this.raf.readByte();
                                }
                                n -= n5;
                                bl = true;
                                continue block18;
                            }
                            n5 = n5 + 1 & 0xFFFE;
                            n -= n5;
                            AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + (long)n5);
                        }
                        continue block18;
                    }
                    case 1095650895: {
                        if (bl) continue block18;
                        byte[] byArray = new byte[n];
                        AudioFile.this.raf.readFully(byArray);
                        audioFileDescr.setProperty("comment", new String(byArray));
                        n = 0;
                        bl = true;
                        continue block18;
                    }
                }
            }
            if (n2 > 0) {
                throw new IOException(AudioFile.getResourceString("errAudioFileIncomplete"));
            }
        }

        @Override
        protected void writeHeader(AudioFileDescr audioFileDescr) throws IOException {
            String string;
            this.isAIFC = audioFileDescr.sampleFormat == 1;
            AudioFile.this.raf.writeInt(1179603533);
            AudioFile.this.raf.writeInt(0);
            AudioFile.this.raf.writeInt(this.isAIFC ? 1095321155 : 1095321158);
            if (this.isAIFC) {
                AudioFile.this.raf.writeInt(1180058962);
                AudioFile.this.raf.writeInt(4);
                AudioFile.this.raf.writeInt(-1568648896);
            }
            AudioFile.this.raf.writeInt(1129270605);
            long l = AudioFile.this.raf.getFilePointer();
            AudioFile.this.raf.writeInt(0);
            AudioFile.this.raf.writeShort(audioFileDescr.channels);
            this.commSmpNumOffset = AudioFile.this.raf.getFilePointer();
            AudioFile.this.raf.writeInt(0);
            AudioFile.this.raf.writeShort(this.isAIFC ? 16 : audioFileDescr.bitsPerSample);
            int n = audioFileDescr.rate < 0.0 ? 128 : 0;
            double d = Math.abs(audioFileDescr.rate);
            int n2 = (int)(Math.log(d) / Math.log(2.0) + 16383.0) & 0xFFFF;
            double d2 = d * (double)(1 << 16414 - n2);
            AudioFile.this.raf.writeShort(((n | n2 >> 8) & 0xFF) << 8 | n2 & 0xFF);
            AudioFile.this.raf.writeInt((int)((long)d2 & 0xFFFFFFFFFFFFFFFFL));
            AudioFile.this.raf.writeInt((int)((long)(d2 % 1.0 * 4.294967296E9) & 0xFFFFFFFFFFFFFFFFL));
            if (this.isAIFC) {
                if (audioFileDescr.bitsPerSample == 32) {
                    string = fl32_HUMAN;
                    n2 = 1718367026;
                } else {
                    string = fl64_HUMAN;
                    n2 = 1718367796;
                }
                AudioFile.this.raf.writeInt(n2);
                AudioFile.this.raf.writeByte(string.length());
                AudioFile.this.raf.writeBytes(string);
                if ((string.length() & 1) == 0) {
                    AudioFile.this.raf.writeByte(0);
                }
            }
            long l2 = AudioFile.this.raf.getFilePointer();
            AudioFile.this.raf.seek(l);
            AudioFile.this.raf.writeInt((int)(l2 - l - 4L));
            AudioFile.this.raf.seek(l2);
            AudioFile.this.raf.writeInt(1229869908);
            AudioFile.this.raf.writeInt(20);
            AudioFile.this.raf.writeInt(1157628031);
            Object object = audioFileDescr.getProperty("gain");
            n2 = object != null ? (int)(20.0 * Math.log(((Float)object).floatValue()) / Math.log(10.0) + 0.5) : 0;
            AudioFile.this.raf.writeInt(0x7F0000 | n2 & 0xFFFF);
            Region region = (Region)audioFileDescr.getProperty(AudioFile.NAME_LOOP);
            boolean bl = region != null;
            AudioFile.this.raf.writeShort(bl ? 1 : 0);
            AudioFile.this.raf.writeInt(bl ? 65538 : 0);
            AudioFile.this.raf.writeShort(0);
            AudioFile.this.raf.writeInt(0);
            List list = (List)audioFileDescr.getProperty("markers");
            if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            if (bl || !list.isEmpty()) {
                AudioFile.this.raf.writeInt(1296126539);
                l = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.writeInt(0);
                n2 = list.size() + (bl ? 2 : 0);
                AudioFile.this.raf.writeShort(n2);
                n = 1;
                if (bl) {
                    AudioFile.this.raf.writeShort(n++);
                    AudioFile.this.raf.writeInt((int)region.span.getStart());
                    AudioFile.this.raf.writeLong(460041605545226240L);
                    AudioFile.this.raf.writeShort(n++);
                    AudioFile.this.raf.writeInt((int)region.span.getStop());
                    AudioFile.this.raf.writeLong(460895913195106304L);
                }
                for (n2 = 0; n2 < list.size(); ++n2) {
                    AudioFile.this.raf.writeShort(n++);
                    Marker marker = (Marker)list.get(n2);
                    AudioFile.this.raf.writeInt((int)marker.pos);
                    AudioFile.this.raf.writeByte(marker.name.length() & 0xFF);
                    AudioFile.this.raf.writeBytes(marker.name);
                    if ((marker.name.length() & 1) != 0) continue;
                    AudioFile.this.raf.writeByte(0);
                }
                l2 = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.seek(l);
                AudioFile.this.raf.writeInt((int)(l2 - l - 4L));
                AudioFile.this.raf.seek(l2);
            }
            if ((string = (String)audioFileDescr.getProperty("comment")) != null && string.length() > 0) {
                AudioFile.this.raf.writeInt(1129270612);
                AudioFile.this.raf.writeInt(11 + string.length() & 0xFFFFFFFE);
                AudioFile.this.raf.writeShort(1);
                AudioFile.this.raf.writeInt((int)(System.currentTimeMillis() + 2021253247L));
                AudioFile.this.raf.writeShort(0);
                AudioFile.this.raf.writeShort(string.length());
                AudioFile.this.raf.writeBytes(string);
                if ((string.length() & 1) == 1) {
                    AudioFile.this.raf.writeByte(0);
                }
            }
            byte[] byArray = (byte[])audioFileDescr.getProperty("app");
            if (audioFileDescr.appCode != null && byArray != null) {
                AudioFile.this.raf.writeInt(1095782476);
                AudioFile.this.raf.writeInt(4 + byArray.length);
                AudioFile.this.raf.write(audioFileDescr.appCode.getBytes(), 0, 4);
                AudioFile.this.raf.write(byArray);
                if (byArray.length % 2 == 1) {
                    AudioFile.this.raf.write(0);
                }
            }
            AudioFile.this.raf.writeInt(1397968452);
            this.ssndLengthOffset = AudioFile.this.raf.getFilePointer();
            AudioFile.this.raf.writeInt(8);
            AudioFile.this.raf.writeInt(0);
            AudioFile.this.raf.writeInt(0);
            this.sampleDataOffset = AudioFile.this.raf.getFilePointer();
            this.updateHeader(audioFileDescr);
        }

        @Override
        protected void updateHeader(AudioFileDescr audioFileDescr) throws IOException {
            long l = AudioFile.this.raf.getFilePointer();
            long l2 = AudioFile.this.raf.length();
            if (l2 == this.lastUpdateLength) {
                return;
            }
            if (l2 >= this.formLengthOffset + 4L) {
                AudioFile.this.raf.seek(this.formLengthOffset);
                AudioFile.this.raf.writeInt((int)(l2 - 8L));
            }
            if (l2 >= this.commSmpNumOffset + 4L) {
                AudioFile.this.raf.seek(this.commSmpNumOffset);
                AudioFile.this.raf.writeInt((int)audioFileDescr.length);
            }
            if (l2 >= this.ssndLengthOffset + 4L) {
                AudioFile.this.raf.seek(this.ssndLengthOffset);
                AudioFile.this.raf.writeInt((int)(l2 - (this.ssndLengthOffset + 4L)));
            }
            AudioFile.this.raf.seek(l);
            this.lastUpdateLength = l2;
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return this.byteOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readMarkers() throws IOException {
            if (this.markersOffset <= 0L) {
                return;
            }
            byte[] byArray = new byte[64];
            long l = AudioFile.this.raf.getFilePointer();
            int n = this.loop ? 2 : 0;
            try {
                AudioFile.this.raf.seek(this.markersOffset);
                int n2 = AudioFile.this.raf.readUnsignedShort();
                ArrayList<Marker> arrayList = new ArrayList<Marker>(n2);
                for (int i = n2; i > 0; --i) {
                    int n3 = AudioFile.this.raf.readUnsignedShort();
                    int n4 = AudioFile.this.raf.readInt();
                    n2 = AudioFile.this.raf.readUnsignedByte();
                    if (this.loop && n3 == this.loopStart) {
                        this.loopStart = n4;
                        --n;
                    } else if (this.loop && n3 == this.loopEnd) {
                        this.loopEnd = n4;
                        --n;
                    } else {
                        n3 = Math.min(n2, byArray.length);
                        AudioFile.this.raf.readFully(byArray, 0, n3);
                        n2 -= n3;
                        if (n3 > 0 && byArray[n3 - 1] == 32) {
                            --n3;
                        }
                        arrayList.add(new Marker(n4, new String(byArray, 0, n3)));
                    }
                    AudioFile.this.raf.seek(AudioFile.this.raf.getFilePointer() + (long)(n2 + 1) & 0xFFFFFFFFFFFFFFFEL);
                }
                AudioFile.this.afd.setProperty("markers", arrayList);
                if (this.loop && n == 0) {
                    AudioFile.this.afd.setProperty(AudioFile.NAME_LOOP, new Region(new Span(this.loopStart, this.loopEnd), AudioFile.NAME_LOOP));
                }
            }
            finally {
                AudioFile.this.raf.seek(l);
            }
        }

        @Override
        protected void readAppCode() throws IOException {
            if (this.appCodeOff > 0L) {
                byte[] byArray = new byte[this.appCodeLen];
                long l = AudioFile.this.raf.getFilePointer();
                AudioFile.this.raf.seek(this.appCodeOff);
                AudioFile.this.raf.readFully(byArray);
                AudioFile.this.afd.setProperty("app", byArray);
                AudioFile.this.raf.seek(l);
            } else {
                AudioFile.this.afd.setProperty("app", null);
            }
        }
    }

    private abstract class AudioFileHeader {
        protected static final long SECONDS_FROM_1904_TO_1970 = 2021253247L;

        protected AudioFileHeader() {
        }

        protected abstract void readHeader(AudioFileDescr var1) throws IOException;

        protected abstract void writeHeader(AudioFileDescr var1) throws IOException;

        protected abstract void updateHeader(AudioFileDescr var1) throws IOException;

        protected abstract long getSampleDataOffset();

        protected abstract ByteOrder getByteOrder();

        protected boolean isUnsignedPCM() {
            return false;
        }

        protected void readMarkers() throws IOException {
        }

        protected void readAppCode() throws IOException {
        }

        protected final int readLittleUShort() throws IOException {
            int n = AudioFile.this.raf.readUnsignedShort();
            return n >> 8 | (n & 0xFF) << 8;
        }

        protected final int readLittleInt() throws IOException {
            int n = AudioFile.this.raf.readInt();
            return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
        }

        protected final float readLittleFloat() throws IOException {
            int n = AudioFile.this.raf.readInt();
            return Float.intBitsToFloat(n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24);
        }

        protected final long readLittleLong() throws IOException {
            long l = AudioFile.this.raf.readLong();
            return l >> 56 & 0xFFL | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L | l << 56;
        }

        protected final void writeLittleShort(int n) throws IOException {
            AudioFile.this.raf.writeShort(n >> 8 | (n & 0xFF) << 8);
        }

        protected final void writeLittleInt(int n) throws IOException {
            AudioFile.this.raf.writeInt(n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24);
        }

        protected final void writeLittleLong(long l) throws IOException {
            AudioFile.this.raf.writeLong(l >> 56 & 0xFFL | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L | l << 56);
        }

        protected final String readNullTermString() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            byte by = AudioFile.this.raf.readByte();
            while (by != 0) {
                stringBuffer.append((char)by);
                by = AudioFile.this.raf.readByte();
            }
            return stringBuffer.toString();
        }

        protected class BigDataInputReader
        extends DataInputReader {
            public BigDataInputReader(DataInput dataInput) {
                super(dataInput);
            }

            @Override
            public int readInt() throws IOException {
                return this.din.readInt();
            }

            @Override
            public float readFloat() throws IOException {
                return this.din.readFloat();
            }
        }

        protected class LittleDataInputReader
        extends DataInputReader {
            public LittleDataInputReader(DataInput dataInput) {
                super(dataInput);
            }

            @Override
            public int readInt() throws IOException {
                return AudioFileHeader.this.readLittleInt();
            }

            @Override
            public float readFloat() throws IOException {
                return AudioFileHeader.this.readLittleFloat();
            }
        }

        protected abstract class DataInputReader {
            protected final DataInput din;

            protected DataInputReader(DataInput dataInput) {
                this.din = dataInput;
            }

            public abstract int readInt() throws IOException;

            public abstract float readFloat() throws IOException;
        }
    }

    private class DoubleBufferHandler
    extends BufferHandler {
        private final DoubleBuffer viewBuf;
        private final double[] arrayBuf;

        protected DoubleBufferHandler() {
            AudioFile.this.byteBuf.clear();
            this.viewBuf = AudioFile.this.byteBuf.asDoubleBuffer();
            this.arrayBuf = new double[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        this.arrayBuf[n5] = fArray2[n6];
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = (float)this.arrayBuf[n5];
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class FloatBufferHandler
    extends BufferHandler {
        private final FloatBuffer viewBuf;
        private final float[] arrayBuf;

        protected FloatBufferHandler() {
            AudioFile.this.byteBuf.clear();
            this.viewBuf = AudioFile.this.byteBuf.asFloatBuffer();
            this.arrayBuf = new float[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        this.arrayBuf[n5] = fArray2[n6];
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = this.arrayBuf[n5];
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class IntBufferHandler
    extends BufferHandler {
        private final IntBuffer viewBuf;
        private final int[] arrayBuf;

        protected IntBufferHandler() {
            AudioFile.this.byteBuf.clear();
            this.viewBuf = AudioFile.this.byteBuf.asIntBuffer();
            this.arrayBuf = new int[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        this.arrayBuf[n5] = (int)(fArray2[n6] * 2.1474836E9f);
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = (float)this.arrayBuf[n5] / 2.1474836E9f;
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class ThreeLittleByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;
        private final int chStep;

        protected ThreeLittleByteBufferHandler() {
            this.chStep = (AudioFile.this.channels - 1) * 3;
            this.arrayBuf = new byte[AudioFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i * 3;
                    int n6 = n;
                    while (n5 < n4) {
                        int n7 = (int)(fArray2[n6] * 8388607.0f);
                        this.arrayBuf[n5++] = (byte)n7;
                        this.arrayBuf[n5++] = (byte)(n7 >> 8);
                        this.arrayBuf[n5++] = (byte)(n7 >> 16);
                        n5 += this.chStep;
                        ++n6;
                    }
                }
                AudioFile.this.byteBuf.clear();
                AudioFile.this.byteBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                AudioFile.this.byteBuf.rewind().limit(n4);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.byteBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i * 3;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = (float)(this.arrayBuf[n5++] & 0xFF | (this.arrayBuf[n5++] & 0xFF) << 8 | this.arrayBuf[n5++] << 16) / 8388607.0f;
                        n5 += this.chStep;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class ThreeByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;
        private final int chStep;

        protected ThreeByteBufferHandler() {
            this.chStep = (AudioFile.this.channels - 1) * 3;
            this.arrayBuf = new byte[AudioFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    int n5 = i * 3;
                    int n6 = n;
                    while (n5 < n4) {
                        int n7 = (int)(fArray2[n6] * 8388607.0f);
                        this.arrayBuf[n5++] = (byte)(n7 >> 16);
                        this.arrayBuf[n5++] = (byte)(n7 >> 8);
                        this.arrayBuf[n5++] = (byte)n7;
                        n5 += this.chStep;
                        ++n6;
                    }
                }
                AudioFile.this.byteBuf.clear();
                AudioFile.this.byteBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                AudioFile.this.byteBuf.rewind().limit(n4);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.byteBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i * 3;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = (float)(this.arrayBuf[n5++] << 16 | (this.arrayBuf[n5++] & 0xFF) << 8 | this.arrayBuf[n5++] & 0xFF) / 8388607.0f;
                        n5 += this.chStep;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class ShortBufferHandler
    extends BufferHandler {
        private final ShortBuffer viewBuf;
        private final short[] arrayBuf;

        protected ShortBufferHandler() {
            AudioFile.this.byteBuf.clear();
            this.viewBuf = AudioFile.this.byteBuf.asShortBuffer();
            this.arrayBuf = new short[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        this.arrayBuf[n5] = (short)(fArray2[n6] * 32767.0f);
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.channels;
                AudioFile.this.byteBuf.rewind().limit(n3 * AudioFile.this.bytesPerFrame);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = (float)this.arrayBuf[n5] / 32767.0f;
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class UByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;

        protected UByteBufferHandler() {
            this.arrayBuf = new byte[AudioFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        this.arrayBuf[n5] = (byte)(fArray2[n6] * 127.0f + 128.0f);
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                AudioFile.this.byteBuf.clear();
                AudioFile.this.byteBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                AudioFile.this.byteBuf.rewind().limit(n4);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.byteBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = this.arrayBuf[n5] < 0 ? (float)(128 + this.arrayBuf[n5]) / 127.0f : (float)(this.arrayBuf[n5] - 128) / 127.0f;
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private class ByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;

        protected ByteBufferHandler() {
            this.arrayBuf = new byte[AudioFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        this.arrayBuf[n5] = (byte)(fArray2[n6] * 127.0f);
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                AudioFile.this.byteBuf.clear();
                AudioFile.this.byteBuf.put(this.arrayBuf, 0, n4);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.fch.write(AudioFile.this.byteBuf);
                n2 -= n3;
                n += n3;
            }
        }

        @Override
        protected void readFrames(float[][] fArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(AudioFile.this.frameBufCapacity, n2);
                int n4 = n3 * AudioFile.this.bytesPerFrame;
                AudioFile.this.byteBuf.rewind().limit(n4);
                AudioFile.this.fch.read(AudioFile.this.byteBuf);
                AudioFile.this.byteBuf.flip();
                AudioFile.this.byteBuf.get(this.arrayBuf, 0, n4);
                for (int i = 0; i < AudioFile.this.channels; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2 == null) continue;
                    int n5 = i;
                    int n6 = n;
                    while (n5 < n4) {
                        fArray2[n6] = (float)this.arrayBuf[n5] / 127.0f;
                        n5 += AudioFile.this.channels;
                        ++n6;
                    }
                }
                n2 -= n3;
                n += n3;
            }
        }
    }

    private abstract class BufferHandler {
        protected BufferHandler() {
        }

        protected abstract void writeFrames(float[][] var1, int var2, int var3) throws IOException;

        protected abstract void readFrames(float[][] var1, int var2, int var3) throws IOException;
    }
}

