/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DynamicURLClassLoader
extends URLClassLoader {
    private final Map mapSingleClasses = new HashMap();

    public DynamicURLClassLoader() {
        super(new URL[0]);
    }

    public DynamicURLClassLoader(URL[] uRLArray) {
        this();
        for (int i = 0; i < uRLArray.length; ++i) {
            this.addURL(uRLArray[i]);
        }
    }

    public DynamicURLClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    public DynamicURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        this(classLoader);
        for (int i = 0; i < uRLArray.length; ++i) {
            this.addURL(uRLArray[i]);
        }
    }

    @Override
    public void addURL(URL uRL) {
        String string = uRL.getPath();
        if (string.endsWith(".class")) {
            int n = string.lastIndexOf(47) + 1;
            this.mapSingleClasses.put(string.substring(n, string.length() - 6), uRL);
        } else {
            super.addURL(uRL);
        }
    }

    public void addURLs(URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            this.addURL(uRLArray[i]);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] byArray;
            URL uRL = (URL)this.mapSingleClasses.get(string);
            if (uRL != null && (byArray = this.loadClassBytes(uRL)) != null) {
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            throw classNotFoundException;
        }
    }

    private byte[] loadClassBytes(URL uRL) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        InputStream inputStream = null;
        int n = 0;
        try {
            byte[] byArray;
            int n2;
            inputStream = uRL.openStream();
            do {
                if ((n2 = inputStream.read(byArray = new byte[4096])) <= 0) continue;
                arrayList.add(byArray);
                arrayList2.add(new Integer(n2));
                n += n2;
            } while (n2 > 0);
            inputStream.close();
            byte[] byArray2 = new byte[n];
            int n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                n2 = (Integer)arrayList2.get(i);
                byArray = (byte[])arrayList.get(i);
                System.arraycopy(byArray, 0, byArray2, n3, n2);
                n3 += n2;
            }
            return byArray2;
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

