/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.util;

import de.sciss.util.ParamSpace;
import java.util.prefs.Preferences;

public class Param {
    public final double val;
    public final int unit;

    public Param(double d, int n) {
        this.val = d;
        this.unit = n;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.val);
        return (int)(l ^ l >>> 32) ^ this.unit;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Param) {
            Param param = (Param)object;
            return Double.doubleToLongBits(this.val) == Double.doubleToLongBits(param.val) && this.unit == param.unit;
        }
        return false;
    }

    public static Param fromPrefs(Preferences preferences, String string, Param param) {
        String string2 = preferences.get(string, null);
        return string2 == null ? param : Param.valueOf(string2);
    }

    public static Param valueOf(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            return new Param(Double.parseDouble(string.substring(0, n)), ParamSpace.stringToUnit(string.substring(n + 1)));
        }
        return new Param(Double.parseDouble(string), 0);
    }

    public String toString() {
        return String.valueOf(this.val) + ' ' + ParamSpace.unitToString(this.unit);
    }
}

