/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.ISplitButtonPainter;
import com.alee.extended.button.WebSplitButton;
import com.alee.extended.button.WebSplitButtonUI;
import com.alee.laf.button.AbstractButtonPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CompareUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class SplitButtonPainter<E extends WebSplitButton, U extends WebSplitButtonUI, D extends IDecoration<E, D>>
extends AbstractButtonPainter<E, U, D>
implements ISplitButtonPainter<E, U> {
    protected Color splitLineColor;
    protected Color splitLineDisabledColor;
    protected int splitIconGap;
    protected int contentGap;
    protected MouseAdapter splitButtonTracker;
    protected boolean onSplit = false;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.splitButtonTracker = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean wasOnSplit = SplitButtonPainter.this.onSplit;
                SplitButtonPainter.this.onSplit = SplitButtonPainter.this.getSplitButtonHitbox((WebSplitButton)SplitButtonPainter.this.component).contains(e.getPoint());
                if (wasOnSplit != SplitButtonPainter.this.onSplit) {
                    SplitButtonPainter.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                boolean wasOnSplit = SplitButtonPainter.this.onSplit;
                SplitButtonPainter.this.onSplit = false;
                if (wasOnSplit != SplitButtonPainter.this.onSplit) {
                    SplitButtonPainter.this.repaint();
                }
            }
        };
        ((WebSplitButton)this.component).addMouseListener(this.splitButtonTracker);
        ((WebSplitButton)this.component).addMouseMotionListener(this.splitButtonTracker);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((WebSplitButton)this.component).removeMouseMotionListener(this.splitButtonTracker);
        ((WebSplitButton)this.component).removeMouseListener(this.splitButtonTracker);
        this.splitButtonTracker = null;
        this.onSplit = false;
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"splitIcon"})) {
            this.updateBorder();
        }
    }

    public int getSplitIconGap() {
        return this.splitIconGap;
    }

    public void setSplitIconGap(int splitIconGap) {
        this.splitIconGap = splitIconGap;
    }

    public int getContentGap() {
        return this.contentGap;
    }

    public void setContentGap(int contentGap) {
        this.contentGap = contentGap;
    }

    @Override
    public boolean isOnSplit() {
        return this.onSplit;
    }

    @Override
    public Insets getBorders() {
        Insets borders = super.getBorders();
        Icon splitIcon = ((WebSplitButton)this.component).getSplitIcon();
        return splitIcon != null ? this.i(borders, 0, 0, 0, this.contentGap + 1 + this.splitIconGap + splitIcon.getIconWidth() + this.splitIconGap) : borders;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        super.paintContent(g2d, bounds, c, ui);
        this.paintSplitButton(g2d, bounds, c);
    }

    protected void paintSplitButton(Graphics2D g2d, Rectangle bounds, E c) {
        Icon splitIcon = ((WebSplitButton)this.component).getSplitIcon();
        Rectangle br = this.getSplitButtonBounds(bounds, c);
        int ix = br.x + br.width / 2 - splitIcon.getIconWidth() / 2;
        int iy = br.y + br.height / 2 - splitIcon.getIconHeight() / 2;
        splitIcon.paintIcon(this.component, g2d, ix, iy);
        Rectangle lr = this.getSplitLineBounds(bounds, c);
        g2d.setPaint(((Component)c).isEnabled() ? this.splitLineColor : this.splitLineDisabledColor);
        g2d.drawLine(lr.x, lr.y, lr.x, lr.y + lr.height);
    }

    protected Rectangle getSplitButtonBounds(Rectangle b, E c) {
        Insets i = ((JComponent)c).getInsets();
        int x = b.x + (this.ltr ? b.width - i.right + this.contentGap + 1 + this.splitIconGap : i.left - this.contentGap - 1 - this.splitIconGap);
        return new Rectangle(x, b.y + i.top, ((WebSplitButton)this.component).getSplitIcon().getIconWidth(), b.height - i.top - i.bottom);
    }

    protected Rectangle getSplitLineBounds(Rectangle b, E c) {
        Insets i = ((JComponent)c).getInsets();
        int x = b.x + (this.ltr ? b.width - i.right + this.contentGap : i.left - this.contentGap);
        return new Rectangle(x, b.y + i.top, 1, b.height - i.top - i.bottom - 1);
    }

    protected Rectangle getSplitButtonHitbox(E c) {
        Insets i = ((JComponent)c).getInsets();
        return new Rectangle(this.ltr ? ((JComponent)c).getWidth() - i.right : 0, 0, this.ltr ? i.right : i.left, ((JComponent)c).getHeight());
    }
}

