/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.DateFieldUI;
import com.alee.extended.date.DateListener;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateFieldUI;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.log.Log;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.style.StyleableComponent;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.swing.Customizer;
import com.alee.utils.swing.SizeMethods;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;

public class WebDateField
extends JComponent
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
SettingsMethods,
SizeMethods<WebDateField> {
    public static final String DATE_PROPERTY = "date";
    public static final String DATE_FORMAT_PROPERTY = "dateFormat";
    public static final String CALENDAR_CUSTOMIZER_PROPERTY = "calendarCustomizer";
    public static final String ALLOW_USER_INPUT_PROPERTY = "allowUserInput";
    protected DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    protected Customizer<WebCalendar> calendarCustomizer;
    protected Date date;
    protected boolean allowUserInput = true;

    public WebDateField() {
        this(StyleId.datefield, null);
    }

    public WebDateField(Date date) {
        this(StyleId.datefield, date);
    }

    public WebDateField(StyleId id) {
        this(id, null);
    }

    public WebDateField(StyleId id, Date date) {
        this.setDate(date);
        this.updateUI();
        this.setStyleId(id);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Date previous = this.date;
        this.date = date;
        this.firePropertyChange(DATE_PROPERTY, previous, date);
        this.fireDateChanged(date);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        DateFormat previous = this.dateFormat;
        this.dateFormat = dateFormat;
        this.firePropertyChange(DATE_FORMAT_PROPERTY, previous, dateFormat);
    }

    public boolean isAllowUserInput() {
        return this.allowUserInput;
    }

    public void setAllowUserInput(boolean allowUserInput) {
        boolean previous = this.allowUserInput;
        this.allowUserInput = allowUserInput;
        this.firePropertyChange(ALLOW_USER_INPUT_PROPERTY, previous, allowUserInput);
    }

    public Customizer<WebCalendar> getCalendarCustomizer() {
        return this.calendarCustomizer;
    }

    public void setCalendarCustomizer(Customizer<WebCalendar> customizer) {
        Customizer<WebCalendar> previous = this.calendarCustomizer;
        this.calendarCustomizer = customizer;
        this.firePropertyChange(CALENDAR_CUSTOMIZER_PROPERTY, previous, this.calendarCustomizer);
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    @Override
    public DateFieldUI getUI() {
        return (DateFieldUI)this.ui;
    }

    private WebDateFieldUI getWebUI() {
        return (WebDateFieldUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebDateFieldUI)) {
            try {
                this.setUI((WebDateFieldUI)ReflectUtils.createInstance((String)WebLookAndFeel.dateFieldUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebDateFieldUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public String getUIClassID() {
        return StyleableComponent.datefield.getUIClassID();
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((JComponent)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((JComponent)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((JComponent)this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebDateField setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebDateField setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebDateField setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebDateField setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth(this);
    }

    @Override
    public WebDateField setMaximumWidth(int maximumWidth) {
        return SizeUtils.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight(this);
    }

    @Override
    public WebDateField setMaximumHeight(int maximumHeight) {
        return SizeUtils.setMaximumHeight(this, maximumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public WebDateField setPreferredSize(int width, int height) {
        return SizeUtils.setPreferredSize(this, width, height);
    }

    public void addDateListener(DateListener listener) {
        this.listenerList.add(DateListener.class, listener);
    }

    public void removeDateListener(DateListener listener) {
        this.listenerList.remove(DateListener.class, listener);
    }

    protected void fireDateChanged(Date date) {
        for (DateListener listener : (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            listener.dateChanged(date);
        }
    }
}

