/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.extended.inspector.ComponentInspector;
import com.alee.extended.inspector.InterfaceTreeDataProvider;
import com.alee.extended.inspector.InterfaceTreeNode;
import com.alee.extended.tree.WebExTree;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.style.StyleId;
import com.alee.utils.swing.HoverListener;
import java.awt.Component;

public class InterfaceTree
extends WebExTree<InterfaceTreeNode>
implements HoverListener<InterfaceTreeNode> {
    protected ComponentInspector hoverInspector;

    public InterfaceTree(Component root) {
        this((StyleId)null, root);
    }

    public InterfaceTree(StyleId id, Component root) {
        super(id);
        this.setVisibleRowCount(20);
        this.setDataProvider(new InterfaceTreeDataProvider(this, root));
        this.hoverInspector = new ComponentInspector();
        this.addHoverListener(this);
    }

    public void hoverChanged(InterfaceTreeNode previous, InterfaceTreeNode current) {
        WebGlassPane glassPane = GlassPaneManager.getGlassPane(this.getRootComponent());
        if (this.hoverInspector.isShowing()) {
            glassPane.hideComponent(this.hoverInspector);
            this.hoverInspector.uninstall();
        }
        if (current != null && current.getComponent() != null && current.getComponent().isShowing()) {
            this.hoverInspector.install(current.getComponent());
            glassPane.showComponent(this.hoverInspector);
        }
    }

    public Component getRootComponent() {
        return ((InterfaceTreeNode)this.getDataProvider().getRoot()).getComponent();
    }

    public void setRootComponent(Component root) {
        this.setDataProvider(new InterfaceTreeDataProvider(this, root));
    }
}

