/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.panel.WebAccordion;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.laf.grouping.AbstractGroupingLayout;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.general.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;

public class AccordionLayout
extends AbstractGroupingLayout {
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    private Dimension getLayoutSize(Container parent, boolean preferred) {
        WebAccordion accordion = (WebAccordion)parent;
        List<WebCollapsiblePane> panes = accordion.getActualPanesList();
        int gap = accordion.getGap();
        Dimension ps = new Dimension();
        boolean hor = accordion.getOrientation() == 0;
        for (WebCollapsiblePane pane : panes) {
            Dimension cps;
            Dimension dimension = cps = preferred || !accordion.isFillSpace() ? pane.getPreferredSize() : pane.getBasePreferredSize();
            if (hor) {
                ps.width += cps.width;
                ps.height = Math.max(ps.height, cps.height);
                continue;
            }
            ps.width = Math.max(ps.width, cps.width);
            ps.height += cps.height;
        }
        if (panes.size() > 0) {
            if (hor) {
                ps.width += gap * (panes.size() - 1);
            } else {
                ps.height += gap * (panes.size() - 1);
            }
        }
        Insets insets = parent.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    @Override
    public void layoutContainer(Container parent) {
        WebAccordion accordion = (WebAccordion)parent;
        List<WebCollapsiblePane> panes = accordion.getActualPanesList();
        int gap = accordion.getGap();
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int w = size.width - insets.left - insets.right;
        int h = size.height - insets.top - insets.bottom;
        boolean hor = accordion.getOrientation() == 0;
        int x = insets.left;
        int y = insets.top;
        if (accordion.isFillSpace()) {
            float totalStates = 0.0f;
            int totalFillLength = (hor ? size.width - insets.left - insets.right : size.height - insets.top - insets.bottom) + gap;
            int visuallyExpanded = 0;
            int lastFillIndex = -1;
            ArrayList<Integer> base = new ArrayList<Integer>();
            for (WebCollapsiblePane pane : panes) {
                Dimension bps = pane.getBasePreferredSize();
                base.add(hor ? bps.width : bps.height);
                float expandState = pane.getTransitionProgress();
                totalStates += expandState;
                totalFillLength -= (hor ? bps.width : bps.height) + gap;
                if (!(expandState > 0.0f)) continue;
                lastFillIndex = panes.indexOf(pane);
                ++visuallyExpanded;
            }
            totalStates = visuallyExpanded == 1 ? 1.0f : totalStates;
            totalFillLength = Math.max(totalFillLength, 0);
            float end = 0.0f;
            for (int i = 0; i < panes.size(); ++i) {
                float expandState = panes.get(i).getTransitionProgress();
                int length = (Integer)base.get(i);
                if (expandState > 0.0f) {
                    length += Math.round((float)Math.floor((float)totalFillLength * expandState / totalStates)) + (i == lastFillIndex ? Math.round(end += (float)totalFillLength * expandState / totalStates % 1.0f) : 0);
                }
                panes.get(i).setBounds(x, y, hor ? length : w, hor ? h : length);
                if (hor) {
                    x += length + gap;
                    continue;
                }
                y += length + gap;
            }
        } else {
            for (WebCollapsiblePane pane : panes) {
                Dimension cps = pane.getPreferredSize();
                pane.setBounds(x, y, hor ? cps.width : w, hor ? h : cps.height);
                if (hor) {
                    x += cps.width + gap;
                    continue;
                }
                y += cps.height + gap;
            }
        }
    }

    @Override
    protected String sides() {
        return this.sides != null ? this.sides : (this.sides = "0,0,0,0");
    }

    @Override
    protected Pair<String, String> getDescriptors(Container parent, Component component, int index) {
        Pair descriptors;
        WebAccordion accordion = (WebAccordion)parent;
        if (accordion.getGap() == 0) {
            int last = parent.getComponentCount() - 1;
            boolean hor = accordion.getOrientation() == 0;
            boolean top = (hor || !hor && index == 0) && this.isPaintTop();
            boolean left = (index == 0 || !hor) && this.isPaintLeft();
            boolean bottom = (hor || !hor && index == last) && this.isPaintBottom();
            boolean right = (index == last || !hor) && this.isPaintLeft();
            String sides = DecorationUtils.toString(top, left, bottom, right);
            String lines = DecorationUtils.toString(false, false, !hor && index != last, hor && index != last);
            descriptors = new Pair((Object)sides, (Object)lines);
        } else {
            descriptors = new Pair();
        }
        return descriptors;
    }
}

