/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.lazy;

import com.alee.api.Behavior;
import com.alee.api.jdk.Function;
import com.alee.api.jdk.Supplier;
import com.alee.api.jdk.UnsafeSupplier;
import com.alee.extended.syntax.SyntaxPreset;
import com.alee.extended.syntax.WebSyntaxArea;
import com.alee.extended.syntax.WebSyntaxScrollPane;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.label.WebLabel;
import com.alee.managers.style.StyleId;
import com.alee.utils.ExceptionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.concurrent.DaemonThreadFactory;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.JComponent;

public class LazyLoadBehavior
implements Behavior {
    protected static ExecutorService executorService = Executors.newFixedThreadPool(4, (ThreadFactory)new DaemonThreadFactory());

    public static <D> void perform(Container container, Object constraints, Supplier<JComponent> loaderSupplier, UnsafeSupplier<D> dataSupplier, Function<D, JComponent> dataHandler) {
        LazyLoadBehavior.perform(container, constraints, loaderSupplier, dataSupplier, dataHandler, new Function<Throwable, JComponent>(){

            public JComponent apply(final Throwable throwable) {
                final WebLabel error = new WebLabel(TextUtils.shortenText((String)throwable.getMessage(), (int)100, (boolean)true));
                error.onMousePress(MouseButton.left, new MouseEventRunnable(){

                    @Override
                    public void run(MouseEvent e) {
                        WebPopOver info = new WebPopOver(error);
                        WebSyntaxArea area = new WebSyntaxArea(ExceptionUtils.getStackTrace((Throwable)throwable), 12, 60, new SyntaxPreset[0]);
                        area.applyPresets(SyntaxPreset.base, SyntaxPreset.viewable, SyntaxPreset.hideMenu, SyntaxPreset.ideaTheme, SyntaxPreset.transparent);
                        info.add((Component)((Object)new WebSyntaxScrollPane(StyleId.syntaxareaScrollUndecorated, area, false)));
                        info.show((Component)error, PopOverDirection.down, PopOverAlignment.centered);
                    }
                });
                return error;
            }
        });
    }

    public static <D> void perform(final Container container, final Object constraints, final Supplier<JComponent> loaderSupplier, final UnsafeSupplier<D> dataSupplier, final Function<D, JComponent> dataHandler, final Function<Throwable, JComponent> errorHandler) {
        SwingUtils.invokeAndWaitSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                final JComponent loader = (JComponent)loaderSupplier.get();
                container.add((Component)loader, constraints);
                SwingUtils.update(container);
                final int index = container.getComponentZOrder(loader);
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final Object data = dataSupplier.get();
                            SwingUtils.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JComponent component = (JComponent)dataHandler.apply(data);
                                    container.remove(loader);
                                    container.add(component, constraints, index);
                                    SwingUtils.update(container);
                                }
                            });
                        }
                        catch (Throwable e) {
                            SwingUtils.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JComponent error = (JComponent)errorHandler.apply((Object)e);
                                    container.remove(loader);
                                    container.add(error, constraints, index);
                                    SwingUtils.update(container);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static void setExecutorService(ExecutorService service) {
        executorService = service;
    }
}

