/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AbstractAsyncTreeDataProvider;
import com.alee.extended.tree.AsyncPathExpansionListener;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeListener;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncTreeQueue;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.sample.SampleAsyncDataProvider;
import com.alee.extended.tree.sample.SampleTreeCellEditor;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.CellEditorAdapter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebAsyncTree<E extends AsyncUniqueNode>
extends WebTree<E>
implements AsyncTreeModelListener<E> {
    protected static final Object lock = new Object();
    protected final Object listenersLock = new Object();
    protected List<AsyncTreeListener> asyncTreeListeners = new ArrayList<AsyncTreeListener>(1);
    protected final Object syncLoadingLock = new Object();
    protected boolean asyncLoading = true;
    protected Comparator<E> comparator;
    protected Filter<E> filter;
    protected CellEditorAdapter cellEditorAdapter;

    public WebAsyncTree() {
        this(StyleId.asynctree);
    }

    public WebAsyncTree(StyleId id) {
        super(id);
        this.setDataProvider(new SampleAsyncDataProvider());
        this.setAsyncLoading(true);
        this.setCellEditor(new SampleTreeCellEditor());
    }

    public WebAsyncTree(AsyncTreeDataProvider dataProvider) {
        this(StyleId.asynctree, dataProvider);
    }

    public WebAsyncTree(StyleId id, AsyncTreeDataProvider dataProvider) {
        super(id);
        this.setDataProvider(dataProvider);
        this.setCellEditor(new WebTreeCellEditor());
    }

    public boolean isAsyncLoading() {
        return this.asyncLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsyncLoading(boolean asyncLoading) {
        Object object = this.syncLoadingLock != null ? this.syncLoadingLock : lock;
        synchronized (object) {
            this.asyncLoading = asyncLoading;
            if (this.isAsyncModel()) {
                this.getAsyncModel().setAsyncLoading(asyncLoading);
            }
        }
    }

    public AsyncTreeDataProvider<E> getDataProvider() {
        TreeModel model = this.getModel();
        return model != null && model instanceof AsyncTreeModel ? this.getAsyncModel().getDataProvider() : null;
    }

    public void setDataProvider(AsyncTreeDataProvider dataProvider) {
        if (dataProvider != null) {
            AsyncTreeDataProvider<E> oldDataProvider = this.getDataProvider();
            this.setModel(new AsyncTreeModel(this, dataProvider));
            this.firePropertyChange("dataProvider", oldDataProvider, dataProvider);
        }
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<E> comparator) {
        Comparator<E> oldComparator = this.comparator;
        this.comparator = comparator;
        AsyncTreeDataProvider<E> dataProvider = this.getDataProvider();
        if (dataProvider instanceof AbstractAsyncTreeDataProvider) {
            ((AbstractAsyncTreeDataProvider)dataProvider).setChildrenComparator(comparator);
            this.updateSortingAndFiltering();
        }
        this.firePropertyChange("comparator", oldComparator, comparator);
    }

    public void clearComparator() {
        this.setComparator(null);
    }

    public Filter<E> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<E> filter) {
        Filter<E> oldFilter = this.filter;
        this.filter = filter;
        AsyncTreeDataProvider<E> dataProvider = this.getDataProvider();
        if (dataProvider instanceof AbstractAsyncTreeDataProvider) {
            ((AbstractAsyncTreeDataProvider)dataProvider).setChildrenFilter(filter);
            this.updateSortingAndFiltering();
        }
        this.firePropertyChange("filter", oldFilter, filter);
    }

    public void clearFilter() {
        this.setFilter(null);
    }

    public void updateSortingAndFiltering() {
        this.getAsyncModel().updateSortingAndFiltering();
    }

    public void updateSortingAndFiltering(E node) {
        this.getAsyncModel().updateSortingAndFiltering(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModel(TreeModel newModel) {
        if (this.getModel() instanceof AsyncTreeModel) {
            this.getAsyncModel().removeAsyncTreeModelListener(this);
        }
        if (newModel instanceof AsyncTreeModel) {
            Object object = this.syncLoadingLock != null ? this.syncLoadingLock : lock;
            synchronized (object) {
                AsyncTreeModel model = (AsyncTreeModel)newModel;
                model.setAsyncLoading(this.asyncLoading);
                model.addAsyncTreeModelListener(this);
            }
        }
        super.setModel(newModel);
    }

    @Override
    public void setCellEditor(final TreeCellEditor cellEditor) {
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(this.cellEditorAdapter);
        }
        super.setCellEditor(cellEditor);
        if (cellEditor != null) {
            this.cellEditorAdapter = new CellEditorAdapter(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    AsyncUniqueNode node = (AsyncUniqueNode)cellEditor.getCellEditorValue();
                    WebAsyncTree.this.updateSortingAndFiltering(node.getParent());
                }
            };
            cellEditor.addCellEditorListener(this.cellEditorAdapter);
        }
    }

    public AsyncTreeModel<E> getAsyncModel() {
        return (AsyncTreeModel)this.getModel();
    }

    public boolean isAsyncModel() {
        TreeModel model = this.getModel();
        return model != null && model instanceof AsyncTreeModel;
    }

    public void setMaximumThreadsAmount(int amount) {
        AsyncTreeQueue.setMaximumThreadsAmount(this, amount);
    }

    public void setChildNodes(E parent, List<E> children) {
        this.getAsyncModel().setChildNodes(parent, children);
    }

    public void addChildNode(E parent, E child) {
        this.getAsyncModel().addChildNodes((AsyncUniqueNode)parent, Arrays.asList(child));
    }

    public void addChildNodes(E parent, List<E> children) {
        this.getAsyncModel().addChildNodes(parent, children);
    }

    public void insertChildNodes(List<E> children, E parent, int index) {
        this.getAsyncModel().insertNodesInto(children, parent, index);
    }

    public void insertChildNodes(E[] children, E parent, int index) {
        this.getAsyncModel().insertNodesInto((AsyncUniqueNode[])children, (AsyncUniqueNode)parent, index);
    }

    public void insertChildNode(E child, E parent, int index) {
        this.getAsyncModel().insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
    }

    public boolean removeNode(String nodeId) {
        return this.removeNode(this.findNode(nodeId));
    }

    public boolean removeNode(E node) {
        boolean exists;
        boolean bl = exists = node != null && ((AsyncUniqueNode)node).getParent() != null;
        if (exists) {
            this.getAsyncModel().removeNodeFromParent((MutableTreeNode)node);
        }
        return exists;
    }

    public void removeNodes(List<E> nodes) {
        this.getAsyncModel().removeNodesFromParent(nodes);
    }

    public void removeNodes(E[] nodes) {
        this.getAsyncModel().removeNodesFromParent(nodes);
    }

    public boolean areChildrenLoaded(E parent) {
        return this.getAsyncModel().areChildrenLoaded(parent);
    }

    public E findNode(String nodeId) {
        return this.getAsyncModel().findNode(nodeId);
    }

    public void updateNode(String nodeId) {
        this.updateNode(this.findNode(nodeId));
    }

    public void updateNode(E node) {
        this.getAsyncModel().updateNode(node);
    }

    public void updateNodeStructure(String nodeId) {
        this.updateNodeStructure(this.findNode(nodeId));
    }

    public void updateNodeStructure(E node) {
        this.getAsyncModel().updateNodeStructure(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSelectedNodesSync() {
        Object object = this.syncLoadingLock != null ? this.syncLoadingLock : lock;
        synchronized (object) {
            boolean async = this.isAsyncLoading();
            this.setAsyncLoading(false);
            this.reloadSelectedNodes();
            this.setAsyncLoading(async);
        }
    }

    public void reloadSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                AsyncUniqueNode node = (AsyncUniqueNode)this.getNodeForPath(path);
                if (node == null || node.isLoading()) continue;
                this.performReload(node, path, false);
            }
        }
    }

    public E reloadNodeUnderPoint(Point point) {
        return this.reloadNodeUnderPoint(point.x, point.y);
    }

    public E reloadNodeUnderPoint(int x, int y) {
        return this.reloadPath(this.getPathForLocation(x, y));
    }

    public E reloadNodeSync(String nodeId) {
        return this.reloadNodeSync(this.findNode(nodeId));
    }

    public E reloadNodeSync(E node) {
        return this.reloadNodeSync(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E reloadNodeSync(E node, boolean select) {
        Object object = this.syncLoadingLock != null ? this.syncLoadingLock : lock;
        synchronized (object) {
            boolean async = this.isAsyncLoading();
            this.setAsyncLoading(false);
            this.reloadNode(node, select);
            this.setAsyncLoading(async);
            return node;
        }
    }

    public E reloadRootNode() {
        return (E)this.reloadNode((AsyncUniqueNode)this.getRootNode());
    }

    public E reloadNode(String nodeId) {
        return this.reloadNode(this.findNode(nodeId));
    }

    public E reloadNode(E node) {
        return this.reloadNode(node, false);
    }

    public E reloadNode(E node, boolean select) {
        if (node != null && !((AsyncUniqueNode)node).isLoading()) {
            this.performReload(node, this.getPathForNode(node), select);
            return node;
        }
        return null;
    }

    public E reloadPathSync(TreePath path) {
        return this.reloadPathSync(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E reloadPathSync(TreePath path, boolean select) {
        Object object = this.syncLoadingLock != null ? this.syncLoadingLock : lock;
        synchronized (object) {
            boolean async = this.isAsyncLoading();
            this.setAsyncLoading(false);
            E node = this.reloadPath(path, select);
            this.setAsyncLoading(async);
            return node;
        }
    }

    public E reloadPath(TreePath path) {
        return this.reloadPath(path, false);
    }

    public E reloadPath(TreePath path, boolean select) {
        AsyncUniqueNode node;
        if (path != null && (node = (AsyncUniqueNode)this.getNodeForPath(path)) != null && !node.isLoading()) {
            this.performReload(node, path, select);
            return (E)node;
        }
        return null;
    }

    protected void performReload(E node, TreePath path, boolean select) {
        if (select && !this.isPathSelected(path)) {
            this.setSelectionPath(path);
        }
        if (!this.isExpanded(path)) {
            this.expandPath(path);
        }
        if (node != null && !((AsyncUniqueNode)node).isLoading()) {
            this.getAsyncModel().reload((TreeNode)node);
        }
    }

    @Override
    public void expandNode(String nodeId) {
        this.expandNode(this.findNode(nodeId));
    }

    public void expandPath(List<String> pathNodeIds) {
        this.expandPath(pathNodeIds, true, true, null);
    }

    public void expandPath(List<String> pathNodeIds, AsyncPathExpansionListener listener) {
        this.expandPath(pathNodeIds, true, true, listener);
    }

    public void expandPath(List<String> pathNodeIds, boolean expandLastNode) {
        this.expandPath(pathNodeIds, expandLastNode, true, null);
    }

    public void expandPath(List<String> pathNodeIds, boolean expandLastNode, AsyncPathExpansionListener listener) {
        this.expandPath(pathNodeIds, expandLastNode, true, listener);
    }

    public void expandPath(List<String> pathNodeIds, boolean expandLastNode, boolean selectLastNode) {
        this.expandPath(pathNodeIds, expandLastNode, selectLastNode, null);
    }

    public void expandPath(List<String> pathNodeIds, boolean expandLastNode, boolean selectLastNode, AsyncPathExpansionListener listener) {
        ArrayList ids = CollectionUtils.copy(pathNodeIds);
        for (int initial = 0; initial < ids.size(); ++initial) {
            E initialNode = this.findNode((String)ids.get(initial));
            if (initialNode == null) continue;
            for (int i = 0; i <= initial; ++i) {
                ids.remove(i);
            }
            if (ids.size() > 0) {
                this.expandPathImpl(initialNode, ids, expandLastNode, selectLastNode, listener);
            }
            return;
        }
        if (listener != null) {
            listener.pathFailedToExpand();
        }
    }

    protected void expandPathImpl(E currentNode, List<String> leftToExpand, boolean expandLastNode, boolean selectLastNode, AsyncPathExpansionListener listener) {
        if (leftToExpand.size() > 0) {
            if (((AsyncUniqueNode)currentNode).isLoaded()) {
                this.expandNode(currentNode);
                if (listener != null) {
                    listener.pathNodeExpanded(currentNode);
                }
                E nextNode = this.findNode(leftToExpand.get(0));
                leftToExpand.remove(0);
                if (nextNode != null) {
                    this.expandPathImpl(nextNode, leftToExpand, expandLastNode, selectLastNode, listener);
                } else {
                    this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
                    if (listener != null) {
                        listener.pathPartiallyExpanded(currentNode);
                    }
                }
            } else {
                this.addAsyncTreeListener(new AsyncTreeAdapter((AsyncUniqueNode)currentNode, listener, leftToExpand, expandLastNode, selectLastNode){
                    final /* synthetic */ AsyncUniqueNode val$currentNode;
                    final /* synthetic */ AsyncPathExpansionListener val$listener;
                    final /* synthetic */ List val$leftToExpand;
                    final /* synthetic */ boolean val$expandLastNode;
                    final /* synthetic */ boolean val$selectLastNode;
                    {
                        this.val$currentNode = asyncUniqueNode;
                        this.val$listener = asyncPathExpansionListener;
                        this.val$leftToExpand = list;
                        this.val$expandLastNode = bl;
                        this.val$selectLastNode = bl2;
                    }

                    @Override
                    public void loadCompleted(AsyncUniqueNode parent, List children) {
                        if (parent.getId().equals(this.val$currentNode.getId())) {
                            WebAsyncTree.this.removeAsyncTreeListener(this);
                            if (this.val$listener != null) {
                                this.val$listener.pathNodeExpanded(this.val$currentNode);
                            }
                            Object nextNode = WebAsyncTree.this.findNode((String)this.val$leftToExpand.get(0));
                            this.val$leftToExpand.remove(0);
                            if (nextNode != null) {
                                WebAsyncTree.this.expandPathImpl(nextNode, this.val$leftToExpand, this.val$expandLastNode, this.val$selectLastNode, this.val$listener);
                            } else {
                                WebAsyncTree.this.expandPathEndImpl(this.val$currentNode, this.val$expandLastNode, this.val$selectLastNode);
                                if (this.val$listener != null) {
                                    this.val$listener.pathPartiallyExpanded(this.val$currentNode);
                                }
                            }
                        }
                    }

                    @Override
                    public void loadFailed(AsyncUniqueNode parent, Throwable cause) {
                        if (parent.getId().equals(this.val$currentNode.getId())) {
                            WebAsyncTree.this.removeAsyncTreeListener(this);
                            WebAsyncTree.this.expandPathEndImpl(this.val$currentNode, this.val$expandLastNode, this.val$selectLastNode);
                            if (this.val$listener != null) {
                                this.val$listener.pathPartiallyExpanded(this.val$currentNode);
                            }
                        }
                    }
                });
                this.expandNode(currentNode);
            }
        } else {
            this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
            if (listener != null) {
                listener.pathExpanded(currentNode);
            }
        }
    }

    protected void expandPathEndImpl(E lastFoundNode, boolean expandLastNode, boolean selectLastNode) {
        if (selectLastNode) {
            this.setSelectedNode(lastFoundNode);
        }
        if (expandLastNode) {
            this.expandNode(lastFoundNode);
        }
    }

    @Override
    public final void expandAll() {
        if (this.isAsyncLoading()) {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                TreePath path = this.getPathForRow(i);
                if (this.getModel().isLeaf(this.getNodeForPath(path))) continue;
                this.performFullPathExpand(path);
            }
        } else {
            super.expandAll();
        }
    }

    protected void performFullPathExpand(TreePath path) {
        if (this.hasBeenExpanded(path)) {
            this.performFullSyncPathExpand(path);
        } else {
            this.performFullAsyncPathExpand(path);
        }
    }

    protected void performFullSyncPathExpand(TreePath path) {
        this.expandPath(path);
        AsyncUniqueNode node = (AsyncUniqueNode)this.getNodeForPath(path);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.performFullPathExpand(this.getPathForNode(node.getChildAt(i)));
        }
    }

    protected void performFullAsyncPathExpand(final TreePath path) {
        this.addAsyncTreeListener(new AsyncTreeAdapter<E>(){

            @Override
            public void loadCompleted(E parent, List<E> children) {
                if (parent == WebAsyncTree.this.getNodeForPath(path)) {
                    for (AsyncUniqueNode child : children) {
                        WebAsyncTree.this.performFullPathExpand(child.getTreePath());
                    }
                    WebAsyncTree.this.removeAsyncTreeListener(this);
                }
            }

            @Override
            public void loadFailed(E parent, Throwable cause) {
                if (parent == WebAsyncTree.this.getNodeForPath(path)) {
                    WebAsyncTree.this.removeAsyncTreeListener(this);
                }
            }
        });
        this.expandPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncTreeListener> getAsyncTreeListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            return CollectionUtils.copy(this.asyncTreeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncTreeListener(AsyncTreeListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.asyncTreeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAsyncTreeListener(AsyncTreeListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.asyncTreeListeners.remove(listener);
        }
    }

    @Override
    public void loadStarted(E parent) {
        this.fireChildrenLoadStarted(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoadStarted(E parent) {
        ArrayList listeners;
        Iterator iterator = this.listenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(this.asyncTreeListeners);
        }
        for (AsyncTreeListener listener : listeners) {
            listener.loadStarted(parent);
        }
    }

    @Override
    public void loadCompleted(E parent, List<E> children) {
        this.fireChildrenLoadCompleted(parent, children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoadCompleted(E parent, List<E> children) {
        ArrayList listeners;
        Iterator iterator = this.listenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(this.asyncTreeListeners);
        }
        for (AsyncTreeListener listener : listeners) {
            listener.loadCompleted(parent, children);
        }
    }

    @Override
    public void loadFailed(E parent, Throwable cause) {
        this.fireChildrenLoadFailed(parent, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoadFailed(E parent, Throwable cause) {
        ArrayList listeners;
        Iterator iterator = this.listenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(this.asyncTreeListeners);
        }
        for (AsyncTreeListener listener : listeners) {
            listener.loadFailed(parent, cause);
        }
    }
}

